#include <QtCore/QtGlobal>
#include <QtMultimedia/qvideoframe.h>
#include <QtCore/QVariant>
#include <QtMultimedia/qvideoframeformat.h>
#include <QtCore/qsize.h>
#include <QtGui/qimage.h>
#include <QtGui/qpainter.h>
#include <QtCore/qrect.h>

#include <QtJambi/QtJambiAPI>
#include <QtJambiMultimedia/hashes.h>

#include <QtJambi/RegistryAPI>
#include <QtJambi/Cast>

void deleter_QVideoFrame(void *ptr, bool isShell)
{
    QTJAMBI_NATIVE_METHOD_CALL("qtjambi_deleter for QVideoFrame")
    QVideoFrame *_ptr = reinterpret_cast<QVideoFrame *>(ptr);
    if(!isShell){
        QtJambiAPI::registerNonShellDeletion(ptr);
    }
    delete _ptr;
}

// emitting (writeConstructors)
// new QVideoFrame()
void __qt_construct_QVideoFrame_0(void* __qtjambi_ptr, JNIEnv* __jni_env, jobject __jni_object, jvalue* __java_arguments)
{
    QTJAMBI_NATIVE_METHOD_CALL("construct QVideoFrame()")
    Q_UNUSED(__java_arguments)
    QVideoFrame *__qt_this = new(__qtjambi_ptr) QVideoFrame();
    Q_UNUSED(__jni_object)
    Q_UNUSED(__jni_env)
    Q_UNUSED(__qt_this)
}

// new QVideoFrame(QVideoFrame)
void __qt_construct_QVideoFrame_1(void* __qtjambi_ptr, JNIEnv* __jni_env, jobject __jni_object, jvalue* __java_arguments)
{
    QTJAMBI_NATIVE_METHOD_CALL("construct QVideoFrame(QVideoFrame)")
    jobject other0 = __java_arguments[0].l;
    const QVideoFrame& __qt_other0 = qtjambi_cast<const QVideoFrame& >(__jni_env, other0);
    QVideoFrame *__qt_this = new(__qtjambi_ptr) QVideoFrame(__qt_other0);
    Q_UNUSED(__jni_object)
    Q_UNUSED(__qt_this)
}

// new QVideoFrame(QVideoFrameFormat)
void __qt_construct_QVideoFrame_2(void* __qtjambi_ptr, JNIEnv* __jni_env, jobject __jni_object, jvalue* __java_arguments)
{
    QTJAMBI_NATIVE_METHOD_CALL("construct QVideoFrame(QVideoFrameFormat)")
    jobject format0 = __java_arguments[0].l;
    const QVideoFrameFormat& __qt_format0 = qtjambi_cast<const QVideoFrameFormat& >(__jni_env, format0);
    QVideoFrame *__qt_this = new(__qtjambi_ptr) QVideoFrame(__qt_format0);
    Q_UNUSED(__jni_object)
    Q_UNUSED(__qt_this)
}

// destruct QVideoFrame
void __qt_destruct_QVideoFrame(void* ptr)
{
    QTJAMBI_NATIVE_METHOD_CALL("destruct QVideoFrame")
    reinterpret_cast<QVideoFrame*>(ptr)->~QVideoFrame();
}

// emitting  (functionsInTargetLang writeFinalFunction)
// QVideoFrame::QVideoFrame()
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_multimedia_QVideoFrame_initialize_1native__Lio_qt_multimedia_QVideoFrame_2)
(JNIEnv *__jni_env,
 jclass __jni_class,
 jobject __jni_object)
{
    QTJAMBI_NATIVE_METHOD_CALL("QVideoFrame::QVideoFrame()")
    QTJAMBI_TRY {
        QtJambiShell::initialize(__jni_env, __jni_class, __jni_object, &__qt_construct_QVideoFrame_0, sizeof(QVideoFrame), typeid(QVideoFrame), false, &deleter_QVideoFrame, nullptr);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QVideoFrame::QVideoFrame(QVideoFrame)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_multimedia_QVideoFrame_initialize_1native__Lio_qt_multimedia_QVideoFrame_2Lio_qt_multimedia_QVideoFrame_2)
(JNIEnv *__jni_env,
 jclass __jni_class,
 jobject __jni_object,
 jobject other0)
{
    QTJAMBI_NATIVE_METHOD_CALL("QVideoFrame::QVideoFrame(QVideoFrame)")
    QTJAMBI_TRY {
        jvalue arguments;
        arguments.l = other0;
        QtJambiShell::initialize(__jni_env, __jni_class, __jni_object, &__qt_construct_QVideoFrame_1, sizeof(QVideoFrame), typeid(QVideoFrame), false, &deleter_QVideoFrame, &arguments);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QVideoFrame::QVideoFrame(QVideoFrameFormat)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_multimedia_QVideoFrame_initialize_1native__Lio_qt_multimedia_QVideoFrame_2Lio_qt_multimedia_QVideoFrameFormat_2)
(JNIEnv *__jni_env,
 jclass __jni_class,
 jobject __jni_object,
 jobject format0)
{
    QTJAMBI_NATIVE_METHOD_CALL("QVideoFrame::QVideoFrame(QVideoFrameFormat)")
    QTJAMBI_TRY {
        jvalue arguments;
        arguments.l = format0;
        QtJambiShell::initialize(__jni_env, __jni_class, __jni_object, &__qt_construct_QVideoFrame_2, sizeof(QVideoFrame), typeid(QVideoFrame), false, &deleter_QVideoFrame, &arguments);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QVideoFrame::bits(int)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_multimedia_QVideoFrame_buffer_1native_1int__JI)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint plane0)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        QVideoFrame *__qt_this = QtJambiAPI::objectFromNativeId<QVideoFrame>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QVideoFrame::bits(int)", __qt_this)
        uchar* __qt_return_value = __qt_this->bits(static_cast<int>(plane0));
        __java_return_value = __jni_env->NewDirectByteBuffer(__qt_return_value, __qt_this->mappedBytes(plane0));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QVideoFrame::bits(int)const
extern "C" Q_DECL_EXPORT jbyteArray JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_multimedia_QVideoFrame_bits_1native_1int_1constfct__JI)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint plane0)
{
    Q_UNUSED(__this)
    jbyteArray __java_return_value{0};
    QTJAMBI_TRY {
        const QVideoFrame *__qt_this = QtJambiAPI::objectFromNativeId<QVideoFrame>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QVideoFrame::bits(int)const", __qt_this)
        const uchar* __qt_return_value = __qt_this->bits(static_cast<int>(plane0));
        __java_return_value = __jni_env->NewByteArray(__qt_this->mappedBytes(plane0));
        __jni_env->SetByteArrayRegion(__java_return_value, 0, __qt_this->mappedBytes(plane0), reinterpret_cast<const jbyte *>(__qt_return_value));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QVideoFrame::bytesPerLine(int)const
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_multimedia_QVideoFrame_bytesPerLine_1native_1int_1constfct__JI)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint plane0)
{
    Q_UNUSED(__this)
    jint __java_return_value{0};
    QTJAMBI_TRY {
        const QVideoFrame *__qt_this = QtJambiAPI::objectFromNativeId<QVideoFrame>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QVideoFrame::bytesPerLine(int)const", __qt_this)
        __java_return_value = __qt_this->bytesPerLine(static_cast<int>(plane0));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QVideoFrame::endTime()const
extern "C" Q_DECL_EXPORT jlong JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_multimedia_QVideoFrame_endTime_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jlong __java_return_value{0};
    QTJAMBI_TRY {
        const QVideoFrame *__qt_this = QtJambiAPI::objectFromNativeId<QVideoFrame>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QVideoFrame::endTime()const", __qt_this)
        qint64 __qt_return_value = __qt_this->endTime();
        __java_return_value = jlong(__qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QVideoFrame::handleType()const
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_multimedia_QVideoFrame_handleType_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jint __java_return_value{0};
    QTJAMBI_TRY {
        const QVideoFrame *__qt_this = QtJambiAPI::objectFromNativeId<QVideoFrame>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QVideoFrame::handleType()const", __qt_this)
        QVideoFrame::HandleType __qt_return_value = __qt_this->handleType();
        __java_return_value = __qt_return_value;
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QVideoFrame::height()const
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_multimedia_QVideoFrame_height_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jint __java_return_value{0};
    QTJAMBI_TRY {
        const QVideoFrame *__qt_this = QtJambiAPI::objectFromNativeId<QVideoFrame>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QVideoFrame::height()const", __qt_this)
        __java_return_value = __qt_this->height();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QVideoFrame::isMapped()const
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_multimedia_QVideoFrame_isMapped_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        const QVideoFrame *__qt_this = QtJambiAPI::objectFromNativeId<QVideoFrame>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QVideoFrame::isMapped()const", __qt_this)
        __java_return_value = __qt_this->isMapped();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QVideoFrame::isReadable()const
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_multimedia_QVideoFrame_isReadable_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        const QVideoFrame *__qt_this = QtJambiAPI::objectFromNativeId<QVideoFrame>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QVideoFrame::isReadable()const", __qt_this)
        __java_return_value = __qt_this->isReadable();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QVideoFrame::isValid()const
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_multimedia_QVideoFrame_isValid_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        const QVideoFrame *__qt_this = QtJambiAPI::objectFromNativeId<QVideoFrame>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QVideoFrame::isValid()const", __qt_this)
        __java_return_value = __qt_this->isValid();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QVideoFrame::isWritable()const
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_multimedia_QVideoFrame_isWritable_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        const QVideoFrame *__qt_this = QtJambiAPI::objectFromNativeId<QVideoFrame>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QVideoFrame::isWritable()const", __qt_this)
        __java_return_value = __qt_this->isWritable();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QVideoFrame::map(QVideoFrame::MapMode)
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_multimedia_QVideoFrame_map_1native_1QVideoFrame_1MapMode__JI)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint mode0)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        QVideoFrame *__qt_this = QtJambiAPI::objectFromNativeId<QVideoFrame>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QVideoFrame::map(QVideoFrame::MapMode)", __qt_this)
        QVideoFrame::MapMode __qt_mode0 = qtjambi_cast<QVideoFrame::MapMode>(__jni_env, mode0);
        __java_return_value = __qt_this->map(QVideoFrame::MapMode(__qt_mode0));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QVideoFrame::mapMode()const
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_multimedia_QVideoFrame_mapMode_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jint __java_return_value{0};
    QTJAMBI_TRY {
        const QVideoFrame *__qt_this = QtJambiAPI::objectFromNativeId<QVideoFrame>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QVideoFrame::mapMode()const", __qt_this)
        QVideoFrame::MapMode __qt_return_value = __qt_this->mapMode();
        __java_return_value = __qt_return_value;
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QVideoFrame::mappedBytes(int)const
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_multimedia_QVideoFrame_mappedBytes_1native_1int_1constfct__JI)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint plane0)
{
    Q_UNUSED(__this)
    jint __java_return_value{0};
    QTJAMBI_TRY {
        const QVideoFrame *__qt_this = QtJambiAPI::objectFromNativeId<QVideoFrame>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QVideoFrame::mappedBytes(int)const", __qt_this)
        __java_return_value = __qt_this->mappedBytes(static_cast<int>(plane0));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QVideoFrame::mirrored()const
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_multimedia_QVideoFrame_mirrored_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        const QVideoFrame *__qt_this = QtJambiAPI::objectFromNativeId<QVideoFrame>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QVideoFrame::mirrored()const", __qt_this)
        __java_return_value = __qt_this->mirrored();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QVideoFrame::operator=(QVideoFrame)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_multimedia_QVideoFrame_assign_1native_1cref_1QVideoFrame__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID other0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QVideoFrame *__qt_this = QtJambiAPI::objectFromNativeId<QVideoFrame>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QVideoFrame::operator=(QVideoFrame)", __qt_this)
        const QVideoFrame& __qt_other0 = QtJambiAPI::valueReferenceFromNativeId<QVideoFrame>(other0);
        (*__qt_this) = __qt_other0;
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QVideoFrame::operator==(QVideoFrame)const
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_multimedia_QVideoFrame_operator_1equal_1native_1cref_1QVideoFrame_1constfct__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID other0)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        const QVideoFrame *__qt_this = QtJambiAPI::objectFromNativeId<QVideoFrame>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QVideoFrame::operator==(QVideoFrame)const", __qt_this)
        const QVideoFrame& __qt_other0 = QtJambiAPI::valueReferenceFromNativeId<QVideoFrame>(other0);
        __java_return_value = (*__qt_this) == __qt_other0;
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QVideoFrame::paint(QPainter*,QRectF,QVideoFrame::PaintOptions)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_multimedia_QVideoFrame_paint_1native_1QPainter_1ptr_1cref_1QRectF_1cref_1QVideoFrame_1PaintOptions__JJJJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID painter0,
 QtJambiNativeID rect1,
 QtJambiNativeID options2)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QVideoFrame *__qt_this = QtJambiAPI::objectFromNativeId<QVideoFrame>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QVideoFrame::paint(QPainter*,QRectF,QVideoFrame::PaintOptions)", __qt_this)
        QPainter* __qt_painter0 = QtJambiAPI::objectFromNativeId<QPainter>(painter0);
        const QRectF& __qt_rect1 = QtJambiAPI::valueReferenceFromNativeId<QRectF>(rect1);
        const QVideoFrame::PaintOptions& __qt_options2 = QtJambiAPI::valueReferenceFromNativeId<QVideoFrame::PaintOptions>(options2);
        __qt_this->paint(__qt_painter0, __qt_rect1, __qt_options2);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QVideoFrame::pixelFormat()const
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_multimedia_QVideoFrame_pixelFormat_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jint __java_return_value{0};
    QTJAMBI_TRY {
        const QVideoFrame *__qt_this = QtJambiAPI::objectFromNativeId<QVideoFrame>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QVideoFrame::pixelFormat()const", __qt_this)
        QVideoFrameFormat::PixelFormat __qt_return_value = __qt_this->pixelFormat();
        __java_return_value = __qt_return_value;
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QVideoFrame::planeCount()const
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_multimedia_QVideoFrame_planeCount_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jint __java_return_value{0};
    QTJAMBI_TRY {
        const QVideoFrame *__qt_this = QtJambiAPI::objectFromNativeId<QVideoFrame>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QVideoFrame::planeCount()const", __qt_this)
        __java_return_value = __qt_this->planeCount();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QVideoFrame::rotationAngle()const
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_multimedia_QVideoFrame_rotationAngle_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jint __java_return_value{0};
    QTJAMBI_TRY {
        const QVideoFrame *__qt_this = QtJambiAPI::objectFromNativeId<QVideoFrame>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QVideoFrame::rotationAngle()const", __qt_this)
        QVideoFrame::RotationAngle __qt_return_value = __qt_this->rotationAngle();
        __java_return_value = __qt_return_value;
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QVideoFrame::setEndTime(qint64)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_multimedia_QVideoFrame_setEndTime_1native_1qint64__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jlong time0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QVideoFrame *__qt_this = QtJambiAPI::objectFromNativeId<QVideoFrame>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QVideoFrame::setEndTime(qint64)", __qt_this)
        __qt_this->setEndTime(static_cast<qint64>(time0));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QVideoFrame::setMirrored(bool)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_multimedia_QVideoFrame_setMirrored_1native_1bool__JZ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jboolean arg__1)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QVideoFrame *__qt_this = QtJambiAPI::objectFromNativeId<QVideoFrame>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QVideoFrame::setMirrored(bool)", __qt_this)
        __qt_this->setMirrored(static_cast<bool>(arg__1));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QVideoFrame::setRotationAngle(QVideoFrame::RotationAngle)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_multimedia_QVideoFrame_setRotationAngle_1native_1QVideoFrame_1RotationAngle__JI)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint arg__1)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QVideoFrame *__qt_this = QtJambiAPI::objectFromNativeId<QVideoFrame>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QVideoFrame::setRotationAngle(QVideoFrame::RotationAngle)", __qt_this)
        QVideoFrame::RotationAngle __qt_arg__1 = qtjambi_cast<QVideoFrame::RotationAngle>(__jni_env, arg__1);
        __qt_this->setRotationAngle(QVideoFrame::RotationAngle(__qt_arg__1));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QVideoFrame::setStartTime(qint64)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_multimedia_QVideoFrame_setStartTime_1native_1qint64__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jlong time0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QVideoFrame *__qt_this = QtJambiAPI::objectFromNativeId<QVideoFrame>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QVideoFrame::setStartTime(qint64)", __qt_this)
        __qt_this->setStartTime(static_cast<qint64>(time0));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QVideoFrame::setSubtitleText(QString)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_multimedia_QVideoFrame_setSubtitleText_1native_1cref_1QString__JLjava_lang_String_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jstring text0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QVideoFrame *__qt_this = QtJambiAPI::objectFromNativeId<QVideoFrame>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QVideoFrame::setSubtitleText(QString)", __qt_this)
        QString  __qt_text0 = qtjambi_cast<QString>(__jni_env, text0);
        __qt_this->setSubtitleText(__qt_text0);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QVideoFrame::size()const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_multimedia_QVideoFrame_size_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QVideoFrame *__qt_this = QtJambiAPI::objectFromNativeId<QVideoFrame>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QVideoFrame::size()const", __qt_this)
        QSize __qt_return_value = __qt_this->size();
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QVideoFrame::startTime()const
extern "C" Q_DECL_EXPORT jlong JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_multimedia_QVideoFrame_startTime_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jlong __java_return_value{0};
    QTJAMBI_TRY {
        const QVideoFrame *__qt_this = QtJambiAPI::objectFromNativeId<QVideoFrame>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QVideoFrame::startTime()const", __qt_this)
        qint64 __qt_return_value = __qt_this->startTime();
        __java_return_value = jlong(__qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QVideoFrame::subtitleText()const
extern "C" Q_DECL_EXPORT jstring JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_multimedia_QVideoFrame_subtitleText_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jstring __java_return_value{0};
    QTJAMBI_TRY {
        const QVideoFrame *__qt_this = QtJambiAPI::objectFromNativeId<QVideoFrame>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QVideoFrame::subtitleText()const", __qt_this)
        QString __qt_return_value = __qt_this->subtitleText();
        __java_return_value = qtjambi_cast<jstring>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QVideoFrame::surfaceFormat()const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_multimedia_QVideoFrame_surfaceFormat_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QVideoFrame *__qt_this = QtJambiAPI::objectFromNativeId<QVideoFrame>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QVideoFrame::surfaceFormat()const", __qt_this)
        QVideoFrameFormat __qt_return_value = __qt_this->surfaceFormat();
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QVideoFrame::swap(QVideoFrame&)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_multimedia_QVideoFrame_swap_1native_1ref_1QVideoFrame__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID other0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QVideoFrame *__qt_this = QtJambiAPI::objectFromNativeId<QVideoFrame>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QVideoFrame::swap(QVideoFrame&)", __qt_this)
        QVideoFrame& __qt_other0 = QtJambiAPI::objectReferenceFromNativeId<QVideoFrame>(__jni_env, other0);
        __qt_this->swap(__qt_other0);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QVideoFrame::toImage()const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_multimedia_QVideoFrame_toImage_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QVideoFrame *__qt_this = QtJambiAPI::objectFromNativeId<QVideoFrame>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QVideoFrame::toImage()const", __qt_this)
        QImage __qt_return_value = __qt_this->toImage();
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QVideoFrame::unmap()
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_multimedia_QVideoFrame_unmap_1native__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QVideoFrame *__qt_this = QtJambiAPI::objectFromNativeId<QVideoFrame>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QVideoFrame::unmap()", __qt_this)
        __qt_this->unmap();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QVideoFrame::width()const
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_multimedia_QVideoFrame_width_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jint __java_return_value{0};
    QTJAMBI_TRY {
        const QVideoFrame *__qt_this = QtJambiAPI::objectFromNativeId<QVideoFrame>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QVideoFrame::width()const", __qt_this)
        __java_return_value = __qt_this->width();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// emitting (writeJavaLangObjectOverrideFunctions)

extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_multimedia_QVideoFrame_hashCode_1native)
(JNIEnv * __jni_env, jclass, QtJambiNativeID __this_nativeId)
{
    jint __java_return_value = 0;
    QTJAMBI_TRY {
        QVideoFrame *__qt_this = QtJambiAPI::objectFromNativeId<QVideoFrame>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        hash_type hashValue = qHash(*__qt_this);
        __java_return_value = jint(quint64(hashValue) ^ quint64(hashValue) >> 32);
    } QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    } QTJAMBI_TRY_END
    return __java_return_value;
}

#include <QtCore/QDebug>
extern "C" Q_DECL_EXPORT jstring JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_multimedia_QVideoFrame_toString_1native)(JNIEnv *__jni_env, jobject, QtJambiNativeID __this_nativeId)
{
    jstring __java_return_value = nullptr;
    QTJAMBI_TRY {
        QVideoFrame *__qt_this = QtJambiAPI::objectFromNativeId<QVideoFrame>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QString res;
        QDebug(&res).noquote() << *__qt_this;
        if(!res.isEmpty() && res.back().isSpace())
            res = res.trimmed();
        __java_return_value = qtjambi_cast<jstring>(__jni_env, res);
    } QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    } QTJAMBI_TRY_END
    return __java_return_value;
}

// emitting (writeCloneFunction)

extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_multimedia_QVideoFrame_clone_1native)
(JNIEnv *__jni_env, jobject, QtJambiNativeID __this_nativeId)
{
    jobject __java_return_value = nullptr;
    QTJAMBI_TRY {
        const QVideoFrame *__qt_this = QtJambiAPI::objectFromNativeId<QVideoFrame>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        __java_return_value = qtjambi_cast<jobject>(__jni_env, *__qt_this);
    } QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    } QTJAMBI_TRY_END
    return __java_return_value;
}


void initialize_meta_info_QVideoFrame(){
    using namespace RegistryAPI;
    const std::type_info& typeId = registerValueTypeInfo<QVideoFrame>("QVideoFrame", "io/qt/multimedia/QVideoFrame");
    Q_UNUSED(typeId)
// BEGIN: function table
    registerConstructorInfos(typeId, &__qt_destruct_QVideoFrame, {
        ConstructorInfo(&__qt_construct_QVideoFrame_0, nullptr)
       ,ConstructorInfo(&__qt_construct_QVideoFrame_1, "Lio/qt/multimedia/QVideoFrame;")
       ,ConstructorInfo(&__qt_construct_QVideoFrame_2, "Lio/qt/multimedia/QVideoFrameFormat;")
    });
// END: function table

// BEGIN: type registration
    registerDeleter(typeId, &deleter_QVideoFrame);
    registerMetaType<QVideoFrame>("QVideoFrame");
// END: type registration

// BEGIN: polymorphic ids
// END: polymorphic ids


// BEGIN: enums and flags
    registerEnumTypeInfo<QVideoFrame::HandleType>("QVideoFrame::HandleType", "io/qt/multimedia/QVideoFrame$HandleType");
    registerEnumTypeInfo<QVideoFrame::MapMode>("QVideoFrame::MapMode", "io/qt/multimedia/QVideoFrame$MapMode");
    registerEnumTypeInfo<QVideoFrame::RotationAngle>("QVideoFrame::RotationAngle", "io/qt/multimedia/QVideoFrame$RotationAngle");
// END: enums and flags
}
