#include <QtCore/QtGlobal>
#include <QtMultimedia/qcameradevice.h>
#include <QtCore/QVariant>
#include <QtMultimedia/qvideoframeformat.h>
#include <QtCore/qsize.h>

#include <QtJambi/QtJambiAPI>
#include <QtJambiMultimedia/hashes.h>

#include <QtJambi/RegistryAPI>
#include <QtJambi/Cast>

void deleter_QCameraFormat(void *ptr, bool isShell)
{
    QTJAMBI_NATIVE_METHOD_CALL("qtjambi_deleter for QCameraFormat")
    QCameraFormat *_ptr = reinterpret_cast<QCameraFormat *>(ptr);
    if(!isShell){
        QtJambiAPI::registerNonShellDeletion(ptr);
    }
    delete _ptr;
}

// emitting (writeConstructors)
// new QCameraFormat()
void __qt_construct_QCameraFormat_0(void* __qtjambi_ptr, JNIEnv* __jni_env, jobject __jni_object, jvalue* __java_arguments)
{
    QTJAMBI_NATIVE_METHOD_CALL("construct QCameraFormat()")
    Q_UNUSED(__java_arguments)
    QCameraFormat *__qt_this = new(__qtjambi_ptr) QCameraFormat();
    Q_UNUSED(__jni_object)
    Q_UNUSED(__jni_env)
    Q_UNUSED(__qt_this)
}

// new QCameraFormat(QCameraFormat)
void __qt_construct_QCameraFormat_1(void* __qtjambi_ptr, JNIEnv* __jni_env, jobject __jni_object, jvalue* __java_arguments)
{
    QTJAMBI_NATIVE_METHOD_CALL("construct QCameraFormat(QCameraFormat)")
    jobject other0 = __java_arguments[0].l;
    const QCameraFormat& __qt_other0 = qtjambi_cast<const QCameraFormat& >(__jni_env, other0);
    QCameraFormat *__qt_this = new(__qtjambi_ptr) QCameraFormat(__qt_other0);
    Q_UNUSED(__jni_object)
    Q_UNUSED(__qt_this)
}

// destruct QCameraFormat
void __qt_destruct_QCameraFormat(void* ptr)
{
    QTJAMBI_NATIVE_METHOD_CALL("destruct QCameraFormat")
    reinterpret_cast<QCameraFormat*>(ptr)->~QCameraFormat();
}

// emitting  (functionsInTargetLang writeFinalFunction)
// QCameraFormat::QCameraFormat()
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_multimedia_QCameraFormat_initialize_1native__Lio_qt_multimedia_QCameraFormat_2)
(JNIEnv *__jni_env,
 jclass __jni_class,
 jobject __jni_object)
{
    QTJAMBI_NATIVE_METHOD_CALL("QCameraFormat::QCameraFormat()")
    QTJAMBI_TRY {
        QtJambiShell::initialize(__jni_env, __jni_class, __jni_object, &__qt_construct_QCameraFormat_0, sizeof(QCameraFormat), typeid(QCameraFormat), false, &deleter_QCameraFormat, nullptr);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QCameraFormat::QCameraFormat(QCameraFormat)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_multimedia_QCameraFormat_initialize_1native__Lio_qt_multimedia_QCameraFormat_2Lio_qt_multimedia_QCameraFormat_2)
(JNIEnv *__jni_env,
 jclass __jni_class,
 jobject __jni_object,
 jobject other0)
{
    QTJAMBI_NATIVE_METHOD_CALL("QCameraFormat::QCameraFormat(QCameraFormat)")
    QTJAMBI_TRY {
        jvalue arguments;
        arguments.l = other0;
        QtJambiShell::initialize(__jni_env, __jni_class, __jni_object, &__qt_construct_QCameraFormat_1, sizeof(QCameraFormat), typeid(QCameraFormat), false, &deleter_QCameraFormat, &arguments);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QCameraFormat::isNull()const
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_multimedia_QCameraFormat_isNull_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        const QCameraFormat *__qt_this = QtJambiAPI::objectFromNativeId<QCameraFormat>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QCameraFormat::isNull()const", __qt_this)
        __java_return_value = __qt_this->isNull();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QCameraFormat::maxFrameRate()const
extern "C" Q_DECL_EXPORT jfloat JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_multimedia_QCameraFormat_maxFrameRate_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jfloat __java_return_value{0};
    QTJAMBI_TRY {
        const QCameraFormat *__qt_this = QtJambiAPI::objectFromNativeId<QCameraFormat>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QCameraFormat::maxFrameRate()const", __qt_this)
        __java_return_value = __qt_this->maxFrameRate();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QCameraFormat::minFrameRate()const
extern "C" Q_DECL_EXPORT jfloat JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_multimedia_QCameraFormat_minFrameRate_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jfloat __java_return_value{0};
    QTJAMBI_TRY {
        const QCameraFormat *__qt_this = QtJambiAPI::objectFromNativeId<QCameraFormat>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QCameraFormat::minFrameRate()const", __qt_this)
        __java_return_value = __qt_this->minFrameRate();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QCameraFormat::operator=(QCameraFormat)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_multimedia_QCameraFormat_assign_1native_1cref_1QCameraFormat__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID other0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QCameraFormat *__qt_this = QtJambiAPI::objectFromNativeId<QCameraFormat>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QCameraFormat::operator=(QCameraFormat)", __qt_this)
        const QCameraFormat& __qt_other0 = QtJambiAPI::valueReferenceFromNativeId<QCameraFormat>(other0);
        (*__qt_this) = __qt_other0;
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QCameraFormat::operator==(QCameraFormat)const
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_multimedia_QCameraFormat_operator_1equal_1native_1cref_1QCameraFormat_1constfct__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID other0)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        const QCameraFormat *__qt_this = QtJambiAPI::objectFromNativeId<QCameraFormat>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QCameraFormat::operator==(QCameraFormat)const", __qt_this)
        const QCameraFormat& __qt_other0 = QtJambiAPI::valueReferenceFromNativeId<QCameraFormat>(other0);
        __java_return_value = (*__qt_this) == __qt_other0;
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QCameraFormat::pixelFormat()const
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_multimedia_QCameraFormat_pixelFormat_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jint __java_return_value{0};
    QTJAMBI_TRY {
        const QCameraFormat *__qt_this = QtJambiAPI::objectFromNativeId<QCameraFormat>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QCameraFormat::pixelFormat()const", __qt_this)
        QVideoFrameFormat::PixelFormat __qt_return_value = __qt_this->pixelFormat();
        __java_return_value = __qt_return_value;
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QCameraFormat::resolution()const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_multimedia_QCameraFormat_resolution_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QCameraFormat *__qt_this = QtJambiAPI::objectFromNativeId<QCameraFormat>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QCameraFormat::resolution()const", __qt_this)
        QSize __qt_return_value = __qt_this->resolution();
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// emitting (writeJavaLangObjectOverrideFunctions)

extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_multimedia_QCameraFormat_hashCode_1native)
(JNIEnv * __jni_env, jclass, QtJambiNativeID __this_nativeId)
{
    jint __java_return_value = 0;
    QTJAMBI_TRY {
        QCameraFormat *__qt_this = QtJambiAPI::objectFromNativeId<QCameraFormat>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        hash_type hashValue = qHash(*__qt_this);
        __java_return_value = jint(quint64(hashValue) ^ quint64(hashValue) >> 32);
    } QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    } QTJAMBI_TRY_END
    return __java_return_value;
}
// emitting (writeCloneFunction)

extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_multimedia_QCameraFormat_clone_1native)
(JNIEnv *__jni_env, jobject, QtJambiNativeID __this_nativeId)
{
    jobject __java_return_value = nullptr;
    QTJAMBI_TRY {
        const QCameraFormat *__qt_this = QtJambiAPI::objectFromNativeId<QCameraFormat>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        __java_return_value = qtjambi_cast<jobject>(__jni_env, *__qt_this);
    } QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    } QTJAMBI_TRY_END
    return __java_return_value;
}


void initialize_meta_info_QCameraFormat(){
    using namespace RegistryAPI;
    const std::type_info& typeId = registerValueTypeInfo<QCameraFormat>("QCameraFormat", "io/qt/multimedia/QCameraFormat");
    Q_UNUSED(typeId)
// BEGIN: function table
    registerConstructorInfos(typeId, &__qt_destruct_QCameraFormat, {
        ConstructorInfo(&__qt_construct_QCameraFormat_0, nullptr)
       ,ConstructorInfo(&__qt_construct_QCameraFormat_1, "Lio/qt/multimedia/QCameraFormat;")
    });
// END: function table

    registerMetaObject(typeId, QCameraFormat::staticMetaObject, false);
// END: signal table

// BEGIN: type registration
    registerDeleter(typeId, &deleter_QCameraFormat);
    registerMetaType<QCameraFormat>("QCameraFormat");
// END: type registration

// BEGIN: polymorphic ids
// END: polymorphic ids


// BEGIN: enums and flags
// END: enums and flags
}
