#include <QtCore/QtGlobal>
#include <QtMultimedia/qaudiodevice.h>
#include <QtCore/QVariant>
#include <QtCore/qbytearray.h>
#include <QtMultimedia/qaudioformat.h>
#include <QtCore/QList>

#include <QtJambi/QtJambiAPI>
#include <QtJambiMultimedia/hashes.h>

#include <QtJambi/RegistryAPI>
#include <QtJambi/Cast>

void deleter_QAudioDevice(void *ptr, bool isShell)
{
    QTJAMBI_NATIVE_METHOD_CALL("qtjambi_deleter for QAudioDevice")
    QAudioDevice *_ptr = reinterpret_cast<QAudioDevice *>(ptr);
    if(!isShell){
        QtJambiAPI::registerNonShellDeletion(ptr);
    }
    delete _ptr;
}

// emitting (writeConstructors)
// new QAudioDevice()
void __qt_construct_QAudioDevice_0(void* __qtjambi_ptr, JNIEnv* __jni_env, jobject __jni_object, jvalue* __java_arguments)
{
    QTJAMBI_NATIVE_METHOD_CALL("construct QAudioDevice()")
    Q_UNUSED(__java_arguments)
    QAudioDevice *__qt_this = new(__qtjambi_ptr) QAudioDevice();
    Q_UNUSED(__jni_object)
    Q_UNUSED(__jni_env)
    Q_UNUSED(__qt_this)
}

// new QAudioDevice(QAudioDevice)
void __qt_construct_QAudioDevice_1(void* __qtjambi_ptr, JNIEnv* __jni_env, jobject __jni_object, jvalue* __java_arguments)
{
    QTJAMBI_NATIVE_METHOD_CALL("construct QAudioDevice(QAudioDevice)")
    jobject other0 = __java_arguments[0].l;
    const QAudioDevice& __qt_other0 = qtjambi_cast<const QAudioDevice& >(__jni_env, other0);
    QAudioDevice *__qt_this = new(__qtjambi_ptr) QAudioDevice(__qt_other0);
    Q_UNUSED(__jni_object)
    Q_UNUSED(__qt_this)
}

// destruct QAudioDevice
void __qt_destruct_QAudioDevice(void* ptr)
{
    QTJAMBI_NATIVE_METHOD_CALL("destruct QAudioDevice")
    reinterpret_cast<QAudioDevice*>(ptr)->~QAudioDevice();
}

// emitting  (functionsInTargetLang writeFinalFunction)
// QAudioDevice::QAudioDevice()
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_multimedia_QAudioDevice_initialize_1native__Lio_qt_multimedia_QAudioDevice_2)
(JNIEnv *__jni_env,
 jclass __jni_class,
 jobject __jni_object)
{
    QTJAMBI_NATIVE_METHOD_CALL("QAudioDevice::QAudioDevice()")
    QTJAMBI_TRY {
        QtJambiShell::initialize(__jni_env, __jni_class, __jni_object, &__qt_construct_QAudioDevice_0, sizeof(QAudioDevice), typeid(QAudioDevice), false, &deleter_QAudioDevice, nullptr);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QAudioDevice::QAudioDevice(QAudioDevice)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_multimedia_QAudioDevice_initialize_1native__Lio_qt_multimedia_QAudioDevice_2Lio_qt_multimedia_QAudioDevice_2)
(JNIEnv *__jni_env,
 jclass __jni_class,
 jobject __jni_object,
 jobject other0)
{
    QTJAMBI_NATIVE_METHOD_CALL("QAudioDevice::QAudioDevice(QAudioDevice)")
    QTJAMBI_TRY {
        jvalue arguments;
        arguments.l = other0;
        QtJambiShell::initialize(__jni_env, __jni_class, __jni_object, &__qt_construct_QAudioDevice_1, sizeof(QAudioDevice), typeid(QAudioDevice), false, &deleter_QAudioDevice, &arguments);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QAudioDevice::channelConfiguration()const
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_multimedia_QAudioDevice_channelConfiguration_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jint __java_return_value{0};
    QTJAMBI_TRY {
        const QAudioDevice *__qt_this = QtJambiAPI::objectFromNativeId<QAudioDevice>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QAudioDevice::channelConfiguration()const", __qt_this)
        QAudioFormat::ChannelConfig __qt_return_value = __qt_this->channelConfiguration();
        __java_return_value = __qt_return_value;
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QAudioDevice::description()const
extern "C" Q_DECL_EXPORT jstring JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_multimedia_QAudioDevice_description_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jstring __java_return_value{0};
    QTJAMBI_TRY {
        const QAudioDevice *__qt_this = QtJambiAPI::objectFromNativeId<QAudioDevice>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QAudioDevice::description()const", __qt_this)
        QString __qt_return_value = __qt_this->description();
        __java_return_value = qtjambi_cast<jstring>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QAudioDevice::id()const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_multimedia_QAudioDevice_id_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QAudioDevice *__qt_this = QtJambiAPI::objectFromNativeId<QAudioDevice>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QAudioDevice::id()const", __qt_this)
        QByteArray __qt_return_value = __qt_this->id();
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QAudioDevice::isDefault()const
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_multimedia_QAudioDevice_isDefault_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        const QAudioDevice *__qt_this = QtJambiAPI::objectFromNativeId<QAudioDevice>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QAudioDevice::isDefault()const", __qt_this)
        __java_return_value = __qt_this->isDefault();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QAudioDevice::isFormatSupported(QAudioFormat)const
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_multimedia_QAudioDevice_isFormatSupported_1native_1cref_1QAudioFormat_1constfct__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID format0)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        const QAudioDevice *__qt_this = QtJambiAPI::objectFromNativeId<QAudioDevice>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QAudioDevice::isFormatSupported(QAudioFormat)const", __qt_this)
        const QAudioFormat& __qt_format0 = QtJambiAPI::valueReferenceFromNativeId<QAudioFormat>(format0);
        __java_return_value = __qt_this->isFormatSupported(__qt_format0);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QAudioDevice::isNull()const
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_multimedia_QAudioDevice_isNull_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        const QAudioDevice *__qt_this = QtJambiAPI::objectFromNativeId<QAudioDevice>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QAudioDevice::isNull()const", __qt_this)
        __java_return_value = __qt_this->isNull();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QAudioDevice::maximumChannelCount()const
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_multimedia_QAudioDevice_maximumChannelCount_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jint __java_return_value{0};
    QTJAMBI_TRY {
        const QAudioDevice *__qt_this = QtJambiAPI::objectFromNativeId<QAudioDevice>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QAudioDevice::maximumChannelCount()const", __qt_this)
        __java_return_value = __qt_this->maximumChannelCount();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QAudioDevice::maximumSampleRate()const
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_multimedia_QAudioDevice_maximumSampleRate_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jint __java_return_value{0};
    QTJAMBI_TRY {
        const QAudioDevice *__qt_this = QtJambiAPI::objectFromNativeId<QAudioDevice>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QAudioDevice::maximumSampleRate()const", __qt_this)
        __java_return_value = __qt_this->maximumSampleRate();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QAudioDevice::minimumChannelCount()const
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_multimedia_QAudioDevice_minimumChannelCount_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jint __java_return_value{0};
    QTJAMBI_TRY {
        const QAudioDevice *__qt_this = QtJambiAPI::objectFromNativeId<QAudioDevice>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QAudioDevice::minimumChannelCount()const", __qt_this)
        __java_return_value = __qt_this->minimumChannelCount();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QAudioDevice::minimumSampleRate()const
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_multimedia_QAudioDevice_minimumSampleRate_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jint __java_return_value{0};
    QTJAMBI_TRY {
        const QAudioDevice *__qt_this = QtJambiAPI::objectFromNativeId<QAudioDevice>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QAudioDevice::minimumSampleRate()const", __qt_this)
        __java_return_value = __qt_this->minimumSampleRate();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QAudioDevice::mode()const
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_multimedia_QAudioDevice_mode_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jint __java_return_value{0};
    QTJAMBI_TRY {
        const QAudioDevice *__qt_this = QtJambiAPI::objectFromNativeId<QAudioDevice>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QAudioDevice::mode()const", __qt_this)
        QAudioDevice::Mode __qt_return_value = __qt_this->mode();
        __java_return_value = __qt_return_value;
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QAudioDevice::operator=(QAudioDevice)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_multimedia_QAudioDevice_assign_1native_1cref_1QAudioDevice__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID other0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QAudioDevice *__qt_this = QtJambiAPI::objectFromNativeId<QAudioDevice>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QAudioDevice::operator=(QAudioDevice)", __qt_this)
        const QAudioDevice& __qt_other0 = QtJambiAPI::valueReferenceFromNativeId<QAudioDevice>(other0);
        (*__qt_this) = __qt_other0;
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QAudioDevice::operator==(QAudioDevice)const
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_multimedia_QAudioDevice_operator_1equal_1native_1cref_1QAudioDevice_1constfct__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID other0)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        const QAudioDevice *__qt_this = QtJambiAPI::objectFromNativeId<QAudioDevice>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QAudioDevice::operator==(QAudioDevice)const", __qt_this)
        const QAudioDevice& __qt_other0 = QtJambiAPI::valueReferenceFromNativeId<QAudioDevice>(other0);
        __java_return_value = (*__qt_this) == __qt_other0;
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QAudioDevice::preferredFormat()const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_multimedia_QAudioDevice_preferredFormat_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QAudioDevice *__qt_this = QtJambiAPI::objectFromNativeId<QAudioDevice>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QAudioDevice::preferredFormat()const", __qt_this)
        QAudioFormat __qt_return_value = __qt_this->preferredFormat();
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QAudioDevice::supportedSampleFormats()const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_multimedia_QAudioDevice_supportedSampleFormats_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QAudioDevice *__qt_this = QtJambiAPI::objectFromNativeId<QAudioDevice>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QAudioDevice::supportedSampleFormats()const", __qt_this)
        QList<QAudioFormat::SampleFormat> __qt_return_value = __qt_this->supportedSampleFormats();
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QAudioDevice::swap(QAudioDevice&)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_multimedia_QAudioDevice_swap_1native_1ref_1QAudioDevice__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID other0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QAudioDevice *__qt_this = QtJambiAPI::objectFromNativeId<QAudioDevice>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QAudioDevice::swap(QAudioDevice&)", __qt_this)
        QAudioDevice& __qt_other0 = QtJambiAPI::objectReferenceFromNativeId<QAudioDevice>(__jni_env, other0);
        __qt_this->swap(__qt_other0);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// emitting (writeJavaLangObjectOverrideFunctions)

extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_multimedia_QAudioDevice_hashCode_1native)
(JNIEnv * __jni_env, jclass, QtJambiNativeID __this_nativeId)
{
    jint __java_return_value = 0;
    QTJAMBI_TRY {
        QAudioDevice *__qt_this = QtJambiAPI::objectFromNativeId<QAudioDevice>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        hash_type hashValue = qHash(*__qt_this);
        __java_return_value = jint(quint64(hashValue) ^ quint64(hashValue) >> 32);
    } QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    } QTJAMBI_TRY_END
    return __java_return_value;
}
// emitting (writeCloneFunction)

extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_multimedia_QAudioDevice_clone_1native)
(JNIEnv *__jni_env, jobject, QtJambiNativeID __this_nativeId)
{
    jobject __java_return_value = nullptr;
    QTJAMBI_TRY {
        const QAudioDevice *__qt_this = QtJambiAPI::objectFromNativeId<QAudioDevice>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        __java_return_value = qtjambi_cast<jobject>(__jni_env, *__qt_this);
    } QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    } QTJAMBI_TRY_END
    return __java_return_value;
}


void initialize_meta_info_QAudioDevice(){
    using namespace RegistryAPI;
    const std::type_info& typeId = registerValueTypeInfo<QAudioDevice>("QAudioDevice", "io/qt/multimedia/QAudioDevice");
    Q_UNUSED(typeId)
// BEGIN: function table
    registerConstructorInfos(typeId, &__qt_destruct_QAudioDevice, {
        ConstructorInfo(&__qt_construct_QAudioDevice_0, nullptr)
       ,ConstructorInfo(&__qt_construct_QAudioDevice_1, "Lio/qt/multimedia/QAudioDevice;")
    });
// END: function table

    registerMetaObject(typeId, QAudioDevice::staticMetaObject, false);
// END: signal table

// BEGIN: type registration
    registerDeleter(typeId, &deleter_QAudioDevice);
    registerMetaType<QAudioDevice>("QAudioDevice");
// END: type registration

// BEGIN: polymorphic ids
// END: polymorphic ids


// BEGIN: enums and flags
    registerEnumTypeInfo<QAudioDevice::Mode>("QAudioDevice::Mode", "io/qt/multimedia/QAudioDevice$Mode");
// END: enums and flags
}
