#include <QtCore/QtGlobal>
#include <QtMultimedia/qmediacontent.h>
#include <QtCore/QList>
#include <QtCore/QVariant>
#include <QtCore/qurl.h>
#include <QtMultimedia/qmediaplaylist.h>
#include <QtMultimedia/qmediaresource.h>
#include <QtNetwork/qnetworkrequest.h>

#include <QtJambi/QtJambiAPI>
#include <QtJambiMultimedia/hashes.h>

#include <QtJambi/RegistryAPI>
#include <QtJambi/Cast>

void deleter_QMediaContent(void *ptr, bool isShell)
{
    QTJAMBI_NATIVE_METHOD_CALL("qtjambi_deleter for QMediaContent")
    QMediaContent *_ptr = reinterpret_cast<QMediaContent *>(ptr);
    if(!isShell){
        QtJambiAPI::registerNonShellDeletion(ptr);
    }
    delete _ptr;
}

// emitting (writeConstructors)
// new QMediaContent()
void __qt_construct_QMediaContent(void* __qtjambi_ptr, JNIEnv* __jni_env, jobject __jni_object, jvalue* __java_arguments, bool __qtjambi_is_generic)
{
    QTJAMBI_NATIVE_METHOD_CALL("construct QMediaContent()")
    Q_UNUSED(__java_arguments)
    QMediaContent *__qt_this = new(__qtjambi_ptr) QMediaContent();
    Q_UNUSED(__qtjambi_is_generic)
    Q_UNUSED(__jni_object)
    Q_UNUSED(__jni_env)
    Q_UNUSED(__qt_this)
}

// QMediaContent::QMediaContent()
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_multimedia_QMediaContent_initialize_1native__Lio_qt_multimedia_QMediaContent_2)
(JNIEnv *__jni_env,
 jclass __jni_class,
 jobject __jni_object)
{
    QTJAMBI_NATIVE_METHOD_CALL("QMediaContent::QMediaContent()")
    QTJAMBI_TRY {
        QtJambiShell::initialize(__jni_env, __jni_class, __jni_object, &__qt_construct_QMediaContent, sizeof(QMediaContent), typeid(QMediaContent), false, &deleter_QMediaContent, nullptr);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// new QMediaContent(QMediaResourceList)
void __qt_construct_QMediaContent_cref_QList(void* __qtjambi_ptr, JNIEnv* __jni_env, jobject __jni_object, jvalue* __java_arguments, bool __qtjambi_is_generic)
{
    QTJAMBI_NATIVE_METHOD_CALL("construct QMediaContent(QMediaResourceList)")
    QtJambiScope __qtjambi_scope;
    jobject resources0 = __java_arguments[0].l;
    const QList<QMediaResource>&  __qt_resources0 = qtjambi_cast<const QList<QMediaResource>& >(__jni_env, __qtjambi_scope, resources0);
    QMediaContent *__qt_this = new(__qtjambi_ptr) QMediaContent(__qt_resources0);
    Q_UNUSED(__qtjambi_is_generic)
    Q_UNUSED(__jni_object)
    Q_UNUSED(__qt_this)
}

// QMediaContent::QMediaContent(QMediaResourceList)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_multimedia_QMediaContent_initialize_1native__Lio_qt_multimedia_QMediaContent_2Ljava_util_Collection_2)
(JNIEnv *__jni_env,
 jclass __jni_class,
 jobject __jni_object,
 jobject resources0)
{
    QTJAMBI_NATIVE_METHOD_CALL("QMediaContent::QMediaContent(QMediaResourceList)")
    QTJAMBI_TRY {
        jvalue arguments;
        arguments.l = resources0;
        QtJambiShell::initialize(__jni_env, __jni_class, __jni_object, &__qt_construct_QMediaContent_cref_QList, sizeof(QMediaContent), typeid(QMediaContent), false, &deleter_QMediaContent, &arguments);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// new QMediaContent(QMediaContent)
void __qt_construct_QMediaContent_cref_QMediaContent(void* __qtjambi_ptr, JNIEnv* __jni_env, jobject __jni_object, jvalue* __java_arguments, bool __qtjambi_is_generic)
{
    QTJAMBI_NATIVE_METHOD_CALL("construct QMediaContent(QMediaContent)")
    jobject other0 = __java_arguments[0].l;
    const QMediaContent& __qt_other0 = qtjambi_cast<const QMediaContent& >(__jni_env, other0);
    QMediaContent *__qt_this = new(__qtjambi_ptr) QMediaContent(__qt_other0);
    Q_UNUSED(__qtjambi_is_generic)
    Q_UNUSED(__jni_object)
    Q_UNUSED(__qt_this)
}

// QMediaContent::QMediaContent(QMediaContent)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_multimedia_QMediaContent_initialize_1native__Lio_qt_multimedia_QMediaContent_2Lio_qt_multimedia_QMediaContent_2)
(JNIEnv *__jni_env,
 jclass __jni_class,
 jobject __jni_object,
 jobject other0)
{
    QTJAMBI_NATIVE_METHOD_CALL("QMediaContent::QMediaContent(QMediaContent)")
    QTJAMBI_TRY {
        jvalue arguments;
        arguments.l = other0;
        QtJambiShell::initialize(__jni_env, __jni_class, __jni_object, &__qt_construct_QMediaContent_cref_QMediaContent, sizeof(QMediaContent), typeid(QMediaContent), false, &deleter_QMediaContent, &arguments);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// new QMediaContent(QMediaPlaylist*,QUrl,bool)
void __qt_construct_QMediaContent_QMediaPlaylist_ptr(void* __qtjambi_ptr, JNIEnv* __jni_env, jobject __jni_object, jvalue* __java_arguments, bool __qtjambi_is_generic)
{
    QTJAMBI_NATIVE_METHOD_CALL("construct QMediaContent(QMediaPlaylist*,QUrl,bool)")
    jobject playlist0 = __java_arguments[0].l;
    QMediaPlaylist* __qt_playlist0 = qtjambi_cast<QMediaPlaylist* >(__jni_env, playlist0);
    QMediaContent *__qt_this = new(__qtjambi_ptr) QMediaContent(__qt_playlist0);
    Q_UNUSED(__qtjambi_is_generic)
    Q_UNUSED(__jni_object)
    Q_UNUSED(__qt_this)
}

// new QMediaContent(QMediaPlaylist*,QUrl,bool)
void __qt_construct_QMediaContent_QMediaPlaylist_ptr_cref_QUrl(void* __qtjambi_ptr, JNIEnv* __jni_env, jobject __jni_object, jvalue* __java_arguments, bool __qtjambi_is_generic)
{
    QTJAMBI_NATIVE_METHOD_CALL("construct QMediaContent(QMediaPlaylist*,QUrl,bool)")
    jobject playlist0 = __java_arguments[0].l;
    QMediaPlaylist* __qt_playlist0 = qtjambi_cast<QMediaPlaylist* >(__jni_env, playlist0);
    jobject contentUrl1 = __java_arguments[1].l;
    const QUrl& __qt_contentUrl1 = qtjambi_cast<const QUrl& >(__jni_env, contentUrl1);
    QMediaContent *__qt_this = new(__qtjambi_ptr) QMediaContent(__qt_playlist0, __qt_contentUrl1);
    Q_UNUSED(__qtjambi_is_generic)
    Q_UNUSED(__jni_object)
    Q_UNUSED(__qt_this)
}

// new QMediaContent(QMediaPlaylist*,QUrl,bool)
void __qt_construct_QMediaContent_QMediaPlaylist_ptr_cref_QUrl_bool(void* __qtjambi_ptr, JNIEnv* __jni_env, jobject __jni_object, jvalue* __java_arguments, bool __qtjambi_is_generic)
{
    QTJAMBI_NATIVE_METHOD_CALL("construct QMediaContent(QMediaPlaylist*,QUrl,bool)")
    jobject playlist0 = __java_arguments[0].l;
    QMediaPlaylist* __qt_playlist0 = qtjambi_cast<QMediaPlaylist* >(__jni_env, playlist0);
    jobject contentUrl1 = __java_arguments[1].l;
    const QUrl& __qt_contentUrl1 = qtjambi_cast<const QUrl& >(__jni_env, contentUrl1);
    jboolean takeOwnership2 = __java_arguments[2].z;
    Q_UNUSED(takeOwnership2)
    QMediaContent *__qt_this = new(__qtjambi_ptr) QMediaContent(__qt_playlist0, __qt_contentUrl1, static_cast<bool>(takeOwnership2));
    Q_UNUSED(__qtjambi_is_generic)
    Q_UNUSED(__jni_object)
    Q_UNUSED(__qt_this)
}

// QMediaContent::QMediaContent(QMediaPlaylist*,QUrl,bool)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_multimedia_QMediaContent_initialize_1native__Lio_qt_multimedia_QMediaContent_2Lio_qt_multimedia_QMediaPlaylist_2Lio_qt_core_QUrl_2Z)
(JNIEnv *__jni_env,
 jclass __jni_class,
 jobject __jni_object,
 jobject playlist0,
 jobject contentUrl1,
 jboolean takeOwnership2)
{
    QTJAMBI_NATIVE_METHOD_CALL("QMediaContent::QMediaContent(QMediaPlaylist*,QUrl,bool)")
    QTJAMBI_TRY {
        jvalue arguments[3];
        arguments[0].l = playlist0;
        arguments[1].l = contentUrl1;
        arguments[2].z = takeOwnership2;
        QtJambiShell::initialize(__jni_env, __jni_class, __jni_object, &__qt_construct_QMediaContent_QMediaPlaylist_ptr_cref_QUrl_bool, sizeof(QMediaContent), typeid(QMediaContent), false, &deleter_QMediaContent, arguments);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// new QMediaContent(QMediaResource)
void __qt_construct_QMediaContent_cref_QMediaResource(void* __qtjambi_ptr, JNIEnv* __jni_env, jobject __jni_object, jvalue* __java_arguments, bool __qtjambi_is_generic)
{
    QTJAMBI_NATIVE_METHOD_CALL("construct QMediaContent(QMediaResource)")
    jobject contentResource0 = __java_arguments[0].l;
    const QMediaResource& __qt_contentResource0 = qtjambi_cast<const QMediaResource& >(__jni_env, contentResource0);
    QMediaContent *__qt_this = new(__qtjambi_ptr) QMediaContent(__qt_contentResource0);
    Q_UNUSED(__qtjambi_is_generic)
    Q_UNUSED(__jni_object)
    Q_UNUSED(__qt_this)
}

// QMediaContent::QMediaContent(QMediaResource)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_multimedia_QMediaContent_initialize_1native__Lio_qt_multimedia_QMediaContent_2Lio_qt_multimedia_QMediaResource_2)
(JNIEnv *__jni_env,
 jclass __jni_class,
 jobject __jni_object,
 jobject contentResource0)
{
    QTJAMBI_NATIVE_METHOD_CALL("QMediaContent::QMediaContent(QMediaResource)")
    QTJAMBI_TRY {
        jvalue arguments;
        arguments.l = contentResource0;
        QtJambiShell::initialize(__jni_env, __jni_class, __jni_object, &__qt_construct_QMediaContent_cref_QMediaResource, sizeof(QMediaContent), typeid(QMediaContent), false, &deleter_QMediaContent, &arguments);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// new QMediaContent(QNetworkRequest)
void __qt_construct_QMediaContent_cref_QNetworkRequest(void* __qtjambi_ptr, JNIEnv* __jni_env, jobject __jni_object, jvalue* __java_arguments, bool __qtjambi_is_generic)
{
    QTJAMBI_NATIVE_METHOD_CALL("construct QMediaContent(QNetworkRequest)")
    jobject contentRequest0 = __java_arguments[0].l;
    const QNetworkRequest& __qt_contentRequest0 = qtjambi_cast<const QNetworkRequest& >(__jni_env, contentRequest0);
    QMediaContent *__qt_this = new(__qtjambi_ptr) QMediaContent(__qt_contentRequest0);
    Q_UNUSED(__qtjambi_is_generic)
    Q_UNUSED(__jni_object)
    Q_UNUSED(__qt_this)
}

// QMediaContent::QMediaContent(QNetworkRequest)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_multimedia_QMediaContent_initialize_1native__Lio_qt_multimedia_QMediaContent_2Lio_qt_network_QNetworkRequest_2)
(JNIEnv *__jni_env,
 jclass __jni_class,
 jobject __jni_object,
 jobject contentRequest0)
{
    QTJAMBI_NATIVE_METHOD_CALL("QMediaContent::QMediaContent(QNetworkRequest)")
    QTJAMBI_TRY {
        jvalue arguments;
        arguments.l = contentRequest0;
        QtJambiShell::initialize(__jni_env, __jni_class, __jni_object, &__qt_construct_QMediaContent_cref_QNetworkRequest, sizeof(QMediaContent), typeid(QMediaContent), false, &deleter_QMediaContent, &arguments);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// new QMediaContent(QUrl)
void __qt_construct_QMediaContent_cref_QUrl(void* __qtjambi_ptr, JNIEnv* __jni_env, jobject __jni_object, jvalue* __java_arguments, bool __qtjambi_is_generic)
{
    QTJAMBI_NATIVE_METHOD_CALL("construct QMediaContent(QUrl)")
    jobject contentUrl0 = __java_arguments[0].l;
    const QUrl& __qt_contentUrl0 = qtjambi_cast<const QUrl& >(__jni_env, contentUrl0);
    QMediaContent *__qt_this = new(__qtjambi_ptr) QMediaContent(__qt_contentUrl0);
    Q_UNUSED(__qtjambi_is_generic)
    Q_UNUSED(__jni_object)
    Q_UNUSED(__qt_this)
}

// QMediaContent::QMediaContent(QUrl)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_multimedia_QMediaContent_initialize_1native__Lio_qt_multimedia_QMediaContent_2Lio_qt_core_QUrl_2)
(JNIEnv *__jni_env,
 jclass __jni_class,
 jobject __jni_object,
 jobject contentUrl0)
{
    QTJAMBI_NATIVE_METHOD_CALL("QMediaContent::QMediaContent(QUrl)")
    QTJAMBI_TRY {
        jvalue arguments;
        arguments.l = contentUrl0;
        QtJambiShell::initialize(__jni_env, __jni_class, __jni_object, &__qt_construct_QMediaContent_cref_QUrl, sizeof(QMediaContent), typeid(QMediaContent), false, &deleter_QMediaContent, &arguments);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// destruct QMediaContent
void __qt_destruct_QMediaContent(void* ptr)
{
    QTJAMBI_NATIVE_METHOD_CALL("destruct QMediaContent")
    reinterpret_cast<QMediaContent*>(ptr)->~QMediaContent();
}

// emitting  (functionsInTargetLang writeFinalFunction)
// QMediaContent::canonicalRequest()const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_multimedia_QMediaContent_canonicalRequest_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QMediaContent *__qt_this = QtJambiAPI::objectFromNativeId<QMediaContent>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QMediaContent::canonicalRequest()const", __qt_this)
        QNetworkRequest __qt_return_value = __qt_this->canonicalRequest();
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QMediaContent::canonicalResource()const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_multimedia_QMediaContent_canonicalResource_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QMediaContent *__qt_this = QtJambiAPI::objectFromNativeId<QMediaContent>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QMediaContent::canonicalResource()const", __qt_this)
        QMediaResource __qt_return_value = __qt_this->canonicalResource();
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QMediaContent::canonicalUrl()const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_multimedia_QMediaContent_canonicalUrl_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QMediaContent *__qt_this = QtJambiAPI::objectFromNativeId<QMediaContent>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QMediaContent::canonicalUrl()const", __qt_this)
        QUrl __qt_return_value = __qt_this->canonicalUrl();
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QMediaContent::isNull()const
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_multimedia_QMediaContent_isNull_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        const QMediaContent *__qt_this = QtJambiAPI::objectFromNativeId<QMediaContent>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QMediaContent::isNull()const", __qt_this)
        __java_return_value = __qt_this->isNull();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QMediaContent::operator=(QMediaContent)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_multimedia_QMediaContent_assign_1native_1cref_1QMediaContent__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID other0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QMediaContent *__qt_this = QtJambiAPI::objectFromNativeId<QMediaContent>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QMediaContent::operator=(QMediaContent)", __qt_this)
        const QMediaContent& __qt_other0 = QtJambiAPI::valueReferenceFromNativeId<QMediaContent>(other0);
        (*__qt_this) = __qt_other0;
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QMediaContent::operator==(QMediaContent)const
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_multimedia_QMediaContent_equals_1native_1cref_1QMediaContent_1constfct__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID other0)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        const QMediaContent *__qt_this = QtJambiAPI::objectFromNativeId<QMediaContent>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QMediaContent::operator==(QMediaContent)const", __qt_this)
        const QMediaContent& __qt_other0 = QtJambiAPI::valueReferenceFromNativeId<QMediaContent>(other0);
        __java_return_value = (*__qt_this) == __qt_other0;
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QMediaContent::playlist()const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_multimedia_QMediaContent_playlist_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QMediaContent *__qt_this = QtJambiAPI::objectFromNativeId<QMediaContent>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QMediaContent::playlist()const", __qt_this)
        QMediaPlaylist* __qt_return_value = __qt_this->playlist();
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QMediaContent::request()const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_multimedia_QMediaContent_request_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QMediaContent *__qt_this = QtJambiAPI::objectFromNativeId<QMediaContent>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QMediaContent::request()const", __qt_this)
        QNetworkRequest __qt_return_value = __qt_this->request();
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QMediaContent::resources()const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_multimedia_QMediaContent_resources_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QMediaContent *__qt_this = QtJambiAPI::objectFromNativeId<QMediaContent>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QMediaContent::resources()const", __qt_this)
        QList<QMediaResource> __qt_return_value = __qt_this->resources();
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// emitting (writeJavaLangObjectOverrideFunctions)

extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_multimedia_QMediaContent_hashCode_1native)
(JNIEnv * __jni_env, jclass, QtJambiNativeID __this_nativeId)
{
    jint __java_return_value = 0;
    QTJAMBI_TRY {
        QMediaContent *__qt_this = QtJambiAPI::objectFromNativeId<QMediaContent>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        hash_type hashValue = qHash(*__qt_this);
        __java_return_value = jint(hashValue);
    } QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    } QTJAMBI_TRY_END
    return __java_return_value;
}
// emitting (writeCloneFunction)

extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_multimedia_QMediaContent_clone_1native)
(JNIEnv *__jni_env, jobject, QtJambiNativeID __this_nativeId)
{
    jobject __java_return_value = nullptr;
    QTJAMBI_TRY {
        const QMediaContent *__qt_this = QtJambiAPI::objectFromNativeId<QMediaContent>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        __java_return_value = qtjambi_cast<jobject>(__jni_env, *__qt_this);
    } QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    } QTJAMBI_TRY_END
    return __java_return_value;
}


void initialize_meta_info_QMediaContent(){
    using namespace RegistryAPI;
    const std::type_info& typeId = registerValueTypeInfo<QMediaContent>("QMediaContent", "io/qt/multimedia/QMediaContent");
    Q_UNUSED(typeId)
// BEGIN: function table
    registerConstructorInfos(typeId, &__qt_destruct_QMediaContent, {
        ConstructorInfo(&__qt_construct_QMediaContent, nullptr)
       ,ConstructorInfo(&__qt_construct_QMediaContent_cref_QList, "Ljava/util/Collection;")
       ,ConstructorInfo(&__qt_construct_QMediaContent_cref_QMediaContent, "Lio/qt/multimedia/QMediaContent;")
       ,ConstructorInfo(&__qt_construct_QMediaContent_QMediaPlaylist_ptr, "Lio/qt/multimedia/QMediaPlaylist;")
       ,ConstructorInfo(&__qt_construct_QMediaContent_QMediaPlaylist_ptr_cref_QUrl, "Lio/qt/multimedia/QMediaPlaylist;Lio/qt/core/QUrl;")
       ,ConstructorInfo(&__qt_construct_QMediaContent_QMediaPlaylist_ptr_cref_QUrl_bool, "Lio/qt/multimedia/QMediaPlaylist;Lio/qt/core/QUrl;Z")
       ,ConstructorInfo(&__qt_construct_QMediaContent_cref_QMediaResource, "Lio/qt/multimedia/QMediaResource;")
       ,ConstructorInfo(&__qt_construct_QMediaContent_cref_QNetworkRequest, "Lio/qt/network/QNetworkRequest;")
       ,ConstructorInfo(&__qt_construct_QMediaContent_cref_QUrl, "Lio/qt/core/QUrl;")
    });
// END: function table

// BEGIN: type registration
    registerDeleter(typeId, &deleter_QMediaContent);
    registerMetaType<QMediaContent>("QMediaContent");
// END: type registration

// BEGIN: polymorphic ids
// END: polymorphic ids


// BEGIN: enums and flags
// END: enums and flags
}
