#include <QtCore/QtGlobal>
#include <QtMultimedia/qvideoframeformat.h>
#include <QtCore/QVariant>
#include <QtCore/qbytearray.h>
#include <QtCore/qrect.h>
#include <QtCore/qsize.h>
#include <QtGui/qimage.h>
#include <QtGui/qmatrix4x4.h>
#include <QtMultimedia/qvideoframe.h>

#include <QtJambi/QtJambiAPI>
#include <QtJambiMultimedia/hashes.h>

#include <QtJambi/RegistryAPI>
#include <QtJambi/Cast>

void deleter_QVideoFrameFormat(void *ptr, bool isShell)
{
    QTJAMBI_NATIVE_METHOD_CALL("qtjambi_deleter for QVideoFrameFormat")
    QVideoFrameFormat *_ptr = reinterpret_cast<QVideoFrameFormat *>(ptr);
    if(!isShell){
        QtJambiAPI::registerNonShellDeletion(ptr);
    }
    delete _ptr;
}

// emitting (writeConstructors)
// new QVideoFrameFormat()
void __qt_construct_QVideoFrameFormat(void* __qtjambi_ptr, JNIEnv* __jni_env, jobject __jni_object, jvalue* __java_arguments, bool __qtjambi_is_generic)
{
    QTJAMBI_NATIVE_METHOD_CALL("construct QVideoFrameFormat()")
    Q_UNUSED(__java_arguments)
    QVideoFrameFormat *__qt_this = new(__qtjambi_ptr) QVideoFrameFormat();
    Q_UNUSED(__qtjambi_is_generic)
    Q_UNUSED(__jni_object)
    Q_UNUSED(__jni_env)
    Q_UNUSED(__qt_this)
}

// QVideoFrameFormat::QVideoFrameFormat()
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_multimedia_QVideoFrameFormat_initialize_1native__Lio_qt_multimedia_QVideoFrameFormat_2)
(JNIEnv *__jni_env,
 jclass __jni_class,
 jobject __jni_object)
{
    QTJAMBI_NATIVE_METHOD_CALL("QVideoFrameFormat::QVideoFrameFormat()")
    QTJAMBI_TRY {
        QtJambiShell::initialize(__jni_env, __jni_class, __jni_object, &__qt_construct_QVideoFrameFormat, sizeof(QVideoFrameFormat), typeid(QVideoFrameFormat), false, &deleter_QVideoFrameFormat, nullptr);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// new QVideoFrameFormat(QSize,QVideoFrameFormat::PixelFormat)
void __qt_construct_QVideoFrameFormat_cref_QSize_QVideoFrameFormat_PixelFormat(void* __qtjambi_ptr, JNIEnv* __jni_env, jobject __jni_object, jvalue* __java_arguments, bool __qtjambi_is_generic)
{
    QTJAMBI_NATIVE_METHOD_CALL("construct QVideoFrameFormat(QSize,QVideoFrameFormat::PixelFormat)")
    jobject size0 = __java_arguments[0].l;
    const QSize& __qt_size0 = qtjambi_cast<const QSize& >(__jni_env, size0);
    jobject pixelFormat1 = __java_arguments[1].l;
    QVideoFrameFormat::PixelFormat __qt_pixelFormat1 = qtjambi_cast<QVideoFrameFormat::PixelFormat>(__jni_env, pixelFormat1);
    QVideoFrameFormat *__qt_this = new(__qtjambi_ptr) QVideoFrameFormat(__qt_size0, QVideoFrameFormat::PixelFormat(__qt_pixelFormat1));
    Q_UNUSED(__qtjambi_is_generic)
    Q_UNUSED(__jni_object)
    Q_UNUSED(__qt_this)
}

// QVideoFrameFormat::QVideoFrameFormat(QSize,QVideoFrameFormat::PixelFormat)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_multimedia_QVideoFrameFormat_initialize_1native__Lio_qt_multimedia_QVideoFrameFormat_2Lio_qt_core_QSize_2Lio_qt_multimedia_QVideoFrameFormat_00024PixelFormat_2)
(JNIEnv *__jni_env,
 jclass __jni_class,
 jobject __jni_object,
 jobject size0,
 jobject pixelFormat1)
{
    QTJAMBI_NATIVE_METHOD_CALL("QVideoFrameFormat::QVideoFrameFormat(QSize,QVideoFrameFormat::PixelFormat)")
    QTJAMBI_TRY {
        jvalue arguments[2];
        arguments[0].l = size0;
        arguments[1].l = pixelFormat1;
        QtJambiShell::initialize(__jni_env, __jni_class, __jni_object, &__qt_construct_QVideoFrameFormat_cref_QSize_QVideoFrameFormat_PixelFormat, sizeof(QVideoFrameFormat), typeid(QVideoFrameFormat), false, &deleter_QVideoFrameFormat, arguments);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// new QVideoFrameFormat(QVideoFrameFormat)
void __qt_construct_QVideoFrameFormat_cref_QVideoFrameFormat(void* __qtjambi_ptr, JNIEnv* __jni_env, jobject __jni_object, jvalue* __java_arguments, bool __qtjambi_is_generic)
{
    QTJAMBI_NATIVE_METHOD_CALL("construct QVideoFrameFormat(QVideoFrameFormat)")
    jobject format0 = __java_arguments[0].l;
    const QVideoFrameFormat& __qt_format0 = qtjambi_cast<const QVideoFrameFormat& >(__jni_env, format0);
    QVideoFrameFormat *__qt_this = new(__qtjambi_ptr) QVideoFrameFormat(__qt_format0);
    Q_UNUSED(__qtjambi_is_generic)
    Q_UNUSED(__jni_object)
    Q_UNUSED(__qt_this)
}

// QVideoFrameFormat::QVideoFrameFormat(QVideoFrameFormat)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_multimedia_QVideoFrameFormat_initialize_1native__Lio_qt_multimedia_QVideoFrameFormat_2Lio_qt_multimedia_QVideoFrameFormat_2)
(JNIEnv *__jni_env,
 jclass __jni_class,
 jobject __jni_object,
 jobject format0)
{
    QTJAMBI_NATIVE_METHOD_CALL("QVideoFrameFormat::QVideoFrameFormat(QVideoFrameFormat)")
    QTJAMBI_TRY {
        jvalue arguments;
        arguments.l = format0;
        QtJambiShell::initialize(__jni_env, __jni_class, __jni_object, &__qt_construct_QVideoFrameFormat_cref_QVideoFrameFormat, sizeof(QVideoFrameFormat), typeid(QVideoFrameFormat), false, &deleter_QVideoFrameFormat, &arguments);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// destruct QVideoFrameFormat
void __qt_destruct_QVideoFrameFormat(void* ptr)
{
    QTJAMBI_NATIVE_METHOD_CALL("destruct QVideoFrameFormat")
    reinterpret_cast<QVideoFrameFormat*>(ptr)->~QVideoFrameFormat();
}

// emitting  (functionsInTargetLang writeFinalFunction)
// QVideoFrameFormat::colorRange()const
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_multimedia_QVideoFrameFormat_colorRange_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jint __java_return_value{0};
    QTJAMBI_TRY {
        const QVideoFrameFormat *__qt_this = QtJambiAPI::objectFromNativeId<QVideoFrameFormat>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QVideoFrameFormat::colorRange()const", __qt_this)
        QVideoFrameFormat::ColorRange __qt_return_value = __qt_this->colorRange();
        __java_return_value = __qt_return_value;
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QVideoFrameFormat::colorSpace()const
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_multimedia_QVideoFrameFormat_colorSpace_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jint __java_return_value{0};
    QTJAMBI_TRY {
        const QVideoFrameFormat *__qt_this = QtJambiAPI::objectFromNativeId<QVideoFrameFormat>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QVideoFrameFormat::colorSpace()const", __qt_this)
        QVideoFrameFormat::ColorSpace __qt_return_value = __qt_this->colorSpace();
        __java_return_value = __qt_return_value;
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QVideoFrameFormat::colorTransfer()const
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_multimedia_QVideoFrameFormat_colorTransfer_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jint __java_return_value{0};
    QTJAMBI_TRY {
        const QVideoFrameFormat *__qt_this = QtJambiAPI::objectFromNativeId<QVideoFrameFormat>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QVideoFrameFormat::colorTransfer()const", __qt_this)
        QVideoFrameFormat::ColorTransfer __qt_return_value = __qt_this->colorTransfer();
        __java_return_value = __qt_return_value;
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QVideoFrameFormat::detach()
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_multimedia_QVideoFrameFormat_detach_1native__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QVideoFrameFormat *__qt_this = QtJambiAPI::objectFromNativeId<QVideoFrameFormat>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QVideoFrameFormat::detach()", __qt_this)
        __qt_this->detach();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QVideoFrameFormat::fragmentShaderFileName()const
extern "C" Q_DECL_EXPORT jstring JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_multimedia_QVideoFrameFormat_fragmentShaderFileName_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jstring __java_return_value{0};
    QTJAMBI_TRY {
        const QVideoFrameFormat *__qt_this = QtJambiAPI::objectFromNativeId<QVideoFrameFormat>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QVideoFrameFormat::fragmentShaderFileName()const", __qt_this)
        QString __qt_return_value = __qt_this->fragmentShaderFileName();
        __java_return_value = qtjambi_cast<jstring>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QVideoFrameFormat::frameHeight()const
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_multimedia_QVideoFrameFormat_frameHeight_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jint __java_return_value{0};
    QTJAMBI_TRY {
        const QVideoFrameFormat *__qt_this = QtJambiAPI::objectFromNativeId<QVideoFrameFormat>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QVideoFrameFormat::frameHeight()const", __qt_this)
        __java_return_value = __qt_this->frameHeight();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QVideoFrameFormat::frameRate()const
extern "C" Q_DECL_EXPORT jdouble JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_multimedia_QVideoFrameFormat_frameRate_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jdouble __java_return_value{0};
    QTJAMBI_TRY {
        const QVideoFrameFormat *__qt_this = QtJambiAPI::objectFromNativeId<QVideoFrameFormat>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QVideoFrameFormat::frameRate()const", __qt_this)
        qreal __qt_return_value = __qt_this->frameRate();
        __java_return_value = jdouble(__qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QVideoFrameFormat::frameSize()const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_multimedia_QVideoFrameFormat_frameSize_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QVideoFrameFormat *__qt_this = QtJambiAPI::objectFromNativeId<QVideoFrameFormat>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QVideoFrameFormat::frameSize()const", __qt_this)
        QSize __qt_return_value = __qt_this->frameSize();
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QVideoFrameFormat::frameWidth()const
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_multimedia_QVideoFrameFormat_frameWidth_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jint __java_return_value{0};
    QTJAMBI_TRY {
        const QVideoFrameFormat *__qt_this = QtJambiAPI::objectFromNativeId<QVideoFrameFormat>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QVideoFrameFormat::frameWidth()const", __qt_this)
        __java_return_value = __qt_this->frameWidth();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QVideoFrameFormat::isMirrored()const
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_multimedia_QVideoFrameFormat_isMirrored_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        const QVideoFrameFormat *__qt_this = QtJambiAPI::objectFromNativeId<QVideoFrameFormat>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QVideoFrameFormat::isMirrored()const", __qt_this)
        __java_return_value = __qt_this->isMirrored();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QVideoFrameFormat::isValid()const
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_multimedia_QVideoFrameFormat_isValid_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        const QVideoFrameFormat *__qt_this = QtJambiAPI::objectFromNativeId<QVideoFrameFormat>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QVideoFrameFormat::isValid()const", __qt_this)
        __java_return_value = __qt_this->isValid();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QVideoFrameFormat::maxLuminance()const
extern "C" Q_DECL_EXPORT jfloat JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_multimedia_QVideoFrameFormat_maxLuminance_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jfloat __java_return_value{0};
    QTJAMBI_TRY {
        const QVideoFrameFormat *__qt_this = QtJambiAPI::objectFromNativeId<QVideoFrameFormat>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QVideoFrameFormat::maxLuminance()const", __qt_this)
        __java_return_value = __qt_this->maxLuminance();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QVideoFrameFormat::operator=(QVideoFrameFormat)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_multimedia_QVideoFrameFormat_assign_1native_1cref_1QVideoFrameFormat__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID format0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QVideoFrameFormat *__qt_this = QtJambiAPI::objectFromNativeId<QVideoFrameFormat>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QVideoFrameFormat::operator=(QVideoFrameFormat)", __qt_this)
        const QVideoFrameFormat& __qt_format0 = QtJambiAPI::valueReferenceFromNativeId<QVideoFrameFormat>(format0);
        (*__qt_this) = __qt_format0;
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QVideoFrameFormat::operator==(QVideoFrameFormat)const
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_multimedia_QVideoFrameFormat_equals_1native_1cref_1QVideoFrameFormat_1constfct__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID format0)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        const QVideoFrameFormat *__qt_this = QtJambiAPI::objectFromNativeId<QVideoFrameFormat>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QVideoFrameFormat::operator==(QVideoFrameFormat)const", __qt_this)
        const QVideoFrameFormat& __qt_format0 = QtJambiAPI::valueReferenceFromNativeId<QVideoFrameFormat>(format0);
        __java_return_value = (*__qt_this) == __qt_format0;
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QVideoFrameFormat::pixelFormat()const
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_multimedia_QVideoFrameFormat_pixelFormat_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jint __java_return_value{0};
    QTJAMBI_TRY {
        const QVideoFrameFormat *__qt_this = QtJambiAPI::objectFromNativeId<QVideoFrameFormat>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QVideoFrameFormat::pixelFormat()const", __qt_this)
        QVideoFrameFormat::PixelFormat __qt_return_value = __qt_this->pixelFormat();
        __java_return_value = __qt_return_value;
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QVideoFrameFormat::planeCount()const
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_multimedia_QVideoFrameFormat_planeCount_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jint __java_return_value{0};
    QTJAMBI_TRY {
        const QVideoFrameFormat *__qt_this = QtJambiAPI::objectFromNativeId<QVideoFrameFormat>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QVideoFrameFormat::planeCount()const", __qt_this)
        __java_return_value = __qt_this->planeCount();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QVideoFrameFormat::scanLineDirection()const
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_multimedia_QVideoFrameFormat_scanLineDirection_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jint __java_return_value{0};
    QTJAMBI_TRY {
        const QVideoFrameFormat *__qt_this = QtJambiAPI::objectFromNativeId<QVideoFrameFormat>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QVideoFrameFormat::scanLineDirection()const", __qt_this)
        QVideoFrameFormat::Direction __qt_return_value = __qt_this->scanLineDirection();
        __java_return_value = __qt_return_value;
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QVideoFrameFormat::setColorRange(QVideoFrameFormat::ColorRange)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_multimedia_QVideoFrameFormat_setColorRange_1native_1QVideoFrameFormat_1ColorRange__JI)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint range0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QVideoFrameFormat *__qt_this = QtJambiAPI::objectFromNativeId<QVideoFrameFormat>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QVideoFrameFormat::setColorRange(QVideoFrameFormat::ColorRange)", __qt_this)
        QVideoFrameFormat::ColorRange __qt_range0 = qtjambi_cast<QVideoFrameFormat::ColorRange>(__jni_env, range0);
        __qt_this->setColorRange(QVideoFrameFormat::ColorRange(__qt_range0));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QVideoFrameFormat::setColorSpace(QVideoFrameFormat::ColorSpace)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_multimedia_QVideoFrameFormat_setColorSpace_1native_1QVideoFrameFormat_1ColorSpace__JI)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint colorSpace0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QVideoFrameFormat *__qt_this = QtJambiAPI::objectFromNativeId<QVideoFrameFormat>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QVideoFrameFormat::setColorSpace(QVideoFrameFormat::ColorSpace)", __qt_this)
        QVideoFrameFormat::ColorSpace __qt_colorSpace0 = qtjambi_cast<QVideoFrameFormat::ColorSpace>(__jni_env, colorSpace0);
        __qt_this->setColorSpace(QVideoFrameFormat::ColorSpace(__qt_colorSpace0));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QVideoFrameFormat::setColorTransfer(QVideoFrameFormat::ColorTransfer)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_multimedia_QVideoFrameFormat_setColorTransfer_1native_1QVideoFrameFormat_1ColorTransfer__JI)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint colorTransfer0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QVideoFrameFormat *__qt_this = QtJambiAPI::objectFromNativeId<QVideoFrameFormat>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QVideoFrameFormat::setColorTransfer(QVideoFrameFormat::ColorTransfer)", __qt_this)
        QVideoFrameFormat::ColorTransfer __qt_colorTransfer0 = qtjambi_cast<QVideoFrameFormat::ColorTransfer>(__jni_env, colorTransfer0);
        __qt_this->setColorTransfer(QVideoFrameFormat::ColorTransfer(__qt_colorTransfer0));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QVideoFrameFormat::setFrameRate(qreal)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_multimedia_QVideoFrameFormat_setFrameRate_1native_1qreal__JD)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jdouble rate0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QVideoFrameFormat *__qt_this = QtJambiAPI::objectFromNativeId<QVideoFrameFormat>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QVideoFrameFormat::setFrameRate(qreal)", __qt_this)
        __qt_this->setFrameRate(static_cast<qreal>(rate0));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QVideoFrameFormat::setFrameSize(QSize)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_multimedia_QVideoFrameFormat_setFrameSize_1native_1cref_1QSize__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID size0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QVideoFrameFormat *__qt_this = QtJambiAPI::objectFromNativeId<QVideoFrameFormat>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QVideoFrameFormat::setFrameSize(QSize)", __qt_this)
        const QSize& __qt_size0 = QtJambiAPI::valueReferenceFromNativeId<QSize>(size0);
        __qt_this->setFrameSize(__qt_size0);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QVideoFrameFormat::setFrameSize(int,int)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_multimedia_QVideoFrameFormat_setFrameSize_1native_1int_1int__JII)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint width0,
 jint height1)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QVideoFrameFormat *__qt_this = QtJambiAPI::objectFromNativeId<QVideoFrameFormat>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QVideoFrameFormat::setFrameSize(int,int)", __qt_this)
        __qt_this->setFrameSize(static_cast<int>(width0), static_cast<int>(height1));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QVideoFrameFormat::setMaxLuminance(float)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_multimedia_QVideoFrameFormat_setMaxLuminance_1native_1float__JF)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jfloat lum0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QVideoFrameFormat *__qt_this = QtJambiAPI::objectFromNativeId<QVideoFrameFormat>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QVideoFrameFormat::setMaxLuminance(float)", __qt_this)
        __qt_this->setMaxLuminance(static_cast<float>(lum0));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QVideoFrameFormat::setMirrored(bool)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_multimedia_QVideoFrameFormat_setMirrored_1native_1bool__JZ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jboolean mirrored0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QVideoFrameFormat *__qt_this = QtJambiAPI::objectFromNativeId<QVideoFrameFormat>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QVideoFrameFormat::setMirrored(bool)", __qt_this)
        __qt_this->setMirrored(static_cast<bool>(mirrored0));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QVideoFrameFormat::setScanLineDirection(QVideoFrameFormat::Direction)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_multimedia_QVideoFrameFormat_setScanLineDirection_1native_1QVideoFrameFormat_1Direction__JI)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint direction0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QVideoFrameFormat *__qt_this = QtJambiAPI::objectFromNativeId<QVideoFrameFormat>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QVideoFrameFormat::setScanLineDirection(QVideoFrameFormat::Direction)", __qt_this)
        QVideoFrameFormat::Direction __qt_direction0 = qtjambi_cast<QVideoFrameFormat::Direction>(__jni_env, direction0);
        __qt_this->setScanLineDirection(QVideoFrameFormat::Direction(__qt_direction0));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QVideoFrameFormat::setViewport(QRect)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_multimedia_QVideoFrameFormat_setViewport_1native_1cref_1QRect__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID viewport0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QVideoFrameFormat *__qt_this = QtJambiAPI::objectFromNativeId<QVideoFrameFormat>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QVideoFrameFormat::setViewport(QRect)", __qt_this)
        const QRect& __qt_viewport0 = QtJambiAPI::valueReferenceFromNativeId<QRect>(viewport0);
        __qt_this->setViewport(__qt_viewport0);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QVideoFrameFormat::setYCbCrColorSpace(QVideoFrameFormat::YCbCrColorSpace)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_multimedia_QVideoFrameFormat_setYCbCrColorSpace_1native_1QVideoFrameFormat_1YCbCrColorSpace__JI)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint colorSpace0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QVideoFrameFormat *__qt_this = QtJambiAPI::objectFromNativeId<QVideoFrameFormat>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QVideoFrameFormat::setYCbCrColorSpace(QVideoFrameFormat::YCbCrColorSpace)", __qt_this)
        QVideoFrameFormat::YCbCrColorSpace __qt_colorSpace0 = qtjambi_cast<QVideoFrameFormat::YCbCrColorSpace>(__jni_env, colorSpace0);
        __qt_this->setYCbCrColorSpace(QVideoFrameFormat::YCbCrColorSpace(__qt_colorSpace0));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QVideoFrameFormat::swap(QVideoFrameFormat&)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_multimedia_QVideoFrameFormat_swap_1native_1ref_1QVideoFrameFormat__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID other0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QVideoFrameFormat *__qt_this = QtJambiAPI::objectFromNativeId<QVideoFrameFormat>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QVideoFrameFormat::swap(QVideoFrameFormat&)", __qt_this)
        QVideoFrameFormat& __qt_other0 = QtJambiAPI::objectReferenceFromNativeId<QVideoFrameFormat>(__jni_env, other0);
        __qt_this->swap(__qt_other0);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QVideoFrameFormat::updateUniformData(QByteArray*,QVideoFrame,QMatrix4x4,float)const
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_multimedia_QVideoFrameFormat_updateUniformData_1native_1QByteArray_1ptr_1cref_1QVideoFrame_1cref_1QMatrix4x4_1float_1constfct__JJJJF)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID dst0,
 QtJambiNativeID frame1,
 QtJambiNativeID transform2,
 jfloat opacity3)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        const QVideoFrameFormat *__qt_this = QtJambiAPI::objectFromNativeId<QVideoFrameFormat>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QVideoFrameFormat::updateUniformData(QByteArray*,QVideoFrame,QMatrix4x4,float)const", __qt_this)
        QByteArray* __qt_dst0 = QtJambiAPI::objectFromNativeId<QByteArray>(dst0);
        const QVideoFrame& __qt_frame1 = QtJambiAPI::valueReferenceFromNativeId<QVideoFrame>(frame1);
        const QMatrix4x4& __qt_transform2 = QtJambiAPI::valueReferenceFromNativeId<QMatrix4x4>(transform2);
        __qt_this->updateUniformData(__qt_dst0, __qt_frame1, __qt_transform2, static_cast<float>(opacity3));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QVideoFrameFormat::vertexShaderFileName()const
extern "C" Q_DECL_EXPORT jstring JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_multimedia_QVideoFrameFormat_vertexShaderFileName_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jstring __java_return_value{0};
    QTJAMBI_TRY {
        const QVideoFrameFormat *__qt_this = QtJambiAPI::objectFromNativeId<QVideoFrameFormat>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QVideoFrameFormat::vertexShaderFileName()const", __qt_this)
        QString __qt_return_value = __qt_this->vertexShaderFileName();
        __java_return_value = qtjambi_cast<jstring>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QVideoFrameFormat::viewport()const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_multimedia_QVideoFrameFormat_viewport_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QVideoFrameFormat *__qt_this = QtJambiAPI::objectFromNativeId<QVideoFrameFormat>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QVideoFrameFormat::viewport()const", __qt_this)
        QRect __qt_return_value = __qt_this->viewport();
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QVideoFrameFormat::yCbCrColorSpace()const
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_multimedia_QVideoFrameFormat_yCbCrColorSpace_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jint __java_return_value{0};
    QTJAMBI_TRY {
        const QVideoFrameFormat *__qt_this = QtJambiAPI::objectFromNativeId<QVideoFrameFormat>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QVideoFrameFormat::yCbCrColorSpace()const", __qt_this)
        QVideoFrameFormat::YCbCrColorSpace __qt_return_value = __qt_this->yCbCrColorSpace();
        __java_return_value = __qt_return_value;
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QVideoFrameFormat::imageFormatFromPixelFormat(QVideoFrameFormat::PixelFormat)
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_multimedia_QVideoFrameFormat_imageFormatFromPixelFormat_1native_1QVideoFrameFormat_1PixelFormat__I)
(JNIEnv *__jni_env,
 jclass,
 jint format0)
{
    QTJAMBI_NATIVE_METHOD_CALL("QVideoFrameFormat::imageFormatFromPixelFormat(QVideoFrameFormat::PixelFormat)")
    jint __java_return_value{0};
    QTJAMBI_TRY {
        QVideoFrameFormat::PixelFormat __qt_format0 = qtjambi_cast<QVideoFrameFormat::PixelFormat>(__jni_env, format0);
        QImage::Format __qt_return_value = QVideoFrameFormat::imageFormatFromPixelFormat(QVideoFrameFormat::PixelFormat(__qt_format0));
        __java_return_value = __qt_return_value;
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QVideoFrameFormat::pixelFormatFromImageFormat(QImage::Format)
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_multimedia_QVideoFrameFormat_pixelFormatFromImageFormat_1native_1QImage_1Format__I)
(JNIEnv *__jni_env,
 jclass,
 jint format0)
{
    QTJAMBI_NATIVE_METHOD_CALL("QVideoFrameFormat::pixelFormatFromImageFormat(QImage::Format)")
    jint __java_return_value{0};
    QTJAMBI_TRY {
        QImage::Format __qt_format0 = qtjambi_cast<QImage::Format>(__jni_env, format0);
        QVideoFrameFormat::PixelFormat __qt_return_value = QVideoFrameFormat::pixelFormatFromImageFormat(QImage::Format(__qt_format0));
        __java_return_value = __qt_return_value;
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QVideoFrameFormat::pixelFormatToString(QVideoFrameFormat::PixelFormat)
extern "C" Q_DECL_EXPORT jstring JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_multimedia_QVideoFrameFormat_pixelFormatToString_1native_1QVideoFrameFormat_1PixelFormat__I)
(JNIEnv *__jni_env,
 jclass,
 jint pixelFormat0)
{
    QTJAMBI_NATIVE_METHOD_CALL("QVideoFrameFormat::pixelFormatToString(QVideoFrameFormat::PixelFormat)")
    jstring __java_return_value{0};
    QTJAMBI_TRY {
        QVideoFrameFormat::PixelFormat __qt_pixelFormat0 = qtjambi_cast<QVideoFrameFormat::PixelFormat>(__jni_env, pixelFormat0);
        QString __qt_return_value = QVideoFrameFormat::pixelFormatToString(QVideoFrameFormat::PixelFormat(__qt_pixelFormat0));
        __java_return_value = qtjambi_cast<jstring>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// emitting Field accessors (writeFieldAccessors)
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_multimedia_QVideoFrameFormat_NPixelFormats__)
(JNIEnv *__jni_env,
 jclass)
{
    jint __java_return_value{0};
    QTJAMBI_TRY {
        int  __qt_value = QVideoFrameFormat::NPixelFormats;
        __java_return_value = jint(__qt_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;
}

// emitting (writeJavaLangObjectOverrideFunctions)

extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_multimedia_QVideoFrameFormat_hashCode_1native)
(JNIEnv * __jni_env, jclass, QtJambiNativeID __this_nativeId)
{
    jint __java_return_value = 0;
    QTJAMBI_TRY {
        QVideoFrameFormat *__qt_this = QtJambiAPI::objectFromNativeId<QVideoFrameFormat>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        hash_type hashValue = qHash(*__qt_this);
        __java_return_value = jint(quint64(hashValue) ^ quint64(hashValue) >> 32);
    } QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    } QTJAMBI_TRY_END
    return __java_return_value;
}

#include <QtCore/QDebug>
extern "C" Q_DECL_EXPORT jstring JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_multimedia_QVideoFrameFormat_toString_1native)(JNIEnv *__jni_env, jobject, QtJambiNativeID __this_nativeId)
{
    jstring __java_return_value = nullptr;
    QTJAMBI_TRY {
        QVideoFrameFormat *__qt_this = QtJambiAPI::objectFromNativeId<QVideoFrameFormat>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QString res;
        QDebug(&res).noquote() << *__qt_this;
        if(!res.isEmpty() && res.back().isSpace())
            res = res.trimmed();
        __java_return_value = qtjambi_cast<jstring>(__jni_env, res);
    } QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    } QTJAMBI_TRY_END
    return __java_return_value;
}

// emitting (writeCloneFunction)

extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_multimedia_QVideoFrameFormat_clone_1native)
(JNIEnv *__jni_env, jobject, QtJambiNativeID __this_nativeId)
{
    jobject __java_return_value = nullptr;
    QTJAMBI_TRY {
        const QVideoFrameFormat *__qt_this = QtJambiAPI::objectFromNativeId<QVideoFrameFormat>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        __java_return_value = qtjambi_cast<jobject>(__jni_env, *__qt_this);
    } QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    } QTJAMBI_TRY_END
    return __java_return_value;
}


void initialize_meta_info_QVideoFrameFormat(){
    using namespace RegistryAPI;
    const std::type_info& typeId = registerValueTypeInfo<QVideoFrameFormat>("QVideoFrameFormat", "io/qt/multimedia/QVideoFrameFormat");
    Q_UNUSED(typeId)
// BEGIN: function table
    registerConstructorInfos(typeId, &__qt_destruct_QVideoFrameFormat, {
        ConstructorInfo(&__qt_construct_QVideoFrameFormat, nullptr)
       ,ConstructorInfo(&__qt_construct_QVideoFrameFormat_cref_QSize_QVideoFrameFormat_PixelFormat, "Lio/qt/core/QSize;Lio/qt/multimedia/QVideoFrameFormat$PixelFormat;")
       ,ConstructorInfo(&__qt_construct_QVideoFrameFormat_cref_QVideoFrameFormat, "Lio/qt/multimedia/QVideoFrameFormat;")
    });
// END: function table

// BEGIN: type registration
    registerDeleter(typeId, &deleter_QVideoFrameFormat);
    registerMetaType<QVideoFrameFormat>("QVideoFrameFormat");
// END: type registration

// BEGIN: polymorphic ids
// END: polymorphic ids


// BEGIN: enums and flags
    registerEnumTypeInfo<QVideoFrameFormat::ColorRange>("QVideoFrameFormat::ColorRange", "io/qt/multimedia/QVideoFrameFormat$ColorRange");
    registerEnumTypeInfo<QVideoFrameFormat::ColorSpace>("QVideoFrameFormat::ColorSpace", "io/qt/multimedia/QVideoFrameFormat$ColorSpace");
    registerEnumTypeInfo<QVideoFrameFormat::ColorTransfer>("QVideoFrameFormat::ColorTransfer", "io/qt/multimedia/QVideoFrameFormat$ColorTransfer");
    registerEnumTypeInfo<QVideoFrameFormat::Direction>("QVideoFrameFormat::Direction", "io/qt/multimedia/QVideoFrameFormat$Direction");
    registerEnumTypeInfo<QVideoFrameFormat::PixelFormat>("QVideoFrameFormat::PixelFormat", "io/qt/multimedia/QVideoFrameFormat$PixelFormat");
    registerEnumTypeInfo<QVideoFrameFormat::YCbCrColorSpace>("QVideoFrameFormat::YCbCrColorSpace", "io/qt/multimedia/QVideoFrameFormat$YCbCrColorSpace");
// END: enums and flags
}
