#include "QMediaFormat_shell.h"
#include <QtJambi/Cast>

void deleter_QMediaFormat(void *ptr, bool isShell)
{
    QTJAMBI_NATIVE_METHOD_CALL("qtjambi_deleter for QMediaFormat")
    QMediaFormat *_ptr = reinterpret_cast<QMediaFormat *>(ptr);
    if(isShell){
        delete static_cast<QMediaFormat_shell*>(_ptr);
    }else{
        QtJambiAPI::registerNonShellDeletion(ptr);
        delete _ptr;
    }
}

// emitting Virtual overrides (virtualFunctions)
// emitting Functions in shell class (nonVirtualShellFunctions)
// emitting Public Override Functions (publicOverrideFunctions)
// emitting Virtual Override Functions (virtualOverrideFunctions)
// emitting (writeConstructors)
// new QMediaFormat(QMediaFormat)
void __qt_construct_QMediaFormat_cref_QMediaFormat(void* __qtjambi_ptr, JNIEnv* __jni_env, jobject __jni_object, jvalue* __java_arguments, bool __qtjambi_is_generic)
{
    QTJAMBI_NATIVE_METHOD_CALL("construct QMediaFormat(QMediaFormat)")
    jobject other0 = __java_arguments[0].l;
    const QMediaFormat& __qt_other0 = qtjambi_cast<const QMediaFormat& >(__jni_env, other0);
    QMediaFormat *__qt_this = new(__qtjambi_ptr) QMediaFormat(__qt_other0);
    Q_UNUSED(__qtjambi_is_generic)
    Q_UNUSED(__jni_object)
    Q_UNUSED(__qt_this)
}

// QMediaFormat::QMediaFormat(QMediaFormat)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_multimedia_QMediaFormat_initialize_1native__Lio_qt_multimedia_QMediaFormat_2Lio_qt_multimedia_QMediaFormat_2)
(JNIEnv *__jni_env,
 jclass __jni_class,
 jobject __jni_object,
 jobject other0)
{
    QTJAMBI_NATIVE_METHOD_CALL("QMediaFormat::QMediaFormat(QMediaFormat)")
    QTJAMBI_TRY {
        jvalue arguments;
        arguments.l = other0;
        QtJambiShell::initialize(__jni_env, __jni_class, __jni_object, &__qt_construct_QMediaFormat_cref_QMediaFormat, sizeof(QMediaFormat_shell), typeid(QMediaFormat), true, &deleter_QMediaFormat, &arguments);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// new QMediaFormat(QMediaFormat::FileFormat)
void __qt_construct_QMediaFormat(void* __qtjambi_ptr, JNIEnv* __jni_env, jobject __jni_object, jvalue* __java_arguments, bool __qtjambi_is_generic)
{
    QTJAMBI_NATIVE_METHOD_CALL("construct QMediaFormat(QMediaFormat::FileFormat)")
    Q_UNUSED(__java_arguments)
    QMediaFormat *__qt_this = new(__qtjambi_ptr) QMediaFormat();
    Q_UNUSED(__qtjambi_is_generic)
    Q_UNUSED(__jni_object)
    Q_UNUSED(__jni_env)
    Q_UNUSED(__qt_this)
}

// new QMediaFormat(QMediaFormat::FileFormat)
void __qt_construct_QMediaFormat_QMediaFormat_FileFormat(void* __qtjambi_ptr, JNIEnv* __jni_env, jobject __jni_object, jvalue* __java_arguments, bool __qtjambi_is_generic)
{
    QTJAMBI_NATIVE_METHOD_CALL("construct QMediaFormat(QMediaFormat::FileFormat)")
    jobject format0 = __java_arguments[0].l;
    QMediaFormat::FileFormat __qt_format0 = qtjambi_cast<QMediaFormat::FileFormat>(__jni_env, format0);
    QMediaFormat *__qt_this = new(__qtjambi_ptr) QMediaFormat(QMediaFormat::FileFormat(__qt_format0));
    Q_UNUSED(__qtjambi_is_generic)
    Q_UNUSED(__jni_object)
    Q_UNUSED(__qt_this)
}

// QMediaFormat::QMediaFormat(QMediaFormat::FileFormat)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_multimedia_QMediaFormat_initialize_1native__Lio_qt_multimedia_QMediaFormat_2Lio_qt_multimedia_QMediaFormat_00024FileFormat_2)
(JNIEnv *__jni_env,
 jclass __jni_class,
 jobject __jni_object,
 jobject format0)
{
    QTJAMBI_NATIVE_METHOD_CALL("QMediaFormat::QMediaFormat(QMediaFormat::FileFormat)")
    QTJAMBI_TRY {
        jvalue arguments;
        arguments.l = format0;
        QtJambiShell::initialize(__jni_env, __jni_class, __jni_object, &__qt_construct_QMediaFormat_QMediaFormat_FileFormat, sizeof(QMediaFormat_shell), typeid(QMediaFormat), true, &deleter_QMediaFormat, &arguments);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// destruct QMediaFormat
void __qt_destruct_QMediaFormat(void* ptr)
{
    QTJAMBI_NATIVE_METHOD_CALL("destruct QMediaFormat")
    reinterpret_cast<QMediaFormat*>(ptr)->~QMediaFormat();
}

// emitting  (functionsInTargetLang writeFinalFunction)
// QMediaFormat::audioCodec()const
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_multimedia_QMediaFormat_audioCodec_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jint __java_return_value{0};
    QTJAMBI_TRY {
        const QMediaFormat *__qt_this = QtJambiAPI::objectFromNativeId<QMediaFormat>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QMediaFormat::audioCodec()const", __qt_this)
        QMediaFormat::AudioCodec __qt_return_value = __qt_this->audioCodec();
        __java_return_value = jint(__qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QMediaFormat::fileFormat()const
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_multimedia_QMediaFormat_fileFormat_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jint __java_return_value{0};
    QTJAMBI_TRY {
        const QMediaFormat *__qt_this = QtJambiAPI::objectFromNativeId<QMediaFormat>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QMediaFormat::fileFormat()const", __qt_this)
        QMediaFormat::FileFormat __qt_return_value = __qt_this->fileFormat();
        __java_return_value = __qt_return_value;
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QMediaFormat::isSupported(QMediaFormat::ConversionMode)const
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_multimedia_QMediaFormat_isSupported_1native_1QMediaFormat_1ConversionMode_1constfct__JI)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint mode0)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        const QMediaFormat *__qt_this = QtJambiAPI::objectFromNativeId<QMediaFormat>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QMediaFormat::isSupported(QMediaFormat::ConversionMode)const", __qt_this)
        QMediaFormat::ConversionMode __qt_mode0 = qtjambi_cast<QMediaFormat::ConversionMode>(__jni_env, mode0);
        __java_return_value = __qt_this->isSupported(QMediaFormat::ConversionMode(__qt_mode0));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QMediaFormat::mimeType()const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_multimedia_QMediaFormat_mimeType_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QMediaFormat *__qt_this = QtJambiAPI::objectFromNativeId<QMediaFormat>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QMediaFormat::mimeType()const", __qt_this)
        QMimeType __qt_return_value = __qt_this->mimeType();
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QMediaFormat::operator=(QMediaFormat)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_multimedia_QMediaFormat_assign_1native_1cref_1QMediaFormat__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID other0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QMediaFormat *__qt_this = QtJambiAPI::objectFromNativeId<QMediaFormat>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QMediaFormat::operator=(QMediaFormat)", __qt_this)
        const QMediaFormat& __qt_other0 = QtJambiAPI::objectReferenceFromNativeId<QMediaFormat>(__jni_env, other0);
        (*__qt_this) = __qt_other0;
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QMediaFormat::operator==(QMediaFormat)const
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_multimedia_QMediaFormat_equals_1native_1cref_1QMediaFormat_1constfct__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID other0)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        const QMediaFormat *__qt_this = QtJambiAPI::objectFromNativeId<QMediaFormat>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QMediaFormat::operator==(QMediaFormat)const", __qt_this)
        const QMediaFormat& __qt_other0 = QtJambiAPI::objectReferenceFromNativeId<QMediaFormat>(__jni_env, other0);
        __java_return_value = (*__qt_this) == __qt_other0;
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QMediaFormat::resolveForEncoding(QMediaFormat::ResolveFlags)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_multimedia_QMediaFormat_resolveForEncoding_1native_1QMediaFormat_1ResolveFlags__JI)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint flags0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QMediaFormat *__qt_this = QtJambiAPI::objectFromNativeId<QMediaFormat>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QMediaFormat::resolveForEncoding(QMediaFormat::ResolveFlags)", __qt_this)
        QMediaFormat::ResolveFlags __qt_flags0 = qtjambi_cast<QMediaFormat::ResolveFlags>(__jni_env, flags0);
        __qt_this->resolveForEncoding(QMediaFormat::ResolveFlags(__qt_flags0));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QMediaFormat::setAudioCodec(QMediaFormat::AudioCodec)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_multimedia_QMediaFormat_setAudioCodec_1native_1QMediaFormat_1AudioCodec__JI)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint codec0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QMediaFormat *__qt_this = QtJambiAPI::objectFromNativeId<QMediaFormat>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QMediaFormat::setAudioCodec(QMediaFormat::AudioCodec)", __qt_this)
        QMediaFormat::AudioCodec __qt_codec0 = qtjambi_cast<QMediaFormat::AudioCodec>(__jni_env, codec0);
        __qt_this->setAudioCodec(QMediaFormat::AudioCodec(__qt_codec0));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QMediaFormat::setFileFormat(QMediaFormat::FileFormat)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_multimedia_QMediaFormat_setFileFormat_1native_1QMediaFormat_1FileFormat__JI)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint f0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QMediaFormat *__qt_this = QtJambiAPI::objectFromNativeId<QMediaFormat>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QMediaFormat::setFileFormat(QMediaFormat::FileFormat)", __qt_this)
        QMediaFormat::FileFormat __qt_f0 = qtjambi_cast<QMediaFormat::FileFormat>(__jni_env, f0);
        __qt_this->setFileFormat(QMediaFormat::FileFormat(__qt_f0));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QMediaFormat::setVideoCodec(QMediaFormat::VideoCodec)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_multimedia_QMediaFormat_setVideoCodec_1native_1QMediaFormat_1VideoCodec__JI)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint codec0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QMediaFormat *__qt_this = QtJambiAPI::objectFromNativeId<QMediaFormat>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QMediaFormat::setVideoCodec(QMediaFormat::VideoCodec)", __qt_this)
        QMediaFormat::VideoCodec __qt_codec0 = qtjambi_cast<QMediaFormat::VideoCodec>(__jni_env, codec0);
        __qt_this->setVideoCodec(QMediaFormat::VideoCodec(__qt_codec0));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QMediaFormat::supportedAudioCodecs(QMediaFormat::ConversionMode)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_multimedia_QMediaFormat_supportedAudioCodecs_1native_1QMediaFormat_1ConversionMode__JI)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint m0)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        QMediaFormat *__qt_this = QtJambiAPI::objectFromNativeId<QMediaFormat>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QMediaFormat::supportedAudioCodecs(QMediaFormat::ConversionMode)", __qt_this)
        QMediaFormat::ConversionMode __qt_m0 = qtjambi_cast<QMediaFormat::ConversionMode>(__jni_env, m0);
        QList<QMediaFormat::AudioCodec> __qt_return_value = __qt_this->supportedAudioCodecs(QMediaFormat::ConversionMode(__qt_m0));
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QMediaFormat::supportedFileFormats(QMediaFormat::ConversionMode)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_multimedia_QMediaFormat_supportedFileFormats_1native_1QMediaFormat_1ConversionMode__JI)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint m0)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        QMediaFormat *__qt_this = QtJambiAPI::objectFromNativeId<QMediaFormat>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QMediaFormat::supportedFileFormats(QMediaFormat::ConversionMode)", __qt_this)
        QMediaFormat::ConversionMode __qt_m0 = qtjambi_cast<QMediaFormat::ConversionMode>(__jni_env, m0);
        QList<QMediaFormat::FileFormat> __qt_return_value = __qt_this->supportedFileFormats(QMediaFormat::ConversionMode(__qt_m0));
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QMediaFormat::supportedVideoCodecs(QMediaFormat::ConversionMode)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_multimedia_QMediaFormat_supportedVideoCodecs_1native_1QMediaFormat_1ConversionMode__JI)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint m0)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        QMediaFormat *__qt_this = QtJambiAPI::objectFromNativeId<QMediaFormat>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QMediaFormat::supportedVideoCodecs(QMediaFormat::ConversionMode)", __qt_this)
        QMediaFormat::ConversionMode __qt_m0 = qtjambi_cast<QMediaFormat::ConversionMode>(__jni_env, m0);
        QList<QMediaFormat::VideoCodec> __qt_return_value = __qt_this->supportedVideoCodecs(QMediaFormat::ConversionMode(__qt_m0));
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QMediaFormat::swap(QMediaFormat&)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_multimedia_QMediaFormat_swap_1native_1ref_1QMediaFormat__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID other0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QMediaFormat *__qt_this = QtJambiAPI::objectFromNativeId<QMediaFormat>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QMediaFormat::swap(QMediaFormat&)", __qt_this)
        QMediaFormat& __qt_other0 = QtJambiAPI::objectReferenceFromNativeId<QMediaFormat>(__jni_env, other0);
        __qt_this->swap(__qt_other0);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QMediaFormat::videoCodec()const
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_multimedia_QMediaFormat_videoCodec_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jint __java_return_value{0};
    QTJAMBI_TRY {
        const QMediaFormat *__qt_this = QtJambiAPI::objectFromNativeId<QMediaFormat>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QMediaFormat::videoCodec()const", __qt_this)
        QMediaFormat::VideoCodec __qt_return_value = __qt_this->videoCodec();
        __java_return_value = jint(__qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QMediaFormat::audioCodecDescription(QMediaFormat::AudioCodec)
extern "C" Q_DECL_EXPORT jstring JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_multimedia_QMediaFormat_audioCodecDescription_1native_1QMediaFormat_1AudioCodec__I)
(JNIEnv *__jni_env,
 jclass,
 jint codec0)
{
    QTJAMBI_NATIVE_METHOD_CALL("QMediaFormat::audioCodecDescription(QMediaFormat::AudioCodec)")
    jstring __java_return_value{0};
    QTJAMBI_TRY {
        QMediaFormat::AudioCodec __qt_codec0 = qtjambi_cast<QMediaFormat::AudioCodec>(__jni_env, codec0);
        QString __qt_return_value = QMediaFormat::audioCodecDescription(QMediaFormat::AudioCodec(__qt_codec0));
        __java_return_value = qtjambi_cast<jstring>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QMediaFormat::audioCodecName(QMediaFormat::AudioCodec)
extern "C" Q_DECL_EXPORT jstring JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_multimedia_QMediaFormat_audioCodecName_1native_1QMediaFormat_1AudioCodec__I)
(JNIEnv *__jni_env,
 jclass,
 jint codec0)
{
    QTJAMBI_NATIVE_METHOD_CALL("QMediaFormat::audioCodecName(QMediaFormat::AudioCodec)")
    jstring __java_return_value{0};
    QTJAMBI_TRY {
        QMediaFormat::AudioCodec __qt_codec0 = qtjambi_cast<QMediaFormat::AudioCodec>(__jni_env, codec0);
        QString __qt_return_value = QMediaFormat::audioCodecName(QMediaFormat::AudioCodec(__qt_codec0));
        __java_return_value = qtjambi_cast<jstring>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QMediaFormat::fileFormatDescription(QMediaFormat::FileFormat)
extern "C" Q_DECL_EXPORT jstring JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_multimedia_QMediaFormat_fileFormatDescription_1native_1QMediaFormat_1FileFormat__I)
(JNIEnv *__jni_env,
 jclass,
 jint fileFormat0)
{
    QTJAMBI_NATIVE_METHOD_CALL("QMediaFormat::fileFormatDescription(QMediaFormat::FileFormat)")
    jstring __java_return_value{0};
    QTJAMBI_TRY {
        QMediaFormat::FileFormat __qt_fileFormat0 = qtjambi_cast<QMediaFormat::FileFormat>(__jni_env, fileFormat0);
        QString __qt_return_value = QMediaFormat::fileFormatDescription(QMediaFormat::FileFormat(__qt_fileFormat0));
        __java_return_value = qtjambi_cast<jstring>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QMediaFormat::fileFormatName(QMediaFormat::FileFormat)
extern "C" Q_DECL_EXPORT jstring JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_multimedia_QMediaFormat_fileFormatName_1native_1QMediaFormat_1FileFormat__I)
(JNIEnv *__jni_env,
 jclass,
 jint fileFormat0)
{
    QTJAMBI_NATIVE_METHOD_CALL("QMediaFormat::fileFormatName(QMediaFormat::FileFormat)")
    jstring __java_return_value{0};
    QTJAMBI_TRY {
        QMediaFormat::FileFormat __qt_fileFormat0 = qtjambi_cast<QMediaFormat::FileFormat>(__jni_env, fileFormat0);
        QString __qt_return_value = QMediaFormat::fileFormatName(QMediaFormat::FileFormat(__qt_fileFormat0));
        __java_return_value = qtjambi_cast<jstring>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QMediaFormat::videoCodecDescription(QMediaFormat::VideoCodec)
extern "C" Q_DECL_EXPORT jstring JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_multimedia_QMediaFormat_videoCodecDescription_1native_1QMediaFormat_1VideoCodec__I)
(JNIEnv *__jni_env,
 jclass,
 jint codec0)
{
    QTJAMBI_NATIVE_METHOD_CALL("QMediaFormat::videoCodecDescription(QMediaFormat::VideoCodec)")
    jstring __java_return_value{0};
    QTJAMBI_TRY {
        QMediaFormat::VideoCodec __qt_codec0 = qtjambi_cast<QMediaFormat::VideoCodec>(__jni_env, codec0);
        QString __qt_return_value = QMediaFormat::videoCodecDescription(QMediaFormat::VideoCodec(__qt_codec0));
        __java_return_value = qtjambi_cast<jstring>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QMediaFormat::videoCodecName(QMediaFormat::VideoCodec)
extern "C" Q_DECL_EXPORT jstring JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_multimedia_QMediaFormat_videoCodecName_1native_1QMediaFormat_1VideoCodec__I)
(JNIEnv *__jni_env,
 jclass,
 jint codec0)
{
    QTJAMBI_NATIVE_METHOD_CALL("QMediaFormat::videoCodecName(QMediaFormat::VideoCodec)")
    jstring __java_return_value{0};
    QTJAMBI_TRY {
        QMediaFormat::VideoCodec __qt_codec0 = qtjambi_cast<QMediaFormat::VideoCodec>(__jni_env, codec0);
        QString __qt_return_value = QMediaFormat::videoCodecName(QMediaFormat::VideoCodec(__qt_codec0));
        __java_return_value = qtjambi_cast<jstring>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// emitting Field accessors (writeFieldAccessors)
// emitting (writeJavaLangObjectOverrideFunctions)

extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_multimedia_QMediaFormat_hashCode_1native)
(JNIEnv * __jni_env, jclass, QtJambiNativeID __this_nativeId)
{
    jint __java_return_value = 0;
    QTJAMBI_TRY {
        QMediaFormat *__qt_this = QtJambiAPI::objectFromNativeId<QMediaFormat>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        hash_type hashValue = qHash(*__qt_this);
        __java_return_value = jint(quint64(hashValue) ^ quint64(hashValue) >> 32);
    } QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    } QTJAMBI_TRY_END
    return __java_return_value;
}
// emitting (writeCloneFunction)

extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_multimedia_QMediaFormat_clone_1native)
(JNIEnv *__jni_env, jobject, QtJambiNativeID __this_nativeId)
{
    jobject __java_return_value = nullptr;
    QTJAMBI_TRY {
        const QMediaFormat *__qt_this = QtJambiAPI::objectFromNativeId<QMediaFormat>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        __java_return_value = qtjambi_cast<jobject>(__jni_env, *__qt_this);
    } QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    } QTJAMBI_TRY_END
    return __java_return_value;
}


bool javaToNativeConverter_QList_lt_QMediaFormat_AudioCodec_gt(JNIEnv*, QtJambiScope*, jvalue, void* &, jValueType);
bool javaToNativeConverter_QList_lt_QMediaFormat_FileFormat_gt(JNIEnv*, QtJambiScope*, jvalue, void* &, jValueType);
bool javaToNativeConverter_QList_lt_QMediaFormat_VideoCodec_gt(JNIEnv*, QtJambiScope*, jvalue, void* &, jValueType);
bool javaToNativeConverter_QMediaFormat_AudioCodec(JNIEnv*, QtJambiScope*, jvalue, void* &, jValueType);
bool javaToNativeConverter_QMediaFormat_AudioCodec(JNIEnv*, QtJambiScope*, jvalue, void* &, jValueType); // declared in QMediaFormat
bool javaToNativeConverter_QMediaFormat_ConversionMode(JNIEnv*, QtJambiScope*, jvalue, void* &, jValueType);
bool javaToNativeConverter_QMediaFormat_ConversionMode(JNIEnv*, QtJambiScope*, jvalue, void* &, jValueType); // declared in QMediaFormat
bool javaToNativeConverter_QMediaFormat_FileFormat(JNIEnv*, QtJambiScope*, jvalue, void* &, jValueType);
bool javaToNativeConverter_QMediaFormat_FileFormat(JNIEnv*, QtJambiScope*, jvalue, void* &, jValueType); // declared in QMediaFormat
bool javaToNativeConverter_QMediaFormat_VideoCodec(JNIEnv*, QtJambiScope*, jvalue, void* &, jValueType);
bool javaToNativeConverter_QMediaFormat_VideoCodec(JNIEnv*, QtJambiScope*, jvalue, void* &, jValueType); // declared in QMediaFormat
bool nativeToJavaConverter_QList_lt_QMediaFormat_AudioCodec_gt(JNIEnv*, QtJambiScope*, const void*, jvalue&, bool);
bool nativeToJavaConverter_QList_lt_QMediaFormat_FileFormat_gt(JNIEnv*, QtJambiScope*, const void*, jvalue&, bool);
bool nativeToJavaConverter_QList_lt_QMediaFormat_VideoCodec_gt(JNIEnv*, QtJambiScope*, const void*, jvalue&, bool);
bool nativeToJavaConverter_QMediaFormat_AudioCodec(JNIEnv*, QtJambiScope*, const void*, jvalue&, bool);
bool nativeToJavaConverter_QMediaFormat_AudioCodec(JNIEnv*, QtJambiScope*, const void*, jvalue&, bool); // declared in QMediaFormat
bool nativeToJavaConverter_QMediaFormat_ConversionMode(JNIEnv*, QtJambiScope*, const void*, jvalue&, bool);
bool nativeToJavaConverter_QMediaFormat_ConversionMode(JNIEnv*, QtJambiScope*, const void*, jvalue&, bool); // declared in QMediaFormat
bool nativeToJavaConverter_QMediaFormat_FileFormat(JNIEnv*, QtJambiScope*, const void*, jvalue&, bool);
bool nativeToJavaConverter_QMediaFormat_FileFormat(JNIEnv*, QtJambiScope*, const void*, jvalue&, bool); // declared in QMediaFormat
bool nativeToJavaConverter_QMediaFormat_VideoCodec(JNIEnv*, QtJambiScope*, const void*, jvalue&, bool);
bool nativeToJavaConverter_QMediaFormat_VideoCodec(JNIEnv*, QtJambiScope*, const void*, jvalue&, bool); // declared in QMediaFormat

bool javaToNativeConverter_QList_lt_QMediaFormat_AudioCodec_gt(JNIEnv* env, QtJambiScope* scope, jvalue in, void* &out, jValueType) {
    Q_UNUSED(env)
    if(scope && !out){
        QList<QMediaFormat::AudioCodec>* _out = new QList<QMediaFormat::AudioCodec>;
        out = _out;
        scope->addDeletion(_out);
    }
    if(!out)
        return false;
    *reinterpret_cast<QList<QMediaFormat::AudioCodec>*>(out) = qtjambi_cast<QList<QMediaFormat::AudioCodec>>(env, in.l);
    return true;
}

bool javaToNativeConverter_QList_lt_QMediaFormat_FileFormat_gt(JNIEnv* env, QtJambiScope* scope, jvalue in, void* &out, jValueType) {
    Q_UNUSED(env)
    if(scope && !out){
        QList<QMediaFormat::FileFormat>* _out = new QList<QMediaFormat::FileFormat>;
        out = _out;
        scope->addDeletion(_out);
    }
    if(!out)
        return false;
    *reinterpret_cast<QList<QMediaFormat::FileFormat>*>(out) = qtjambi_cast<QList<QMediaFormat::FileFormat>>(env, in.l);
    return true;
}

bool javaToNativeConverter_QList_lt_QMediaFormat_VideoCodec_gt(JNIEnv* env, QtJambiScope* scope, jvalue in, void* &out, jValueType) {
    Q_UNUSED(env)
    if(scope && !out){
        QList<QMediaFormat::VideoCodec>* _out = new QList<QMediaFormat::VideoCodec>;
        out = _out;
        scope->addDeletion(_out);
    }
    if(!out)
        return false;
    *reinterpret_cast<QList<QMediaFormat::VideoCodec>*>(out) = qtjambi_cast<QList<QMediaFormat::VideoCodec>>(env, in.l);
    return true;
}

bool javaToNativeConverter_QMediaFormat_AudioCodec(JNIEnv* env, QtJambiScope* scope, jvalue in, void* &out, jValueType) {
    Q_UNUSED(env)
    if(scope && !out){
        QMediaFormat::AudioCodec* _out = new QMediaFormat::AudioCodec;
        out = _out;
        scope->addDeletion(_out);
    }
    if(!out)
        return false;
    *reinterpret_cast<QMediaFormat::AudioCodec*>(out) = qtjambi_cast<QMediaFormat::AudioCodec>(env, in.l);
    return true;
}

bool javaToNativeConverter_QMediaFormat_ConversionMode(JNIEnv* env, QtJambiScope* scope, jvalue in, void* &out, jValueType) {
    Q_UNUSED(env)
    if(scope && !out){
        QMediaFormat::ConversionMode* _out = new QMediaFormat::ConversionMode;
        out = _out;
        scope->addDeletion(_out);
    }
    if(!out)
        return false;
    *reinterpret_cast<QMediaFormat::ConversionMode*>(out) = qtjambi_cast<QMediaFormat::ConversionMode>(env, in.l);
    return true;
}

bool javaToNativeConverter_QMediaFormat_FileFormat(JNIEnv* env, QtJambiScope* scope, jvalue in, void* &out, jValueType) {
    Q_UNUSED(env)
    if(scope && !out){
        QMediaFormat::FileFormat* _out = new QMediaFormat::FileFormat;
        out = _out;
        scope->addDeletion(_out);
    }
    if(!out)
        return false;
    *reinterpret_cast<QMediaFormat::FileFormat*>(out) = qtjambi_cast<QMediaFormat::FileFormat>(env, in.l);
    return true;
}

bool javaToNativeConverter_QMediaFormat_VideoCodec(JNIEnv* env, QtJambiScope* scope, jvalue in, void* &out, jValueType) {
    Q_UNUSED(env)
    if(scope && !out){
        QMediaFormat::VideoCodec* _out = new QMediaFormat::VideoCodec;
        out = _out;
        scope->addDeletion(_out);
    }
    if(!out)
        return false;
    *reinterpret_cast<QMediaFormat::VideoCodec*>(out) = qtjambi_cast<QMediaFormat::VideoCodec>(env, in.l);
    return true;
}

bool nativeToJavaConverter_QList_lt_QMediaFormat_AudioCodec_gt(JNIEnv* env, QtJambiScope* scope, const void* in, jvalue& out, bool) {
    Q_UNUSED(env)
    Q_UNUSED(scope)
    out.l = qtjambi_cast<jobject>(env, *reinterpret_cast<QList<QMediaFormat::AudioCodec> const*>(in));
    return true;
}

bool nativeToJavaConverter_QList_lt_QMediaFormat_FileFormat_gt(JNIEnv* env, QtJambiScope* scope, const void* in, jvalue& out, bool) {
    Q_UNUSED(env)
    Q_UNUSED(scope)
    out.l = qtjambi_cast<jobject>(env, *reinterpret_cast<QList<QMediaFormat::FileFormat> const*>(in));
    return true;
}

bool nativeToJavaConverter_QList_lt_QMediaFormat_VideoCodec_gt(JNIEnv* env, QtJambiScope* scope, const void* in, jvalue& out, bool) {
    Q_UNUSED(env)
    Q_UNUSED(scope)
    out.l = qtjambi_cast<jobject>(env, *reinterpret_cast<QList<QMediaFormat::VideoCodec> const*>(in));
    return true;
}

bool nativeToJavaConverter_QMediaFormat_AudioCodec(JNIEnv* env, QtJambiScope* scope, const void* in, jvalue& out, bool) {
    Q_UNUSED(env)
    Q_UNUSED(scope)
    out.l = qtjambi_cast<jobject>(env, *reinterpret_cast<QMediaFormat::AudioCodec const*>(in));
    return true;
}

bool nativeToJavaConverter_QMediaFormat_ConversionMode(JNIEnv* env, QtJambiScope* scope, const void* in, jvalue& out, bool) {
    Q_UNUSED(env)
    Q_UNUSED(scope)
    out.l = qtjambi_cast<jobject>(env, *reinterpret_cast<QMediaFormat::ConversionMode const*>(in));
    return true;
}

bool nativeToJavaConverter_QMediaFormat_FileFormat(JNIEnv* env, QtJambiScope* scope, const void* in, jvalue& out, bool) {
    Q_UNUSED(env)
    Q_UNUSED(scope)
    out.l = qtjambi_cast<jobject>(env, *reinterpret_cast<QMediaFormat::FileFormat const*>(in));
    return true;
}

bool nativeToJavaConverter_QMediaFormat_VideoCodec(JNIEnv* env, QtJambiScope* scope, const void* in, jvalue& out, bool) {
    Q_UNUSED(env)
    Q_UNUSED(scope)
    out.l = qtjambi_cast<jobject>(env, *reinterpret_cast<QMediaFormat::VideoCodec const*>(in));
    return true;
}


void initialize_meta_info_QMediaFormat(){
    using namespace RegistryAPI;
    const std::type_info& typeId = registerValueTypeInfo<QMediaFormat>("QMediaFormat", "io/qt/multimedia/QMediaFormat");
    Q_UNUSED(typeId)
// BEGIN: function table
    registerConstructorInfos(typeId, &__qt_destruct_QMediaFormat, {
        ConstructorInfo(&__qt_construct_QMediaFormat_cref_QMediaFormat, "Lio/qt/multimedia/QMediaFormat;")
       ,ConstructorInfo(&__qt_construct_QMediaFormat, nullptr)
       ,ConstructorInfo(&__qt_construct_QMediaFormat_QMediaFormat_FileFormat, "Lio/qt/multimedia/QMediaFormat$FileFormat;")
    });
// END: function table

    registerMetaObject(typeId, QMediaFormat::staticMetaObject, false,
            {},
            [](const QMetaMethod& method, QList<ParameterInfo>& infos) {
                Q_UNUSED(infos)
                int methodIndex = method.methodIndex();
                if(methodIndex==QMediaFormat::staticMetaObject.indexOfMethod("isSupported(QMediaFormat::ConversionMode)const")){
                    infos << ParameterInfo(QMetaType::Bool);
                    infos << ParameterInfo(
                                // QMediaFormat::ConversionMode
                                method.parameterType(0),
                                "io/qt/multimedia/QMediaFormat$ConversionMode",
                                &nativeToJavaConverter_QMediaFormat_ConversionMode,
                                &javaToNativeConverter_QMediaFormat_ConversionMode);
                    return true;
                }
                if(methodIndex==QMediaFormat::staticMetaObject.indexOfMethod("supportedAudioCodecs(QMediaFormat::ConversionMode)")){
                    infos << ParameterInfo(
                                // QList<QMediaFormat::AudioCodec>
                                method.returnType(),
                                "io/qt/core/QList",
                                &nativeToJavaConverter_QList_lt_QMediaFormat_AudioCodec_gt,
                                &javaToNativeConverter_QList_lt_QMediaFormat_AudioCodec_gt);
                    infos << ParameterInfo(
                                // QMediaFormat::ConversionMode
                                method.parameterType(0),
                                "io/qt/multimedia/QMediaFormat$ConversionMode",
                                &nativeToJavaConverter_QMediaFormat_ConversionMode,
                                &javaToNativeConverter_QMediaFormat_ConversionMode);
                    return true;
                }
                if(methodIndex==QMediaFormat::staticMetaObject.indexOfMethod("supportedFileFormats(QMediaFormat::ConversionMode)")){
                    infos << ParameterInfo(
                                // QList<QMediaFormat::FileFormat>
                                method.returnType(),
                                "io/qt/core/QList",
                                &nativeToJavaConverter_QList_lt_QMediaFormat_FileFormat_gt,
                                &javaToNativeConverter_QList_lt_QMediaFormat_FileFormat_gt);
                    infos << ParameterInfo(
                                // QMediaFormat::ConversionMode
                                method.parameterType(0),
                                "io/qt/multimedia/QMediaFormat$ConversionMode",
                                &nativeToJavaConverter_QMediaFormat_ConversionMode,
                                &javaToNativeConverter_QMediaFormat_ConversionMode);
                    return true;
                }
                if(methodIndex==QMediaFormat::staticMetaObject.indexOfMethod("supportedVideoCodecs(QMediaFormat::ConversionMode)")){
                    infos << ParameterInfo(
                                // QList<QMediaFormat::VideoCodec>
                                method.returnType(),
                                "io/qt/core/QList",
                                &nativeToJavaConverter_QList_lt_QMediaFormat_VideoCodec_gt,
                                &javaToNativeConverter_QList_lt_QMediaFormat_VideoCodec_gt);
                    infos << ParameterInfo(
                                // QMediaFormat::ConversionMode
                                method.parameterType(0),
                                "io/qt/multimedia/QMediaFormat$ConversionMode",
                                &nativeToJavaConverter_QMediaFormat_ConversionMode,
                                &javaToNativeConverter_QMediaFormat_ConversionMode);
                    return true;
                }
                if(methodIndex==QMediaFormat::staticMetaObject.indexOfMethod("audioCodecDescription(QMediaFormat::AudioCodec)")){
                    infos << ParameterInfo(QMetaType::QString);
                    infos << ParameterInfo(
                                // QMediaFormat::AudioCodec
                                method.parameterType(0),
                                "io/qt/multimedia/QMediaFormat$AudioCodec",
                                &nativeToJavaConverter_QMediaFormat_AudioCodec,
                                &javaToNativeConverter_QMediaFormat_AudioCodec);
                    return true;
                }
                if(methodIndex==QMediaFormat::staticMetaObject.indexOfMethod("audioCodecName(QMediaFormat::AudioCodec)")){
                    infos << ParameterInfo(QMetaType::QString);
                    infos << ParameterInfo(
                                // QMediaFormat::AudioCodec
                                method.parameterType(0),
                                "io/qt/multimedia/QMediaFormat$AudioCodec",
                                &nativeToJavaConverter_QMediaFormat_AudioCodec,
                                &javaToNativeConverter_QMediaFormat_AudioCodec);
                    return true;
                }
                if(methodIndex==QMediaFormat::staticMetaObject.indexOfMethod("fileFormatDescription(QMediaFormat::FileFormat)")){
                    infos << ParameterInfo(QMetaType::QString);
                    infos << ParameterInfo(
                                // QMediaFormat::FileFormat
                                method.parameterType(0),
                                "io/qt/multimedia/QMediaFormat$FileFormat",
                                &nativeToJavaConverter_QMediaFormat_FileFormat,
                                &javaToNativeConverter_QMediaFormat_FileFormat);
                    return true;
                }
                if(methodIndex==QMediaFormat::staticMetaObject.indexOfMethod("fileFormatName(QMediaFormat::FileFormat)")){
                    infos << ParameterInfo(QMetaType::QString);
                    infos << ParameterInfo(
                                // QMediaFormat::FileFormat
                                method.parameterType(0),
                                "io/qt/multimedia/QMediaFormat$FileFormat",
                                &nativeToJavaConverter_QMediaFormat_FileFormat,
                                &javaToNativeConverter_QMediaFormat_FileFormat);
                    return true;
                }
                if(methodIndex==QMediaFormat::staticMetaObject.indexOfMethod("videoCodecDescription(QMediaFormat::VideoCodec)")){
                    infos << ParameterInfo(QMetaType::QString);
                    infos << ParameterInfo(
                                // QMediaFormat::VideoCodec
                                method.parameterType(0),
                                "io/qt/multimedia/QMediaFormat$VideoCodec",
                                &nativeToJavaConverter_QMediaFormat_VideoCodec,
                                &javaToNativeConverter_QMediaFormat_VideoCodec);
                    return true;
                }
                if(methodIndex==QMediaFormat::staticMetaObject.indexOfMethod("videoCodecName(QMediaFormat::VideoCodec)")){
                    infos << ParameterInfo(QMetaType::QString);
                    infos << ParameterInfo(
                                // QMediaFormat::VideoCodec
                                method.parameterType(0),
                                "io/qt/multimedia/QMediaFormat$VideoCodec",
                                &nativeToJavaConverter_QMediaFormat_VideoCodec,
                                &javaToNativeConverter_QMediaFormat_VideoCodec);
                    return true;
                }
                return false;
            });
// END: signal table

// BEGIN: type registration
    registerDeleter(typeId, &deleter_QMediaFormat);
    registerMetaType<QMediaFormat>("QMediaFormat");
    registerMetaType<QList<QMediaFormat::AudioCodec>>("QList<QMediaFormat::AudioCodec>");
    registerMetaType<QList<QMediaFormat::FileFormat>>("QList<QMediaFormat::FileFormat>");
    registerMetaType<QList<QMediaFormat::VideoCodec>>("QList<QMediaFormat::VideoCodec>");
// END: type registration

// BEGIN: polymorphic ids
// END: polymorphic ids


// BEGIN: enums and flags
    registerEnumTypeInfo<QMediaFormat::AudioCodec>("QMediaFormat::AudioCodec", "io/qt/multimedia/QMediaFormat$AudioCodec");
    registerEnumTypeInfo<QMediaFormat::ConversionMode>("QMediaFormat::ConversionMode", "io/qt/multimedia/QMediaFormat$ConversionMode");
    registerEnumTypeInfo<QMediaFormat::FileFormat>("QMediaFormat::FileFormat", "io/qt/multimedia/QMediaFormat$FileFormat");
    registerEnumTypeInfo<QMediaFormat::ResolveFlags>("QMediaFormat::ResolveFlags", "io/qt/multimedia/QMediaFormat$ResolveFlags");
    registerEnumTypeInfo<QMediaFormat::VideoCodec>("QMediaFormat::VideoCodec", "io/qt/multimedia/QMediaFormat$VideoCodec");
// END: enums and flags
}
