#include <QtCore/QtGlobal>
#include <QtMultimedia/qaudioformat.h>
#include <QtCore/QVariant>

#include <QtJambi/QtJambiAPI>
#include <QtJambiMultimedia/hashes.h>

#include <QtJambi/RegistryAPI>
#include <QtJambi/Cast>

void deleter_QAudioFormat(void *ptr, bool isShell)
{
    QTJAMBI_NATIVE_METHOD_CALL("qtjambi_deleter for QAudioFormat")
    QAudioFormat *_ptr = reinterpret_cast<QAudioFormat *>(ptr);
    if(!isShell){
        QtJambiAPI::registerNonShellDeletion(ptr);
    }
    delete _ptr;
}

// emitting (writeConstructors)
// new 
void __qt_construct_QAudioFormat_0(void* __qtjambi_ptr, JNIEnv* __jni_env, jobject __jni_object, jvalue* __java_arguments)
{
    QTJAMBI_NATIVE_METHOD_CALL("construct ")
    Q_UNUSED(__java_arguments)
    QAudioFormat *__qt_this = new(__qtjambi_ptr) QAudioFormat();
    Q_UNUSED(__jni_object)
    Q_UNUSED(__jni_env)
    Q_UNUSED(__qt_this)
}

// destruct QAudioFormat
void __qt_destruct_QAudioFormat(void* ptr)
{
    QTJAMBI_NATIVE_METHOD_CALL("destruct QAudioFormat")
    reinterpret_cast<QAudioFormat*>(ptr)->~QAudioFormat();
}

// emitting  (functionsInTargetLang writeFinalFunction)
// QAudioFormat::
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_multimedia_QAudioFormat_initialize_1native__Lio_qt_multimedia_QAudioFormat_2)
(JNIEnv *__jni_env,
 jclass __jni_class,
 jobject __jni_object)
{
    QTJAMBI_NATIVE_METHOD_CALL("QAudioFormat::")
    QTJAMBI_TRY {
        QtJambiShell::initialize(__jni_env, __jni_class, __jni_object, &__qt_construct_QAudioFormat_0, sizeof(QAudioFormat), typeid(QAudioFormat), false, &deleter_QAudioFormat, nullptr);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QAudioFormat::bytesForDuration(qint64)const
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_multimedia_QAudioFormat_bytesForDuration_1native_1qint64_1constfct__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jlong microseconds0)
{
    Q_UNUSED(__this)
    jint __java_return_value{0};
    QTJAMBI_TRY {
        const QAudioFormat *__qt_this = QtJambiAPI::objectFromNativeId<QAudioFormat>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QAudioFormat::bytesForDuration(qint64)const", __qt_this)
        qint32 __qt_return_value = __qt_this->bytesForDuration(static_cast<qint64>(microseconds0));
        __java_return_value = jint(__qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QAudioFormat::bytesForFrames(qint32)const
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_multimedia_QAudioFormat_bytesForFrames_1native_1qint32_1constfct__JI)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint frameCount0)
{
    Q_UNUSED(__this)
    jint __java_return_value{0};
    QTJAMBI_TRY {
        const QAudioFormat *__qt_this = QtJambiAPI::objectFromNativeId<QAudioFormat>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QAudioFormat::bytesForFrames(qint32)const", __qt_this)
        qint32 __qt_return_value = __qt_this->bytesForFrames(static_cast<qint32>(frameCount0));
        __java_return_value = jint(__qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QAudioFormat::bytesPerFrame()const
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_multimedia_QAudioFormat_bytesPerFrame_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jint __java_return_value{0};
    QTJAMBI_TRY {
        const QAudioFormat *__qt_this = QtJambiAPI::objectFromNativeId<QAudioFormat>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QAudioFormat::bytesPerFrame()const", __qt_this)
        __java_return_value = __qt_this->bytesPerFrame();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QAudioFormat::bytesPerSample()const
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_multimedia_QAudioFormat_bytesPerSample_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jint __java_return_value{0};
    QTJAMBI_TRY {
        const QAudioFormat *__qt_this = QtJambiAPI::objectFromNativeId<QAudioFormat>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QAudioFormat::bytesPerSample()const", __qt_this)
        __java_return_value = __qt_this->bytesPerSample();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QAudioFormat::channelConfig()const
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_multimedia_QAudioFormat_channelConfig_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jint __java_return_value{0};
    QTJAMBI_TRY {
        const QAudioFormat *__qt_this = QtJambiAPI::objectFromNativeId<QAudioFormat>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QAudioFormat::channelConfig()const", __qt_this)
        QAudioFormat::ChannelConfig __qt_return_value = __qt_this->channelConfig();
        __java_return_value = __qt_return_value;
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QAudioFormat::channelCount()const
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_multimedia_QAudioFormat_channelCount_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jint __java_return_value{0};
    QTJAMBI_TRY {
        const QAudioFormat *__qt_this = QtJambiAPI::objectFromNativeId<QAudioFormat>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QAudioFormat::channelCount()const", __qt_this)
        __java_return_value = __qt_this->channelCount();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QAudioFormat::channelOffset(QAudioFormat::AudioChannelPosition)const
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_multimedia_QAudioFormat_channelOffset_1native_1QAudioFormat_1AudioChannelPosition_1constfct__JI)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint channel0)
{
    Q_UNUSED(__this)
    jint __java_return_value{0};
    QTJAMBI_TRY {
        const QAudioFormat *__qt_this = QtJambiAPI::objectFromNativeId<QAudioFormat>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QAudioFormat::channelOffset(QAudioFormat::AudioChannelPosition)const", __qt_this)
        QAudioFormat::AudioChannelPosition __qt_channel0 = qtjambi_cast<QAudioFormat::AudioChannelPosition>(__jni_env, channel0);
        __java_return_value = __qt_this->channelOffset(QAudioFormat::AudioChannelPosition(__qt_channel0));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QAudioFormat::durationForBytes(qint32)const
extern "C" Q_DECL_EXPORT jlong JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_multimedia_QAudioFormat_durationForBytes_1native_1qint32_1constfct__JI)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint byteCount0)
{
    Q_UNUSED(__this)
    jlong __java_return_value{0};
    QTJAMBI_TRY {
        const QAudioFormat *__qt_this = QtJambiAPI::objectFromNativeId<QAudioFormat>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QAudioFormat::durationForBytes(qint32)const", __qt_this)
        qint64 __qt_return_value = __qt_this->durationForBytes(static_cast<qint32>(byteCount0));
        __java_return_value = jlong(__qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QAudioFormat::durationForFrames(qint32)const
extern "C" Q_DECL_EXPORT jlong JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_multimedia_QAudioFormat_durationForFrames_1native_1qint32_1constfct__JI)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint frameCount0)
{
    Q_UNUSED(__this)
    jlong __java_return_value{0};
    QTJAMBI_TRY {
        const QAudioFormat *__qt_this = QtJambiAPI::objectFromNativeId<QAudioFormat>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QAudioFormat::durationForFrames(qint32)const", __qt_this)
        qint64 __qt_return_value = __qt_this->durationForFrames(static_cast<qint32>(frameCount0));
        __java_return_value = jlong(__qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QAudioFormat::framesForBytes(qint32)const
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_multimedia_QAudioFormat_framesForBytes_1native_1qint32_1constfct__JI)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint byteCount0)
{
    Q_UNUSED(__this)
    jint __java_return_value{0};
    QTJAMBI_TRY {
        const QAudioFormat *__qt_this = QtJambiAPI::objectFromNativeId<QAudioFormat>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QAudioFormat::framesForBytes(qint32)const", __qt_this)
        qint32 __qt_return_value = __qt_this->framesForBytes(static_cast<qint32>(byteCount0));
        __java_return_value = jint(__qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QAudioFormat::framesForDuration(qint64)const
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_multimedia_QAudioFormat_framesForDuration_1native_1qint64_1constfct__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jlong microseconds0)
{
    Q_UNUSED(__this)
    jint __java_return_value{0};
    QTJAMBI_TRY {
        const QAudioFormat *__qt_this = QtJambiAPI::objectFromNativeId<QAudioFormat>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QAudioFormat::framesForDuration(qint64)const", __qt_this)
        qint32 __qt_return_value = __qt_this->framesForDuration(static_cast<qint64>(microseconds0));
        __java_return_value = jint(__qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QAudioFormat::isValid()const
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_multimedia_QAudioFormat_isValid_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        const QAudioFormat *__qt_this = QtJambiAPI::objectFromNativeId<QAudioFormat>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QAudioFormat::isValid()const", __qt_this)
        __java_return_value = __qt_this->isValid();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QAudioFormat::normalizedSampleValue(const void*)const
extern "C" Q_DECL_EXPORT jfloat JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_multimedia_QAudioFormat_normalizedSampleValue_1native_1const_1void_1ptr_1constfct__JLjava_nio_Buffer_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jobject sample0)
{
    Q_UNUSED(__this)
    jfloat __java_return_value{0};
    QTJAMBI_TRY {
        const QAudioFormat *__qt_this = QtJambiAPI::objectFromNativeId<QAudioFormat>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QAudioFormat::normalizedSampleValue(const void*)const", __qt_this)
        JBufferConstData __qt_sample0_buffer(__jni_env, sample0);
        const void* __qt_sample0 = reinterpret_cast<const void* >(__qt_sample0_buffer.data());
        __java_return_value = __qt_this->normalizedSampleValue(__qt_sample0);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QAudioFormat::operator==(QAudioFormat,QAudioFormat)
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_multimedia_QAudioFormat_operator_1equal_1native_1cref_1QAudioFormat__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID b1)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        QAudioFormat *__qt_this = QtJambiAPI::objectFromNativeId<QAudioFormat>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QAudioFormat::operator==(QAudioFormat,QAudioFormat)", __qt_this)
        const QAudioFormat& __qt_b1 = QtJambiAPI::valueReferenceFromNativeId<QAudioFormat>(b1);
        __java_return_value = (*__qt_this) == __qt_b1;
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QAudioFormat::sampleFormat()const
extern "C" Q_DECL_EXPORT jshort JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_multimedia_QAudioFormat_sampleFormat_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jshort __java_return_value{0};
    QTJAMBI_TRY {
        const QAudioFormat *__qt_this = QtJambiAPI::objectFromNativeId<QAudioFormat>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QAudioFormat::sampleFormat()const", __qt_this)
        QAudioFormat::SampleFormat __qt_return_value = __qt_this->sampleFormat();
        __java_return_value = __qt_return_value;
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QAudioFormat::sampleRate()const
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_multimedia_QAudioFormat_sampleRate_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jint __java_return_value{0};
    QTJAMBI_TRY {
        const QAudioFormat *__qt_this = QtJambiAPI::objectFromNativeId<QAudioFormat>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QAudioFormat::sampleRate()const", __qt_this)
        __java_return_value = __qt_this->sampleRate();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QAudioFormat::setChannelConfig(QAudioFormat::ChannelConfig)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_multimedia_QAudioFormat_setChannelConfig_1native_1QAudioFormat_1ChannelConfig__JI)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint config0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QAudioFormat *__qt_this = QtJambiAPI::objectFromNativeId<QAudioFormat>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QAudioFormat::setChannelConfig(QAudioFormat::ChannelConfig)", __qt_this)
        QAudioFormat::ChannelConfig __qt_config0 = qtjambi_cast<QAudioFormat::ChannelConfig>(__jni_env, config0);
        __qt_this->setChannelConfig(QAudioFormat::ChannelConfig(__qt_config0));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QAudioFormat::setChannelCount(int)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_multimedia_QAudioFormat_setChannelCount_1native_1int__JI)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint channelCount0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QAudioFormat *__qt_this = QtJambiAPI::objectFromNativeId<QAudioFormat>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QAudioFormat::setChannelCount(int)", __qt_this)
        __qt_this->setChannelCount(static_cast<int>(channelCount0));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QAudioFormat::setSampleFormat(QAudioFormat::SampleFormat)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_multimedia_QAudioFormat_setSampleFormat_1native_1QAudioFormat_1SampleFormat__JS)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jshort f0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QAudioFormat *__qt_this = QtJambiAPI::objectFromNativeId<QAudioFormat>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QAudioFormat::setSampleFormat(QAudioFormat::SampleFormat)", __qt_this)
        QAudioFormat::SampleFormat __qt_f0 = qtjambi_cast<QAudioFormat::SampleFormat>(__jni_env, f0);
        __qt_this->setSampleFormat(QAudioFormat::SampleFormat(__qt_f0));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QAudioFormat::setSampleRate(int)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_multimedia_QAudioFormat_setSampleRate_1native_1int__JI)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint sampleRate0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QAudioFormat *__qt_this = QtJambiAPI::objectFromNativeId<QAudioFormat>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QAudioFormat::setSampleRate(int)", __qt_this)
        __qt_this->setSampleRate(static_cast<int>(sampleRate0));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QAudioFormat::defaultChannelConfigForChannelCount(int)
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_multimedia_QAudioFormat_defaultChannelConfigForChannelCount_1native_1int__I)
(JNIEnv *__jni_env,
 jclass,
 jint channelCount0)
{
    QTJAMBI_NATIVE_METHOD_CALL("QAudioFormat::defaultChannelConfigForChannelCount(int)")
    jint __java_return_value{0};
    QTJAMBI_TRY {
        QAudioFormat::ChannelConfig __qt_return_value = QAudioFormat::defaultChannelConfigForChannelCount(static_cast<int>(channelCount0));
        __java_return_value = __qt_return_value;
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// emitting Field accessors (writeFieldAccessors)
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_multimedia_QAudioFormat_NChannelPositions__)
(JNIEnv *__jni_env,
 jclass)
{
    jint __java_return_value{0};
    QTJAMBI_TRY {
        int  __qt_value = QAudioFormat::NChannelPositions;
        __java_return_value = jint(__qt_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;
}

// emitting (writeJavaLangObjectOverrideFunctions)

extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_multimedia_QAudioFormat_hashCode_1native)
(JNIEnv * __jni_env, jclass, QtJambiNativeID __this_nativeId)
{
    jint __java_return_value = 0;
    QTJAMBI_TRY {
        QAudioFormat *__qt_this = QtJambiAPI::objectFromNativeId<QAudioFormat>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        hash_type hashValue = qHash(*__qt_this);
        __java_return_value = jint(quint64(hashValue) ^ quint64(hashValue) >> 32);
    } QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    } QTJAMBI_TRY_END
    return __java_return_value;
}

#include <QtCore/QDebug>
extern "C" Q_DECL_EXPORT jstring JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_multimedia_QAudioFormat_toString_1native)(JNIEnv *__jni_env, jobject, QtJambiNativeID __this_nativeId)
{
    jstring __java_return_value = nullptr;
    QTJAMBI_TRY {
        QAudioFormat *__qt_this = QtJambiAPI::objectFromNativeId<QAudioFormat>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QString res;
        QDebug(&res).noquote() << *__qt_this;
        if(!res.isEmpty() && res.back().isSpace())
            res = res.trimmed();
        __java_return_value = qtjambi_cast<jstring>(__jni_env, res);
    } QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    } QTJAMBI_TRY_END
    return __java_return_value;
}

// emitting (writeCloneFunction)

extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_multimedia_QAudioFormat_clone_1native)
(JNIEnv *__jni_env, jobject, QtJambiNativeID __this_nativeId)
{
    jobject __java_return_value = nullptr;
    QTJAMBI_TRY {
        const QAudioFormat *__qt_this = QtJambiAPI::objectFromNativeId<QAudioFormat>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        __java_return_value = qtjambi_cast<jobject>(__jni_env, *__qt_this);
    } QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    } QTJAMBI_TRY_END
    return __java_return_value;
}

// emitting  (functionsInTargetLang writePlacementConstructor)
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_multimedia_QAudioFormat_00024ChannelConfig_ChannelConfigStereo)
(JNIEnv *, jclass) {
    return jint(QAudioFormat::ChannelConfig::ChannelConfigStereo);
}

// emitting  (functionsInTargetLang writePlacementConstructor)
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_multimedia_QAudioFormat_00024ChannelConfig_ChannelConfig2Dot1)
(JNIEnv *, jclass) {
    return jint(QAudioFormat::ChannelConfig::ChannelConfig2Dot1);
}

// emitting  (functionsInTargetLang writePlacementConstructor)
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_multimedia_QAudioFormat_00024ChannelConfig_ChannelConfig3Dot0)
(JNIEnv *, jclass) {
    return jint(QAudioFormat::ChannelConfig::ChannelConfig3Dot0);
}

// emitting  (functionsInTargetLang writePlacementConstructor)
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_multimedia_QAudioFormat_00024ChannelConfig_ChannelConfig3Dot1)
(JNIEnv *, jclass) {
    return jint(QAudioFormat::ChannelConfig::ChannelConfig3Dot1);
}

// emitting  (functionsInTargetLang writePlacementConstructor)
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_multimedia_QAudioFormat_00024ChannelConfig_ChannelConfigSurround5Dot0)
(JNIEnv *, jclass) {
    return jint(QAudioFormat::ChannelConfig::ChannelConfigSurround5Dot0);
}

// emitting  (functionsInTargetLang writePlacementConstructor)
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_multimedia_QAudioFormat_00024ChannelConfig_ChannelConfigSurround5Dot1)
(JNIEnv *, jclass) {
    return jint(QAudioFormat::ChannelConfig::ChannelConfigSurround5Dot1);
}

// emitting  (functionsInTargetLang writePlacementConstructor)
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_multimedia_QAudioFormat_00024ChannelConfig_ChannelConfigSurround7Dot0)
(JNIEnv *, jclass) {
    return jint(QAudioFormat::ChannelConfig::ChannelConfigSurround7Dot0);
}

// emitting  (functionsInTargetLang writePlacementConstructor)
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_multimedia_QAudioFormat_00024ChannelConfig_ChannelConfigSurround7Dot1)
(JNIEnv *, jclass) {
    return jint(QAudioFormat::ChannelConfig::ChannelConfigSurround7Dot1);
}


void initialize_meta_info_QAudioFormat(){
    using namespace RegistryAPI;
    const std::type_info& typeId = registerValueTypeInfo<QAudioFormat>("QAudioFormat", "io/qt/multimedia/QAudioFormat");
    Q_UNUSED(typeId)
// BEGIN: function table
    registerConstructorInfos(typeId, &__qt_destruct_QAudioFormat, {
        ConstructorInfo(&__qt_construct_QAudioFormat_0, nullptr)
    });
// END: function table

// BEGIN: type registration
    registerDeleter(typeId, &deleter_QAudioFormat);
    registerMetaType<QAudioFormat>("QAudioFormat");
// END: type registration

// BEGIN: polymorphic ids
// END: polymorphic ids


// BEGIN: enums and flags
    registerEnumTypeInfo<QAudioFormat::AudioChannelPosition>("QAudioFormat::AudioChannelPosition", "io/qt/multimedia/QAudioFormat$AudioChannelPosition");
    registerEnumTypeInfo<QAudioFormat::ChannelConfig>("QAudioFormat::ChannelConfig", "io/qt/multimedia/QAudioFormat$ChannelConfig");
    registerEnumTypeInfo<QAudioFormat::SampleFormat>("QAudioFormat::SampleFormat", "io/qt/multimedia/QAudioFormat$SampleFormat");
// END: enums and flags
}
