#include <QtCore/QtGlobal>
#include <QtMultimedia/qvideoframe.h>
#include <QtCore/QMap>
#include <QtCore/QVariant>
#include <QtCore/qsize.h>
#include <QtGui/qimage.h>
#include <QtMultimedia/qabstractvideobuffer.h>

#include <QtJambi/QtJambiAPI>
#include <QtJambiMultimedia/hashes.h>

#include <QtJambi/RegistryAPI>
#include <QtJambi/Cast>

void deleter_QVideoFrame(void *ptr, bool isShell)
{
    QTJAMBI_NATIVE_METHOD_CALL("qtjambi_deleter for QVideoFrame")
    QVideoFrame *_ptr = reinterpret_cast<QVideoFrame *>(ptr);
    if(!isShell){
        QtJambiAPI::registerNonShellDeletion(ptr);
    }
    delete _ptr;
}

// emitting (writeConstructors)
// new QVideoFrame()
void __qt_construct_QVideoFrame(void* __qtjambi_ptr, JNIEnv* __jni_env, jobject __jni_object, jvalue* __java_arguments, bool __qtjambi_is_generic)
{
    QTJAMBI_NATIVE_METHOD_CALL("construct QVideoFrame()")
    Q_UNUSED(__java_arguments)
    QVideoFrame *__qt_this = new(__qtjambi_ptr) QVideoFrame();
    Q_UNUSED(__qtjambi_is_generic)
    Q_UNUSED(__jni_object)
    Q_UNUSED(__jni_env)
    Q_UNUSED(__qt_this)
}

// QVideoFrame::QVideoFrame()
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_multimedia_QVideoFrame_initialize_1native__Lio_qt_multimedia_QVideoFrame_2)
(JNIEnv *__jni_env,
 jclass __jni_class,
 jobject __jni_object)
{
    QTJAMBI_NATIVE_METHOD_CALL("QVideoFrame::QVideoFrame()")
    QTJAMBI_TRY {
        QtJambiShell::initialize(__jni_env, __jni_class, __jni_object, &__qt_construct_QVideoFrame, sizeof(QVideoFrame), typeid(QVideoFrame), false, &deleter_QVideoFrame, nullptr);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// new QVideoFrame(QAbstractVideoBuffer*,QSize,QVideoFrame::PixelFormat)
void __qt_construct_QVideoFrame_QAbstractVideoBuffer_ptr_cref_QSize_QVideoFrame_PixelFormat(void* __qtjambi_ptr, JNIEnv* __jni_env, jobject __jni_object, jvalue* __java_arguments, bool __qtjambi_is_generic)
{
    QTJAMBI_NATIVE_METHOD_CALL("construct QVideoFrame(QAbstractVideoBuffer*,QSize,QVideoFrame::PixelFormat)")
    jobject buffer0 = __java_arguments[0].l;
    QAbstractVideoBuffer* __qt_buffer0 = qtjambi_cast<QAbstractVideoBuffer* >(__jni_env, buffer0);
    jobject size1 = __java_arguments[1].l;
    const QSize& __qt_size1 = qtjambi_cast<const QSize& >(__jni_env, size1);
    jobject format2 = __java_arguments[2].l;
    QVideoFrame::PixelFormat __qt_format2 = qtjambi_cast<QVideoFrame::PixelFormat>(__jni_env, format2);
    QVideoFrame *__qt_this = new(__qtjambi_ptr) QVideoFrame(__qt_buffer0, __qt_size1, QVideoFrame::PixelFormat(__qt_format2));
    Q_UNUSED(__qtjambi_is_generic)
    Q_UNUSED(__jni_object)
    Q_UNUSED(__qt_this)
}

// QVideoFrame::QVideoFrame(QAbstractVideoBuffer*,QSize,QVideoFrame::PixelFormat)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_multimedia_QVideoFrame_initialize_1native__Lio_qt_multimedia_QVideoFrame_2Lio_qt_multimedia_QAbstractVideoBuffer_2Lio_qt_core_QSize_2Lio_qt_multimedia_QVideoFrame_00024PixelFormat_2)
(JNIEnv *__jni_env,
 jclass __jni_class,
 jobject __jni_object,
 jobject buffer0,
 jobject size1,
 jobject format2)
{
    QTJAMBI_NATIVE_METHOD_CALL("QVideoFrame::QVideoFrame(QAbstractVideoBuffer*,QSize,QVideoFrame::PixelFormat)")
    QTJAMBI_TRY {
        jvalue arguments[3];
        arguments[0].l = buffer0;
        arguments[1].l = size1;
        arguments[2].l = format2;
        QtJambiShell::initialize(__jni_env, __jni_class, __jni_object, &__qt_construct_QVideoFrame_QAbstractVideoBuffer_ptr_cref_QSize_QVideoFrame_PixelFormat, sizeof(QVideoFrame), typeid(QVideoFrame), false, &deleter_QVideoFrame, arguments);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// new QVideoFrame(QImage)
void __qt_construct_QVideoFrame_cref_QImage(void* __qtjambi_ptr, JNIEnv* __jni_env, jobject __jni_object, jvalue* __java_arguments, bool __qtjambi_is_generic)
{
    QTJAMBI_NATIVE_METHOD_CALL("construct QVideoFrame(QImage)")
    jobject image0 = __java_arguments[0].l;
    const QImage& __qt_image0 = qtjambi_cast<const QImage& >(__jni_env, image0);
    QVideoFrame *__qt_this = new(__qtjambi_ptr) QVideoFrame(__qt_image0);
    Q_UNUSED(__qtjambi_is_generic)
    Q_UNUSED(__jni_object)
    Q_UNUSED(__qt_this)
}

// QVideoFrame::QVideoFrame(QImage)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_multimedia_QVideoFrame_initialize_1native__Lio_qt_multimedia_QVideoFrame_2Lio_qt_gui_QImage_2)
(JNIEnv *__jni_env,
 jclass __jni_class,
 jobject __jni_object,
 jobject image0)
{
    QTJAMBI_NATIVE_METHOD_CALL("QVideoFrame::QVideoFrame(QImage)")
    QTJAMBI_TRY {
        jvalue arguments;
        arguments.l = image0;
        QtJambiShell::initialize(__jni_env, __jni_class, __jni_object, &__qt_construct_QVideoFrame_cref_QImage, sizeof(QVideoFrame), typeid(QVideoFrame), false, &deleter_QVideoFrame, &arguments);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// new QVideoFrame(QVideoFrame)
void __qt_construct_QVideoFrame_cref_QVideoFrame(void* __qtjambi_ptr, JNIEnv* __jni_env, jobject __jni_object, jvalue* __java_arguments, bool __qtjambi_is_generic)
{
    QTJAMBI_NATIVE_METHOD_CALL("construct QVideoFrame(QVideoFrame)")
    jobject other0 = __java_arguments[0].l;
    const QVideoFrame& __qt_other0 = qtjambi_cast<const QVideoFrame& >(__jni_env, other0);
    QVideoFrame *__qt_this = new(__qtjambi_ptr) QVideoFrame(__qt_other0);
    Q_UNUSED(__qtjambi_is_generic)
    Q_UNUSED(__jni_object)
    Q_UNUSED(__qt_this)
}

// QVideoFrame::QVideoFrame(QVideoFrame)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_multimedia_QVideoFrame_initialize_1native__Lio_qt_multimedia_QVideoFrame_2Lio_qt_multimedia_QVideoFrame_2)
(JNIEnv *__jni_env,
 jclass __jni_class,
 jobject __jni_object,
 jobject other0)
{
    QTJAMBI_NATIVE_METHOD_CALL("QVideoFrame::QVideoFrame(QVideoFrame)")
    QTJAMBI_TRY {
        jvalue arguments;
        arguments.l = other0;
        QtJambiShell::initialize(__jni_env, __jni_class, __jni_object, &__qt_construct_QVideoFrame_cref_QVideoFrame, sizeof(QVideoFrame), typeid(QVideoFrame), false, &deleter_QVideoFrame, &arguments);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// new QVideoFrame(int,QSize,int,QVideoFrame::PixelFormat)
void __qt_construct_QVideoFrame_int_cref_QSize_int_QVideoFrame_PixelFormat(void* __qtjambi_ptr, JNIEnv* __jni_env, jobject __jni_object, jvalue* __java_arguments, bool __qtjambi_is_generic)
{
    QTJAMBI_NATIVE_METHOD_CALL("construct QVideoFrame(int,QSize,int,QVideoFrame::PixelFormat)")
    jint bytes0 = __java_arguments[0].i;
    Q_UNUSED(bytes0)
    jobject size1 = __java_arguments[1].l;
    const QSize& __qt_size1 = qtjambi_cast<const QSize& >(__jni_env, size1);
    jint bytesPerLine2 = __java_arguments[2].i;
    Q_UNUSED(bytesPerLine2)
    jobject format3 = __java_arguments[3].l;
    QVideoFrame::PixelFormat __qt_format3 = qtjambi_cast<QVideoFrame::PixelFormat>(__jni_env, format3);
    QVideoFrame *__qt_this = new(__qtjambi_ptr) QVideoFrame(static_cast<int>(bytes0), __qt_size1, static_cast<int>(bytesPerLine2), QVideoFrame::PixelFormat(__qt_format3));
    Q_UNUSED(__qtjambi_is_generic)
    Q_UNUSED(__jni_object)
    Q_UNUSED(__qt_this)
}

// QVideoFrame::QVideoFrame(int,QSize,int,QVideoFrame::PixelFormat)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_multimedia_QVideoFrame_initialize_1native__Lio_qt_multimedia_QVideoFrame_2ILio_qt_core_QSize_2ILio_qt_multimedia_QVideoFrame_00024PixelFormat_2)
(JNIEnv *__jni_env,
 jclass __jni_class,
 jobject __jni_object,
 jint bytes0,
 jobject size1,
 jint bytesPerLine2,
 jobject format3)
{
    QTJAMBI_NATIVE_METHOD_CALL("QVideoFrame::QVideoFrame(int,QSize,int,QVideoFrame::PixelFormat)")
    QTJAMBI_TRY {
        jvalue arguments[4];
        arguments[0].i = bytes0;
        arguments[1].l = size1;
        arguments[2].i = bytesPerLine2;
        arguments[3].l = format3;
        QtJambiShell::initialize(__jni_env, __jni_class, __jni_object, &__qt_construct_QVideoFrame_int_cref_QSize_int_QVideoFrame_PixelFormat, sizeof(QVideoFrame), typeid(QVideoFrame), false, &deleter_QVideoFrame, arguments);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// destruct QVideoFrame
void __qt_destruct_QVideoFrame(void* ptr)
{
    QTJAMBI_NATIVE_METHOD_CALL("destruct QVideoFrame")
    reinterpret_cast<QVideoFrame*>(ptr)->~QVideoFrame();
}

// emitting  (functionsInTargetLang writeFinalFunction)
// QVideoFrame::availableMetaData()const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_multimedia_QVideoFrame_availableMetaData_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QVideoFrame *__qt_this = QtJambiAPI::objectFromNativeId<QVideoFrame>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QVideoFrame::availableMetaData()const", __qt_this)
        QMap<QString, QVariant> __qt_return_value = __qt_this->availableMetaData();
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QVideoFrame::bits()const
extern "C" Q_DECL_EXPORT jbyteArray JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_multimedia_QVideoFrame_bits_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jbyteArray __java_return_value{0};
    QTJAMBI_TRY {
        const QVideoFrame *__qt_this = QtJambiAPI::objectFromNativeId<QVideoFrame>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QVideoFrame::bits()const", __qt_this)
        const uchar* __qt_return_value = __qt_this->bits();
        __java_return_value = __jni_env->NewByteArray(__qt_this->mappedBytes());
        __jni_env->SetByteArrayRegion(__java_return_value, 0, __qt_this->mappedBytes(), reinterpret_cast<const jbyte *>(__qt_return_value));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QVideoFrame::buffer()const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_multimedia_QVideoFrame_buffer_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QVideoFrame *__qt_this = QtJambiAPI::objectFromNativeId<QVideoFrame>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QVideoFrame::buffer()const", __qt_this)
        QAbstractVideoBuffer* __qt_return_value = __qt_this->buffer();
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QVideoFrame::bytesPerLine()const
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_multimedia_QVideoFrame_bytesPerLine_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jint __java_return_value{0};
    QTJAMBI_TRY {
        const QVideoFrame *__qt_this = QtJambiAPI::objectFromNativeId<QVideoFrame>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QVideoFrame::bytesPerLine()const", __qt_this)
        __java_return_value = __qt_this->bytesPerLine();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QVideoFrame::bytesPerLine(int)const
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_multimedia_QVideoFrame_bytesPerLine_1native_1int_1constfct__JI)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint plane0)
{
    Q_UNUSED(__this)
    jint __java_return_value{0};
    QTJAMBI_TRY {
        const QVideoFrame *__qt_this = QtJambiAPI::objectFromNativeId<QVideoFrame>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QVideoFrame::bytesPerLine(int)const", __qt_this)
        __java_return_value = __qt_this->bytesPerLine(static_cast<int>(plane0));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QVideoFrame::endTime()const
extern "C" Q_DECL_EXPORT jlong JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_multimedia_QVideoFrame_endTime_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jlong __java_return_value{0};
    QTJAMBI_TRY {
        const QVideoFrame *__qt_this = QtJambiAPI::objectFromNativeId<QVideoFrame>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QVideoFrame::endTime()const", __qt_this)
        qint64 __qt_return_value = __qt_this->endTime();
        __java_return_value = jlong(__qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QVideoFrame::fieldType()const
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_multimedia_QVideoFrame_fieldType_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jint __java_return_value{0};
    QTJAMBI_TRY {
        const QVideoFrame *__qt_this = QtJambiAPI::objectFromNativeId<QVideoFrame>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QVideoFrame::fieldType()const", __qt_this)
        QVideoFrame::FieldType __qt_return_value = __qt_this->fieldType();
        __java_return_value = __qt_return_value;
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QVideoFrame::handle()const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_multimedia_QVideoFrame_handle_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QVideoFrame *__qt_this = QtJambiAPI::objectFromNativeId<QVideoFrame>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QVideoFrame::handle()const", __qt_this)
        QVariant __qt_return_value = __qt_this->handle();
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QVideoFrame::handleType()const
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_multimedia_QVideoFrame_handleType_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jint __java_return_value{0};
    QTJAMBI_TRY {
        const QVideoFrame *__qt_this = QtJambiAPI::objectFromNativeId<QVideoFrame>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QVideoFrame::handleType()const", __qt_this)
        QAbstractVideoBuffer::HandleType __qt_return_value = __qt_this->handleType();
        __java_return_value = __qt_return_value;
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QVideoFrame::height()const
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_multimedia_QVideoFrame_height_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jint __java_return_value{0};
    QTJAMBI_TRY {
        const QVideoFrame *__qt_this = QtJambiAPI::objectFromNativeId<QVideoFrame>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QVideoFrame::height()const", __qt_this)
        __java_return_value = __qt_this->height();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QVideoFrame::image()const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_multimedia_QVideoFrame_image_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QVideoFrame *__qt_this = QtJambiAPI::objectFromNativeId<QVideoFrame>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QVideoFrame::image()const", __qt_this)
        QImage __qt_return_value = __qt_this->image();
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QVideoFrame::isMapped()const
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_multimedia_QVideoFrame_isMapped_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        const QVideoFrame *__qt_this = QtJambiAPI::objectFromNativeId<QVideoFrame>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QVideoFrame::isMapped()const", __qt_this)
        __java_return_value = __qt_this->isMapped();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QVideoFrame::isReadable()const
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_multimedia_QVideoFrame_isReadable_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        const QVideoFrame *__qt_this = QtJambiAPI::objectFromNativeId<QVideoFrame>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QVideoFrame::isReadable()const", __qt_this)
        __java_return_value = __qt_this->isReadable();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QVideoFrame::isValid()const
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_multimedia_QVideoFrame_isValid_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        const QVideoFrame *__qt_this = QtJambiAPI::objectFromNativeId<QVideoFrame>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QVideoFrame::isValid()const", __qt_this)
        __java_return_value = __qt_this->isValid();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QVideoFrame::isWritable()const
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_multimedia_QVideoFrame_isWritable_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        const QVideoFrame *__qt_this = QtJambiAPI::objectFromNativeId<QVideoFrame>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QVideoFrame::isWritable()const", __qt_this)
        __java_return_value = __qt_this->isWritable();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QVideoFrame::map(QAbstractVideoBuffer::MapMode)
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_multimedia_QVideoFrame_map_1native_1QAbstractVideoBuffer_1MapMode__JI)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint mode0)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        QVideoFrame *__qt_this = QtJambiAPI::objectFromNativeId<QVideoFrame>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QVideoFrame::map(QAbstractVideoBuffer::MapMode)", __qt_this)
        QAbstractVideoBuffer::MapMode __qt_mode0 = qtjambi_cast<QAbstractVideoBuffer::MapMode>(__jni_env, mode0);
        __java_return_value = __qt_this->map(QAbstractVideoBuffer::MapMode(__qt_mode0));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QVideoFrame::mapMode()const
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_multimedia_QVideoFrame_mapMode_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jint __java_return_value{0};
    QTJAMBI_TRY {
        const QVideoFrame *__qt_this = QtJambiAPI::objectFromNativeId<QVideoFrame>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QVideoFrame::mapMode()const", __qt_this)
        QAbstractVideoBuffer::MapMode __qt_return_value = __qt_this->mapMode();
        __java_return_value = __qt_return_value;
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QVideoFrame::mappedBytes()const
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_multimedia_QVideoFrame_mappedBytes_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jint __java_return_value{0};
    QTJAMBI_TRY {
        const QVideoFrame *__qt_this = QtJambiAPI::objectFromNativeId<QVideoFrame>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QVideoFrame::mappedBytes()const", __qt_this)
        __java_return_value = __qt_this->mappedBytes();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QVideoFrame::metaData(QString)const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_multimedia_QVideoFrame_metaData_1native_1cref_1QString_1constfct__JLjava_lang_String_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jstring key0)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QVideoFrame *__qt_this = QtJambiAPI::objectFromNativeId<QVideoFrame>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QVideoFrame::metaData(QString)const", __qt_this)
        QString  __qt_key0 = qtjambi_cast<QString>(__jni_env, key0);
        QVariant __qt_return_value = __qt_this->metaData(__qt_key0);
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QVideoFrame::operator=(QVideoFrame)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_multimedia_QVideoFrame_assign_1native_1cref_1QVideoFrame__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID other0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QVideoFrame *__qt_this = QtJambiAPI::objectFromNativeId<QVideoFrame>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QVideoFrame::operator=(QVideoFrame)", __qt_this)
        const QVideoFrame& __qt_other0 = QtJambiAPI::valueReferenceFromNativeId<QVideoFrame>(other0);
        (*__qt_this) = __qt_other0;
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QVideoFrame::operator==(QVideoFrame)const
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_multimedia_QVideoFrame_equals_1native_1cref_1QVideoFrame_1constfct__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID other0)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        const QVideoFrame *__qt_this = QtJambiAPI::objectFromNativeId<QVideoFrame>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QVideoFrame::operator==(QVideoFrame)const", __qt_this)
        const QVideoFrame& __qt_other0 = QtJambiAPI::valueReferenceFromNativeId<QVideoFrame>(other0);
        __java_return_value = (*__qt_this) == __qt_other0;
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QVideoFrame::pixelFormat()const
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_multimedia_QVideoFrame_pixelFormat_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jint __java_return_value{0};
    QTJAMBI_TRY {
        const QVideoFrame *__qt_this = QtJambiAPI::objectFromNativeId<QVideoFrame>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QVideoFrame::pixelFormat()const", __qt_this)
        QVideoFrame::PixelFormat __qt_return_value = __qt_this->pixelFormat();
        __java_return_value = __qt_return_value;
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QVideoFrame::planeCount()const
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_multimedia_QVideoFrame_planeCount_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jint __java_return_value{0};
    QTJAMBI_TRY {
        const QVideoFrame *__qt_this = QtJambiAPI::objectFromNativeId<QVideoFrame>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QVideoFrame::planeCount()const", __qt_this)
        __java_return_value = __qt_this->planeCount();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QVideoFrame::setEndTime(qint64)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_multimedia_QVideoFrame_setEndTime_1native_1qint64__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jlong time0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QVideoFrame *__qt_this = QtJambiAPI::objectFromNativeId<QVideoFrame>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QVideoFrame::setEndTime(qint64)", __qt_this)
        __qt_this->setEndTime(static_cast<qint64>(time0));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QVideoFrame::setFieldType(QVideoFrame::FieldType)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_multimedia_QVideoFrame_setFieldType_1native_1QVideoFrame_1FieldType__JI)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint arg__1)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QVideoFrame *__qt_this = QtJambiAPI::objectFromNativeId<QVideoFrame>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QVideoFrame::setFieldType(QVideoFrame::FieldType)", __qt_this)
        QVideoFrame::FieldType __qt_arg__1 = qtjambi_cast<QVideoFrame::FieldType>(__jni_env, arg__1);
        __qt_this->setFieldType(QVideoFrame::FieldType(__qt_arg__1));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QVideoFrame::setMetaData(QString,QVariant)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_multimedia_QVideoFrame_setMetaData_1native_1cref_1QString_1cref_1QVariant__JLjava_lang_String_2Ljava_lang_Object_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jstring key0,
 jobject value1)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QVideoFrame *__qt_this = QtJambiAPI::objectFromNativeId<QVideoFrame>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QVideoFrame::setMetaData(QString,QVariant)", __qt_this)
        QString  __qt_key0 = qtjambi_cast<QString>(__jni_env, key0);
        QVariant  __qt_value1 = qtjambi_cast<QVariant >(__jni_env, value1);
        __qt_this->setMetaData(__qt_key0, __qt_value1);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QVideoFrame::setStartTime(qint64)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_multimedia_QVideoFrame_setStartTime_1native_1qint64__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jlong time0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QVideoFrame *__qt_this = QtJambiAPI::objectFromNativeId<QVideoFrame>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QVideoFrame::setStartTime(qint64)", __qt_this)
        __qt_this->setStartTime(static_cast<qint64>(time0));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QVideoFrame::size()const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_multimedia_QVideoFrame_size_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QVideoFrame *__qt_this = QtJambiAPI::objectFromNativeId<QVideoFrame>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QVideoFrame::size()const", __qt_this)
        QSize __qt_return_value = __qt_this->size();
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QVideoFrame::startTime()const
extern "C" Q_DECL_EXPORT jlong JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_multimedia_QVideoFrame_startTime_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jlong __java_return_value{0};
    QTJAMBI_TRY {
        const QVideoFrame *__qt_this = QtJambiAPI::objectFromNativeId<QVideoFrame>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QVideoFrame::startTime()const", __qt_this)
        qint64 __qt_return_value = __qt_this->startTime();
        __java_return_value = jlong(__qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QVideoFrame::unmap()
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_multimedia_QVideoFrame_unmap_1native__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QVideoFrame *__qt_this = QtJambiAPI::objectFromNativeId<QVideoFrame>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QVideoFrame::unmap()", __qt_this)
        __qt_this->unmap();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QVideoFrame::width()const
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_multimedia_QVideoFrame_width_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jint __java_return_value{0};
    QTJAMBI_TRY {
        const QVideoFrame *__qt_this = QtJambiAPI::objectFromNativeId<QVideoFrame>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QVideoFrame::width()const", __qt_this)
        __java_return_value = __qt_this->width();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QVideoFrame::imageFormatFromPixelFormat(QVideoFrame::PixelFormat)
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_multimedia_QVideoFrame_imageFormatFromPixelFormat_1native_1QVideoFrame_1PixelFormat__I)
(JNIEnv *__jni_env,
 jclass,
 jint format0)
{
    QTJAMBI_NATIVE_METHOD_CALL("QVideoFrame::imageFormatFromPixelFormat(QVideoFrame::PixelFormat)")
    jint __java_return_value{0};
    QTJAMBI_TRY {
        QVideoFrame::PixelFormat __qt_format0 = qtjambi_cast<QVideoFrame::PixelFormat>(__jni_env, format0);
        QImage::Format __qt_return_value = QVideoFrame::imageFormatFromPixelFormat(QVideoFrame::PixelFormat(__qt_format0));
        __java_return_value = __qt_return_value;
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QVideoFrame::pixelFormatFromImageFormat(QImage::Format)
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_multimedia_QVideoFrame_pixelFormatFromImageFormat_1native_1QImage_1Format__I)
(JNIEnv *__jni_env,
 jclass,
 jint format0)
{
    QTJAMBI_NATIVE_METHOD_CALL("QVideoFrame::pixelFormatFromImageFormat(QImage::Format)")
    jint __java_return_value{0};
    QTJAMBI_TRY {
        QImage::Format __qt_format0 = qtjambi_cast<QImage::Format>(__jni_env, format0);
        QVideoFrame::PixelFormat __qt_return_value = QVideoFrame::pixelFormatFromImageFormat(QImage::Format(__qt_format0));
        __java_return_value = __qt_return_value;
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// emitting (writeJavaLangObjectOverrideFunctions)

extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_multimedia_QVideoFrame_hashCode_1native)
(JNIEnv * __jni_env, jclass, QtJambiNativeID __this_nativeId)
{
    jint __java_return_value = 0;
    QTJAMBI_TRY {
        QVideoFrame *__qt_this = QtJambiAPI::objectFromNativeId<QVideoFrame>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        hash_type hashValue = qHash(*__qt_this);
        __java_return_value = jint(hashValue);
    } QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    } QTJAMBI_TRY_END
    return __java_return_value;
}

#include <QtCore/QDebug>
extern "C" Q_DECL_EXPORT jstring JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_multimedia_QVideoFrame_toString_1native)(JNIEnv *__jni_env, jobject, QtJambiNativeID __this_nativeId)
{
    jstring __java_return_value = nullptr;
    QTJAMBI_TRY {
        QVideoFrame *__qt_this = QtJambiAPI::objectFromNativeId<QVideoFrame>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QString res;
        QDebug(&res).noquote() << *__qt_this;
        if(!res.isEmpty() && res.back().isSpace())
            res = res.trimmed();
        __java_return_value = qtjambi_cast<jstring>(__jni_env, res);
    } QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    } QTJAMBI_TRY_END
    return __java_return_value;
}

// emitting (writeCloneFunction)

extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_multimedia_QVideoFrame_clone_1native)
(JNIEnv *__jni_env, jobject, QtJambiNativeID __this_nativeId)
{
    jobject __java_return_value = nullptr;
    QTJAMBI_TRY {
        const QVideoFrame *__qt_this = QtJambiAPI::objectFromNativeId<QVideoFrame>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        __java_return_value = qtjambi_cast<jobject>(__jni_env, *__qt_this);
    } QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    } QTJAMBI_TRY_END
    return __java_return_value;
}


void initialize_meta_info_QVideoFrame(){
    using namespace RegistryAPI;
    const std::type_info& typeId = registerValueTypeInfo<QVideoFrame>("QVideoFrame", "io/qt/multimedia/QVideoFrame");
    Q_UNUSED(typeId)
// BEGIN: function table
    registerConstructorInfos(typeId, &__qt_destruct_QVideoFrame, {
        ConstructorInfo(&__qt_construct_QVideoFrame, nullptr)
       ,ConstructorInfo(&__qt_construct_QVideoFrame_QAbstractVideoBuffer_ptr_cref_QSize_QVideoFrame_PixelFormat, "Lio/qt/multimedia/QAbstractVideoBuffer;Lio/qt/core/QSize;Lio/qt/multimedia/QVideoFrame$PixelFormat;")
       ,ConstructorInfo(&__qt_construct_QVideoFrame_cref_QImage, "Lio/qt/gui/QImage;")
       ,ConstructorInfo(&__qt_construct_QVideoFrame_cref_QVideoFrame, "Lio/qt/multimedia/QVideoFrame;")
       ,ConstructorInfo(&__qt_construct_QVideoFrame_int_cref_QSize_int_QVideoFrame_PixelFormat, "ILio/qt/core/QSize;ILio/qt/multimedia/QVideoFrame$PixelFormat;")
    });
// END: function table

// BEGIN: type registration
    registerDeleter(typeId, &deleter_QVideoFrame);
    registerMetaType<QVideoFrame>("QVideoFrame");
// END: type registration

// BEGIN: polymorphic ids
// END: polymorphic ids


// BEGIN: enums and flags
    registerEnumTypeInfo<QVideoFrame::FieldType>("QVideoFrame::FieldType", "io/qt/multimedia/QVideoFrame$FieldType");
    registerEnumTypeInfo<QVideoFrame::PixelFormat>("QVideoFrame::PixelFormat", "io/qt/multimedia/QVideoFrame$PixelFormat");
// END: enums and flags
}
