#ifndef QABSTRACTVIDEOBUFFER_SHELL_H
#define QABSTRACTVIDEOBUFFER_SHELL_H

#include <QtCore/QtGlobal>
#include <QtMultimedia/qabstractvideobuffer.h>
#include <QtJambi/QtJambiAPI>
#include <QtCore/QVariant>
#include "utils_p.h"
#include <QtJambi/RegistryAPI>


class QAbstractVideoBuffer_shell : public QAbstractVideoBuffer, public QtJambiShellInterface
{
public:
    QAbstractVideoBuffer_shell(QAbstractVideoBuffer::HandleType type0);
    ~QAbstractVideoBuffer_shell() override;

    QVariant handle() const override;
    uchar* map(QAbstractVideoBuffer::MapMode mode0, int* numBytes1, int* bytesPerLine2) override;
    QAbstractVideoBuffer::MapMode mapMode() const override;
    void release() override;
    void unmap() override;
    static void operator delete(void * ptr) noexcept;
private:
    QtJambiShell* __shell() const override final;
    jmethodID __shell_javaMethod(int pos) const;
};

struct QAbstractVideoBuffer_access : public QAbstractVideoBuffer
{
    jobject __qt_handle_constfct(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId) const;
    jobject __qt_map_QAbstractVideoBuffer_MapMode_int_ptr_int_ptr(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId, jint mode0);
    jint __qt_mapMode_constfct(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId) const;
    void __qt_release(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId);
    void __qt_unmap(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId);
    void setHandleType_cref_QAbstractVideoBuffer_HandleType(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId, jint handleType0);
};

#endif // QABSTRACTVIDEOBUFFER_SHELL_H
