#include <QtCore/QtGlobal>
#include <QtMultimedia/qvideosurfaceformat.h>
#include <QtCore/QByteArray>
#include <QtCore/QList>
#include <QtCore/QScopedPointer>
#include <QtCore/QVariant>
#include <QtCore/qbytearray.h>
#include <QtCore/qrect.h>
#include <QtCore/qsize.h>
#include <QtMultimedia/qabstractvideobuffer.h>
#include <QtMultimedia/qvideoframe.h>

#include <QtJambi/QtJambiAPI>
#include <QtJambiMultimedia/hashes.h>

#include <QtJambi/RegistryAPI>
#include <QtJambi/Cast>

void deleter_QVideoSurfaceFormat(void *ptr, bool isShell)
{
    QTJAMBI_NATIVE_METHOD_CALL("qtjambi_deleter for QVideoSurfaceFormat")
    QVideoSurfaceFormat *_ptr = reinterpret_cast<QVideoSurfaceFormat *>(ptr);
    if(!isShell){
        QtJambiAPI::registerNonShellDeletion(ptr);
    }
    delete _ptr;
}

// emitting (writeConstructors)
// new QVideoSurfaceFormat()
void __qt_construct_QVideoSurfaceFormat_0(void* __qtjambi_ptr, JNIEnv* __jni_env, jobject __jni_object, jvalue* __java_arguments)
{
    QTJAMBI_NATIVE_METHOD_CALL("construct QVideoSurfaceFormat()")
    Q_UNUSED(__java_arguments)
    QVideoSurfaceFormat *__qt_this = new(__qtjambi_ptr) QVideoSurfaceFormat();
    Q_UNUSED(__jni_object)
    Q_UNUSED(__jni_env)
    Q_UNUSED(__qt_this)
}

// new QVideoSurfaceFormat(QSize,QVideoFrame::PixelFormat,QAbstractVideoBuffer::HandleType)
void __qt_construct_QVideoSurfaceFormat_1(void* __qtjambi_ptr, JNIEnv* __jni_env, jobject __jni_object, jvalue* __java_arguments)
{
    QTJAMBI_NATIVE_METHOD_CALL("construct QVideoSurfaceFormat(QSize,QVideoFrame::PixelFormat,QAbstractVideoBuffer::HandleType)")
    jobject size0 = __java_arguments[0].l;
    const QSize& __qt_size0 = qtjambi_cast<const QSize& >(__jni_env, size0);
    jobject pixelFormat1 = __java_arguments[1].l;
    QVideoFrame::PixelFormat __qt_pixelFormat1 = qtjambi_cast<QVideoFrame::PixelFormat>(__jni_env, pixelFormat1);
    QVideoSurfaceFormat *__qt_this = new(__qtjambi_ptr) QVideoSurfaceFormat(__qt_size0, QVideoFrame::PixelFormat(__qt_pixelFormat1));
    Q_UNUSED(__jni_object)
    Q_UNUSED(__qt_this)
}

// new QVideoSurfaceFormat(QSize,QVideoFrame::PixelFormat,QAbstractVideoBuffer::HandleType)
void __qt_construct_QVideoSurfaceFormat_2(void* __qtjambi_ptr, JNIEnv* __jni_env, jobject __jni_object, jvalue* __java_arguments)
{
    QTJAMBI_NATIVE_METHOD_CALL("construct QVideoSurfaceFormat(QSize,QVideoFrame::PixelFormat,QAbstractVideoBuffer::HandleType)")
    jobject size0 = __java_arguments[0].l;
    const QSize& __qt_size0 = qtjambi_cast<const QSize& >(__jni_env, size0);
    jobject pixelFormat1 = __java_arguments[1].l;
    QVideoFrame::PixelFormat __qt_pixelFormat1 = qtjambi_cast<QVideoFrame::PixelFormat>(__jni_env, pixelFormat1);
    jobject handleType2 = __java_arguments[2].l;
    QAbstractVideoBuffer::HandleType __qt_handleType2 = qtjambi_cast<QAbstractVideoBuffer::HandleType>(__jni_env, handleType2);
    QVideoSurfaceFormat *__qt_this = new(__qtjambi_ptr) QVideoSurfaceFormat(__qt_size0, QVideoFrame::PixelFormat(__qt_pixelFormat1), QAbstractVideoBuffer::HandleType(__qt_handleType2));
    Q_UNUSED(__jni_object)
    Q_UNUSED(__qt_this)
}

// new QVideoSurfaceFormat(QVideoSurfaceFormat)
void __qt_construct_QVideoSurfaceFormat_3(void* __qtjambi_ptr, JNIEnv* __jni_env, jobject __jni_object, jvalue* __java_arguments)
{
    QTJAMBI_NATIVE_METHOD_CALL("construct QVideoSurfaceFormat(QVideoSurfaceFormat)")
    jobject format0 = __java_arguments[0].l;
    const QVideoSurfaceFormat& __qt_format0 = qtjambi_cast<const QVideoSurfaceFormat& >(__jni_env, format0);
    QVideoSurfaceFormat *__qt_this = new(__qtjambi_ptr) QVideoSurfaceFormat(__qt_format0);
    Q_UNUSED(__jni_object)
    Q_UNUSED(__qt_this)
}

// destruct QVideoSurfaceFormat
void __qt_destruct_QVideoSurfaceFormat(void* ptr)
{
    QTJAMBI_NATIVE_METHOD_CALL("destruct QVideoSurfaceFormat")
    reinterpret_cast<QVideoSurfaceFormat*>(ptr)->~QVideoSurfaceFormat();
}

// emitting  (functionsInTargetLang writeFinalFunction)
// QVideoSurfaceFormat::QVideoSurfaceFormat()
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_multimedia_QVideoSurfaceFormat_initialize_1native__Lio_qt_multimedia_QVideoSurfaceFormat_2)
(JNIEnv *__jni_env,
 jclass __jni_class,
 jobject __jni_object)
{
    QTJAMBI_NATIVE_METHOD_CALL("QVideoSurfaceFormat::QVideoSurfaceFormat()")
    QTJAMBI_TRY {
        QtJambiShell::initialize(__jni_env, __jni_class, __jni_object, &__qt_construct_QVideoSurfaceFormat_0, sizeof(QVideoSurfaceFormat), typeid(QVideoSurfaceFormat), false, &deleter_QVideoSurfaceFormat, nullptr);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QVideoSurfaceFormat::QVideoSurfaceFormat(QSize,QVideoFrame::PixelFormat,QAbstractVideoBuffer::HandleType)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_multimedia_QVideoSurfaceFormat_initialize_1native__Lio_qt_multimedia_QVideoSurfaceFormat_2Lio_qt_core_QSize_2Lio_qt_multimedia_QVideoFrame_00024PixelFormat_2Lio_qt_multimedia_QAbstractVideoBuffer_00024HandleType_2)
(JNIEnv *__jni_env,
 jclass __jni_class,
 jobject __jni_object,
 jobject size0,
 jobject pixelFormat1,
 jobject handleType2)
{
    QTJAMBI_NATIVE_METHOD_CALL("QVideoSurfaceFormat::QVideoSurfaceFormat(QSize,QVideoFrame::PixelFormat,QAbstractVideoBuffer::HandleType)")
    QTJAMBI_TRY {
        jvalue arguments[3];
        arguments[0].l = size0;
        arguments[1].l = pixelFormat1;
        arguments[2].l = handleType2;
        QtJambiShell::initialize(__jni_env, __jni_class, __jni_object, &__qt_construct_QVideoSurfaceFormat_2, sizeof(QVideoSurfaceFormat), typeid(QVideoSurfaceFormat), false, &deleter_QVideoSurfaceFormat, arguments);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QVideoSurfaceFormat::QVideoSurfaceFormat(QVideoSurfaceFormat)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_multimedia_QVideoSurfaceFormat_initialize_1native__Lio_qt_multimedia_QVideoSurfaceFormat_2Lio_qt_multimedia_QVideoSurfaceFormat_2)
(JNIEnv *__jni_env,
 jclass __jni_class,
 jobject __jni_object,
 jobject format0)
{
    QTJAMBI_NATIVE_METHOD_CALL("QVideoSurfaceFormat::QVideoSurfaceFormat(QVideoSurfaceFormat)")
    QTJAMBI_TRY {
        jvalue arguments;
        arguments.l = format0;
        QtJambiShell::initialize(__jni_env, __jni_class, __jni_object, &__qt_construct_QVideoSurfaceFormat_3, sizeof(QVideoSurfaceFormat), typeid(QVideoSurfaceFormat), false, &deleter_QVideoSurfaceFormat, &arguments);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QVideoSurfaceFormat::frameHeight()const
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_multimedia_QVideoSurfaceFormat_frameHeight_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jint __java_return_value{0};
    QTJAMBI_TRY {
        const QVideoSurfaceFormat *__qt_this = QtJambiAPI::objectFromNativeId<QVideoSurfaceFormat>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QVideoSurfaceFormat::frameHeight()const", __qt_this)
        __java_return_value = __qt_this->frameHeight();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QVideoSurfaceFormat::frameRate()const
extern "C" Q_DECL_EXPORT jdouble JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_multimedia_QVideoSurfaceFormat_frameRate_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jdouble __java_return_value{0};
    QTJAMBI_TRY {
        const QVideoSurfaceFormat *__qt_this = QtJambiAPI::objectFromNativeId<QVideoSurfaceFormat>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QVideoSurfaceFormat::frameRate()const", __qt_this)
        qreal __qt_return_value = __qt_this->frameRate();
        __java_return_value = jdouble(__qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QVideoSurfaceFormat::frameSize()const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_multimedia_QVideoSurfaceFormat_frameSize_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QVideoSurfaceFormat *__qt_this = QtJambiAPI::objectFromNativeId<QVideoSurfaceFormat>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QVideoSurfaceFormat::frameSize()const", __qt_this)
        QSize __qt_return_value = __qt_this->frameSize();
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QVideoSurfaceFormat::frameWidth()const
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_multimedia_QVideoSurfaceFormat_frameWidth_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jint __java_return_value{0};
    QTJAMBI_TRY {
        const QVideoSurfaceFormat *__qt_this = QtJambiAPI::objectFromNativeId<QVideoSurfaceFormat>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QVideoSurfaceFormat::frameWidth()const", __qt_this)
        __java_return_value = __qt_this->frameWidth();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QVideoSurfaceFormat::handleType()const
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_multimedia_QVideoSurfaceFormat_handleType_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jint __java_return_value{0};
    QTJAMBI_TRY {
        const QVideoSurfaceFormat *__qt_this = QtJambiAPI::objectFromNativeId<QVideoSurfaceFormat>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QVideoSurfaceFormat::handleType()const", __qt_this)
        QAbstractVideoBuffer::HandleType __qt_return_value = __qt_this->handleType();
        __java_return_value = __qt_return_value;
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QVideoSurfaceFormat::isMirrored()const
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_multimedia_QVideoSurfaceFormat_isMirrored_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        const QVideoSurfaceFormat *__qt_this = QtJambiAPI::objectFromNativeId<QVideoSurfaceFormat>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QVideoSurfaceFormat::isMirrored()const", __qt_this)
        __java_return_value = __qt_this->isMirrored();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QVideoSurfaceFormat::isValid()const
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_multimedia_QVideoSurfaceFormat_isValid_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        const QVideoSurfaceFormat *__qt_this = QtJambiAPI::objectFromNativeId<QVideoSurfaceFormat>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QVideoSurfaceFormat::isValid()const", __qt_this)
        __java_return_value = __qt_this->isValid();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QVideoSurfaceFormat::operator=(QVideoSurfaceFormat)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_multimedia_QVideoSurfaceFormat_assign_1native_1cref_1QVideoSurfaceFormat__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID format0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QVideoSurfaceFormat *__qt_this = QtJambiAPI::objectFromNativeId<QVideoSurfaceFormat>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QVideoSurfaceFormat::operator=(QVideoSurfaceFormat)", __qt_this)
        const QVideoSurfaceFormat& __qt_format0 = QtJambiAPI::valueReferenceFromNativeId<QVideoSurfaceFormat>(format0);
        (*__qt_this) = __qt_format0;
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QVideoSurfaceFormat::operator==(QVideoSurfaceFormat)const
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_multimedia_QVideoSurfaceFormat_equals_1native_1cref_1QVideoSurfaceFormat_1constfct__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID format0)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        const QVideoSurfaceFormat *__qt_this = QtJambiAPI::objectFromNativeId<QVideoSurfaceFormat>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QVideoSurfaceFormat::operator==(QVideoSurfaceFormat)const", __qt_this)
        const QVideoSurfaceFormat& __qt_format0 = QtJambiAPI::valueReferenceFromNativeId<QVideoSurfaceFormat>(format0);
        __java_return_value = (*__qt_this) == __qt_format0;
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QVideoSurfaceFormat::pixelAspectRatio()const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_multimedia_QVideoSurfaceFormat_pixelAspectRatio_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QVideoSurfaceFormat *__qt_this = QtJambiAPI::objectFromNativeId<QVideoSurfaceFormat>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QVideoSurfaceFormat::pixelAspectRatio()const", __qt_this)
        QSize __qt_return_value = __qt_this->pixelAspectRatio();
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QVideoSurfaceFormat::pixelFormat()const
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_multimedia_QVideoSurfaceFormat_pixelFormat_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jint __java_return_value{0};
    QTJAMBI_TRY {
        const QVideoSurfaceFormat *__qt_this = QtJambiAPI::objectFromNativeId<QVideoSurfaceFormat>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QVideoSurfaceFormat::pixelFormat()const", __qt_this)
        QVideoFrame::PixelFormat __qt_return_value = __qt_this->pixelFormat();
        __java_return_value = __qt_return_value;
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QVideoSurfaceFormat::property(const char*)const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_multimedia_QVideoSurfaceFormat_property_1native_1const_1char_1ptr_1constfct__JLjava_lang_String_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jstring name0)
{
    QtJambiScope __qtjambi_scope(__this_nativeId);
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QVideoSurfaceFormat *__qt_this = QtJambiAPI::objectFromNativeId<QVideoSurfaceFormat>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QVideoSurfaceFormat::property(const char*)const", __qt_this)
        const char*  __qt_name0 = qtjambi_cast<const char* >(__jni_env, __qtjambi_scope, name0);
        QVariant __qt_return_value = __qt_this->property(__qt_name0);
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QVideoSurfaceFormat::propertyNames()const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_multimedia_QVideoSurfaceFormat_propertyNames_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QVideoSurfaceFormat *__qt_this = QtJambiAPI::objectFromNativeId<QVideoSurfaceFormat>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QVideoSurfaceFormat::propertyNames()const", __qt_this)
        QList<QByteArray> __qt_return_value = __qt_this->propertyNames();
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QVideoSurfaceFormat::scanLineDirection()const
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_multimedia_QVideoSurfaceFormat_scanLineDirection_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jint __java_return_value{0};
    QTJAMBI_TRY {
        const QVideoSurfaceFormat *__qt_this = QtJambiAPI::objectFromNativeId<QVideoSurfaceFormat>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QVideoSurfaceFormat::scanLineDirection()const", __qt_this)
        QVideoSurfaceFormat::Direction __qt_return_value = __qt_this->scanLineDirection();
        __java_return_value = __qt_return_value;
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QVideoSurfaceFormat::setFrameRate(qreal)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_multimedia_QVideoSurfaceFormat_setFrameRate_1native_1qreal__JD)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jdouble rate0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QVideoSurfaceFormat *__qt_this = QtJambiAPI::objectFromNativeId<QVideoSurfaceFormat>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QVideoSurfaceFormat::setFrameRate(qreal)", __qt_this)
        __qt_this->setFrameRate(static_cast<qreal>(rate0));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QVideoSurfaceFormat::setFrameSize(QSize)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_multimedia_QVideoSurfaceFormat_setFrameSize_1native_1cref_1QSize__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID size0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QVideoSurfaceFormat *__qt_this = QtJambiAPI::objectFromNativeId<QVideoSurfaceFormat>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QVideoSurfaceFormat::setFrameSize(QSize)", __qt_this)
        const QSize& __qt_size0 = QtJambiAPI::valueReferenceFromNativeId<QSize>(size0);
        __qt_this->setFrameSize(__qt_size0);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QVideoSurfaceFormat::setFrameSize(int,int)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_multimedia_QVideoSurfaceFormat_setFrameSize_1native_1int_1int__JII)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint width0,
 jint height1)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QVideoSurfaceFormat *__qt_this = QtJambiAPI::objectFromNativeId<QVideoSurfaceFormat>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QVideoSurfaceFormat::setFrameSize(int,int)", __qt_this)
        __qt_this->setFrameSize(static_cast<int>(width0), static_cast<int>(height1));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QVideoSurfaceFormat::setMirrored(bool)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_multimedia_QVideoSurfaceFormat_setMirrored_1native_1bool__JZ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jboolean mirrored0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QVideoSurfaceFormat *__qt_this = QtJambiAPI::objectFromNativeId<QVideoSurfaceFormat>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QVideoSurfaceFormat::setMirrored(bool)", __qt_this)
        __qt_this->setMirrored(static_cast<bool>(mirrored0));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QVideoSurfaceFormat::setPixelAspectRatio(QSize)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_multimedia_QVideoSurfaceFormat_setPixelAspectRatio_1native_1cref_1QSize__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID ratio0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QVideoSurfaceFormat *__qt_this = QtJambiAPI::objectFromNativeId<QVideoSurfaceFormat>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QVideoSurfaceFormat::setPixelAspectRatio(QSize)", __qt_this)
        const QSize& __qt_ratio0 = QtJambiAPI::valueReferenceFromNativeId<QSize>(ratio0);
        __qt_this->setPixelAspectRatio(__qt_ratio0);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QVideoSurfaceFormat::setPixelAspectRatio(int,int)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_multimedia_QVideoSurfaceFormat_setPixelAspectRatio_1native_1int_1int__JII)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint width0,
 jint height1)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QVideoSurfaceFormat *__qt_this = QtJambiAPI::objectFromNativeId<QVideoSurfaceFormat>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QVideoSurfaceFormat::setPixelAspectRatio(int,int)", __qt_this)
        __qt_this->setPixelAspectRatio(static_cast<int>(width0), static_cast<int>(height1));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QVideoSurfaceFormat::setProperty(const char*,QVariant)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_multimedia_QVideoSurfaceFormat_setProperty_1native_1const_1char_1ptr_1cref_1QVariant__JLjava_lang_String_2Ljava_lang_Object_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jstring name0,
 jobject value1)
{
    QtJambiScope __qtjambi_scope(__this_nativeId);
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QVideoSurfaceFormat *__qt_this = QtJambiAPI::objectFromNativeId<QVideoSurfaceFormat>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QVideoSurfaceFormat::setProperty(const char*,QVariant)", __qt_this)
        const char*  __qt_name0 = qtjambi_cast<const char* >(__jni_env, __qtjambi_scope, name0);
        QVariant  __qt_value1 = qtjambi_cast<QVariant >(__jni_env, value1);
        __qt_this->setProperty(__qt_name0, __qt_value1);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QVideoSurfaceFormat::setScanLineDirection(QVideoSurfaceFormat::Direction)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_multimedia_QVideoSurfaceFormat_setScanLineDirection_1native_1QVideoSurfaceFormat_1Direction__JI)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint direction0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QVideoSurfaceFormat *__qt_this = QtJambiAPI::objectFromNativeId<QVideoSurfaceFormat>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QVideoSurfaceFormat::setScanLineDirection(QVideoSurfaceFormat::Direction)", __qt_this)
        QVideoSurfaceFormat::Direction __qt_direction0 = qtjambi_cast<QVideoSurfaceFormat::Direction>(__jni_env, direction0);
        __qt_this->setScanLineDirection(QVideoSurfaceFormat::Direction(__qt_direction0));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QVideoSurfaceFormat::setViewport(QRect)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_multimedia_QVideoSurfaceFormat_setViewport_1native_1cref_1QRect__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID viewport0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QVideoSurfaceFormat *__qt_this = QtJambiAPI::objectFromNativeId<QVideoSurfaceFormat>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QVideoSurfaceFormat::setViewport(QRect)", __qt_this)
        const QRect& __qt_viewport0 = QtJambiAPI::valueReferenceFromNativeId<QRect>(viewport0);
        __qt_this->setViewport(__qt_viewport0);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QVideoSurfaceFormat::setYCbCrColorSpace(QVideoSurfaceFormat::YCbCrColorSpace)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_multimedia_QVideoSurfaceFormat_setYCbCrColorSpace_1native_1QVideoSurfaceFormat_1YCbCrColorSpace__JI)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint colorSpace0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QVideoSurfaceFormat *__qt_this = QtJambiAPI::objectFromNativeId<QVideoSurfaceFormat>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QVideoSurfaceFormat::setYCbCrColorSpace(QVideoSurfaceFormat::YCbCrColorSpace)", __qt_this)
        QVideoSurfaceFormat::YCbCrColorSpace __qt_colorSpace0 = qtjambi_cast<QVideoSurfaceFormat::YCbCrColorSpace>(__jni_env, colorSpace0);
        __qt_this->setYCbCrColorSpace(QVideoSurfaceFormat::YCbCrColorSpace(__qt_colorSpace0));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QVideoSurfaceFormat::sizeHint()const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_multimedia_QVideoSurfaceFormat_sizeHint_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QVideoSurfaceFormat *__qt_this = QtJambiAPI::objectFromNativeId<QVideoSurfaceFormat>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QVideoSurfaceFormat::sizeHint()const", __qt_this)
        QSize __qt_return_value = __qt_this->sizeHint();
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QVideoSurfaceFormat::viewport()const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_multimedia_QVideoSurfaceFormat_viewport_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QVideoSurfaceFormat *__qt_this = QtJambiAPI::objectFromNativeId<QVideoSurfaceFormat>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QVideoSurfaceFormat::viewport()const", __qt_this)
        QRect __qt_return_value = __qt_this->viewport();
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QVideoSurfaceFormat::yCbCrColorSpace()const
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_multimedia_QVideoSurfaceFormat_yCbCrColorSpace_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jint __java_return_value{0};
    QTJAMBI_TRY {
        const QVideoSurfaceFormat *__qt_this = QtJambiAPI::objectFromNativeId<QVideoSurfaceFormat>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QVideoSurfaceFormat::yCbCrColorSpace()const", __qt_this)
        QVideoSurfaceFormat::YCbCrColorSpace __qt_return_value = __qt_this->yCbCrColorSpace();
        __java_return_value = __qt_return_value;
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// emitting (writeJavaLangObjectOverrideFunctions)

extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_multimedia_QVideoSurfaceFormat_hashCode_1native)
(JNIEnv * __jni_env, jclass, QtJambiNativeID __this_nativeId)
{
    jint __java_return_value = 0;
    QTJAMBI_TRY {
        QVideoSurfaceFormat *__qt_this = QtJambiAPI::objectFromNativeId<QVideoSurfaceFormat>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        hash_type hashValue = qHash(*__qt_this);
        __java_return_value = jint(hashValue);
    } QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    } QTJAMBI_TRY_END
    return __java_return_value;
}

#include <QtCore/QDebug>
extern "C" Q_DECL_EXPORT jstring JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_multimedia_QVideoSurfaceFormat_toString_1native)(JNIEnv *__jni_env, jobject, QtJambiNativeID __this_nativeId)
{
    jstring __java_return_value = nullptr;
    QTJAMBI_TRY {
        QVideoSurfaceFormat *__qt_this = QtJambiAPI::objectFromNativeId<QVideoSurfaceFormat>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QString res;
        QDebug(&res).noquote() << *__qt_this;
        if(!res.isEmpty() && res.back().isSpace())
            res = res.trimmed();
        __java_return_value = qtjambi_cast<jstring>(__jni_env, res);
    } QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    } QTJAMBI_TRY_END
    return __java_return_value;
}

// emitting (writeCloneFunction)

extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_multimedia_QVideoSurfaceFormat_clone_1native)
(JNIEnv *__jni_env, jobject, QtJambiNativeID __this_nativeId)
{
    jobject __java_return_value = nullptr;
    QTJAMBI_TRY {
        const QVideoSurfaceFormat *__qt_this = QtJambiAPI::objectFromNativeId<QVideoSurfaceFormat>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        __java_return_value = qtjambi_cast<jobject>(__jni_env, *__qt_this);
    } QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    } QTJAMBI_TRY_END
    return __java_return_value;
}


void initialize_meta_info_QVideoSurfaceFormat(){
    using namespace RegistryAPI;
    const std::type_info& typeId = registerValueTypeInfo<QVideoSurfaceFormat>("QVideoSurfaceFormat", "io/qt/multimedia/QVideoSurfaceFormat");
    Q_UNUSED(typeId)
// BEGIN: function table
    registerConstructorInfos(typeId, &__qt_destruct_QVideoSurfaceFormat, {
        ConstructorInfo(&__qt_construct_QVideoSurfaceFormat_0, nullptr)
       ,ConstructorInfo(&__qt_construct_QVideoSurfaceFormat_1, "Lio/qt/core/QSize;Lio/qt/multimedia/QVideoFrame$PixelFormat;")
       ,ConstructorInfo(&__qt_construct_QVideoSurfaceFormat_2, "Lio/qt/core/QSize;Lio/qt/multimedia/QVideoFrame$PixelFormat;Lio/qt/multimedia/QAbstractVideoBuffer$HandleType;")
       ,ConstructorInfo(&__qt_construct_QVideoSurfaceFormat_3, "Lio/qt/multimedia/QVideoSurfaceFormat;")
    });
// END: function table

// BEGIN: type registration
    registerDeleter(typeId, &deleter_QVideoSurfaceFormat);
    registerMetaType<QVideoSurfaceFormat>("QVideoSurfaceFormat");
// END: type registration

// BEGIN: polymorphic ids
// END: polymorphic ids


// BEGIN: enums and flags
    registerEnumTypeInfo<QVideoSurfaceFormat::Direction>("QVideoSurfaceFormat::Direction", "io/qt/multimedia/QVideoSurfaceFormat$Direction");
    registerEnumTypeInfo<QVideoSurfaceFormat::YCbCrColorSpace>("QVideoSurfaceFormat::YCbCrColorSpace", "io/qt/multimedia/QVideoSurfaceFormat$YCbCrColorSpace");
// END: enums and flags
}
