#ifndef QRADIOTUNERCONTROL_SHELL_H
#define QRADIOTUNERCONTROL_SHELL_H

#include <QtCore/QtGlobal>
#include <QtCore/qcompilerdetection.h>

QT_WARNING_DISABLE_DEPRECATED
QT_WARNING_DISABLE_GCC("-Wdeprecated-declarations")

#include <QtMultimedia/qradiotunercontrol.h>
#include <QtJambi/QtJambiAPI>
#include <QtCore/QList>
#include <QtCore/QVariant>
#include <QtCore/qbytearray.h>
#include <QtCore/qcoreevent.h>
#include <QtCore/qmetaobject.h>
#include <QtCore/qnamespace.h>
#include <QtCore/qobject.h>
#include <QtCore/qpair.h>
#include <QtCore/qregexp.h>
#include <qtcore-config.h>
#if QT_CONFIG(regularexpression)
#include <QtCore/qregularexpression.h>
#endif //QT_CONFIG(regularexpression)
#include <QtCore/qthread.h>
#include <QtCore/qtimer.h>
#include <QtMultimedia/qradiotuner.h>
#include <QtJambi/RegistryAPI>


class QRadioTunerControl_shell : public QRadioTunerControl, public QtJambiShellInterface
{
public:
    QRadioTunerControl_shell(QObject* parent0 = nullptr);
    ~QRadioTunerControl_shell() override;

    QRadioTuner::Band band() const override;
    void cancelSearch() override;
    void childEvent(QChildEvent* event0) override;
    void connectNotify(const QMetaMethod& signal0) override;
    void customEvent(QEvent* event0) override;
    void disconnectNotify(const QMetaMethod& signal0) override;
    QRadioTuner::Error error() const override;
    QString errorString() const override;
    bool event(QEvent* event0) override;
    bool eventFilter(QObject* watched0, QEvent* event1) override;
    int frequency() const override;
    QPair<int, int> frequencyRange(QRadioTuner::Band b0) const override;
    int frequencyStep(QRadioTuner::Band b0) const override;
    bool isAntennaConnected() const override;
    bool isBandSupported(QRadioTuner::Band b0) const override;
    bool isMuted() const override;
    bool isSearching() const override;
    bool isStereo() const override;
    void searchAllStations(QRadioTuner::SearchMode searchMode0) override;
    void searchBackward() override;
    void searchForward() override;
    void setBand(QRadioTuner::Band b0) override;
    void setFrequency(int frequency0) override;
    void setMuted(bool muted0) override;
    void setStereoMode(QRadioTuner::StereoMode mode0) override;
    void setVolume(int volume0) override;
    int signalStrength() const override;
    void start() override;
    QRadioTuner::State state() const override;
    QRadioTuner::StereoMode stereoMode() const override;
    void stop() override;
    void timerEvent(QTimerEvent* event0) override;
    int volume() const override;
    static void operator delete(void * ptr) noexcept;
    const QMetaObject *metaObject() const override final;
    void *qt_metacast(const char *) override final;
    int qt_metacall(QMetaObject::Call, int, void **) override final;
private:
    QtJambiShell* __shell() const override final;
    jmethodID __shell_javaMethod(int pos) const;
};

struct QRadioTunerControl_access : public QRadioTunerControl
{
    jint __qt_band(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId) const;
    void __qt_cancelSearch(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId);
    jint __qt_error(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId) const;
    jstring __qt_errorString(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId) const;
    jint __qt_frequency(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId) const;
    jobject __qt_frequencyRange_QRadioTuner_Band_constfct(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId, jint b0) const;
    jint __qt_frequencyStep_QRadioTuner_Band_constfct(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId, jint b0) const;
    jboolean __qt_isAntennaConnected(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId) const;
    jboolean __qt_isBandSupported_QRadioTuner_Band_constfct(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId, jint b0) const;
    jboolean __qt_isMuted(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId) const;
    jboolean __qt_isSearching(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId) const;
    jboolean __qt_isStereo(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId) const;
    void __qt_searchAllStations_QRadioTuner_SearchMode(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId, jint searchMode0);
    void __qt_searchBackward(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId);
    void __qt_searchForward(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId);
    void __qt_setBand_QRadioTuner_Band(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId, jint b0);
    void __qt_setFrequency_int(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId, jint frequency0);
    void __qt_setMuted_bool(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId, jboolean muted0);
    void __qt_setStereoMode_QRadioTuner_StereoMode(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId, jint mode0);
    void __qt_setVolume_int(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId, jint volume0);
    jint __qt_signalStrength(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId) const;
    void __qt_start(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId);
    jint __qt_state(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId) const;
    jint __qt_stereoMode(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId) const;
    void __qt_stop(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId);
    jint __qt_volume(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId) const;
};

#endif // QRADIOTUNERCONTROL_SHELL_H
