#include <QtCore/QtGlobal>
#include <QtMultimedia/qaudioformat.h>
#include <QtCore/QVariant>

#include <QtJambi/QtJambiAPI>
#include <QtJambiMultimedia/hashes.h>

#include <QtJambi/RegistryAPI>
#include <QtJambi/Cast>

void deleter_QAudioFormat(void *ptr, bool isShell)
{
    QTJAMBI_NATIVE_METHOD_CALL("qtjambi_deleter for QAudioFormat")
    QAudioFormat *_ptr = reinterpret_cast<QAudioFormat *>(ptr);
    if(!isShell){
        QtJambiAPI::registerNonShellDeletion(ptr);
    }
    delete _ptr;
}

// emitting (writeConstructors)
// new QAudioFormat()
void __qt_construct_QAudioFormat_0(void* __qtjambi_ptr, JNIEnv* __jni_env, jobject __jni_object, jvalue* __java_arguments)
{
    QTJAMBI_NATIVE_METHOD_CALL("construct QAudioFormat()")
    Q_UNUSED(__java_arguments)
    QAudioFormat *__qt_this = new(__qtjambi_ptr) QAudioFormat();
    Q_UNUSED(__jni_object)
    Q_UNUSED(__jni_env)
    Q_UNUSED(__qt_this)
}

// new QAudioFormat(QAudioFormat)
void __qt_construct_QAudioFormat_1(void* __qtjambi_ptr, JNIEnv* __jni_env, jobject __jni_object, jvalue* __java_arguments)
{
    QTJAMBI_NATIVE_METHOD_CALL("construct QAudioFormat(QAudioFormat)")
    jobject other0 = __java_arguments[0].l;
    const QAudioFormat& __qt_other0 = qtjambi_cast<const QAudioFormat& >(__jni_env, other0);
    QAudioFormat *__qt_this = new(__qtjambi_ptr) QAudioFormat(__qt_other0);
    Q_UNUSED(__jni_object)
    Q_UNUSED(__qt_this)
}

// destruct QAudioFormat
void __qt_destruct_QAudioFormat(void* ptr)
{
    QTJAMBI_NATIVE_METHOD_CALL("destruct QAudioFormat")
    reinterpret_cast<QAudioFormat*>(ptr)->~QAudioFormat();
}

// emitting  (functionsInTargetLang writeFinalFunction)
// QAudioFormat::QAudioFormat()
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_multimedia_QAudioFormat_initialize_1native__Lio_qt_multimedia_QAudioFormat_2)
(JNIEnv *__jni_env,
 jclass __jni_class,
 jobject __jni_object)
{
    QTJAMBI_NATIVE_METHOD_CALL("QAudioFormat::QAudioFormat()")
    QTJAMBI_TRY {
        QtJambiShell::initialize(__jni_env, __jni_class, __jni_object, &__qt_construct_QAudioFormat_0, sizeof(QAudioFormat), typeid(QAudioFormat), false, &deleter_QAudioFormat, nullptr);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QAudioFormat::QAudioFormat(QAudioFormat)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_multimedia_QAudioFormat_initialize_1native__Lio_qt_multimedia_QAudioFormat_2Lio_qt_multimedia_QAudioFormat_2)
(JNIEnv *__jni_env,
 jclass __jni_class,
 jobject __jni_object,
 jobject other0)
{
    QTJAMBI_NATIVE_METHOD_CALL("QAudioFormat::QAudioFormat(QAudioFormat)")
    QTJAMBI_TRY {
        jvalue arguments;
        arguments.l = other0;
        QtJambiShell::initialize(__jni_env, __jni_class, __jni_object, &__qt_construct_QAudioFormat_1, sizeof(QAudioFormat), typeid(QAudioFormat), false, &deleter_QAudioFormat, &arguments);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QAudioFormat::byteOrder()const
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_multimedia_QAudioFormat_byteOrder_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jint __java_return_value{0};
    QTJAMBI_TRY {
        const QAudioFormat *__qt_this = QtJambiAPI::objectFromNativeId<QAudioFormat>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QAudioFormat::byteOrder()const", __qt_this)
        QAudioFormat::Endian __qt_return_value = __qt_this->byteOrder();
        __java_return_value = __qt_return_value;
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QAudioFormat::bytesForDuration(qint64)const
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_multimedia_QAudioFormat_bytesForDuration_1native_1qint64_1constfct__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jlong duration0)
{
    Q_UNUSED(__this)
    jint __java_return_value{0};
    QTJAMBI_TRY {
        const QAudioFormat *__qt_this = QtJambiAPI::objectFromNativeId<QAudioFormat>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QAudioFormat::bytesForDuration(qint64)const", __qt_this)
        qint32 __qt_return_value = __qt_this->bytesForDuration(static_cast<qint64>(duration0));
        __java_return_value = jint(__qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QAudioFormat::bytesForFrames(qint32)const
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_multimedia_QAudioFormat_bytesForFrames_1native_1qint32_1constfct__JI)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint frameCount0)
{
    Q_UNUSED(__this)
    jint __java_return_value{0};
    QTJAMBI_TRY {
        const QAudioFormat *__qt_this = QtJambiAPI::objectFromNativeId<QAudioFormat>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QAudioFormat::bytesForFrames(qint32)const", __qt_this)
        qint32 __qt_return_value = __qt_this->bytesForFrames(static_cast<qint32>(frameCount0));
        __java_return_value = jint(__qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QAudioFormat::bytesPerFrame()const
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_multimedia_QAudioFormat_bytesPerFrame_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jint __java_return_value{0};
    QTJAMBI_TRY {
        const QAudioFormat *__qt_this = QtJambiAPI::objectFromNativeId<QAudioFormat>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QAudioFormat::bytesPerFrame()const", __qt_this)
        __java_return_value = __qt_this->bytesPerFrame();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QAudioFormat::channelCount()const
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_multimedia_QAudioFormat_channelCount_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jint __java_return_value{0};
    QTJAMBI_TRY {
        const QAudioFormat *__qt_this = QtJambiAPI::objectFromNativeId<QAudioFormat>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QAudioFormat::channelCount()const", __qt_this)
        __java_return_value = __qt_this->channelCount();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QAudioFormat::codec()const
extern "C" Q_DECL_EXPORT jstring JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_multimedia_QAudioFormat_codec_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jstring __java_return_value{0};
    QTJAMBI_TRY {
        const QAudioFormat *__qt_this = QtJambiAPI::objectFromNativeId<QAudioFormat>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QAudioFormat::codec()const", __qt_this)
        QString __qt_return_value = __qt_this->codec();
        __java_return_value = qtjambi_cast<jstring>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QAudioFormat::durationForBytes(qint32)const
extern "C" Q_DECL_EXPORT jlong JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_multimedia_QAudioFormat_durationForBytes_1native_1qint32_1constfct__JI)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint byteCount0)
{
    Q_UNUSED(__this)
    jlong __java_return_value{0};
    QTJAMBI_TRY {
        const QAudioFormat *__qt_this = QtJambiAPI::objectFromNativeId<QAudioFormat>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QAudioFormat::durationForBytes(qint32)const", __qt_this)
        qint64 __qt_return_value = __qt_this->durationForBytes(static_cast<qint32>(byteCount0));
        __java_return_value = jlong(__qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QAudioFormat::durationForFrames(qint32)const
extern "C" Q_DECL_EXPORT jlong JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_multimedia_QAudioFormat_durationForFrames_1native_1qint32_1constfct__JI)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint frameCount0)
{
    Q_UNUSED(__this)
    jlong __java_return_value{0};
    QTJAMBI_TRY {
        const QAudioFormat *__qt_this = QtJambiAPI::objectFromNativeId<QAudioFormat>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QAudioFormat::durationForFrames(qint32)const", __qt_this)
        qint64 __qt_return_value = __qt_this->durationForFrames(static_cast<qint32>(frameCount0));
        __java_return_value = jlong(__qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QAudioFormat::framesForBytes(qint32)const
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_multimedia_QAudioFormat_framesForBytes_1native_1qint32_1constfct__JI)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint byteCount0)
{
    Q_UNUSED(__this)
    jint __java_return_value{0};
    QTJAMBI_TRY {
        const QAudioFormat *__qt_this = QtJambiAPI::objectFromNativeId<QAudioFormat>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QAudioFormat::framesForBytes(qint32)const", __qt_this)
        qint32 __qt_return_value = __qt_this->framesForBytes(static_cast<qint32>(byteCount0));
        __java_return_value = jint(__qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QAudioFormat::framesForDuration(qint64)const
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_multimedia_QAudioFormat_framesForDuration_1native_1qint64_1constfct__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jlong duration0)
{
    Q_UNUSED(__this)
    jint __java_return_value{0};
    QTJAMBI_TRY {
        const QAudioFormat *__qt_this = QtJambiAPI::objectFromNativeId<QAudioFormat>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QAudioFormat::framesForDuration(qint64)const", __qt_this)
        qint32 __qt_return_value = __qt_this->framesForDuration(static_cast<qint64>(duration0));
        __java_return_value = jint(__qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QAudioFormat::isValid()const
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_multimedia_QAudioFormat_isValid_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        const QAudioFormat *__qt_this = QtJambiAPI::objectFromNativeId<QAudioFormat>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QAudioFormat::isValid()const", __qt_this)
        __java_return_value = __qt_this->isValid();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QAudioFormat::operator=(QAudioFormat)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_multimedia_QAudioFormat_assign_1native_1cref_1QAudioFormat__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID other0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QAudioFormat *__qt_this = QtJambiAPI::objectFromNativeId<QAudioFormat>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QAudioFormat::operator=(QAudioFormat)", __qt_this)
        const QAudioFormat& __qt_other0 = QtJambiAPI::valueReferenceFromNativeId<QAudioFormat>(other0);
        (*__qt_this) = __qt_other0;
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QAudioFormat::operator==(QAudioFormat)const
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_multimedia_QAudioFormat_equals_1native_1cref_1QAudioFormat_1constfct__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID other0)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        const QAudioFormat *__qt_this = QtJambiAPI::objectFromNativeId<QAudioFormat>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QAudioFormat::operator==(QAudioFormat)const", __qt_this)
        const QAudioFormat& __qt_other0 = QtJambiAPI::valueReferenceFromNativeId<QAudioFormat>(other0);
        __java_return_value = (*__qt_this) == __qt_other0;
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QAudioFormat::sampleRate()const
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_multimedia_QAudioFormat_sampleRate_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jint __java_return_value{0};
    QTJAMBI_TRY {
        const QAudioFormat *__qt_this = QtJambiAPI::objectFromNativeId<QAudioFormat>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QAudioFormat::sampleRate()const", __qt_this)
        __java_return_value = __qt_this->sampleRate();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QAudioFormat::sampleSize()const
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_multimedia_QAudioFormat_sampleSize_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jint __java_return_value{0};
    QTJAMBI_TRY {
        const QAudioFormat *__qt_this = QtJambiAPI::objectFromNativeId<QAudioFormat>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QAudioFormat::sampleSize()const", __qt_this)
        __java_return_value = __qt_this->sampleSize();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QAudioFormat::sampleType()const
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_multimedia_QAudioFormat_sampleType_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jint __java_return_value{0};
    QTJAMBI_TRY {
        const QAudioFormat *__qt_this = QtJambiAPI::objectFromNativeId<QAudioFormat>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QAudioFormat::sampleType()const", __qt_this)
        QAudioFormat::SampleType __qt_return_value = __qt_this->sampleType();
        __java_return_value = __qt_return_value;
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QAudioFormat::setByteOrder(QAudioFormat::Endian)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_multimedia_QAudioFormat_setByteOrder_1native_1QAudioFormat_1Endian__JI)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint byteOrder0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QAudioFormat *__qt_this = QtJambiAPI::objectFromNativeId<QAudioFormat>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QAudioFormat::setByteOrder(QAudioFormat::Endian)", __qt_this)
        QAudioFormat::Endian __qt_byteOrder0 = qtjambi_cast<QAudioFormat::Endian>(__jni_env, byteOrder0);
        __qt_this->setByteOrder(QAudioFormat::Endian(__qt_byteOrder0));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QAudioFormat::setChannelCount(int)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_multimedia_QAudioFormat_setChannelCount_1native_1int__JI)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint channelCount0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QAudioFormat *__qt_this = QtJambiAPI::objectFromNativeId<QAudioFormat>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QAudioFormat::setChannelCount(int)", __qt_this)
        __qt_this->setChannelCount(static_cast<int>(channelCount0));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QAudioFormat::setCodec(QString)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_multimedia_QAudioFormat_setCodec_1native_1cref_1QString__JLjava_lang_String_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jstring codec0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QAudioFormat *__qt_this = QtJambiAPI::objectFromNativeId<QAudioFormat>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QAudioFormat::setCodec(QString)", __qt_this)
        QString  __qt_codec0 = qtjambi_cast<QString>(__jni_env, codec0);
        __qt_this->setCodec(__qt_codec0);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QAudioFormat::setSampleRate(int)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_multimedia_QAudioFormat_setSampleRate_1native_1int__JI)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint sampleRate0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QAudioFormat *__qt_this = QtJambiAPI::objectFromNativeId<QAudioFormat>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QAudioFormat::setSampleRate(int)", __qt_this)
        __qt_this->setSampleRate(static_cast<int>(sampleRate0));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QAudioFormat::setSampleSize(int)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_multimedia_QAudioFormat_setSampleSize_1native_1int__JI)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint sampleSize0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QAudioFormat *__qt_this = QtJambiAPI::objectFromNativeId<QAudioFormat>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QAudioFormat::setSampleSize(int)", __qt_this)
        __qt_this->setSampleSize(static_cast<int>(sampleSize0));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QAudioFormat::setSampleType(QAudioFormat::SampleType)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_multimedia_QAudioFormat_setSampleType_1native_1QAudioFormat_1SampleType__JI)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint sampleType0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QAudioFormat *__qt_this = QtJambiAPI::objectFromNativeId<QAudioFormat>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QAudioFormat::setSampleType(QAudioFormat::SampleType)", __qt_this)
        QAudioFormat::SampleType __qt_sampleType0 = qtjambi_cast<QAudioFormat::SampleType>(__jni_env, sampleType0);
        __qt_this->setSampleType(QAudioFormat::SampleType(__qt_sampleType0));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// emitting (writeJavaLangObjectOverrideFunctions)

extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_multimedia_QAudioFormat_hashCode_1native)
(JNIEnv * __jni_env, jclass, QtJambiNativeID __this_nativeId)
{
    jint __java_return_value = 0;
    QTJAMBI_TRY {
        QAudioFormat *__qt_this = QtJambiAPI::objectFromNativeId<QAudioFormat>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        hash_type hashValue = qHash(*__qt_this);
        __java_return_value = jint(hashValue);
    } QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    } QTJAMBI_TRY_END
    return __java_return_value;
}

#include <QtCore/QDebug>
extern "C" Q_DECL_EXPORT jstring JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_multimedia_QAudioFormat_toString_1native)(JNIEnv *__jni_env, jobject, QtJambiNativeID __this_nativeId)
{
    jstring __java_return_value = nullptr;
    QTJAMBI_TRY {
        QAudioFormat *__qt_this = QtJambiAPI::objectFromNativeId<QAudioFormat>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QString res;
        QDebug(&res).noquote() << *__qt_this;
        if(!res.isEmpty() && res.back().isSpace())
            res = res.trimmed();
        __java_return_value = qtjambi_cast<jstring>(__jni_env, res);
    } QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    } QTJAMBI_TRY_END
    return __java_return_value;
}

// emitting (writeCloneFunction)

extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_multimedia_QAudioFormat_clone_1native)
(JNIEnv *__jni_env, jobject, QtJambiNativeID __this_nativeId)
{
    jobject __java_return_value = nullptr;
    QTJAMBI_TRY {
        const QAudioFormat *__qt_this = QtJambiAPI::objectFromNativeId<QAudioFormat>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        __java_return_value = qtjambi_cast<jobject>(__jni_env, *__qt_this);
    } QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    } QTJAMBI_TRY_END
    return __java_return_value;
}


void initialize_meta_info_QAudioFormat(){
    using namespace RegistryAPI;
    const std::type_info& typeId = registerValueTypeInfo<QAudioFormat>("QAudioFormat", "io/qt/multimedia/QAudioFormat");
    Q_UNUSED(typeId)
// BEGIN: function table
    registerConstructorInfos(typeId, &__qt_destruct_QAudioFormat, {
        ConstructorInfo(&__qt_construct_QAudioFormat_0, nullptr)
       ,ConstructorInfo(&__qt_construct_QAudioFormat_1, "Lio/qt/multimedia/QAudioFormat;")
    });
// END: function table

// BEGIN: type registration
    registerDeleter(typeId, &deleter_QAudioFormat);
    registerMetaType<QAudioFormat>("QAudioFormat");
// END: type registration

// BEGIN: polymorphic ids
// END: polymorphic ids


// BEGIN: enums and flags
    registerEnumTypeInfo<QAudioFormat::Endian>("QAudioFormat::Endian", "io/qt/multimedia/QAudioFormat$Endian");
    registerEnumTypeInfo<QAudioFormat::SampleType>("QAudioFormat::SampleType", "io/qt/multimedia/QAudioFormat$SampleType");
// END: enums and flags
}
