#include <QtCore/QtGlobal>
#include <QtMultimedia/qaudiobuffer.h>
#include <QtCore/QVariant>
#include <QtCore/qbytearray.h>
#include <QtMultimedia/qaudioformat.h>
#include "utils_p.h"

#include <QtJambi/QtJambiAPI>
#include <QtJambi/RegistryAPI>
#include <QtJambi/Cast>

void deleter_QAudioBuffer(void *ptr, bool isShell)
{
    QTJAMBI_NATIVE_METHOD_CALL("qtjambi_deleter for QAudioBuffer")
    QAudioBuffer *_ptr = reinterpret_cast<QAudioBuffer *>(ptr);
    if(!isShell){
        QtJambiAPI::registerNonShellDeletion(ptr);
    }
    delete _ptr;
}

// emitting (writeConstructors)
// new QAudioBuffer()
void __qt_construct_QAudioBuffer_0(void* __qtjambi_ptr, JNIEnv* __jni_env, jobject __jni_object, jvalue* __java_arguments)
{
    QTJAMBI_NATIVE_METHOD_CALL("construct QAudioBuffer()")
    Q_UNUSED(__java_arguments)
    QAudioBuffer *__qt_this = new(__qtjambi_ptr) QAudioBuffer();
    Q_UNUSED(__jni_object)
    Q_UNUSED(__jni_env)
    Q_UNUSED(__qt_this)
}

// new QAudioBuffer(QAudioBuffer)
void __qt_construct_QAudioBuffer_1(void* __qtjambi_ptr, JNIEnv* __jni_env, jobject __jni_object, jvalue* __java_arguments)
{
    QTJAMBI_NATIVE_METHOD_CALL("construct QAudioBuffer(QAudioBuffer)")
    jobject other0 = __java_arguments[0].l;
    const QAudioBuffer& __qt_other0 = qtjambi_cast<const QAudioBuffer& >(__jni_env, other0);
    QAudioBuffer *__qt_this = new(__qtjambi_ptr) QAudioBuffer(__qt_other0);
    Q_UNUSED(__jni_object)
    Q_UNUSED(__qt_this)
}

// new QAudioBuffer(QByteArray,QAudioFormat,qint64)
void __qt_construct_QAudioBuffer_2(void* __qtjambi_ptr, JNIEnv* __jni_env, jobject __jni_object, jvalue* __java_arguments)
{
    QTJAMBI_NATIVE_METHOD_CALL("construct QAudioBuffer(QByteArray,QAudioFormat,qint64)")
    jobject data0 = __java_arguments[0].l;
    const QByteArray& __qt_data0 = qtjambi_cast<const QByteArray& >(__jni_env, data0);
    jobject format1 = __java_arguments[1].l;
    const QAudioFormat& __qt_format1 = qtjambi_cast<const QAudioFormat& >(__jni_env, format1);
    QAudioBuffer *__qt_this = new(__qtjambi_ptr) QAudioBuffer(__qt_data0, __qt_format1);
    Q_UNUSED(__jni_object)
    Q_UNUSED(__qt_this)
}

// new QAudioBuffer(QByteArray,QAudioFormat,qint64)
void __qt_construct_QAudioBuffer_3(void* __qtjambi_ptr, JNIEnv* __jni_env, jobject __jni_object, jvalue* __java_arguments)
{
    QTJAMBI_NATIVE_METHOD_CALL("construct QAudioBuffer(QByteArray,QAudioFormat,qint64)")
    jobject data0 = __java_arguments[0].l;
    const QByteArray& __qt_data0 = qtjambi_cast<const QByteArray& >(__jni_env, data0);
    jobject format1 = __java_arguments[1].l;
    const QAudioFormat& __qt_format1 = qtjambi_cast<const QAudioFormat& >(__jni_env, format1);
    jlong startTime2 = __java_arguments[2].j;
    Q_UNUSED(startTime2)
    QAudioBuffer *__qt_this = new(__qtjambi_ptr) QAudioBuffer(__qt_data0, __qt_format1, static_cast<qint64>(startTime2));
    Q_UNUSED(__jni_object)
    Q_UNUSED(__qt_this)
}

// new QAudioBuffer(int,QAudioFormat,qint64)
void __qt_construct_QAudioBuffer_4(void* __qtjambi_ptr, JNIEnv* __jni_env, jobject __jni_object, jvalue* __java_arguments)
{
    QTJAMBI_NATIVE_METHOD_CALL("construct QAudioBuffer(int,QAudioFormat,qint64)")
    jint numFrames0 = __java_arguments[0].i;
    Q_UNUSED(numFrames0)
    jobject format1 = __java_arguments[1].l;
    const QAudioFormat& __qt_format1 = qtjambi_cast<const QAudioFormat& >(__jni_env, format1);
    QAudioBuffer *__qt_this = new(__qtjambi_ptr) QAudioBuffer(static_cast<int>(numFrames0), __qt_format1);
    Q_UNUSED(__jni_object)
    Q_UNUSED(__qt_this)
}

// new QAudioBuffer(int,QAudioFormat,qint64)
void __qt_construct_QAudioBuffer_5(void* __qtjambi_ptr, JNIEnv* __jni_env, jobject __jni_object, jvalue* __java_arguments)
{
    QTJAMBI_NATIVE_METHOD_CALL("construct QAudioBuffer(int,QAudioFormat,qint64)")
    jint numFrames0 = __java_arguments[0].i;
    Q_UNUSED(numFrames0)
    jobject format1 = __java_arguments[1].l;
    const QAudioFormat& __qt_format1 = qtjambi_cast<const QAudioFormat& >(__jni_env, format1);
    jlong startTime2 = __java_arguments[2].j;
    Q_UNUSED(startTime2)
    QAudioBuffer *__qt_this = new(__qtjambi_ptr) QAudioBuffer(static_cast<int>(numFrames0), __qt_format1, static_cast<qint64>(startTime2));
    Q_UNUSED(__jni_object)
    Q_UNUSED(__qt_this)
}

// destruct QAudioBuffer
void __qt_destruct_QAudioBuffer(void* ptr)
{
    QTJAMBI_NATIVE_METHOD_CALL("destruct QAudioBuffer")
    reinterpret_cast<QAudioBuffer*>(ptr)->~QAudioBuffer();
}

// emitting  (functionsInTargetLang writeFinalFunction)
// QAudioBuffer::QAudioBuffer()
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_multimedia_QAudioBuffer_initialize_1native__Lio_qt_multimedia_QAudioBuffer_2)
(JNIEnv *__jni_env,
 jclass __jni_class,
 jobject __jni_object)
{
    QTJAMBI_NATIVE_METHOD_CALL("QAudioBuffer::QAudioBuffer()")
    QTJAMBI_TRY {
        QtJambiShell::initialize(__jni_env, __jni_class, __jni_object, &__qt_construct_QAudioBuffer_0, sizeof(QAudioBuffer), typeid(QAudioBuffer), false, &deleter_QAudioBuffer, nullptr);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QAudioBuffer::QAudioBuffer(QAudioBuffer)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_multimedia_QAudioBuffer_initialize_1native__Lio_qt_multimedia_QAudioBuffer_2Lio_qt_multimedia_QAudioBuffer_2)
(JNIEnv *__jni_env,
 jclass __jni_class,
 jobject __jni_object,
 jobject other0)
{
    QTJAMBI_NATIVE_METHOD_CALL("QAudioBuffer::QAudioBuffer(QAudioBuffer)")
    QTJAMBI_TRY {
        jvalue arguments;
        arguments.l = other0;
        QtJambiShell::initialize(__jni_env, __jni_class, __jni_object, &__qt_construct_QAudioBuffer_1, sizeof(QAudioBuffer), typeid(QAudioBuffer), false, &deleter_QAudioBuffer, &arguments);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QAudioBuffer::QAudioBuffer(QByteArray,QAudioFormat,qint64)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_multimedia_QAudioBuffer_initialize_1native__Lio_qt_multimedia_QAudioBuffer_2Lio_qt_core_QByteArray_2Lio_qt_multimedia_QAudioFormat_2J)
(JNIEnv *__jni_env,
 jclass __jni_class,
 jobject __jni_object,
 jobject data0,
 jobject format1,
 jlong startTime2)
{
    QTJAMBI_NATIVE_METHOD_CALL("QAudioBuffer::QAudioBuffer(QByteArray,QAudioFormat,qint64)")
    QTJAMBI_TRY {
        jvalue arguments[3];
        arguments[0].l = data0;
        arguments[1].l = format1;
        arguments[2].j = startTime2;
        QtJambiShell::initialize(__jni_env, __jni_class, __jni_object, &__qt_construct_QAudioBuffer_3, sizeof(QAudioBuffer), typeid(QAudioBuffer), false, &deleter_QAudioBuffer, arguments);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QAudioBuffer::QAudioBuffer(int,QAudioFormat,qint64)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_multimedia_QAudioBuffer_initialize_1native__Lio_qt_multimedia_QAudioBuffer_2ILio_qt_multimedia_QAudioFormat_2J)
(JNIEnv *__jni_env,
 jclass __jni_class,
 jobject __jni_object,
 jint numFrames0,
 jobject format1,
 jlong startTime2)
{
    QTJAMBI_NATIVE_METHOD_CALL("QAudioBuffer::QAudioBuffer(int,QAudioFormat,qint64)")
    QTJAMBI_TRY {
        jvalue arguments[3];
        arguments[0].i = numFrames0;
        arguments[1].l = format1;
        arguments[2].j = startTime2;
        QtJambiShell::initialize(__jni_env, __jni_class, __jni_object, &__qt_construct_QAudioBuffer_5, sizeof(QAudioBuffer), typeid(QAudioBuffer), false, &deleter_QAudioBuffer, arguments);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QAudioBuffer::byteCount()const
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_multimedia_QAudioBuffer_byteCount_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jint __java_return_value{0};
    QTJAMBI_TRY {
        const QAudioBuffer *__qt_this = QtJambiAPI::objectFromNativeId<QAudioBuffer>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QAudioBuffer::byteCount()const", __qt_this)
        __java_return_value = __qt_this->byteCount();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QAudioBuffer::duration()const
extern "C" Q_DECL_EXPORT jlong JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_multimedia_QAudioBuffer_duration_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jlong __java_return_value{0};
    QTJAMBI_TRY {
        const QAudioBuffer *__qt_this = QtJambiAPI::objectFromNativeId<QAudioBuffer>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QAudioBuffer::duration()const", __qt_this)
        qint64 __qt_return_value = __qt_this->duration();
        __java_return_value = jlong(__qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QAudioBuffer::format()const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_multimedia_QAudioBuffer_format_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QAudioBuffer *__qt_this = QtJambiAPI::objectFromNativeId<QAudioBuffer>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QAudioBuffer::format()const", __qt_this)
        QAudioFormat __qt_return_value = __qt_this->format();
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QAudioBuffer::frameCount()const
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_multimedia_QAudioBuffer_frameCount_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jint __java_return_value{0};
    QTJAMBI_TRY {
        const QAudioBuffer *__qt_this = QtJambiAPI::objectFromNativeId<QAudioBuffer>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QAudioBuffer::frameCount()const", __qt_this)
        __java_return_value = __qt_this->frameCount();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QAudioBuffer::isValid()const
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_multimedia_QAudioBuffer_isValid_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        const QAudioBuffer *__qt_this = QtJambiAPI::objectFromNativeId<QAudioBuffer>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QAudioBuffer::isValid()const", __qt_this)
        __java_return_value = __qt_this->isValid();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QAudioBuffer::operator=(QAudioBuffer)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_multimedia_QAudioBuffer_assign_1native_1cref_1QAudioBuffer__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID other0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QAudioBuffer *__qt_this = QtJambiAPI::objectFromNativeId<QAudioBuffer>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QAudioBuffer::operator=(QAudioBuffer)", __qt_this)
        const QAudioBuffer& __qt_other0 = QtJambiAPI::valueReferenceFromNativeId<QAudioBuffer>(other0);
        (*__qt_this) = __qt_other0;
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QAudioBuffer::sampleCount()const
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_multimedia_QAudioBuffer_sampleCount_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jint __java_return_value{0};
    QTJAMBI_TRY {
        const QAudioBuffer *__qt_this = QtJambiAPI::objectFromNativeId<QAudioBuffer>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QAudioBuffer::sampleCount()const", __qt_this)
        __java_return_value = __qt_this->sampleCount();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QAudioBuffer::startTime()const
extern "C" Q_DECL_EXPORT jlong JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_multimedia_QAudioBuffer_startTime_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jlong __java_return_value{0};
    QTJAMBI_TRY {
        const QAudioBuffer *__qt_this = QtJambiAPI::objectFromNativeId<QAudioBuffer>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QAudioBuffer::startTime()const", __qt_this)
        qint64 __qt_return_value = __qt_this->startTime();
        __java_return_value = jlong(__qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// emitting (writeJavaLangObjectOverrideFunctions)
// emitting (writeCloneFunction)

extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_multimedia_QAudioBuffer_clone_1native)
(JNIEnv *__jni_env, jobject, QtJambiNativeID __this_nativeId)
{
    jobject __java_return_value = nullptr;
    QTJAMBI_TRY {
        const QAudioBuffer *__qt_this = QtJambiAPI::objectFromNativeId<QAudioBuffer>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        __java_return_value = qtjambi_cast<jobject>(__jni_env, *__qt_this);
    } QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    } QTJAMBI_TRY_END
    return __java_return_value;
}


void initialize_meta_info_QAudioBuffer(){
    using namespace RegistryAPI;
    const std::type_info& typeId = registerValueTypeInfo<QAudioBuffer>("QAudioBuffer", "io/qt/multimedia/QAudioBuffer");
    Q_UNUSED(typeId)
// BEGIN: function table
    registerConstructorInfos(typeId, &__qt_destruct_QAudioBuffer, {
        ConstructorInfo(&__qt_construct_QAudioBuffer_0, nullptr)
       ,ConstructorInfo(&__qt_construct_QAudioBuffer_1, "Lio/qt/multimedia/QAudioBuffer;")
       ,ConstructorInfo(&__qt_construct_QAudioBuffer_2, "Lio/qt/core/QByteArray;Lio/qt/multimedia/QAudioFormat;")
       ,ConstructorInfo(&__qt_construct_QAudioBuffer_3, "Lio/qt/core/QByteArray;Lio/qt/multimedia/QAudioFormat;J")
       ,ConstructorInfo(&__qt_construct_QAudioBuffer_4, "ILio/qt/multimedia/QAudioFormat;")
       ,ConstructorInfo(&__qt_construct_QAudioBuffer_5, "ILio/qt/multimedia/QAudioFormat;J")
    });
// END: function table

// BEGIN: type registration
    registerDeleter(typeId, &deleter_QAudioBuffer);
    registerMetaType<QAudioBuffer>("QAudioBuffer");
// END: type registration

// BEGIN: polymorphic ids
// END: polymorphic ids


// BEGIN: enums and flags
// END: enums and flags
}
