package io.qt.macextras;


/**
 * <p>Converts between a MIME type and a Uniform Type Identifier (UTI) format</p>
 * <p>Java wrapper for Qt class <a href="http://doc.qt.io/qt-5/qmacpasteboardmime.html">QMacPasteboardMime</a></p>
 */
public abstract class QMacPasteboardMime extends io.qt.QtObject
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    @io.qt.NativeAccess
    private static final class ConcreteWrapper extends QMacPasteboardMime {
        
        @io.qt.NativeAccess
        private ConcreteWrapper(QPrivateConstructor p) { super(p); }
        
        @Override
        @io.qt.QtUninvokable
        public boolean canConvert(java.lang.String mime, java.lang.String flav){
            return canConvert_native_cref_QString_QString(QtJambi_LibraryUtilities.internal.nativeId(this), mime, flav);
        }
        @io.qt.QtUninvokable
        private native boolean canConvert_native_cref_QString_QString(long __this__nativeId, java.lang.String mime, java.lang.String flav);
        
        
        @Override
        @io.qt.QtUninvokable
        public java.util.List<io.qt.core.QByteArray> convertFromMime(java.lang.String mime, java.lang.Object data, java.lang.String flav){
            return convertFromMime_native_cref_QString_QVariant_QString(QtJambi_LibraryUtilities.internal.nativeId(this), mime, data, flav);
        }
        @io.qt.QtUninvokable
        private native java.util.List<io.qt.core.QByteArray> convertFromMime_native_cref_QString_QVariant_QString(long __this__nativeId, java.lang.String mime, java.lang.Object data, java.lang.String flav);
        
        
        @Override
        @io.qt.QtUninvokable
        public java.lang.Object convertToMime(java.lang.String mime, java.util.Collection<? extends io.qt.core.QByteArray> data, java.lang.String flav){
            return convertToMime_native_cref_QString_QList_QString(QtJambi_LibraryUtilities.internal.nativeId(this), mime, data, flav);
        }
        @io.qt.QtUninvokable
        private native java.lang.Object convertToMime_native_cref_QString_QList_QString(long __this__nativeId, java.lang.String mime, java.util.Collection<? extends io.qt.core.QByteArray> data, java.lang.String flav);
        
        
        @Override
        @io.qt.QtUninvokable
        public java.lang.String convertorName(){
            return convertorName_native(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        @io.qt.QtUninvokable
        private native java.lang.String convertorName_native(long __this__nativeId);
        
        
        @Override
        @io.qt.QtUninvokable
        public java.lang.String flavorFor(java.lang.String mime){
            return flavorFor_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), mime);
        }
        @io.qt.QtUninvokable
        private native java.lang.String flavorFor_native_cref_QString(long __this__nativeId, java.lang.String mime);
        
        
        @Override
        @io.qt.QtUninvokable
        public java.lang.String mimeFor(java.lang.String flav){
            return mimeFor_native_QString(QtJambi_LibraryUtilities.internal.nativeId(this), flav);
        }
        @io.qt.QtUninvokable
        private native java.lang.String mimeFor_native_QString(long __this__nativeId, java.lang.String flav);
        
    }
    
    /**
     * <p>Java wrapper for Qt enum QMacPasteboardMime::QMacPasteboardMimeType</p>
     */
    public enum QMacPasteboardMimeType implements io.qt.QtEnumerator {
        MIME_DND(1),
        MIME_CLIP(2),
        MIME_QT_CONVERTOR(4),
        MIME_QT3_CONVERTOR(8),
        MIME_ALL(3);

        private QMacPasteboardMimeType(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static QMacPasteboardMimeType resolve(int value) {
            switch (value) {
            case 1: return MIME_DND;
            case 2: return MIME_CLIP;
            case 4: return MIME_QT_CONVERTOR;
            case 8: return MIME_QT3_CONVERTOR;
            case 3: return MIME_ALL;
            default: throw new io.qt.QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qmacpasteboardmime.html#QMacPasteboardMime">QMacPasteboardMime::QMacPasteboardMime(char)</a></p>
     */
    public QMacPasteboardMime(byte arg__1){
        super((QPrivateConstructor)null);
        initialize_native(this, arg__1);
    }
    
    private native static void initialize_native(QMacPasteboardMime instance, byte arg__1);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qmacpasteboardmime.html#canConvert">QMacPasteboardMime::canConvert(QString,QString)</a></p>
     */
    @io.qt.QtUninvokable
    public abstract boolean canConvert(java.lang.String mime, java.lang.String flav);
    
    @io.qt.QtUninvokable
    private native boolean canConvert_native_cref_QString_QString(long __this__nativeId, java.lang.String mime, java.lang.String flav);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qmacpasteboardmime.html#convertFromMime">QMacPasteboardMime::convertFromMime(QString,QVariant,QString)</a></p>
     */
    @io.qt.QtUninvokable
    public abstract java.util.List<io.qt.core.QByteArray> convertFromMime(java.lang.String mime, java.lang.Object data, java.lang.String flav);
    
    @io.qt.QtUninvokable
    private native java.util.List<io.qt.core.QByteArray> convertFromMime_native_cref_QString_QVariant_QString(long __this__nativeId, java.lang.String mime, java.lang.Object data, java.lang.String flav);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qmacpasteboardmime.html#convertToMime">QMacPasteboardMime::convertToMime(QString,QList&lt;QByteArray&gt;,QString)</a></p>
     */
    @io.qt.QtUninvokable
    public abstract java.lang.Object convertToMime(java.lang.String mime, java.util.Collection<? extends io.qt.core.QByteArray> data, java.lang.String flav);
    
    @io.qt.QtUninvokable
    private native java.lang.Object convertToMime_native_cref_QString_QList_QString(long __this__nativeId, java.lang.String mime, java.util.Collection<? extends io.qt.core.QByteArray> data, java.lang.String flav);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qmacpasteboardmime.html#convertorName">QMacPasteboardMime::convertorName()</a></p>
     */
    @io.qt.QtUninvokable
    public abstract java.lang.String convertorName();
    
    @io.qt.QtUninvokable
    private native java.lang.String convertorName_native(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qmacpasteboardmime.html#count">QMacPasteboardMime::count(QMimeData*)</a></p>
     */
    @io.qt.QtUninvokable
    public int count(io.qt.core.QMimeData mimeData){
        return count_native_QMimeData_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(mimeData));
    }
    
    @io.qt.QtUninvokable
    private native int count_native_QMimeData_ptr(long __this__nativeId, long mimeData);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qmacpasteboardmime.html#flavorFor">QMacPasteboardMime::flavorFor(QString)</a></p>
     */
    @io.qt.QtUninvokable
    public abstract java.lang.String flavorFor(java.lang.String mime);
    
    @io.qt.QtUninvokable
    private native java.lang.String flavorFor_native_cref_QString(long __this__nativeId, java.lang.String mime);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qmacpasteboardmime.html#mimeFor">QMacPasteboardMime::mimeFor(QString)</a></p>
     */
    @io.qt.QtUninvokable
    public abstract java.lang.String mimeFor(java.lang.String flav);
    
    @io.qt.QtUninvokable
    private native java.lang.String mimeFor_native_QString(long __this__nativeId, java.lang.String flav);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @io.qt.NativeAccess
    protected QMacPasteboardMime(QPrivateConstructor p) { super(p); } 
    
}
