package io.qt.macextras;

import io.qt.*;


/**
 * <p>Item for QMacToolBar</p>
 * <p>Java wrapper for Qt class <code><a href="http://doc.qt.io/qt-5/qmactoolbaritem.html">QMacToolBarItem</a></code></p>
 */
public class QMacToolBarItem extends io.qt.core.QObject
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.@NonNull QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QMacToolBarItem.class);
    
    /**
     * <p>Java wrapper for Qt enum <code><a href="http://doc.qt.io/qt-5/qmactoolbaritem.html#StandardItem-enum">QMacToolBarItem::StandardItem</a></code></p>
     */
    @QtUnlistedEnum
    public enum StandardItem implements QtEnumerator {
        /**
         * <p>Representing <code><a href="http://doc.qt.io/qt-5/qmactoolbaritem.html#StandardItem-enum">QMacToolBarItem::<wbr/>NoStandardItem</a></code></p>
         */
        NoStandardItem(0),
        /**
         * <p>Representing <code><a href="http://doc.qt.io/qt-5/qmactoolbaritem.html#StandardItem-enum">QMacToolBarItem::<wbr/>Space</a></code></p>
         */
        Space(1),
        /**
         * <p>Representing <code><a href="http://doc.qt.io/qt-5/qmactoolbaritem.html#StandardItem-enum">QMacToolBarItem::<wbr/>FlexibleSpace</a></code></p>
         */
        FlexibleSpace(2);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private StandardItem(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull StandardItem resolve(int value) {
            switch (value) {
            case 0: return NoStandardItem;
            case 1: return Space;
            case 2: return FlexibleSpace;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    

    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qmactoolbaritem.html#activated">QMacToolBarItem::<wbr/>activated()</a></code></p>
     */
    public final @NonNull Signal0 activated = new Signal0();
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qmactoolbaritem.html#QMacToolBarItem">QMacToolBarItem::<wbr/>QMacToolBarItem(QObject*)</a></code></p>
     */
    public QMacToolBarItem(io.qt.core.@Nullable QObject parent){
        super((QPrivateConstructor)null);
        initialize_native(this, parent);
    }
    
    private native static void initialize_native(QMacToolBarItem instance, io.qt.core.QObject parent);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qmactoolbaritem.html#icon-prop">QMacToolBarItem::<wbr/>icon()const</a></code></p>
     */
    @QtPropertyReader(name="icon")
    @QtUninvokable
    public final io.qt.gui.@NonNull QIcon icon(){
        return icon_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.gui.QIcon icon_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qmactoolbaritem.html#selectable-prop">QMacToolBarItem::<wbr/>selectable()const</a></code></p>
     */
    @QtPropertyReader(name="selectable")
    @QtUninvokable
    public final boolean selectable(){
        return selectable_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean selectable_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qmactoolbaritem.html#icon-prop">QMacToolBarItem::<wbr/>setIcon(QIcon)</a></code></p>
     */
    @QtPropertyWriter(name="icon")
    @QtUninvokable
    public final void setIcon(io.qt.gui.@NonNull QIcon icon){
        setIcon_native_cref_QIcon(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(icon));
    }
    
    @QtUninvokable
    private native void setIcon_native_cref_QIcon(long __this__nativeId, long icon);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qmactoolbaritem.html#selectable-prop">QMacToolBarItem::<wbr/>setSelectable(bool)</a></code></p>
     */
    @QtPropertyWriter(name="selectable")
    @QtUninvokable
    public final void setSelectable(boolean selectable){
        setSelectable_native_bool(QtJambi_LibraryUtilities.internal.nativeId(this), selectable);
    }
    
    @QtUninvokable
    private native void setSelectable_native_bool(long __this__nativeId, boolean selectable);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qmactoolbaritem.html#standardItem-prop">QMacToolBarItem::<wbr/>setStandardItem(QMacToolBarItem::StandardItem)</a></code></p>
     */
    @QtPropertyWriter(name="standardItem")
    @QtUninvokable
    public final void setStandardItem(io.qt.macextras.QMacToolBarItem.@NonNull StandardItem standardItem){
        setStandardItem_native_QMacToolBarItem_StandardItem(QtJambi_LibraryUtilities.internal.nativeId(this), standardItem.value());
    }
    
    @QtUninvokable
    private native void setStandardItem_native_QMacToolBarItem_StandardItem(long __this__nativeId, int standardItem);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qmactoolbaritem.html#text-prop">QMacToolBarItem::<wbr/>setText(QString)</a></code></p>
     */
    @QtPropertyWriter(name="text")
    @QtUninvokable
    public final void setText(java.lang.@NonNull String text){
        setText_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), text);
    }
    
    @QtUninvokable
    private native void setText_native_cref_QString(long __this__nativeId, java.lang.String text);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qmactoolbaritem.html#standardItem-prop">QMacToolBarItem::<wbr/>standardItem()const</a></code></p>
     */
    @QtPropertyReader(name="standardItem")
    @QtUninvokable
    public final io.qt.macextras.QMacToolBarItem.@NonNull StandardItem standardItem(){
        return io.qt.macextras.QMacToolBarItem.StandardItem.resolve(standardItem_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @QtUninvokable
    private native int standardItem_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qmactoolbaritem.html#text-prop">QMacToolBarItem::<wbr/>text()const</a></code></p>
     */
    @QtPropertyReader(name="text")
    @QtUninvokable
    public final java.lang.@NonNull String text(){
        return text_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native java.lang.String text_native_constfct(long __this__nativeId);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     * @hidden
     */
    @NativeAccess
    protected QMacToolBarItem(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * It is not allowed to call the declarative constructor from inside Java.
     * @hidden
     */
    @NativeAccess
    protected QMacToolBarItem(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @QtUninvokable
    private static native void initialize_native(QMacToolBarItem instance, QDeclarativeConstructor constructor);
    
    
    /**
     * <p>Overloaded constructor for {@link #QMacToolBarItem(io.qt.core.QObject)}
     *  with <code>parent = null</code>.</p>
     */
    public QMacToolBarItem() {
        this((io.qt.core.QObject)null);
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #icon()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.gui.@NonNull QIcon getIcon() {
        return icon();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #selectable()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final boolean getSelectable() {
        return selectable();
    }
    
    /**
     * <p>Overloaded function for {@link #setIcon(io.qt.gui.QIcon)}.</p>
     */
    @QtUninvokable
    public final void setIcon(io.qt.gui.@NonNull QPixmap icon) {
        setIcon(new io.qt.gui.QIcon(icon));
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #standardItem()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.macextras.QMacToolBarItem.@NonNull StandardItem getStandardItem() {
        return standardItem();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #text()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final java.lang.@NonNull String getText() {
        return text();
    }
}
