package io.qt.macextras;

import io.qt.*;


/**
 * <p>Converts between a MIME type and a Uniform Type Identifier (UTI) format</p>
 * <p>Java wrapper for Qt's class <a href="http://doc.qt.io/qt-5/qmacpasteboardmime.html">QMacPasteboardMime</a></p>
 */
public abstract class QMacPasteboardMime extends QtObject
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    @NativeAccess
    private static final class ConcreteWrapper extends QMacPasteboardMime {
        
        @NativeAccess
        private ConcreteWrapper(QPrivateConstructor p) { super(p); }
        
        @Override
        @QtUninvokable
        public boolean canConvert(java.lang.@NonNull String mime, java.lang.@NonNull String flav){
            return canConvert_native_cref_QString_QString(QtJambi_LibraryUtilities.internal.nativeId(this), mime, flav);
        }
        @QtUninvokable
        private native boolean canConvert_native_cref_QString_QString(long __this__nativeId, java.lang.String mime, java.lang.String flav);
        
        
        @Override
        @QtUninvokable
        public java.util.@NonNull List<io.qt.core.@NonNull QByteArray> convertFromMime(java.lang.@NonNull String mime, java.lang.Object data, java.lang.@NonNull String flav){
            return convertFromMime_native_cref_QString_QVariant_QString(QtJambi_LibraryUtilities.internal.nativeId(this), mime, data, flav);
        }
        @QtUninvokable
        private native java.util.List<io.qt.core.QByteArray> convertFromMime_native_cref_QString_QVariant_QString(long __this__nativeId, java.lang.String mime, java.lang.Object data, java.lang.String flav);
        
        
        @Override
        @QtUninvokable
        public java.lang.Object convertToMime(java.lang.@NonNull String mime, java.util.@NonNull Collection<? extends io.qt.core.@NonNull QByteArray> data, java.lang.@NonNull String flav){
            return convertToMime_native_cref_QString_QList_QString(QtJambi_LibraryUtilities.internal.nativeId(this), mime, data, flav);
        }
        @QtUninvokable
        private native java.lang.Object convertToMime_native_cref_QString_QList_QString(long __this__nativeId, java.lang.String mime, java.util.Collection<? extends io.qt.core.QByteArray> data, java.lang.String flav);
        
        
        @Override
        @QtUninvokable
        public java.lang.@NonNull String convertorName(){
            return convertorName_native(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        @QtUninvokable
        private native java.lang.String convertorName_native(long __this__nativeId);
        
        
        @Override
        @QtUninvokable
        public java.lang.@NonNull String flavorFor(java.lang.@NonNull String mime){
            return flavorFor_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), mime);
        }
        @QtUninvokable
        private native java.lang.String flavorFor_native_cref_QString(long __this__nativeId, java.lang.String mime);
        
        
        @Override
        @QtUninvokable
        public java.lang.@NonNull String mimeFor(java.lang.@NonNull String flav){
            return mimeFor_native_QString(QtJambi_LibraryUtilities.internal.nativeId(this), flav);
        }
        @QtUninvokable
        private native java.lang.String mimeFor_native_QString(long __this__nativeId, java.lang.String flav);
        
    }
    
    /**
     * <p>Java wrapper for Qt enum QMacPasteboardMime::QMacPasteboardMimeType</p>
     */
    public enum QMacPasteboardMimeType implements QtEnumerator {
        MIME_DND(1),
        MIME_CLIP(2),
        MIME_QT_CONVERTOR(4),
        MIME_QT3_CONVERTOR(8),
        MIME_ALL(3);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private QMacPasteboardMimeType(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static QMacPasteboardMimeType resolve(int value) {
            switch (value) {
            case 1: return MIME_DND;
            case 2: return MIME_CLIP;
            case 4: return MIME_QT_CONVERTOR;
            case 8: return MIME_QT3_CONVERTOR;
            case 3: return MIME_ALL;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qmacpasteboardmime.html#QMacPasteboardMime">QMacPasteboardMime::QMacPasteboardMime(char)</a></p>
     */
    public QMacPasteboardMime(byte arg__1){
        super((QPrivateConstructor)null);
        initialize_native(this, arg__1);
    }
    
    private native static void initialize_native(QMacPasteboardMime instance, byte arg__1);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qmacpasteboardmime.html#canConvert">QMacPasteboardMime::canConvert(QString,QString)</a></p>
     */
    @QtUninvokable
    public abstract boolean canConvert(java.lang.@NonNull String mime, java.lang.@NonNull String flav);
    
    @QtUninvokable
    private native boolean canConvert_native_cref_QString_QString(long __this__nativeId, java.lang.String mime, java.lang.String flav);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qmacpasteboardmime.html#convertFromMime">QMacPasteboardMime::convertFromMime(QString,QVariant,QString)</a></p>
     */
    @QtUninvokable
    public abstract java.util.@NonNull List<io.qt.core.@NonNull QByteArray> convertFromMime(java.lang.@NonNull String mime, java.lang.Object data, java.lang.@NonNull String flav);
    
    @QtUninvokable
    private native java.util.List<io.qt.core.QByteArray> convertFromMime_native_cref_QString_QVariant_QString(long __this__nativeId, java.lang.String mime, java.lang.Object data, java.lang.String flav);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qmacpasteboardmime.html#convertToMime">QMacPasteboardMime::convertToMime(QString,QList&lt;QByteArray&gt;,QString)</a></p>
     */
    @QtUninvokable
    public abstract java.lang.Object convertToMime(java.lang.@NonNull String mime, java.util.@NonNull Collection<? extends io.qt.core.@NonNull QByteArray> data, java.lang.@NonNull String flav);
    
    @QtUninvokable
    private native java.lang.Object convertToMime_native_cref_QString_QList_QString(long __this__nativeId, java.lang.String mime, java.util.Collection<? extends io.qt.core.QByteArray> data, java.lang.String flav);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qmacpasteboardmime.html#convertorName">QMacPasteboardMime::convertorName()</a></p>
     */
    @QtUninvokable
    public abstract java.lang.@NonNull String convertorName();
    
    @QtUninvokable
    private native java.lang.String convertorName_native(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qmacpasteboardmime.html#count">QMacPasteboardMime::count(QMimeData*)</a></p>
     */
    @QtUninvokable
    public int count(io.qt.core.@Nullable QMimeData mimeData){
        return count_native_QMimeData_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(mimeData));
    }
    
    @QtUninvokable
    private native int count_native_QMimeData_ptr(long __this__nativeId, long mimeData);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qmacpasteboardmime.html#flavorFor">QMacPasteboardMime::flavorFor(QString)</a></p>
     */
    @QtUninvokable
    public abstract java.lang.@NonNull String flavorFor(java.lang.@NonNull String mime);
    
    @QtUninvokable
    private native java.lang.String flavorFor_native_cref_QString(long __this__nativeId, java.lang.String mime);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qmacpasteboardmime.html#mimeFor">QMacPasteboardMime::mimeFor(QString)</a></p>
     */
    @QtUninvokable
    public abstract java.lang.@NonNull String mimeFor(java.lang.@NonNull String flav);
    
    @QtUninvokable
    private native java.lang.String mimeFor_native_QString(long __this__nativeId, java.lang.String flav);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @NativeAccess
    protected QMacPasteboardMime(QPrivateConstructor p) { super(p); } 
    
}
