package io.qt.help;

import io.qt.*;


/**
 * <p>The core functionality of the help system</p>
 * <p>Java wrapper for Qt class <code><a href="https://doc.qt.io/qt/qhelpenginecore.html">QHelpEngineCore</a></code></p>
 */
public class QHelpEngineCore extends io.qt.core.QObject
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.@NonNull QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QHelpEngineCore.class);
    

    /**
     * <p>See <code>QHelpEngineCore::<wbr/>currentFilterChanged(QString)</code></p>
     */
    public final @NonNull Signal1<java.lang.@NonNull String> currentFilterChanged = new Signal1<>();

    /**
     * <p>See <code>QHelpEngineCore::<wbr/>readersAboutToBeInvalidated()</code></p>
     */
    public final @NonNull Signal0 readersAboutToBeInvalidated = new Signal0();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qhelpenginecore.html#setupFinished">QHelpEngineCore::<wbr/>setupFinished()</a></code></p>
     */
    public final @NonNull Signal0 setupFinished = new Signal0();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qhelpenginecore.html#setupStarted">QHelpEngineCore::<wbr/>setupStarted()</a></code></p>
     */
    public final @NonNull Signal0 setupStarted = new Signal0();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qhelpenginecore.html#warning">QHelpEngineCore::<wbr/>warning(QString)</a></code></p>
     */
    public final @NonNull Signal1<java.lang.@NonNull String> warning = new Signal1<>();
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qhelpenginecore.html#QHelpEngineCore">QHelpEngineCore::<wbr/>QHelpEngineCore(QString,<wbr/>QObject*)</a></code></p>
     */
    public QHelpEngineCore(java.lang.@NonNull String collectionFile, io.qt.core.@Nullable QObject parent){
        super((QPrivateConstructor)null);
        initialize_native(this, collectionFile, parent);
        if (parent != null) QtJambi_LibraryUtilities.internal.setCppOwnership(this);
    }
    
    private native static void initialize_native(QHelpEngineCore instance, java.lang.String collectionFile, io.qt.core.QObject parent);
    
    /**
     * <p>See <code>QHelpEngineCore::<wbr/>addCustomFilter(QString,<wbr/>QStringList)</code></p>
     */
    @QtUninvokable
    public final boolean addCustomFilter(java.lang.@NonNull String filterName, java.util.@NonNull Collection<java.lang.@NonNull String> attributes){
        return addCustomFilter_native_cref_QString_cref_QStringList(QtJambi_LibraryUtilities.internal.nativeId(this), filterName, attributes);
    }
    
    @QtUninvokable
    private native boolean addCustomFilter_native_cref_QString_cref_QStringList(long __this__nativeId, java.lang.String filterName, java.util.Collection<java.lang.String> attributes);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qhelpenginecore.html#autoSaveFilter-prop">QHelpEngineCore::<wbr/>autoSaveFilter()const</a></code></p>
     */
    @QtPropertyReader(name="autoSaveFilter")
    @QtUninvokable
    public final boolean autoSaveFilter(){
        return autoSaveFilter_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean autoSaveFilter_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qhelpenginecore.html#collectionFile-prop">QHelpEngineCore::<wbr/>collectionFile()const</a></code></p>
     */
    @QtPropertyReader(name="collectionFile")
    @QtUninvokable
    public final java.lang.@NonNull String collectionFile(){
        return collectionFile_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native java.lang.String collectionFile_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qhelpenginecore.html#copyCollectionFile">QHelpEngineCore::<wbr/>copyCollectionFile(QString)</a></code></p>
     */
    @QtUninvokable
    public final boolean copyCollectionFile(java.lang.@NonNull String fileName){
        return copyCollectionFile_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), fileName);
    }
    
    @QtUninvokable
    private native boolean copyCollectionFile_native_cref_QString(long __this__nativeId, java.lang.String fileName);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qhelpenginecore-obsolete.html#currentFilter-prop">QHelpEngineCore::<wbr/>currentFilter()const</a></code></p>
     */
    @QtPropertyReader(name="currentFilter")
    @QtUninvokable
    public final java.lang.@NonNull String currentFilter(){
        return currentFilter_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native java.lang.String currentFilter_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code>QHelpEngineCore::<wbr/>customFilters()const</code></p>
     */
    @QtUninvokable
    public final io.qt.core.@NonNull QStringList customFilters(){
        return customFilters_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QStringList customFilters_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qhelpenginecore.html#customValue">QHelpEngineCore::<wbr/>customValue(QString,<wbr/>QVariant)const</a></code></p>
     */
    @QtUninvokable
    public final java.lang.Object customValue(java.lang.@NonNull String key, java.lang.Object defaultValue){
        return customValue_native_cref_QString_cref_QVariant_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), key, defaultValue);
    }
    
    @QtUninvokable
    private native java.lang.Object customValue_native_cref_QString_cref_QVariant_constfct(long __this__nativeId, java.lang.String key, java.lang.Object defaultValue);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qhelpenginecore.html#documentationFileName">QHelpEngineCore::<wbr/>documentationFileName(QString)</a></code></p>
     */
    @QtUninvokable
    public final java.lang.@NonNull String documentationFileName(java.lang.@NonNull String namespaceName){
        return documentationFileName_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), namespaceName);
    }
    
    @QtUninvokable
    private native java.lang.String documentationFileName_native_cref_QString(long __this__nativeId, java.lang.String namespaceName);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qhelpenginecore.html#documentsForIdentifier">QHelpEngineCore::<wbr/>documentsForIdentifier(QString)const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.core.@NonNull QList<io.qt.help.@NonNull QHelpLink> documentsForIdentifier(java.lang.@NonNull String id){
        return documentsForIdentifier_native_cref_QString_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), id);
    }
    
    @QtUninvokable
    private native io.qt.core.QList<io.qt.help.QHelpLink> documentsForIdentifier_native_cref_QString_constfct(long __this__nativeId, java.lang.String id);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qhelpenginecore.html#documentsForIdentifier-1">QHelpEngineCore::<wbr/>documentsForIdentifier(QString,<wbr/>QString)const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.core.@NonNull QList<io.qt.help.@NonNull QHelpLink> documentsForIdentifier(java.lang.@NonNull String id, java.lang.@NonNull String filterName){
        return documentsForIdentifier_native_cref_QString_cref_QString_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), id, filterName);
    }
    
    @QtUninvokable
    private native io.qt.core.QList<io.qt.help.QHelpLink> documentsForIdentifier_native_cref_QString_cref_QString_constfct(long __this__nativeId, java.lang.String id, java.lang.String filterName);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qhelpenginecore.html#documentsForKeyword">QHelpEngineCore::<wbr/>documentsForKeyword(QString)const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.core.@NonNull QList<io.qt.help.@NonNull QHelpLink> documentsForKeyword(java.lang.@NonNull String keyword){
        return documentsForKeyword_native_cref_QString_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), keyword);
    }
    
    @QtUninvokable
    private native io.qt.core.QList<io.qt.help.QHelpLink> documentsForKeyword_native_cref_QString_constfct(long __this__nativeId, java.lang.String keyword);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qhelpenginecore.html#documentsForKeyword-1">QHelpEngineCore::<wbr/>documentsForKeyword(QString,<wbr/>QString)const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.core.@NonNull QList<io.qt.help.@NonNull QHelpLink> documentsForKeyword(java.lang.@NonNull String keyword, java.lang.@NonNull String filterName){
        return documentsForKeyword_native_cref_QString_cref_QString_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), keyword, filterName);
    }
    
    @QtUninvokable
    private native io.qt.core.QList<io.qt.help.QHelpLink> documentsForKeyword_native_cref_QString_cref_QString_constfct(long __this__nativeId, java.lang.String keyword, java.lang.String filterName);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qhelpenginecore.html#error">QHelpEngineCore::<wbr/>error()const</a></code></p>
     */
    @QtUninvokable
    public final java.lang.@NonNull String error(){
        return error_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native java.lang.String error_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qhelpenginecore.html#fileData">QHelpEngineCore::<wbr/>fileData(QUrl)const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.core.@NonNull QByteArray fileData(io.qt.core.@NonNull QUrl url){
        return fileData_native_cref_QUrl_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(url));
    }
    
    @QtUninvokable
    private native io.qt.core.QByteArray fileData_native_cref_QUrl_constfct(long __this__nativeId, long url);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qhelpenginecore.html#files-1">QHelpEngineCore::<wbr/>files(QString,<wbr/>QString,<wbr/>QString)</a></code></p>
     */
    @QtUninvokable
    public final io.qt.core.@NonNull QList<io.qt.core.@NonNull QUrl> files(java.lang.@NonNull String namespaceName, java.lang.@NonNull String filterName, java.lang.@NonNull String extensionFilter){
        return files_native_const_QString_cref_QString_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), namespaceName, filterName, extensionFilter);
    }
    
    @QtUninvokable
    private native io.qt.core.QList<io.qt.core.QUrl> files_native_const_QString_cref_QString_cref_QString(long __this__nativeId, java.lang.String namespaceName, java.lang.String filterName, java.lang.String extensionFilter);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qhelpenginecore.html#files-1">QHelpEngineCore::<wbr/>files(QString,<wbr/>QStringList,<wbr/>QString)</a></code></p>
     */
    @QtUninvokable
    public final io.qt.core.@NonNull QList<io.qt.core.@NonNull QUrl> files(java.lang.@NonNull String namespaceName, java.util.@NonNull Collection<java.lang.@NonNull String> filterAttributes, java.lang.@NonNull String extensionFilter){
        return files_native_const_QString_cref_QStringList_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), namespaceName, filterAttributes, extensionFilter);
    }
    
    @QtUninvokable
    private native io.qt.core.QList<io.qt.core.QUrl> files_native_const_QString_cref_QStringList_cref_QString(long __this__nativeId, java.lang.String namespaceName, java.util.Collection<java.lang.String> filterAttributes, java.lang.String extensionFilter);
    
    /**
     * <p>See <code>QHelpEngineCore::<wbr/>filterAttributeSets(QString)const</code></p>
     */
    @QtUninvokable
    public final io.qt.core.@NonNull QList<java.util.@NonNull List<java.lang.@NonNull String>> filterAttributeSets(java.lang.@NonNull String namespaceName){
        return filterAttributeSets_native_cref_QString_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), namespaceName);
    }
    
    @QtUninvokable
    private native io.qt.core.QList<java.util.List<java.lang.String>> filterAttributeSets_native_cref_QString_constfct(long __this__nativeId, java.lang.String namespaceName);
    
    /**
     * <p>See <code>QHelpEngineCore::<wbr/>filterAttributes()const</code></p>
     */
    @QtUninvokable
    public final io.qt.core.@NonNull QStringList filterAttributes(){
        return filterAttributes_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QStringList filterAttributes_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code>QHelpEngineCore::<wbr/>filterAttributes(QString)const</code></p>
     */
    @QtUninvokable
    public final io.qt.core.@NonNull QStringList filterAttributes(java.lang.@NonNull String filterName){
        return filterAttributes_native_cref_QString_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), filterName);
    }
    
    @QtUninvokable
    private native io.qt.core.QStringList filterAttributes_native_cref_QString_constfct(long __this__nativeId, java.lang.String filterName);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qhelpenginecore.html#filterEngine">QHelpEngineCore::<wbr/>filterEngine()const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.help.@Nullable QHelpFilterEngine filterEngine(){
        return filterEngine_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.help.QHelpFilterEngine filterEngine_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qhelpenginecore.html#findFile">QHelpEngineCore::<wbr/>findFile(QUrl)const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.core.@NonNull QUrl findFile(io.qt.core.@NonNull QUrl url){
        return findFile_native_cref_QUrl_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(url));
    }
    
    @QtUninvokable
    private native io.qt.core.QUrl findFile_native_cref_QUrl_constfct(long __this__nativeId, long url);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qhelpenginecore.html#readOnly-prop">QHelpEngineCore::<wbr/>isReadOnly()const</a></code></p>
     */
    @QtPropertyReader(name="readOnly")
    @QtUninvokable
    public final boolean isReadOnly(){
        return isReadOnly_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean isReadOnly_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qhelpenginecore.html#registerDocumentation">QHelpEngineCore::<wbr/>registerDocumentation(QString)</a></code></p>
     */
    @QtUninvokable
    public final boolean registerDocumentation(java.lang.@NonNull String documentationFileName){
        return registerDocumentation_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), documentationFileName);
    }
    
    @QtUninvokable
    private native boolean registerDocumentation_native_cref_QString(long __this__nativeId, java.lang.String documentationFileName);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qhelpenginecore.html#registeredDocumentations">QHelpEngineCore::<wbr/>registeredDocumentations()const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.core.@NonNull QStringList registeredDocumentations(){
        return registeredDocumentations_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QStringList registeredDocumentations_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code>QHelpEngineCore::<wbr/>removeCustomFilter(QString)</code></p>
     */
    @QtUninvokable
    public final boolean removeCustomFilter(java.lang.@NonNull String filterName){
        return removeCustomFilter_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), filterName);
    }
    
    @QtUninvokable
    private native boolean removeCustomFilter_native_cref_QString(long __this__nativeId, java.lang.String filterName);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qhelpenginecore.html#removeCustomValue">QHelpEngineCore::<wbr/>removeCustomValue(QString)</a></code></p>
     */
    @QtUninvokable
    public final boolean removeCustomValue(java.lang.@NonNull String key){
        return removeCustomValue_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), key);
    }
    
    @QtUninvokable
    private native boolean removeCustomValue_native_cref_QString(long __this__nativeId, java.lang.String key);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qhelpenginecore.html#autoSaveFilter-prop">QHelpEngineCore::<wbr/>setAutoSaveFilter(bool)</a></code></p>
     */
    @QtPropertyWriter(name="autoSaveFilter")
    @QtUninvokable
    public final void setAutoSaveFilter(boolean save){
        setAutoSaveFilter_native_bool(QtJambi_LibraryUtilities.internal.nativeId(this), save);
    }
    
    @QtUninvokable
    private native void setAutoSaveFilter_native_bool(long __this__nativeId, boolean save);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qhelpenginecore.html#collectionFile-prop">QHelpEngineCore::<wbr/>setCollectionFile(QString)</a></code></p>
     */
    @QtPropertyWriter(name="collectionFile")
    @QtUninvokable
    public final void setCollectionFile(java.lang.@NonNull String fileName){
        setCollectionFile_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), fileName);
    }
    
    @QtUninvokable
    private native void setCollectionFile_native_cref_QString(long __this__nativeId, java.lang.String fileName);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qhelpenginecore-obsolete.html#currentFilter-prop">QHelpEngineCore::<wbr/>setCurrentFilter(QString)</a></code></p>
     */
    @QtPropertyWriter(name="currentFilter")
    @QtUninvokable
    public final void setCurrentFilter(java.lang.@NonNull String filterName){
        setCurrentFilter_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), filterName);
    }
    
    @QtUninvokable
    private native void setCurrentFilter_native_cref_QString(long __this__nativeId, java.lang.String filterName);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qhelpenginecore.html#setCustomValue">QHelpEngineCore::<wbr/>setCustomValue(QString,<wbr/>QVariant)</a></code></p>
     */
    @QtUninvokable
    public final boolean setCustomValue(java.lang.@NonNull String key, java.lang.Object value){
        return setCustomValue_native_cref_QString_cref_QVariant(QtJambi_LibraryUtilities.internal.nativeId(this), key, value);
    }
    
    @QtUninvokable
    private native boolean setCustomValue_native_cref_QString_cref_QVariant(long __this__nativeId, java.lang.String key, java.lang.Object value);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qhelpenginecore.html#readOnly-prop">QHelpEngineCore::<wbr/>setReadOnly(bool)</a></code></p>
     */
    @QtPropertyWriter(name="readOnly")
    @QtUninvokable
    public final void setReadOnly(boolean enable){
        setReadOnly_native_bool(QtJambi_LibraryUtilities.internal.nativeId(this), enable);
    }
    
    @QtUninvokable
    private native void setReadOnly_native_bool(long __this__nativeId, boolean enable);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qhelpenginecore.html#setUsesFilterEngine">QHelpEngineCore::<wbr/>setUsesFilterEngine(bool)</a></code></p>
     */
    @QtUninvokable
    public final void setUsesFilterEngine(boolean uses){
        setUsesFilterEngine_native_bool(QtJambi_LibraryUtilities.internal.nativeId(this), uses);
    }
    
    @QtUninvokable
    private native void setUsesFilterEngine_native_bool(long __this__nativeId, boolean uses);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qhelpenginecore.html#setupData">QHelpEngineCore::<wbr/>setupData()</a></code></p>
     */
    @QtUninvokable
    public final boolean setupData(){
        return setupData_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean setupData_native(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qhelpenginecore.html#unregisterDocumentation">QHelpEngineCore::<wbr/>unregisterDocumentation(QString)</a></code></p>
     */
    @QtUninvokable
    public final boolean unregisterDocumentation(java.lang.@NonNull String namespaceName){
        return unregisterDocumentation_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), namespaceName);
    }
    
    @QtUninvokable
    private native boolean unregisterDocumentation_native_cref_QString(long __this__nativeId, java.lang.String namespaceName);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qhelpenginecore.html#usesFilterEngine">QHelpEngineCore::<wbr/>usesFilterEngine()const</a></code></p>
     */
    @QtUninvokable
    public final boolean usesFilterEngine(){
        return usesFilterEngine_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean usesFilterEngine_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qhelpenginecore.html#metaData">QHelpEngineCore::<wbr/>metaData(QString,<wbr/>QString)</a></code></p>
     */
    public native static java.lang.Object metaData(java.lang.@NonNull String documentationFileName, java.lang.@NonNull String name);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qhelpenginecore.html#namespaceName">QHelpEngineCore::<wbr/>namespaceName(QString)</a></code></p>
     */
    public native static java.lang.@NonNull String namespaceName(java.lang.@NonNull String documentationFileName);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     * @hidden
     */
    @NativeAccess
    protected QHelpEngineCore(QPrivateConstructor p) { super(p); } 
    
    
    /**
     * <p>Overloaded constructor for {@link #QHelpEngineCore(java.lang.String, io.qt.core.QObject)}
     *  with <code>parent = null</code>.</p>
     */
    public QHelpEngineCore(java.lang.@NonNull String collectionFile) {
        this(collectionFile, (io.qt.core.QObject)null);
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #autoSaveFilter()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final boolean getAutoSaveFilter() {
        return autoSaveFilter();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #collectionFile()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final java.lang.@NonNull String getCollectionFile() {
        return collectionFile();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #currentFilter()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final java.lang.@NonNull String getCurrentFilter() {
        return currentFilter();
    }
    
    /**
     * <p>Overloaded function for {@link #customValue(java.lang.String, java.lang.Object)}
     *  with <code>defaultValue = null</code>.</p>
     */
    @QtUninvokable
    public final java.lang.Object customValue(java.lang.@NonNull String key) {
        return customValue(key, (java.lang.Object)null);
    }
    
    /**
     * <p>Overloaded function for {@link #fileData(io.qt.core.QUrl)}.</p>
     */
    @QtUninvokable
    public final io.qt.core.@NonNull QByteArray fileData(java.lang.@NonNull String url) {
        return fileData(new io.qt.core.QUrl(url));
    }
    
    /**
     * <p>Overloaded function for {@link #files(java.lang.String, java.lang.String, java.lang.String)}
     *  with <code>extensionFilter = (String)null</code>.</p>
     */
    @QtUninvokable
    public final io.qt.core.@NonNull QList<io.qt.core.@NonNull QUrl> files(java.lang.@NonNull String namespaceName, java.lang.@NonNull String filterName) {
        return files(namespaceName, filterName, (String)null);
    }
    
    /**
     * <p>Overloaded function for {@link #files(java.lang.String, java.util.Collection, java.lang.String)}
     *  with <code>extensionFilter = (String)null</code>.</p>
     */
    @QtUninvokable
    public final io.qt.core.@NonNull QList<io.qt.core.@NonNull QUrl> files(java.lang.@NonNull String namespaceName, java.util.@NonNull Collection<java.lang.@NonNull String> filterAttributes) {
        return files(namespaceName, filterAttributes, (String)null);
    }
    
    /**
     * <p>Overloaded function for {@link #findFile(io.qt.core.QUrl)}.</p>
     */
    @QtUninvokable
    public final io.qt.core.@NonNull QUrl findFile(java.lang.@NonNull String url) {
        return findFile(new io.qt.core.QUrl(url));
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #isReadOnly()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final boolean getReadOnly() {
        return isReadOnly();
    }
}
