package io.qt.help;

import io.qt.*;


/**
 * <p>Struct provides the data associated with a help link</p>
 * <p>Java wrapper for Qt class <code><a href="https://doc.qt.io/qt/qhelplink.html">QHelpLink</a></code></p>
 */
public final class QHelpLink extends QtObject
    implements java.lang.Cloneable
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    
    /**
     * <p>See <code>QHelpLink::<wbr/>QHelpLink()</code></p>
     */
    public QHelpLink(){
        super((QPrivateConstructor)null);
        initialize_native(this);
    }
    
    private native static void initialize_native(QHelpLink instance);
    
    /**
     * <p>Of the link</p>
     * <p>See <code><a href="https://doc.qt.io/qt/qhelplink.html#title-var">QHelpLink::<wbr/>title</a></code></p>
     */
    @QtUninvokable
    public final void setTitle(java.lang.@NonNull String title){
        setTitle_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), title);
    }
    
    @QtUninvokable
    private native void setTitle_native_cref_QString(long __this__nativeId, java.lang.String title);
    
    /**
     * <p>Of the link</p>
     * <p>See <code><a href="https://doc.qt.io/qt/qhelplink.html#title-var">QHelpLink::<wbr/>title</a></code></p>
     */
    @QtUninvokable
    public final java.lang.@NonNull String title(){
        return title_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native java.lang.String title_native(long __this__nativeId);
    
    /**
     * <p>Target url of the link</p>
     * <p>See <code><a href="https://doc.qt.io/qt/qhelplink.html#url-var">QHelpLink::<wbr/>url</a></code></p>
     */
    @QtUninvokable
    public final void setUrl(io.qt.core.@NonNull QUrl url){
        setUrl_native_cref_QUrl(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(url));
    }
    
    @QtUninvokable
    private native void setUrl_native_cref_QUrl(long __this__nativeId, long url);
    
    /**
     * <p>Target url of the link</p>
     * <p>See <code><a href="https://doc.qt.io/qt/qhelplink.html#url-var">QHelpLink::<wbr/>url</a></code></p>
     */
    @QtUninvokable
    public final io.qt.core.@NonNull QUrl url(){
        return url_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QUrl url_native(long __this__nativeId);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     * @hidden
     */
    @NativeAccess
    protected QHelpLink(QPrivateConstructor p) { super(p); } 
    
    
    /**
     * <p>Creates and returns a copy of this object.</p>
     */
    @QtUninvokable
    @Override
    public QHelpLink clone() {
        return clone_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    private static native QHelpLink clone_native(long __this_nativeId);
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #title()} instead.</p>
     */
    @QtUninvokable
    public final java.lang.@NonNull String getTitle() {
        return title();
    }
    
    /**
     * <p>Overloaded function for {@link #setUrl(io.qt.core.QUrl)}.</p>
     */
    @QtUninvokable
    public final void setUrl(java.lang.@NonNull String url) {
        setUrl(new io.qt.core.QUrl(url));
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #url()} instead.</p>
     */
    @QtUninvokable
    public final io.qt.core.@NonNull QUrl getUrl() {
        return url();
    }
}
