package io.qt.help;

import io.qt.*;


/**
 * <p>Details for the filters used by QHelpFilterEngine</p>
 * <p>Java wrapper for Qt class <code><a href="https://doc.qt.io/qt/qhelpfilterdata.html">QHelpFilterData</a></code></p>
 */
public final class QHelpFilterData extends QtObject
    implements java.lang.Cloneable
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qhelpfilterdata.html#QHelpFilterData">QHelpFilterData::<wbr/>QHelpFilterData()</a></code></p>
     */
    public QHelpFilterData(){
        super((QPrivateConstructor)null);
        initialize_native(this);
    }
    
    private native static void initialize_native(QHelpFilterData instance);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qhelpfilterdata.html#QHelpFilterData-1">QHelpFilterData::<wbr/>QHelpFilterData(QHelpFilterData)</a></code></p>
     */
    public QHelpFilterData(io.qt.help.@NonNull QHelpFilterData other){
        super((QPrivateConstructor)null);
        initialize_native(this, other);
    }
    
    private native static void initialize_native(QHelpFilterData instance, io.qt.help.QHelpFilterData other);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qhelpfilterdata.html#components">QHelpFilterData::<wbr/>components()const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.core.@NonNull QStringList components(){
        return components_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QStringList components_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qhelpfilterdata.html#operator-eq">QHelpFilterData::<wbr/>operator=(QHelpFilterData)</a></code></p>
     */
    @QtUninvokable
    public final void assign(io.qt.help.@NonNull QHelpFilterData other){
        assign_native_cref_QHelpFilterData(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(other));
    }
    
    @QtUninvokable
    private native void assign_native_cref_QHelpFilterData(long __this__nativeId, long other);
    
    /**
     * <p>See <code>QHelpFilterData::<wbr/>operator==(QHelpFilterData)const</code></p>
     */
    @QtUninvokable
    public final boolean equals(io.qt.help.@NonNull QHelpFilterData other){
        return equals_native_cref_QHelpFilterData_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(other));
    }
    
    @QtUninvokable
    private native boolean equals_native_cref_QHelpFilterData_constfct(long __this__nativeId, long other);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qhelpfilterdata.html#setComponents">QHelpFilterData::<wbr/>setComponents(QStringList)</a></code></p>
     */
    @QtUninvokable
    public final void setComponents(java.util.@NonNull Collection<java.lang.@NonNull String> components){
        setComponents_native_cref_QStringList(QtJambi_LibraryUtilities.internal.nativeId(this), components);
    }
    
    @QtUninvokable
    private native void setComponents_native_cref_QStringList(long __this__nativeId, java.util.Collection<java.lang.String> components);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qhelpfilterdata.html#setVersions">QHelpFilterData::<wbr/>setVersions(QList&lt;QVersionNumber&gt;)</a></code></p>
     */
    @QtUninvokable
    public final void setVersions(java.util.@NonNull Collection<? extends io.qt.core.@NonNull QVersionNumber> versions){
        setVersions_native_cref_QList(QtJambi_LibraryUtilities.internal.nativeId(this), versions);
    }
    
    @QtUninvokable
    private native void setVersions_native_cref_QList(long __this__nativeId, java.util.Collection<? extends io.qt.core.QVersionNumber> versions);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qhelpfilterdata.html#swap">QHelpFilterData::<wbr/>swap(QHelpFilterData&amp;)</a></code></p>
     */
    @QtUninvokable
    public final void swap(io.qt.help.@StrictNonNull QHelpFilterData other){
        java.util.Objects.requireNonNull(other, "Argument 'other': null not expected.");
        swap_native_ref_QHelpFilterData(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(other));
    }
    
    @QtUninvokable
    private native void swap_native_ref_QHelpFilterData(long __this__nativeId, long other);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qhelpfilterdata.html#versions">QHelpFilterData::<wbr/>versions()const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.core.@NonNull QList<io.qt.core.@NonNull QVersionNumber> versions(){
        return versions_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QList<io.qt.core.QVersionNumber> versions_native_constfct(long __this__nativeId);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     * @hidden
     */
    @NativeAccess
    protected QHelpFilterData(QPrivateConstructor p) { super(p); } 
    

    /**
     * <p>See <code>QHelpFilterData::<wbr/>operator==(QHelpFilterData)const</code></p>
     */
    @Override
    @QtUninvokable
    public boolean equals(Object other) {
        if (other instanceof io.qt.help.QHelpFilterData) {
            return equals((io.qt.help.QHelpFilterData) other);
        }

        return false;
    }


    /**
     * Returns the objects's hash code computed by <code>qHash(QHelpFilterData)</code>.
     */
    @QtUninvokable
    @Override
    public int hashCode() {
        return hashCode_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    @QtUninvokable
    private native static int hashCode_native(long __this_nativeId);
    
    /**
     * <p>Creates and returns a copy of this object.</p>
     */
    @QtUninvokable
    @Override
    public QHelpFilterData clone() {
        return clone_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    private static native QHelpFilterData clone_native(long __this_nativeId);
}
