package io.qt.help;

import io.qt.*;


/**
 * <p>Simple line edit or an advanced widget to enable the user to input a search term in a standardized input mask</p>
 * <p>Java wrapper for Qt class <code><a href="https://doc.qt.io/qt/qhelpsearchquerywidget.html">QHelpSearchQueryWidget</a></code></p>
 */
public class QHelpSearchQueryWidget extends io.qt.widgets.QWidget
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.@NonNull QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QHelpSearchQueryWidget.class);
    

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qhelpsearchquerywidget.html#search">QHelpSearchQueryWidget::<wbr>search()</a></code></p>
     */
    public final @NonNull Signal0 search = new Signal0();
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qhelpsearchquerywidget.html#QHelpSearchQueryWidget">QHelpSearchQueryWidget::<wbr>QHelpSearchQueryWidget(QWidget*)</a></code></p>
     */
    public QHelpSearchQueryWidget(io.qt.widgets.@Nullable QWidget parent){
        super((QPrivateConstructor)null);
        initialize_native(this, parent);
        if (parent != null) QtJambi_LibraryUtilities.internal.setCppOwnership(this);
    }
    
    private native static void initialize_native(QHelpSearchQueryWidget instance, io.qt.widgets.QWidget parent);
    
    /**
     * Function has no implementation because its native counterpart is private.
     */
    @Deprecated
    @QtUninvokable
    @Override
    protected final void changeEvent(io.qt.core.@Nullable QEvent event) throws QNoImplementationException {
        throw new QNoImplementationException();
    }
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qhelpsearchquerywidget.html#collapseExtendedSearch">QHelpSearchQueryWidget::<wbr>collapseExtendedSearch()</a></code></p>
     */
    @QtUninvokable
    public final void collapseExtendedSearch(){
        collapseExtendedSearch_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native void collapseExtendedSearch_native(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qhelpsearchquerywidget.html#expandExtendedSearch">QHelpSearchQueryWidget::<wbr>expandExtendedSearch()</a></code></p>
     */
    @QtUninvokable
    public final void expandExtendedSearch(){
        expandExtendedSearch_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native void expandExtendedSearch_native(long __this__nativeId);
    
    /**
     * Function has no implementation because its native counterpart is private.
     */
    @Deprecated
    @QtUninvokable
    @Override
    protected final void focusInEvent(io.qt.gui.@Nullable QFocusEvent focusEvent) throws QNoImplementationException {
        throw new QNoImplementationException();
    }
    
    /**
     * <p>See <code>QHelpSearchQueryWidget::<wbr>isCompactMode()const</code></p>
     */
    @QtUninvokable
    public final boolean isCompactMode(){
        return isCompactMode_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean isCompactMode_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code>QHelpSearchQueryWidget::<wbr>query()const</code></p>
     */
    @QtUninvokable
    public final io.qt.core.@NonNull QList<io.qt.help.@NonNull QHelpSearchQuery> query(){
        return query_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QList<io.qt.help.QHelpSearchQuery> query_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qhelpsearchquerywidget.html#searchInput">QHelpSearchQueryWidget::<wbr>searchInput()const</a></code></p>
     */
    @QtUninvokable
    public final java.lang.@NonNull String searchInput(){
        return searchInput_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native java.lang.String searchInput_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code>QHelpSearchQueryWidget::<wbr>setCompactMode(bool)</code></p>
     */
    public final void setCompactMode(boolean on){
        setCompactMode_native_bool(QtJambi_LibraryUtilities.internal.nativeId(this), on);
    }
    
    private native void setCompactMode_native_bool(long __this__nativeId, boolean on);
    
    /**
     * <p>See <code>QHelpSearchQueryWidget::<wbr>setQuery(QList&lt;QHelpSearchQuery&gt;)</code></p>
     */
    @QtUninvokable
    public final void setQuery(java.util.@NonNull Collection<? extends io.qt.help.@NonNull QHelpSearchQuery> queryList){
        setQuery_native_cref_QList(QtJambi_LibraryUtilities.internal.nativeId(this), queryList);
    }
    
    @QtUninvokable
    private native void setQuery_native_cref_QList(long __this__nativeId, java.util.Collection<? extends io.qt.help.QHelpSearchQuery> queryList);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qhelpsearchquerywidget.html#setSearchInput">QHelpSearchQueryWidget::<wbr>setSearchInput(QString)</a></code></p>
     */
    @QtUninvokable
    public final void setSearchInput(java.lang.@NonNull String searchInput){
        setSearchInput_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), searchInput);
    }
    
    @QtUninvokable
    private native void setSearchInput_native_cref_QString(long __this__nativeId, java.lang.String searchInput);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     * @hidden
     */
    @NativeAccess
    protected QHelpSearchQueryWidget(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * @hidden
     * It is not allowed to call the declarative constructor from inside Java.
     */
    @NativeAccess
    protected QHelpSearchQueryWidget(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @QtUninvokable
    private static native void initialize_native(QHelpSearchQueryWidget instance, QDeclarativeConstructor constructor);
    
    
    /**
     * <p>Overloaded constructor for {@link #QHelpSearchQueryWidget(io.qt.widgets.QWidget)}
     *  with <code>parent = null</code>.</p>
     */
    public QHelpSearchQueryWidget() {
        this((io.qt.widgets.QWidget)null);
    }
}
