package io.qt.help;

import io.qt.*;


/**
 * <p>Model that supplies index keywords to views</p>
 * <p>Java wrapper for Qt class <code><a href="https://doc.qt.io/qt/qhelpindexmodel.html">QHelpIndexModel</a></code></p>
 */
public final class QHelpIndexModel extends io.qt.core.QStringListModel
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.@NonNull QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QHelpIndexModel.class);
    

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qhelpindexmodel.html#indexCreated">QHelpIndexModel::<wbr>indexCreated()</a></code></p>
     */
    public final @NonNull Signal0 indexCreated = new Signal0();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qhelpindexmodel.html#indexCreationStarted">QHelpIndexModel::<wbr>indexCreationStarted()</a></code></p>
     */
    public final @NonNull Signal0 indexCreationStarted = new Signal0();
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qhelpindexmodel.html#createIndex">QHelpIndexModel::<wbr>createIndex(QString)</a></code></p>
     */
    @QtUninvokable
    public final void createIndex(java.lang.@NonNull String customFilterName){
        createIndex_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), customFilterName);
    }
    
    @QtUninvokable
    private native void createIndex_native_cref_QString(long __this__nativeId, java.lang.String customFilterName);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qhelpindexmodel.html#filter">QHelpIndexModel::<wbr>filter(QString,<wbr>QString)</a></code></p>
     */
    @QtUninvokable
    public final io.qt.core.@NonNull QModelIndex filter(java.lang.@NonNull String filter, java.lang.@NonNull String wildcard){
        return filter_native_cref_QString_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), filter, wildcard);
    }
    
    @QtUninvokable
    private native io.qt.core.QModelIndex filter_native_cref_QString_cref_QString(long __this__nativeId, java.lang.String filter, java.lang.String wildcard);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qhelpindexmodel.html#helpEngine">QHelpIndexModel::<wbr>helpEngine()const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.help.@Nullable QHelpEngineCore helpEngine(){
        return helpEngine_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.help.QHelpEngineCore helpEngine_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qhelpindexmodel.html#isCreatingIndex">QHelpIndexModel::<wbr>isCreatingIndex()const</a></code></p>
     */
    @QtUninvokable
    public final boolean isCreatingIndex(){
        return isCreatingIndex_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean isCreatingIndex_native_constfct(long __this__nativeId);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     * @hidden
     */
    @NativeAccess
    protected QHelpIndexModel(QPrivateConstructor p) { super(p); } 
    
    
    /**
     * <p>Overloaded function for {@link #filter(java.lang.String, java.lang.String)}
     *  with <code>wildcard = (String)null</code>.</p>
     */
    @QtUninvokable
    public final io.qt.core.@NonNull QModelIndex filter(java.lang.@NonNull String filter) {
        return filter(filter, (String)null);
    }
}
