package io.qt.help;

import io.qt.*;


/**
 * <p>Filtered view of the help contents</p>
 * <p>Java wrapper for Qt class <code><a href="https://doc.qt.io/qt/qhelpfilterengine.html">QHelpFilterEngine</a></code></p>
 */
public class QHelpFilterEngine extends io.qt.core.QObject
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.@NonNull QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QHelpFilterEngine.class);
    

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qhelpfilterengine.html#filterActivated">QHelpFilterEngine::<wbr>filterActivated(QString)</a></code></p>
     */
    public final @NonNull Signal1<java.lang.@NonNull String> filterActivated = new Signal1<>();
    
    /**
     * <p>See <code>QHelpFilterEngine::<wbr>QHelpFilterEngine(QHelpEngineCore*)</code></p>
     */
    protected QHelpFilterEngine(io.qt.help.@Nullable QHelpEngineCore helpEngine){
        super((QPrivateConstructor)null);
        initialize_native(this, helpEngine);
    }
    
    private native static void initialize_native(QHelpFilterEngine instance, io.qt.help.QHelpEngineCore helpEngine);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qhelpfilterengine.html#activeFilter">QHelpFilterEngine::<wbr>activeFilter()const</a></code></p>
     */
    @QtUninvokable
    public final java.lang.@NonNull String activeFilter(){
        return activeFilter_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native java.lang.String activeFilter_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qhelpfilterengine.html#availableComponents">QHelpFilterEngine::<wbr>availableComponents()const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.core.@NonNull QStringList availableComponents(){
        return availableComponents_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QStringList availableComponents_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qhelpfilterengine.html#availableVersions">QHelpFilterEngine::<wbr>availableVersions()const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.core.@NonNull QList<io.qt.core.@NonNull QVersionNumber> availableVersions(){
        return availableVersions_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QList<io.qt.core.QVersionNumber> availableVersions_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qhelpfilterengine.html#filterData">QHelpFilterEngine::<wbr>filterData(QString)const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.help.@NonNull QHelpFilterData filterData(java.lang.@NonNull String filterName){
        return filterData_native_cref_QString_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), filterName);
    }
    
    @QtUninvokable
    private native io.qt.help.QHelpFilterData filterData_native_cref_QString_constfct(long __this__nativeId, java.lang.String filterName);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qhelpfilterengine.html#filters">QHelpFilterEngine::<wbr>filters()const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.core.@NonNull QStringList filters(){
        return filters_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QStringList filters_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qhelpfilterengine.html#indices">QHelpFilterEngine::<wbr>indices()const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.core.@NonNull QStringList indices(){
        return indices_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QStringList indices_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qhelpfilterengine.html#indices-1">QHelpFilterEngine::<wbr>indices(QString)const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.core.@NonNull QStringList indices(java.lang.@NonNull String filterName){
        return indices_native_cref_QString_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), filterName);
    }
    
    @QtUninvokable
    private native io.qt.core.QStringList indices_native_cref_QString_constfct(long __this__nativeId, java.lang.String filterName);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qhelpfilterengine.html#namespaceToComponent">QHelpFilterEngine::<wbr>namespaceToComponent()const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.core.@NonNull QMap<java.lang.@NonNull String, java.lang.@NonNull String> namespaceToComponent(){
        return namespaceToComponent_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QMap<java.lang.String, java.lang.String> namespaceToComponent_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qhelpfilterengine.html#namespaceToVersion">QHelpFilterEngine::<wbr>namespaceToVersion()const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.core.@NonNull QMap<java.lang.@NonNull String, io.qt.core.@NonNull QVersionNumber> namespaceToVersion(){
        return namespaceToVersion_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QMap<java.lang.String, io.qt.core.QVersionNumber> namespaceToVersion_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qhelpfilterengine.html#namespacesForFilter">QHelpFilterEngine::<wbr>namespacesForFilter(QString)const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.core.@NonNull QStringList namespacesForFilter(java.lang.@NonNull String filterName){
        return namespacesForFilter_native_cref_QString_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), filterName);
    }
    
    @QtUninvokable
    private native io.qt.core.QStringList namespacesForFilter_native_cref_QString_constfct(long __this__nativeId, java.lang.String filterName);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qhelpfilterengine.html#removeFilter">QHelpFilterEngine::<wbr>removeFilter(QString)</a></code></p>
     */
    @QtUninvokable
    public final boolean removeFilter(java.lang.@NonNull String filterName){
        return removeFilter_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), filterName);
    }
    
    @QtUninvokable
    private native boolean removeFilter_native_cref_QString(long __this__nativeId, java.lang.String filterName);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qhelpfilterengine.html#setActiveFilter">QHelpFilterEngine::<wbr>setActiveFilter(QString)</a></code></p>
     */
    @QtUninvokable
    public final boolean setActiveFilter(java.lang.@NonNull String filterName){
        return setActiveFilter_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), filterName);
    }
    
    @QtUninvokable
    private native boolean setActiveFilter_native_cref_QString(long __this__nativeId, java.lang.String filterName);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qhelpfilterengine.html#setFilterData">QHelpFilterEngine::<wbr>setFilterData(QString,<wbr>QHelpFilterData)</a></code></p>
     */
    @QtUninvokable
    public final boolean setFilterData(java.lang.@NonNull String filterName, io.qt.help.@NonNull QHelpFilterData filterData){
        return setFilterData_native_cref_QString_cref_QHelpFilterData(QtJambi_LibraryUtilities.internal.nativeId(this), filterName, QtJambi_LibraryUtilities.internal.checkedNativeId(filterData));
    }
    
    @QtUninvokable
    private native boolean setFilterData_native_cref_QString_cref_QHelpFilterData(long __this__nativeId, java.lang.String filterName, long filterData);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     * @hidden
     */
    @NativeAccess
    protected QHelpFilterEngine(QPrivateConstructor p) { super(p); } 
    
}
