package io.qt.help;

import io.qt.*;


/**
 * <p>Access to widgets reusable to integrate fulltext search as well as to index and search documentation</p>
 * <p>Java wrapper for Qt class <code><a href="https://doc.qt.io/qt/qhelpsearchengine.html">QHelpSearchEngine</a></code></p>
 */
public class QHelpSearchEngine extends io.qt.core.QObject
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.@NonNull QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QHelpSearchEngine.class);
    

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qhelpsearchengine.html#indexingFinished">QHelpSearchEngine::<wbr>indexingFinished()</a></code></p>
     */
    public final @NonNull Signal0 indexingFinished = new Signal0();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qhelpsearchengine.html#indexingStarted">QHelpSearchEngine::<wbr>indexingStarted()</a></code></p>
     */
    public final @NonNull Signal0 indexingStarted = new Signal0();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qhelpsearchengine.html#searchingFinished">QHelpSearchEngine::<wbr>searchingFinished(int)</a></code></p>
     */
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Integer> searchingFinished = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qhelpsearchengine.html#searchingStarted">QHelpSearchEngine::<wbr>searchingStarted()</a></code></p>
     */
    public final @NonNull Signal0 searchingStarted = new Signal0();
    
    /**
     * <p>Overloaded constructor for {@link #QHelpSearchEngine(io.qt.help.QHelpEngineCore, io.qt.core.QObject)}
     *  with <code>parent = null</code>.</p>
     */
    public QHelpSearchEngine(io.qt.help.@Nullable QHelpEngineCore helpEngine) {
        this(helpEngine, (io.qt.core.QObject)null);
    }
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qhelpsearchengine.html#QHelpSearchEngine">QHelpSearchEngine::<wbr>QHelpSearchEngine(QHelpEngineCore*,<wbr>QObject*)</a></code></p>
     */
    public QHelpSearchEngine(io.qt.help.@Nullable QHelpEngineCore helpEngine, io.qt.core.@Nullable QObject parent){
        super((QPrivateConstructor)null);
        initialize_native(this, helpEngine, parent);
        if (parent != null) QtJambi_LibraryUtilities.internal.setCppOwnership(this);
    }
    
    private native static void initialize_native(QHelpSearchEngine instance, io.qt.help.QHelpEngineCore helpEngine, io.qt.core.QObject parent);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qhelpsearchengine.html#cancelIndexing">QHelpSearchEngine::<wbr>cancelIndexing()</a></code></p>
     */
    public final void cancelIndexing(){
        cancelIndexing_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    private native void cancelIndexing_native(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qhelpsearchengine.html#cancelSearching">QHelpSearchEngine::<wbr>cancelSearching()</a></code></p>
     */
    public final void cancelSearching(){
        cancelSearching_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    private native void cancelSearching_native(long __this__nativeId);
    
    /**
     * <p>See <code>QHelpSearchEngine::<wbr>hitCount()const</code></p>
     */
    @QtUninvokable
    public final int hitCount(){
        return hitCount_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int hitCount_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code>QHelpSearchEngine::<wbr>hits(int,<wbr>int)const</code></p>
     */
    @QtUninvokable
    public final io.qt.core.@NonNull QList<io.qt.core.@NonNull QPair<java.lang.@NonNull String, java.lang.@NonNull String>> hits(int start, int end){
        return hits_native_int_int_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), start, end);
    }
    
    @QtUninvokable
    private native io.qt.core.QList<io.qt.core.QPair<java.lang.String, java.lang.String>> hits_native_int_int_constfct(long __this__nativeId, int start, int end);
    
    /**
     * <p>See <code>QHelpSearchEngine::<wbr>hitsCount()const</code></p>
     */
    @QtUninvokable
    public final int hitsCount(){
        return hitsCount_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int hitsCount_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code>QHelpSearchEngine::<wbr>query()const</code></p>
     */
    @QtUninvokable
    public final io.qt.core.@NonNull QList<io.qt.help.@NonNull QHelpSearchQuery> query(){
        return query_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QList<io.qt.help.QHelpSearchQuery> query_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qhelpsearchengine.html#queryWidget">QHelpSearchEngine::<wbr>queryWidget()</a></code></p>
     */
    @QtUninvokable
    public final io.qt.help.@Nullable QHelpSearchQueryWidget queryWidget(){
        return queryWidget_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.help.QHelpSearchQueryWidget queryWidget_native(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qhelpsearchengine.html#reindexDocumentation">QHelpSearchEngine::<wbr>reindexDocumentation()</a></code></p>
     */
    public final void reindexDocumentation(){
        reindexDocumentation_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    private native void reindexDocumentation_native(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qhelpsearchengine.html#resultWidget">QHelpSearchEngine::<wbr>resultWidget()</a></code></p>
     */
    @QtUninvokable
    public final io.qt.help.@Nullable QHelpSearchResultWidget resultWidget(){
        return resultWidget_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.help.QHelpSearchResultWidget resultWidget_native(long __this__nativeId);
    
    /**
     * <p>See <code>QHelpSearchEngine::<wbr>scheduleIndexDocumentation()</code></p>
     */
    public final void scheduleIndexDocumentation(){
        scheduleIndexDocumentation_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    private native void scheduleIndexDocumentation_native(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qhelpsearchengine.html#search-1">QHelpSearchEngine::<wbr>search(QList&lt;QHelpSearchQuery&gt;)</a></code></p>
     */
    public final void search(java.util.@NonNull Collection<? extends io.qt.help.@NonNull QHelpSearchQuery> queryList){
        search_native_cref_QList(QtJambi_LibraryUtilities.internal.nativeId(this), queryList);
    }
    
    private native void search_native_cref_QList(long __this__nativeId, java.util.Collection<? extends io.qt.help.QHelpSearchQuery> queryList);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qhelpsearchengine.html#search-1">QHelpSearchEngine::<wbr>search(QString)</a></code></p>
     */
    public final void search(java.lang.@NonNull String searchInput){
        search_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), searchInput);
    }
    
    private native void search_native_cref_QString(long __this__nativeId, java.lang.String searchInput);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qhelpsearchengine.html#searchInput">QHelpSearchEngine::<wbr>searchInput()const</a></code></p>
     */
    @QtUninvokable
    public final java.lang.@NonNull String searchInput(){
        return searchInput_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native java.lang.String searchInput_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qhelpsearchengine.html#searchResultCount">QHelpSearchEngine::<wbr>searchResultCount()const</a></code></p>
     */
    @QtUninvokable
    public final int searchResultCount(){
        return searchResultCount_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int searchResultCount_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qhelpsearchengine.html#searchResults">QHelpSearchEngine::<wbr>searchResults(int,<wbr>int)const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.core.@NonNull QList<io.qt.help.@NonNull QHelpSearchResult> searchResults(int start, int end){
        return searchResults_native_int_int_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), start, end);
    }
    
    @QtUninvokable
    private native io.qt.core.QList<io.qt.help.QHelpSearchResult> searchResults_native_int_int_constfct(long __this__nativeId, int start, int end);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     * @hidden
     */
    @NativeAccess
    protected QHelpSearchEngine(QPrivateConstructor p) { super(p); } 
    
}
