package io.qt.help;

import io.qt.*;


/**
 * <p>Widget that allows for creating, editing and removing filters</p>
 * <p>Java wrapper for Qt class <code><a href="https://doc.qt.io/qt/qhelpfiltersettingswidget.html">QHelpFilterSettingsWidget</a></code></p>
 */
public class QHelpFilterSettingsWidget extends io.qt.widgets.QWidget
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.@NonNull QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QHelpFilterSettingsWidget.class);
    
    
    /**
     * <p>Overloaded constructor for {@link #QHelpFilterSettingsWidget(io.qt.widgets.QWidget)}
     *  with <code>parent = null</code>.</p>
     */
    public QHelpFilterSettingsWidget() {
        this((io.qt.widgets.QWidget)null);
    }
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qhelpfiltersettingswidget.html#QHelpFilterSettingsWidget">QHelpFilterSettingsWidget::<wbr>QHelpFilterSettingsWidget(QWidget*)</a></code></p>
     */
    public QHelpFilterSettingsWidget(io.qt.widgets.@Nullable QWidget parent){
        super((QPrivateConstructor)null);
        initialize_native(this, parent);
    }
    
    private native static void initialize_native(QHelpFilterSettingsWidget instance, io.qt.widgets.QWidget parent);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qhelpfiltersettingswidget.html#applySettings">QHelpFilterSettingsWidget::<wbr>applySettings(QHelpFilterEngine*)const</a></code></p>
     */
    @QtUninvokable
    public final boolean applySettings(io.qt.help.@Nullable QHelpFilterEngine filterEngine){
        return applySettings_native_QHelpFilterEngine_ptr_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(filterEngine));
    }
    
    @QtUninvokable
    private native boolean applySettings_native_QHelpFilterEngine_ptr_constfct(long __this__nativeId, long filterEngine);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qhelpfiltersettingswidget.html#readSettings">QHelpFilterSettingsWidget::<wbr>readSettings(const QHelpFilterEngine*)</a></code></p>
     */
    @QtUninvokable
    public final void readSettings(io.qt.help.@Nullable QHelpFilterEngine filterEngine){
        readSettings_native_const_QHelpFilterEngine_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(filterEngine));
    }
    
    @QtUninvokable
    private native void readSettings_native_const_QHelpFilterEngine_ptr(long __this__nativeId, long filterEngine);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qhelpfiltersettingswidget.html#setAvailableComponents">QHelpFilterSettingsWidget::<wbr>setAvailableComponents(QStringList)</a></code></p>
     */
    @QtUninvokable
    public final void setAvailableComponents(java.util.@NonNull Collection<java.lang.@NonNull String> components){
        setAvailableComponents_native_cref_QStringList(QtJambi_LibraryUtilities.internal.nativeId(this), components);
    }
    
    @QtUninvokable
    private native void setAvailableComponents_native_cref_QStringList(long __this__nativeId, java.util.Collection<java.lang.String> components);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qhelpfiltersettingswidget.html#setAvailableVersions">QHelpFilterSettingsWidget::<wbr>setAvailableVersions(QList&lt;QVersionNumber&gt;)</a></code></p>
     */
    @QtUninvokable
    public final void setAvailableVersions(java.util.@NonNull Collection<? extends io.qt.core.@NonNull QVersionNumber> versions){
        setAvailableVersions_native_cref_QList(QtJambi_LibraryUtilities.internal.nativeId(this), versions);
    }
    
    @QtUninvokable
    private native void setAvailableVersions_native_cref_QList(long __this__nativeId, java.util.Collection<? extends io.qt.core.QVersionNumber> versions);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     * @hidden
     */
    @NativeAccess
    protected QHelpFilterSettingsWidget(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * @hidden
     * It is not allowed to call the declarative constructor from inside Java.
     */
    @NativeAccess
    protected QHelpFilterSettingsWidget(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @QtUninvokable
    private static native void initialize_native(QHelpFilterSettingsWidget instance, QDeclarativeConstructor constructor);
    
}
