package io.qt.help;


/**
 * <p>Access to widgets reusable to integrate fulltext search as well as to index and search documentation</p>
 * <p>Java wrapper for Qt's class <a href="https://doc.qt.io/qt/qhelpsearchengine.html">QHelpSearchEngine</a></p>
 */
public class QHelpSearchEngine extends io.qt.core.QObject
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QHelpSearchEngine.class);
    

    /**
     * <p>See <a href="https://doc.qt.io/qt/qhelpsearchengine.html#indexingFinished">QHelpSearchEngine::indexingFinished()</a></p>
     */
    public final Signal0 indexingFinished = new Signal0();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qhelpsearchengine.html#indexingStarted">QHelpSearchEngine::indexingStarted()</a></p>
     */
    public final Signal0 indexingStarted = new Signal0();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qhelpsearchengine.html#searchingFinished">QHelpSearchEngine::searchingFinished(int)</a></p>
     */
    public final Signal1<@io.qt.QtPrimitiveType Integer> searchingFinished = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qhelpsearchengine.html#searchingStarted">QHelpSearchEngine::searchingStarted()</a></p>
     */
    public final Signal0 searchingStarted = new Signal0();
    
    /**
     * <p>Overloaded constructor for {@link #QHelpSearchEngine(io.qt.help.QHelpEngineCore, io.qt.core.QObject)}
     *  with <code>parent = null</code>.</p>
     */
    public QHelpSearchEngine(io.qt.help.QHelpEngineCore helpEngine) {
        this(helpEngine, (io.qt.core.QObject)null);
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qhelpsearchengine.html#QHelpSearchEngine">QHelpSearchEngine::QHelpSearchEngine(QHelpEngineCore*,QObject*)</a></p>
     */
    public QHelpSearchEngine(io.qt.help.QHelpEngineCore helpEngine, io.qt.core.QObject parent){
        super((QPrivateConstructor)null);
        initialize_native(this, helpEngine, parent);
        if (parent != null) QtJambi_LibraryUtilities.internal.setCppOwnership(this);
    }
    
    private native static void initialize_native(QHelpSearchEngine instance, io.qt.help.QHelpEngineCore helpEngine, io.qt.core.QObject parent);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qhelpsearchengine.html#cancelIndexing">QHelpSearchEngine::cancelIndexing()</a></p>
     */
    public final void cancelIndexing(){
        cancelIndexing_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    private native void cancelIndexing_native(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qhelpsearchengine.html#cancelSearching">QHelpSearchEngine::cancelSearching()</a></p>
     */
    public final void cancelSearching(){
        cancelSearching_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    private native void cancelSearching_native(long __this__nativeId);
    
    @Deprecated
    @io.qt.QtUninvokable
    public final int hitCount(){
        return hitCount_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @Deprecated
    @io.qt.QtUninvokable
    private native int hitCount_native_constfct(long __this__nativeId);
    
    @Deprecated
    @io.qt.QtUninvokable
    public final io.qt.core.QList<io.qt.core.QPair<java.lang.String, java.lang.String>> hits(int start, int end){
        return hits_native_int_int_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), start, end);
    }
    
    @Deprecated
    @io.qt.QtUninvokable
    private native io.qt.core.QList<io.qt.core.QPair<java.lang.String, java.lang.String>> hits_native_int_int_constfct(long __this__nativeId, int start, int end);
    
    @Deprecated
    @io.qt.QtUninvokable
    public final int hitsCount(){
        return hitsCount_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @Deprecated
    @io.qt.QtUninvokable
    private native int hitsCount_native_constfct(long __this__nativeId);
    
    @Deprecated
    @io.qt.QtUninvokable
    public final io.qt.core.QList<io.qt.help.QHelpSearchQuery> query(){
        return query_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @Deprecated
    @io.qt.QtUninvokable
    private native io.qt.core.QList<io.qt.help.QHelpSearchQuery> query_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qhelpsearchengine.html#queryWidget">QHelpSearchEngine::queryWidget()</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.help.QHelpSearchQueryWidget queryWidget(){
        return queryWidget_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.help.QHelpSearchQueryWidget queryWidget_native(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qhelpsearchengine.html#reindexDocumentation">QHelpSearchEngine::reindexDocumentation()</a></p>
     */
    public final void reindexDocumentation(){
        reindexDocumentation_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    private native void reindexDocumentation_native(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qhelpsearchengine.html#resultWidget">QHelpSearchEngine::resultWidget()</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.help.QHelpSearchResultWidget resultWidget(){
        return resultWidget_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.help.QHelpSearchResultWidget resultWidget_native(long __this__nativeId);
    
    public final void scheduleIndexDocumentation(){
        scheduleIndexDocumentation_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    private native void scheduleIndexDocumentation_native(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qhelpsearchengine.html#search-1">QHelpSearchEngine::search(QList&lt;QHelpSearchQuery&gt;)</a></p>
     */
    @Deprecated
    public final void search(java.util.Collection<? extends io.qt.help.QHelpSearchQuery> queryList){
        search_native_cref_QList(QtJambi_LibraryUtilities.internal.nativeId(this), queryList);
    }
    
    @Deprecated
    private native void search_native_cref_QList(long __this__nativeId, java.util.Collection<? extends io.qt.help.QHelpSearchQuery> queryList);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qhelpsearchengine.html#search-1">QHelpSearchEngine::search(QString)</a></p>
     */
    public final void search(java.lang.String searchInput){
        search_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), searchInput);
    }
    
    private native void search_native_cref_QString(long __this__nativeId, java.lang.String searchInput);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qhelpsearchengine.html#searchInput">QHelpSearchEngine::searchInput()const</a></p>
     */
    @io.qt.QtUninvokable
    public final java.lang.String searchInput(){
        return searchInput_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native java.lang.String searchInput_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qhelpsearchengine.html#searchResultCount">QHelpSearchEngine::searchResultCount()const</a></p>
     */
    @io.qt.QtUninvokable
    public final int searchResultCount(){
        return searchResultCount_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native int searchResultCount_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qhelpsearchengine.html#searchResults">QHelpSearchEngine::searchResults(int,int)const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.core.QList<io.qt.help.QHelpSearchResult> searchResults(int start, int end){
        return searchResults_native_int_int_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), start, end);
    }
    
    @io.qt.QtUninvokable
    private native io.qt.core.QList<io.qt.help.QHelpSearchResult> searchResults_native_int_int_constfct(long __this__nativeId, int start, int end);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @io.qt.NativeAccess
    protected QHelpSearchEngine(QPrivateConstructor p) { super(p); } 
    
}
