package io.qt.help;


/**
 * <p>Struct provides the data associated with a help link</p>
 * <p>Java wrapper for Qt class <a href="https://doc.qt.io/qt/qhelplink.html">QHelpLink</a></p>
 */
public final class QHelpLink extends io.qt.QtObject
    implements java.lang.Cloneable
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    
    /**
     * <p>Of the link</p>
     * <p>See <a href="https://doc.qt.io/qt/qhelplink.html#title-var">QHelpLink::title</a></p>
     */
    @io.qt.QtUninvokable
    public final void setTitle(java.lang.String title){
        setTitle_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), title);
    }
    
    @io.qt.QtUninvokable
    private native void setTitle_native_cref_QString(long __this__nativeId, java.lang.String title);
    
    /**
     * <p>Of the link</p>
     * <p>See <a href="https://doc.qt.io/qt/qhelplink.html#title-var">QHelpLink::title</a></p>
     */
    @io.qt.QtUninvokable
    public final java.lang.String title(){
        return title_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native java.lang.String title_native(long __this__nativeId);
    
    /**
     * <p>Target url of the link</p>
     * <p>See <a href="https://doc.qt.io/qt/qhelplink.html#url-var">QHelpLink::url</a></p>
     */
    @io.qt.QtUninvokable
    public final void setUrl(io.qt.core.QUrl url){
        setUrl_native_cref_QUrl(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(url));
    }
    
    @io.qt.QtUninvokable
    private native void setUrl_native_cref_QUrl(long __this__nativeId, long url);
    
    /**
     * <p>Target url of the link</p>
     * <p>See <a href="https://doc.qt.io/qt/qhelplink.html#url-var">QHelpLink::url</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.core.QUrl url(){
        return url_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.core.QUrl url_native(long __this__nativeId);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @io.qt.NativeAccess
    protected QHelpLink(QPrivateConstructor p) { super(p); } 
    
    
    @Override
    public QHelpLink clone() {
        return clone_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    private native QHelpLink clone_native(long __this_nativeId);
}
