package io.qt.help;


/**
 * <p>Filtered view of the help contents</p>
 * <p>Java wrapper for Qt class <a href="https://doc.qt.io/qt/qhelpfilterengine.html">QHelpFilterEngine</a></p>
 */
public class QHelpFilterEngine extends io.qt.core.QObject
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QHelpFilterEngine.class);
    

    /**
     * <p>See <a href="https://doc.qt.io/qt/qhelpfilterengine.html#filterActivated">QHelpFilterEngine::filterActivated(QString)</a></p>
     */
    public final Signal1<java.lang.String> filterActivated = new Signal1<>();
    
    protected QHelpFilterEngine(io.qt.help.QHelpEngineCore helpEngine){
        super((QPrivateConstructor)null);
        initialize_native(this, helpEngine);
    }
    
    private native static void initialize_native(QHelpFilterEngine instance, io.qt.help.QHelpEngineCore helpEngine);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qhelpfilterengine.html#activeFilter">QHelpFilterEngine::activeFilter()const</a></p>
     */
    @io.qt.QtUninvokable
    public final java.lang.String activeFilter(){
        return activeFilter_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native java.lang.String activeFilter_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qhelpfilterengine.html#availableComponents">QHelpFilterEngine::availableComponents()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.core.QStringList availableComponents(){
        return availableComponents_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.core.QStringList availableComponents_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qhelpfilterengine.html#availableVersions">QHelpFilterEngine::availableVersions()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.core.QList<io.qt.core.QVersionNumber> availableVersions(){
        return availableVersions_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.core.QList<io.qt.core.QVersionNumber> availableVersions_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qhelpfilterengine.html#filterData">QHelpFilterEngine::filterData(QString)const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.help.QHelpFilterData filterData(java.lang.String filterName){
        return filterData_native_cref_QString_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), filterName);
    }
    
    @io.qt.QtUninvokable
    private native io.qt.help.QHelpFilterData filterData_native_cref_QString_constfct(long __this__nativeId, java.lang.String filterName);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qhelpfilterengine.html#filters">QHelpFilterEngine::filters()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.core.QStringList filters(){
        return filters_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.core.QStringList filters_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qhelpfilterengine.html#indices">QHelpFilterEngine::indices()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.core.QStringList indices(){
        return indices_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.core.QStringList indices_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qhelpfilterengine.html#indices-1">QHelpFilterEngine::indices(QString)const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.core.QStringList indices(java.lang.String filterName){
        return indices_native_cref_QString_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), filterName);
    }
    
    @io.qt.QtUninvokable
    private native io.qt.core.QStringList indices_native_cref_QString_constfct(long __this__nativeId, java.lang.String filterName);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qhelpfilterengine.html#namespaceToComponent">QHelpFilterEngine::namespaceToComponent()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.core.QMap<java.lang.String, java.lang.String> namespaceToComponent(){
        return namespaceToComponent_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.core.QMap<java.lang.String, java.lang.String> namespaceToComponent_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qhelpfilterengine.html#namespaceToVersion">QHelpFilterEngine::namespaceToVersion()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.core.QMap<java.lang.String, io.qt.core.QVersionNumber> namespaceToVersion(){
        return namespaceToVersion_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.core.QMap<java.lang.String, io.qt.core.QVersionNumber> namespaceToVersion_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qhelpfilterengine.html#namespacesForFilter">QHelpFilterEngine::namespacesForFilter(QString)const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.core.QStringList namespacesForFilter(java.lang.String filterName){
        return namespacesForFilter_native_cref_QString_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), filterName);
    }
    
    @io.qt.QtUninvokable
    private native io.qt.core.QStringList namespacesForFilter_native_cref_QString_constfct(long __this__nativeId, java.lang.String filterName);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qhelpfilterengine.html#removeFilter">QHelpFilterEngine::removeFilter(QString)</a></p>
     */
    @io.qt.QtUninvokable
    public final boolean removeFilter(java.lang.String filterName){
        return removeFilter_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), filterName);
    }
    
    @io.qt.QtUninvokable
    private native boolean removeFilter_native_cref_QString(long __this__nativeId, java.lang.String filterName);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qhelpfilterengine.html#setActiveFilter">QHelpFilterEngine::setActiveFilter(QString)</a></p>
     */
    @io.qt.QtUninvokable
    public final boolean setActiveFilter(java.lang.String filterName){
        return setActiveFilter_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), filterName);
    }
    
    @io.qt.QtUninvokable
    private native boolean setActiveFilter_native_cref_QString(long __this__nativeId, java.lang.String filterName);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qhelpfilterengine.html#setFilterData">QHelpFilterEngine::setFilterData(QString,QHelpFilterData)</a></p>
     */
    @io.qt.QtUninvokable
    public final boolean setFilterData(java.lang.String filterName, io.qt.help.QHelpFilterData filterData){
        return setFilterData_native_cref_QString_cref_QHelpFilterData(QtJambi_LibraryUtilities.internal.nativeId(this), filterName, QtJambi_LibraryUtilities.internal.checkedNativeId(filterData));
    }
    
    @io.qt.QtUninvokable
    private native boolean setFilterData_native_cref_QString_cref_QHelpFilterData(long __this__nativeId, java.lang.String filterName, long filterData);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @io.qt.NativeAccess
    protected QHelpFilterEngine(QPrivateConstructor p) { super(p); } 
    
}
