package io.qt.help;


/**
 * <p>The core functionality of the help system</p>
 * <p>Java wrapper for Qt class <a href="http://doc.qt.io/qt-5/qhelpenginecore.html">QHelpEngineCore</a></p>
 */
public class QHelpEngineCore extends io.qt.core.QObject
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QHelpEngineCore.class);
    

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qhelpenginecore-obsolete.html#currentFilterChanged">QHelpEngineCore::currentFilterChanged(QString)</a></p>
     */
    public final Signal1<java.lang.String> currentFilterChanged = new Signal1<>();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qhelpenginecore-obsolete.html#readersAboutToBeInvalidated">QHelpEngineCore::readersAboutToBeInvalidated()</a></p>
     */
    public final Signal0 readersAboutToBeInvalidated = new Signal0();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qhelpenginecore.html#setupFinished">QHelpEngineCore::setupFinished()</a></p>
     */
    public final Signal0 setupFinished = new Signal0();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qhelpenginecore.html#setupStarted">QHelpEngineCore::setupStarted()</a></p>
     */
    public final Signal0 setupStarted = new Signal0();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qhelpenginecore.html#warning">QHelpEngineCore::warning(QString)</a></p>
     */
    public final Signal1<java.lang.String> warning = new Signal1<>();
    
    /**
     * <p>Overloaded constructor for {@link #QHelpEngineCore(java.lang.String, io.qt.core.QObject)}
     *  with <code>parent = null</code>.</p>
     */
    public QHelpEngineCore(java.lang.String collectionFile) {
        this(collectionFile, (io.qt.core.QObject)null);
    }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qhelpenginecore.html#QHelpEngineCore">QHelpEngineCore::QHelpEngineCore(QString,QObject*)</a></p>
     */
    public QHelpEngineCore(java.lang.String collectionFile, io.qt.core.QObject parent){
        super((QPrivateConstructor)null);
        initialize_native(this, collectionFile, parent);
        if (parent != null) QtJambi_LibraryUtilities.internal.setCppOwnership(this);
    }
    
    private native static void initialize_native(QHelpEngineCore instance, java.lang.String collectionFile, io.qt.core.QObject parent);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qhelpenginecore-obsolete.html#addCustomFilter">QHelpEngineCore::addCustomFilter(QString,QStringList)</a></p>
     */
    @io.qt.QtUninvokable
    public final boolean addCustomFilter(java.lang.String filterName, java.util.Collection<java.lang.String> attributes){
        return addCustomFilter_native_cref_QString_cref_QStringList(QtJambi_LibraryUtilities.internal.nativeId(this), filterName, attributes);
    }
    
    @io.qt.QtUninvokable
    private native boolean addCustomFilter_native_cref_QString_cref_QStringList(long __this__nativeId, java.lang.String filterName, java.util.Collection<java.lang.String> attributes);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qhelpenginecore.html#autoSaveFilter-prop">QHelpEngineCore::autoSaveFilter()const</a></p>
     */
    @io.qt.QtPropertyReader(name="autoSaveFilter")
    @io.qt.QtUninvokable
    public final boolean autoSaveFilter(){
        return autoSaveFilter_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean autoSaveFilter_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qhelpenginecore.html#collectionFile-prop">QHelpEngineCore::collectionFile()const</a></p>
     */
    @io.qt.QtPropertyReader(name="collectionFile")
    @io.qt.QtUninvokable
    public final java.lang.String collectionFile(){
        return collectionFile_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native java.lang.String collectionFile_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qhelpenginecore.html#copyCollectionFile">QHelpEngineCore::copyCollectionFile(QString)</a></p>
     */
    @io.qt.QtUninvokable
    public final boolean copyCollectionFile(java.lang.String fileName){
        return copyCollectionFile_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), fileName);
    }
    
    @io.qt.QtUninvokable
    private native boolean copyCollectionFile_native_cref_QString(long __this__nativeId, java.lang.String fileName);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qhelpenginecore-obsolete.html#currentFilter-prop">QHelpEngineCore::currentFilter()const</a></p>
     */
    @io.qt.QtPropertyReader(name="currentFilter")
    @io.qt.QtUninvokable
    public final java.lang.String currentFilter(){
        return currentFilter_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native java.lang.String currentFilter_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qhelpenginecore-obsolete.html#customFilters">QHelpEngineCore::customFilters()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.core.QStringList customFilters(){
        return customFilters_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.core.QStringList customFilters_native_constfct(long __this__nativeId);
    
    /**
     * <p>Overloaded function for {@link #customValue(java.lang.String, java.lang.Object)}
     *  with <code>defaultValue = null</code>.</p>
     */
    @io.qt.QtUninvokable
    public final java.lang.Object customValue(java.lang.String key) {
        return customValue(key, (java.lang.Object)null);
    }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qhelpenginecore.html#customValue">QHelpEngineCore::customValue(QString,QVariant)const</a></p>
     */
    @io.qt.QtUninvokable
    public final java.lang.Object customValue(java.lang.String key, java.lang.Object defaultValue){
        return customValue_native_cref_QString_cref_QVariant_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), key, defaultValue);
    }
    
    @io.qt.QtUninvokable
    private native java.lang.Object customValue_native_cref_QString_cref_QVariant_constfct(long __this__nativeId, java.lang.String key, java.lang.Object defaultValue);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qhelpenginecore.html#documentationFileName">QHelpEngineCore::documentationFileName(QString)</a></p>
     */
    @io.qt.QtUninvokable
    public final java.lang.String documentationFileName(java.lang.String namespaceName){
        return documentationFileName_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), namespaceName);
    }
    
    @io.qt.QtUninvokable
    private native java.lang.String documentationFileName_native_cref_QString(long __this__nativeId, java.lang.String namespaceName);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qhelpenginecore.html#documentsForIdentifier">QHelpEngineCore::documentsForIdentifier(QString)const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.core.QList<io.qt.help.QHelpLink> documentsForIdentifier(java.lang.String id){
        return documentsForIdentifier_native_cref_QString_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), id);
    }
    
    @io.qt.QtUninvokable
    private native io.qt.core.QList<io.qt.help.QHelpLink> documentsForIdentifier_native_cref_QString_constfct(long __this__nativeId, java.lang.String id);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qhelpenginecore.html#documentsForIdentifier-1">QHelpEngineCore::documentsForIdentifier(QString,QString)const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.core.QList<io.qt.help.QHelpLink> documentsForIdentifier(java.lang.String id, java.lang.String filterName){
        return documentsForIdentifier_native_cref_QString_cref_QString_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), id, filterName);
    }
    
    @io.qt.QtUninvokable
    private native io.qt.core.QList<io.qt.help.QHelpLink> documentsForIdentifier_native_cref_QString_cref_QString_constfct(long __this__nativeId, java.lang.String id, java.lang.String filterName);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qhelpenginecore.html#documentsForKeyword">QHelpEngineCore::documentsForKeyword(QString)const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.core.QList<io.qt.help.QHelpLink> documentsForKeyword(java.lang.String keyword){
        return documentsForKeyword_native_cref_QString_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), keyword);
    }
    
    @io.qt.QtUninvokable
    private native io.qt.core.QList<io.qt.help.QHelpLink> documentsForKeyword_native_cref_QString_constfct(long __this__nativeId, java.lang.String keyword);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qhelpenginecore.html#documentsForKeyword-1">QHelpEngineCore::documentsForKeyword(QString,QString)const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.core.QList<io.qt.help.QHelpLink> documentsForKeyword(java.lang.String keyword, java.lang.String filterName){
        return documentsForKeyword_native_cref_QString_cref_QString_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), keyword, filterName);
    }
    
    @io.qt.QtUninvokable
    private native io.qt.core.QList<io.qt.help.QHelpLink> documentsForKeyword_native_cref_QString_cref_QString_constfct(long __this__nativeId, java.lang.String keyword, java.lang.String filterName);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qhelpenginecore.html#error">QHelpEngineCore::error()const</a></p>
     */
    @io.qt.QtUninvokable
    public final java.lang.String error(){
        return error_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native java.lang.String error_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qhelpenginecore.html#fileData">QHelpEngineCore::fileData(QUrl)const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.core.QByteArray fileData(io.qt.core.QUrl url){
        return fileData_native_cref_QUrl_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(url));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.core.QByteArray fileData_native_cref_QUrl_constfct(long __this__nativeId, long url);
    
    /**
     * <p>Overloaded function for {@link #files(java.lang.String, java.lang.String, java.lang.String)}
     *  with <code>extensionFilter = ""</code>.</p>
     */
    @io.qt.QtUninvokable
    public final io.qt.core.QList<io.qt.core.QUrl> files(java.lang.String namespaceName, java.lang.String filterName) {
        return files(namespaceName, filterName, "");
    }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qhelpenginecore.html#files-1">QHelpEngineCore::files(QString,QString,QString)</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.core.QList<io.qt.core.QUrl> files(java.lang.String namespaceName, java.lang.String filterName, java.lang.String extensionFilter){
        return files_native_const_QString_cref_QString_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), namespaceName, filterName, extensionFilter);
    }
    
    @io.qt.QtUninvokable
    private native io.qt.core.QList<io.qt.core.QUrl> files_native_const_QString_cref_QString_cref_QString(long __this__nativeId, java.lang.String namespaceName, java.lang.String filterName, java.lang.String extensionFilter);
    
    /**
     * <p>Overloaded function for {@link #files(java.lang.String, java.util.Collection, java.lang.String)}
     *  with <code>extensionFilter = ""</code>.</p>
     */
    @io.qt.QtUninvokable
    public final io.qt.core.QList<io.qt.core.QUrl> files(java.lang.String namespaceName, java.util.Collection<java.lang.String> filterAttributes) {
        return files(namespaceName, filterAttributes, "");
    }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qhelpenginecore-obsolete.html#files">QHelpEngineCore::files(QString,QStringList,QString)</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.core.QList<io.qt.core.QUrl> files(java.lang.String namespaceName, java.util.Collection<java.lang.String> filterAttributes, java.lang.String extensionFilter){
        return files_native_const_QString_cref_QStringList_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), namespaceName, filterAttributes, extensionFilter);
    }
    
    @io.qt.QtUninvokable
    private native io.qt.core.QList<io.qt.core.QUrl> files_native_const_QString_cref_QStringList_cref_QString(long __this__nativeId, java.lang.String namespaceName, java.util.Collection<java.lang.String> filterAttributes, java.lang.String extensionFilter);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qhelpenginecore-obsolete.html#filterAttributeSets">QHelpEngineCore::filterAttributeSets(QString)const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.core.QList<java.util.List<java.lang.String>> filterAttributeSets(java.lang.String namespaceName){
        return filterAttributeSets_native_cref_QString_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), namespaceName);
    }
    
    @io.qt.QtUninvokable
    private native io.qt.core.QList<java.util.List<java.lang.String>> filterAttributeSets_native_cref_QString_constfct(long __this__nativeId, java.lang.String namespaceName);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qhelpenginecore-obsolete.html#filterAttributes">QHelpEngineCore::filterAttributes()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.core.QStringList filterAttributes(){
        return filterAttributes_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.core.QStringList filterAttributes_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qhelpenginecore-obsolete.html#filterAttributes-1">QHelpEngineCore::filterAttributes(QString)const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.core.QStringList filterAttributes(java.lang.String filterName){
        return filterAttributes_native_cref_QString_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), filterName);
    }
    
    @io.qt.QtUninvokable
    private native io.qt.core.QStringList filterAttributes_native_cref_QString_constfct(long __this__nativeId, java.lang.String filterName);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qhelpenginecore.html#filterEngine">QHelpEngineCore::filterEngine()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.help.QHelpFilterEngine filterEngine(){
        return filterEngine_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.help.QHelpFilterEngine filterEngine_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qhelpenginecore.html#findFile">QHelpEngineCore::findFile(QUrl)const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.core.QUrl findFile(io.qt.core.QUrl url){
        return findFile_native_cref_QUrl_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(url));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.core.QUrl findFile_native_cref_QUrl_constfct(long __this__nativeId, long url);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qhelpenginecore-obsolete.html#linksForIdentifier">QHelpEngineCore::linksForIdentifier(QString)const</a></p>
     * 
     * @deprecated Use {@link io.qt.help.QHelpEngineCore#documentsForIdentifier(java.lang.String)} instead
     */
    @Deprecated
    @io.qt.QtUninvokable
    public final io.qt.core.QMap<java.lang.String, io.qt.core.QUrl> linksForIdentifier(java.lang.String id){
        return linksForIdentifier_native_cref_QString_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), id);
    }
    
    @Deprecated
    @io.qt.QtUninvokable
    private native io.qt.core.QMap<java.lang.String, io.qt.core.QUrl> linksForIdentifier_native_cref_QString_constfct(long __this__nativeId, java.lang.String id);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qhelpenginecore-obsolete.html#linksForKeyword">QHelpEngineCore::linksForKeyword(QString)const</a></p>
     * 
     * @deprecated Use {@link io.qt.help.QHelpEngineCore#documentsForKeyword(java.lang.String)} instead
     */
    @Deprecated
    @io.qt.QtUninvokable
    public final io.qt.core.QMap<java.lang.String, io.qt.core.QUrl> linksForKeyword(java.lang.String keyword){
        return linksForKeyword_native_cref_QString_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), keyword);
    }
    
    @Deprecated
    @io.qt.QtUninvokable
    private native io.qt.core.QMap<java.lang.String, io.qt.core.QUrl> linksForKeyword_native_cref_QString_constfct(long __this__nativeId, java.lang.String keyword);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qhelpenginecore.html#registerDocumentation">QHelpEngineCore::registerDocumentation(QString)</a></p>
     */
    @io.qt.QtUninvokable
    public final boolean registerDocumentation(java.lang.String documentationFileName){
        return registerDocumentation_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), documentationFileName);
    }
    
    @io.qt.QtUninvokable
    private native boolean registerDocumentation_native_cref_QString(long __this__nativeId, java.lang.String documentationFileName);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qhelpenginecore.html#registeredDocumentations">QHelpEngineCore::registeredDocumentations()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.core.QStringList registeredDocumentations(){
        return registeredDocumentations_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.core.QStringList registeredDocumentations_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qhelpenginecore-obsolete.html#removeCustomFilter">QHelpEngineCore::removeCustomFilter(QString)</a></p>
     */
    @io.qt.QtUninvokable
    public final boolean removeCustomFilter(java.lang.String filterName){
        return removeCustomFilter_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), filterName);
    }
    
    @io.qt.QtUninvokable
    private native boolean removeCustomFilter_native_cref_QString(long __this__nativeId, java.lang.String filterName);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qhelpenginecore.html#removeCustomValue">QHelpEngineCore::removeCustomValue(QString)</a></p>
     */
    @io.qt.QtUninvokable
    public final boolean removeCustomValue(java.lang.String key){
        return removeCustomValue_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), key);
    }
    
    @io.qt.QtUninvokable
    private native boolean removeCustomValue_native_cref_QString(long __this__nativeId, java.lang.String key);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qhelpenginecore.html#autoSaveFilter-prop">QHelpEngineCore::setAutoSaveFilter(bool)</a></p>
     */
    @io.qt.QtPropertyWriter(name="autoSaveFilter")
    @io.qt.QtUninvokable
    public final void setAutoSaveFilter(boolean save){
        setAutoSaveFilter_native_bool(QtJambi_LibraryUtilities.internal.nativeId(this), save);
    }
    
    @io.qt.QtUninvokable
    private native void setAutoSaveFilter_native_bool(long __this__nativeId, boolean save);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qhelpenginecore.html#collectionFile-prop">QHelpEngineCore::setCollectionFile(QString)</a></p>
     */
    @io.qt.QtPropertyWriter(name="collectionFile")
    @io.qt.QtUninvokable
    public final void setCollectionFile(java.lang.String fileName){
        setCollectionFile_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), fileName);
    }
    
    @io.qt.QtUninvokable
    private native void setCollectionFile_native_cref_QString(long __this__nativeId, java.lang.String fileName);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qhelpenginecore-obsolete.html#currentFilter-prop">QHelpEngineCore::setCurrentFilter(QString)</a></p>
     */
    @io.qt.QtPropertyWriter(name="currentFilter")
    @io.qt.QtUninvokable
    public final void setCurrentFilter(java.lang.String filterName){
        setCurrentFilter_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), filterName);
    }
    
    @io.qt.QtUninvokable
    private native void setCurrentFilter_native_cref_QString(long __this__nativeId, java.lang.String filterName);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qhelpenginecore.html#setCustomValue">QHelpEngineCore::setCustomValue(QString,QVariant)</a></p>
     */
    @io.qt.QtUninvokable
    public final boolean setCustomValue(java.lang.String key, java.lang.Object value){
        return setCustomValue_native_cref_QString_cref_QVariant(QtJambi_LibraryUtilities.internal.nativeId(this), key, value);
    }
    
    @io.qt.QtUninvokable
    private native boolean setCustomValue_native_cref_QString_cref_QVariant(long __this__nativeId, java.lang.String key, java.lang.Object value);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qhelpenginecore.html#setUsesFilterEngine">QHelpEngineCore::setUsesFilterEngine(bool)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setUsesFilterEngine(boolean uses){
        setUsesFilterEngine_native_bool(QtJambi_LibraryUtilities.internal.nativeId(this), uses);
    }
    
    @io.qt.QtUninvokable
    private native void setUsesFilterEngine_native_bool(long __this__nativeId, boolean uses);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qhelpenginecore.html#setupData">QHelpEngineCore::setupData()</a></p>
     */
    @io.qt.QtUninvokable
    public final boolean setupData(){
        return setupData_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean setupData_native(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qhelpenginecore.html#unregisterDocumentation">QHelpEngineCore::unregisterDocumentation(QString)</a></p>
     */
    @io.qt.QtUninvokable
    public final boolean unregisterDocumentation(java.lang.String namespaceName){
        return unregisterDocumentation_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), namespaceName);
    }
    
    @io.qt.QtUninvokable
    private native boolean unregisterDocumentation_native_cref_QString(long __this__nativeId, java.lang.String namespaceName);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qhelpenginecore.html#usesFilterEngine">QHelpEngineCore::usesFilterEngine()const</a></p>
     */
    @io.qt.QtUninvokable
    public final boolean usesFilterEngine(){
        return usesFilterEngine_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean usesFilterEngine_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qhelpenginecore.html#metaData">QHelpEngineCore::metaData(QString,QString)</a></p>
     */
    public native static java.lang.Object metaData(java.lang.String documentationFileName, java.lang.String name);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qhelpenginecore.html#namespaceName">QHelpEngineCore::namespaceName(QString)</a></p>
     */
    public native static java.lang.String namespaceName(java.lang.String documentationFileName);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @io.qt.NativeAccess
    protected QHelpEngineCore(QPrivateConstructor p) { super(p); } 
    
}
