package io.qt.gamepad;


/**
 * <p>A gamepad device connected to a system</p>
 * <p>Java wrapper for Qt class <a href="http://doc.qt.io/qt-5/qgamepad.html">QGamepad</a></p>
 */
public class QGamepad extends io.qt.core.QObject
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QGamepad.class);
    

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qgamepad.html#axisLeftX-prop">QGamepad::axisLeftXChanged(double)</a></p>
     */
    @io.qt.QtPropertyNotify(name="axisLeftX")
    public final Signal1<@io.qt.QtPrimitiveType Double> axisLeftXChanged = new Signal1<>();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qgamepad.html#axisLeftY-prop">QGamepad::axisLeftYChanged(double)</a></p>
     */
    @io.qt.QtPropertyNotify(name="axisLeftY")
    public final Signal1<@io.qt.QtPrimitiveType Double> axisLeftYChanged = new Signal1<>();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qgamepad.html#axisRightX-prop">QGamepad::axisRightXChanged(double)</a></p>
     */
    @io.qt.QtPropertyNotify(name="axisRightX")
    public final Signal1<@io.qt.QtPrimitiveType Double> axisRightXChanged = new Signal1<>();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qgamepad.html#axisRightY-prop">QGamepad::axisRightYChanged(double)</a></p>
     */
    @io.qt.QtPropertyNotify(name="axisRightY")
    public final Signal1<@io.qt.QtPrimitiveType Double> axisRightYChanged = new Signal1<>();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qgamepad.html#buttonA-prop">QGamepad::buttonAChanged(bool)</a></p>
     */
    @io.qt.QtPropertyNotify(name="buttonA")
    public final Signal1<@io.qt.QtPrimitiveType Boolean> buttonAChanged = new Signal1<>();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qgamepad.html#buttonB-prop">QGamepad::buttonBChanged(bool)</a></p>
     */
    @io.qt.QtPropertyNotify(name="buttonB")
    public final Signal1<@io.qt.QtPrimitiveType Boolean> buttonBChanged = new Signal1<>();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qgamepad.html#buttonCenter-prop">QGamepad::buttonCenterChanged(bool)</a></p>
     */
    @io.qt.QtPropertyNotify(name="buttonCenter")
    public final Signal1<@io.qt.QtPrimitiveType Boolean> buttonCenterChanged = new Signal1<>();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qgamepad.html#buttonDown-prop">QGamepad::buttonDownChanged(bool)</a></p>
     */
    @io.qt.QtPropertyNotify(name="buttonDown")
    public final Signal1<@io.qt.QtPrimitiveType Boolean> buttonDownChanged = new Signal1<>();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qgamepad.html#buttonGuide-prop">QGamepad::buttonGuideChanged(bool)</a></p>
     */
    @io.qt.QtPropertyNotify(name="buttonGuide")
    public final Signal1<@io.qt.QtPrimitiveType Boolean> buttonGuideChanged = new Signal1<>();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qgamepad.html#buttonL1-prop">QGamepad::buttonL1Changed(bool)</a></p>
     */
    @io.qt.QtPropertyNotify(name="buttonL1")
    public final Signal1<@io.qt.QtPrimitiveType Boolean> buttonL1Changed = new Signal1<>();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qgamepad.html#buttonL2-prop">QGamepad::buttonL2Changed(double)</a></p>
     */
    @io.qt.QtPropertyNotify(name="buttonL2")
    public final Signal1<@io.qt.QtPrimitiveType Double> buttonL2Changed = new Signal1<>();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qgamepad.html#buttonL3-prop">QGamepad::buttonL3Changed(bool)</a></p>
     */
    @io.qt.QtPropertyNotify(name="buttonL3")
    public final Signal1<@io.qt.QtPrimitiveType Boolean> buttonL3Changed = new Signal1<>();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qgamepad.html#buttonLeft-prop">QGamepad::buttonLeftChanged(bool)</a></p>
     */
    @io.qt.QtPropertyNotify(name="buttonLeft")
    public final Signal1<@io.qt.QtPrimitiveType Boolean> buttonLeftChanged = new Signal1<>();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qgamepad.html#buttonR1-prop">QGamepad::buttonR1Changed(bool)</a></p>
     */
    @io.qt.QtPropertyNotify(name="buttonR1")
    public final Signal1<@io.qt.QtPrimitiveType Boolean> buttonR1Changed = new Signal1<>();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qgamepad.html#buttonR2-prop">QGamepad::buttonR2Changed(double)</a></p>
     */
    @io.qt.QtPropertyNotify(name="buttonR2")
    public final Signal1<@io.qt.QtPrimitiveType Double> buttonR2Changed = new Signal1<>();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qgamepad.html#buttonR3-prop">QGamepad::buttonR3Changed(bool)</a></p>
     */
    @io.qt.QtPropertyNotify(name="buttonR3")
    public final Signal1<@io.qt.QtPrimitiveType Boolean> buttonR3Changed = new Signal1<>();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qgamepad.html#buttonRight-prop">QGamepad::buttonRightChanged(bool)</a></p>
     */
    @io.qt.QtPropertyNotify(name="buttonRight")
    public final Signal1<@io.qt.QtPrimitiveType Boolean> buttonRightChanged = new Signal1<>();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qgamepad.html#buttonSelect-prop">QGamepad::buttonSelectChanged(bool)</a></p>
     */
    @io.qt.QtPropertyNotify(name="buttonSelect")
    public final Signal1<@io.qt.QtPrimitiveType Boolean> buttonSelectChanged = new Signal1<>();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qgamepad.html#buttonStart-prop">QGamepad::buttonStartChanged(bool)</a></p>
     */
    @io.qt.QtPropertyNotify(name="buttonStart")
    public final Signal1<@io.qt.QtPrimitiveType Boolean> buttonStartChanged = new Signal1<>();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qgamepad.html#buttonUp-prop">QGamepad::buttonUpChanged(bool)</a></p>
     */
    @io.qt.QtPropertyNotify(name="buttonUp")
    public final Signal1<@io.qt.QtPrimitiveType Boolean> buttonUpChanged = new Signal1<>();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qgamepad.html#buttonX-prop">QGamepad::buttonXChanged(bool)</a></p>
     */
    @io.qt.QtPropertyNotify(name="buttonX")
    public final Signal1<@io.qt.QtPrimitiveType Boolean> buttonXChanged = new Signal1<>();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qgamepad.html#buttonY-prop">QGamepad::buttonYChanged(bool)</a></p>
     */
    @io.qt.QtPropertyNotify(name="buttonY")
    public final Signal1<@io.qt.QtPrimitiveType Boolean> buttonYChanged = new Signal1<>();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qgamepad.html#connected-prop">QGamepad::connectedChanged(bool)</a></p>
     */
    @io.qt.QtPropertyNotify(name="connected")
    public final Signal1<@io.qt.QtPrimitiveType Boolean> connectedChanged = new Signal1<>();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qgamepad.html#deviceId-prop">QGamepad::deviceIdChanged(int)</a></p>
     */
    @io.qt.QtPropertyNotify(name="deviceId")
    public final Signal1<@io.qt.QtPrimitiveType Integer> deviceIdChanged = new Signal1<>();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qgamepad.html#name-prop">QGamepad::nameChanged(QString)</a></p>
     */
    @io.qt.QtPropertyNotify(name="name")
    public final Signal1<java.lang.String> nameChanged = new Signal1<>();
    
    /**
     * <p>Overloaded constructor for {@link #QGamepad(int, io.qt.core.QObject)}
     *  with <code>parent = null</code>.</p>
     */
    public QGamepad(int deviceId) {
        this(deviceId, (io.qt.core.QObject)null);
    }
    
    /**
     * <p>Overloaded constructor for {@link #QGamepad(int, io.qt.core.QObject)}</p>
     * <p>with: </p><ul>
     * <li><code>deviceId = 0</code></li>
     * <li><code>parent = null</code></li>
     * </ul>
     */
    public QGamepad() {
        this((int)0, (io.qt.core.QObject)null);
    }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qgamepad.html#QGamepad">QGamepad::QGamepad(int,QObject*)</a></p>
     */
    public QGamepad(int deviceId, io.qt.core.QObject parent){
        super((QPrivateConstructor)null);
        initialize_native(this, deviceId, parent);
    }
    
    private native static void initialize_native(QGamepad instance, int deviceId, io.qt.core.QObject parent);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qgamepad.html#axisLeftX-prop">QGamepad::axisLeftX()const</a></p>
     */
    @io.qt.QtPropertyReader(name="axisLeftX")
    @io.qt.QtUninvokable
    public final double axisLeftX(){
        return axisLeftX_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native double axisLeftX_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qgamepad.html#axisLeftY-prop">QGamepad::axisLeftY()const</a></p>
     */
    @io.qt.QtPropertyReader(name="axisLeftY")
    @io.qt.QtUninvokable
    public final double axisLeftY(){
        return axisLeftY_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native double axisLeftY_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qgamepad.html#axisRightX-prop">QGamepad::axisRightX()const</a></p>
     */
    @io.qt.QtPropertyReader(name="axisRightX")
    @io.qt.QtUninvokable
    public final double axisRightX(){
        return axisRightX_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native double axisRightX_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qgamepad.html#axisRightY-prop">QGamepad::axisRightY()const</a></p>
     */
    @io.qt.QtPropertyReader(name="axisRightY")
    @io.qt.QtUninvokable
    public final double axisRightY(){
        return axisRightY_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native double axisRightY_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qgamepad.html#buttonA-prop">QGamepad::buttonA()const</a></p>
     */
    @io.qt.QtPropertyReader(name="buttonA")
    @io.qt.QtUninvokable
    public final boolean buttonA(){
        return buttonA_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean buttonA_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qgamepad.html#buttonB-prop">QGamepad::buttonB()const</a></p>
     */
    @io.qt.QtPropertyReader(name="buttonB")
    @io.qt.QtUninvokable
    public final boolean buttonB(){
        return buttonB_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean buttonB_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qgamepad.html#buttonCenter-prop">QGamepad::buttonCenter()const</a></p>
     */
    @io.qt.QtPropertyReader(name="buttonCenter")
    @io.qt.QtUninvokable
    public final boolean buttonCenter(){
        return buttonCenter_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean buttonCenter_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qgamepad.html#buttonDown-prop">QGamepad::buttonDown()const</a></p>
     */
    @io.qt.QtPropertyReader(name="buttonDown")
    @io.qt.QtUninvokable
    public final boolean buttonDown(){
        return buttonDown_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean buttonDown_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qgamepad.html#buttonGuide-prop">QGamepad::buttonGuide()const</a></p>
     */
    @io.qt.QtPropertyReader(name="buttonGuide")
    @io.qt.QtUninvokable
    public final boolean buttonGuide(){
        return buttonGuide_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean buttonGuide_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qgamepad.html#buttonL1-prop">QGamepad::buttonL1()const</a></p>
     */
    @io.qt.QtPropertyReader(name="buttonL1")
    @io.qt.QtUninvokable
    public final boolean buttonL1(){
        return buttonL1_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean buttonL1_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qgamepad.html#buttonL2-prop">QGamepad::buttonL2()const</a></p>
     */
    @io.qt.QtPropertyReader(name="buttonL2")
    @io.qt.QtUninvokable
    public final double buttonL2(){
        return buttonL2_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native double buttonL2_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qgamepad.html#buttonL3-prop">QGamepad::buttonL3()const</a></p>
     */
    @io.qt.QtPropertyReader(name="buttonL3")
    @io.qt.QtUninvokable
    public final boolean buttonL3(){
        return buttonL3_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean buttonL3_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qgamepad.html#buttonLeft-prop">QGamepad::buttonLeft()const</a></p>
     */
    @io.qt.QtPropertyReader(name="buttonLeft")
    @io.qt.QtUninvokable
    public final boolean buttonLeft(){
        return buttonLeft_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean buttonLeft_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qgamepad.html#buttonR1-prop">QGamepad::buttonR1()const</a></p>
     */
    @io.qt.QtPropertyReader(name="buttonR1")
    @io.qt.QtUninvokable
    public final boolean buttonR1(){
        return buttonR1_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean buttonR1_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qgamepad.html#buttonR2-prop">QGamepad::buttonR2()const</a></p>
     */
    @io.qt.QtPropertyReader(name="buttonR2")
    @io.qt.QtUninvokable
    public final double buttonR2(){
        return buttonR2_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native double buttonR2_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qgamepad.html#buttonR3-prop">QGamepad::buttonR3()const</a></p>
     */
    @io.qt.QtPropertyReader(name="buttonR3")
    @io.qt.QtUninvokable
    public final boolean buttonR3(){
        return buttonR3_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean buttonR3_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qgamepad.html#buttonRight-prop">QGamepad::buttonRight()const</a></p>
     */
    @io.qt.QtPropertyReader(name="buttonRight")
    @io.qt.QtUninvokable
    public final boolean buttonRight(){
        return buttonRight_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean buttonRight_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qgamepad.html#buttonSelect-prop">QGamepad::buttonSelect()const</a></p>
     */
    @io.qt.QtPropertyReader(name="buttonSelect")
    @io.qt.QtUninvokable
    public final boolean buttonSelect(){
        return buttonSelect_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean buttonSelect_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qgamepad.html#buttonStart-prop">QGamepad::buttonStart()const</a></p>
     */
    @io.qt.QtPropertyReader(name="buttonStart")
    @io.qt.QtUninvokable
    public final boolean buttonStart(){
        return buttonStart_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean buttonStart_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qgamepad.html#buttonUp-prop">QGamepad::buttonUp()const</a></p>
     */
    @io.qt.QtPropertyReader(name="buttonUp")
    @io.qt.QtUninvokable
    public final boolean buttonUp(){
        return buttonUp_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean buttonUp_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qgamepad.html#buttonX-prop">QGamepad::buttonX()const</a></p>
     */
    @io.qt.QtPropertyReader(name="buttonX")
    @io.qt.QtUninvokable
    public final boolean buttonX(){
        return buttonX_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean buttonX_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qgamepad.html#buttonY-prop">QGamepad::buttonY()const</a></p>
     */
    @io.qt.QtPropertyReader(name="buttonY")
    @io.qt.QtUninvokable
    public final boolean buttonY(){
        return buttonY_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean buttonY_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qgamepad.html#deviceId-prop">QGamepad::deviceId()const</a></p>
     */
    @io.qt.QtPropertyReader(name="deviceId")
    @io.qt.QtUninvokable
    public final int deviceId(){
        return deviceId_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native int deviceId_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qgamepad.html#connected-prop">QGamepad::isConnected()const</a></p>
     */
    @io.qt.QtPropertyReader(name="connected")
    @io.qt.QtUninvokable
    public final boolean isConnected(){
        return isConnected_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean isConnected_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qgamepad.html#name-prop">QGamepad::name()const</a></p>
     */
    @io.qt.QtPropertyReader(name="name")
    @io.qt.QtUninvokable
    public final java.lang.String name(){
        return name_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native java.lang.String name_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qgamepad.html#deviceId-prop">QGamepad::setDeviceId(int)</a></p>
     */
    @io.qt.QtPropertyWriter(name="deviceId")
    public final void setDeviceId(int number){
        setDeviceId_native_int(QtJambi_LibraryUtilities.internal.nativeId(this), number);
    }
    
    private native void setDeviceId_native_int(long __this__nativeId, int number);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @io.qt.NativeAccess
    protected QGamepad(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * It is not allowed to call the declarative constructor from inside Java.
     */
    @io.qt.NativeAccess
    protected QGamepad(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @io.qt.QtUninvokable
    private static native void initialize_native(QGamepad instance, QDeclarativeConstructor constructor);
    
}
