package io.qt.gamepad;

import io.qt.*;


/**
 * <p>Queries attached gamepads and related events</p>
 * <p>Java wrapper for Qt class <code><a href="http://doc.qt.io/qt-5/qgamepadmanager.html">QGamepadManager</a></code></p>
 */
public final class QGamepadManager extends io.qt.core.QObject
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.@NonNull QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QGamepadManager.class);
    
    /**
     * <p>Java wrapper for Qt enum <code>QGamepadManager::GamepadAxis</code></p>
     * 
     * @see GamepadAxes
     */
    public enum GamepadAxis implements QtFlagEnumerator {
        /**
         * <p>Representing <code>QGamepadManager::<wbr/>AxisInvalid</code></p>
         */
        AxisInvalid(-1),
        /**
         * <p>Representing <code>QGamepadManager::<wbr/>AxisLeftX</code></p>
         */
        AxisLeftX(0),
        /**
         * <p>Representing <code>QGamepadManager::<wbr/>AxisLeftY</code></p>
         */
        AxisLeftY(1),
        /**
         * <p>Representing <code>QGamepadManager::<wbr/>AxisRightX</code></p>
         */
        AxisRightX(2),
        /**
         * <p>Representing <code>QGamepadManager::<wbr/>AxisRightY</code></p>
         */
        AxisRightY(3);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private GamepadAxis(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Create a QFlags of the enum entry.
         * @return QFlags
         */
        public @NonNull GamepadAxes asFlags() {
            return new GamepadAxes(value);
        }

        /**
         * Combines this entry with other enum entry.
         * @param e enum entry
         * @return new flag
         */
        public @NonNull GamepadAxes combined(@NonNull GamepadAxis e) {
            return asFlags().setFlag(e, true);
        }

        /**
         * Excludes other enum entry from a flag of this entry.
         * @param e enum entry
         * @return new flag
         */
        public @NonNull GamepadAxes cleared(@NonNull GamepadAxis e) {
            return asFlags().setFlag(e, false);
        }

        /**
         * Creates a new {@link GamepadAxes} from the entries.
         * @param values entries
         * @return new flag
         */
        public static @NonNull GamepadAxes flags(@Nullable GamepadAxis @NonNull... values) {
            return new GamepadAxes(values);
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull GamepadAxis resolve(int value) {
            switch (value) {
            case -1: return AxisInvalid;
            case 0: return AxisLeftX;
            case 1: return AxisLeftY;
            case 2: return AxisRightX;
            case 3: return AxisRightY;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * {@link QFlags} type for enum {@link GamepadAxis}
     */
    public static final class GamepadAxes extends QFlags<GamepadAxis> implements Comparable<GamepadAxes> {
        private static final long serialVersionUID = 0xda70e9601c72f2ddL;
        static {
            QtJambi_LibraryUtilities.initialize();
        }

        /**
         * Creates a new GamepadAxes where the flags in <code>args</code> are set.
         * @param args enum entries
         */
        public GamepadAxes(@Nullable GamepadAxis @NonNull... args){
            super(args);
        }

        /**
         * Creates a new GamepadAxes with given <code>value</code>.
         * @param value
         */
        public GamepadAxes(int value) {
            super(value);
        }

        /**
         * Combines this flags with enum entry.
         * @param e enum entry
         * @return new GamepadAxes
         */
        @Override
        public final @NonNull GamepadAxes combined(@StrictNonNull GamepadAxis e){
            return new GamepadAxes(value() | e.value());
        }

        /**
         * Sets the flag <code>e</code>
         * @param e enum entry
         * @return this
         */
        public final @NonNull GamepadAxes setFlag(@Nullable GamepadAxis e){
            return setFlag(e, true);
        }

        /**
         * Sets or clears the flag <code>flag</code>
         * @param e enum entry
         * @param on set (true) or clear (false)
         * @return this
         */
        public final @NonNull GamepadAxes setFlag(@Nullable GamepadAxis e, boolean on){
            if (on) {
            	setValue(value() | e.value());
            }else {
            	setValue(value() & ~e.value());
            }
            return this;
        }

        /**
         * Returns an array of flag objects represented by this GamepadAxes.
         * @return array of enum entries
         */
        @Override
        public final @NonNull GamepadAxis @NonNull[] flags(){
            return super.flags(GamepadAxis.values());
        }

        /**
         * {@inheritDoc}
         */
        @Override
        public final @NonNull GamepadAxes clone(){
            return new GamepadAxes(value());
        }

        /**
         * {@inheritDoc}
         */
        @Override
        public final int compareTo(@StrictNonNull GamepadAxes other){
            return Integer.compare(value(), other.value());
        }
    }
    
    /**
     * <p>Java wrapper for Qt enum <code>QGamepadManager::GamepadButton</code></p>
     * 
     * @see GamepadButtons
     */
    public enum GamepadButton implements QtFlagEnumerator {
        /**
         * <p>Representing <code>QGamepadManager::<wbr/>ButtonInvalid</code></p>
         */
        ButtonInvalid(-1),
        /**
         * <p>Representing <code>QGamepadManager::<wbr/>ButtonA</code></p>
         */
        ButtonA(0),
        /**
         * <p>Representing <code>QGamepadManager::<wbr/>ButtonB</code></p>
         */
        ButtonB(1),
        /**
         * <p>Representing <code>QGamepadManager::<wbr/>ButtonX</code></p>
         */
        ButtonX(2),
        /**
         * <p>Representing <code>QGamepadManager::<wbr/>ButtonY</code></p>
         */
        ButtonY(3),
        /**
         * <p>Representing <code>QGamepadManager::<wbr/>ButtonL1</code></p>
         */
        ButtonL1(4),
        /**
         * <p>Representing <code>QGamepadManager::<wbr/>ButtonR1</code></p>
         */
        ButtonR1(5),
        /**
         * <p>Representing <code>QGamepadManager::<wbr/>ButtonL2</code></p>
         */
        ButtonL2(6),
        /**
         * <p>Representing <code>QGamepadManager::<wbr/>ButtonR2</code></p>
         */
        ButtonR2(7),
        /**
         * <p>Representing <code>QGamepadManager::<wbr/>ButtonSelect</code></p>
         */
        ButtonSelect(8),
        /**
         * <p>Representing <code>QGamepadManager::<wbr/>ButtonStart</code></p>
         */
        ButtonStart(9),
        /**
         * <p>Representing <code>QGamepadManager::<wbr/>ButtonL3</code></p>
         */
        ButtonL3(10),
        /**
         * <p>Representing <code>QGamepadManager::<wbr/>ButtonR3</code></p>
         */
        ButtonR3(11),
        /**
         * <p>Representing <code>QGamepadManager::<wbr/>ButtonUp</code></p>
         */
        ButtonUp(12),
        /**
         * <p>Representing <code>QGamepadManager::<wbr/>ButtonDown</code></p>
         */
        ButtonDown(13),
        /**
         * <p>Representing <code>QGamepadManager::<wbr/>ButtonRight</code></p>
         */
        ButtonRight(14),
        /**
         * <p>Representing <code>QGamepadManager::<wbr/>ButtonLeft</code></p>
         */
        ButtonLeft(15),
        /**
         * <p>Representing <code>QGamepadManager::<wbr/>ButtonCenter</code></p>
         */
        ButtonCenter(16),
        /**
         * <p>Representing <code>QGamepadManager::<wbr/>ButtonGuide</code></p>
         */
        ButtonGuide(17);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private GamepadButton(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Create a QFlags of the enum entry.
         * @return QFlags
         */
        public @NonNull GamepadButtons asFlags() {
            return new GamepadButtons(value);
        }

        /**
         * Combines this entry with other enum entry.
         * @param e enum entry
         * @return new flag
         */
        public @NonNull GamepadButtons combined(@NonNull GamepadButton e) {
            return asFlags().setFlag(e, true);
        }

        /**
         * Excludes other enum entry from a flag of this entry.
         * @param e enum entry
         * @return new flag
         */
        public @NonNull GamepadButtons cleared(@NonNull GamepadButton e) {
            return asFlags().setFlag(e, false);
        }

        /**
         * Creates a new {@link GamepadButtons} from the entries.
         * @param values entries
         * @return new flag
         */
        public static @NonNull GamepadButtons flags(@Nullable GamepadButton @NonNull... values) {
            return new GamepadButtons(values);
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull GamepadButton resolve(int value) {
            switch (value) {
            case -1: return ButtonInvalid;
            case 0: return ButtonA;
            case 1: return ButtonB;
            case 2: return ButtonX;
            case 3: return ButtonY;
            case 4: return ButtonL1;
            case 5: return ButtonR1;
            case 6: return ButtonL2;
            case 7: return ButtonR2;
            case 8: return ButtonSelect;
            case 9: return ButtonStart;
            case 10: return ButtonL3;
            case 11: return ButtonR3;
            case 12: return ButtonUp;
            case 13: return ButtonDown;
            case 14: return ButtonRight;
            case 15: return ButtonLeft;
            case 16: return ButtonCenter;
            case 17: return ButtonGuide;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * {@link QFlags} type for enum {@link GamepadButton}
     */
    public static final class GamepadButtons extends QFlags<GamepadButton> implements Comparable<GamepadButtons> {
        private static final long serialVersionUID = 0x5ce4d2185530f07L;
        static {
            QtJambi_LibraryUtilities.initialize();
        }

        /**
         * Creates a new GamepadButtons where the flags in <code>args</code> are set.
         * @param args enum entries
         */
        public GamepadButtons(@Nullable GamepadButton @NonNull... args){
            super(args);
        }

        /**
         * Creates a new GamepadButtons with given <code>value</code>.
         * @param value
         */
        public GamepadButtons(int value) {
            super(value);
        }

        /**
         * Combines this flags with enum entry.
         * @param e enum entry
         * @return new GamepadButtons
         */
        @Override
        public final @NonNull GamepadButtons combined(@StrictNonNull GamepadButton e){
            return new GamepadButtons(value() | e.value());
        }

        /**
         * Sets the flag <code>e</code>
         * @param e enum entry
         * @return this
         */
        public final @NonNull GamepadButtons setFlag(@Nullable GamepadButton e){
            return setFlag(e, true);
        }

        /**
         * Sets or clears the flag <code>flag</code>
         * @param e enum entry
         * @param on set (true) or clear (false)
         * @return this
         */
        public final @NonNull GamepadButtons setFlag(@Nullable GamepadButton e, boolean on){
            if (on) {
            	setValue(value() | e.value());
            }else {
            	setValue(value() & ~e.value());
            }
            return this;
        }

        /**
         * Returns an array of flag objects represented by this GamepadButtons.
         * @return array of enum entries
         */
        @Override
        public final @NonNull GamepadButton @NonNull[] flags(){
            return super.flags(GamepadButton.values());
        }

        /**
         * {@inheritDoc}
         */
        @Override
        public final @NonNull GamepadButtons clone(){
            return new GamepadButtons(value());
        }

        /**
         * {@inheritDoc}
         */
        @Override
        public final int compareTo(@StrictNonNull GamepadButtons other){
            return Integer.compare(value(), other.value());
        }
    }
    

    /**
     * <p>See <code>QGamepadManager::<wbr/>axisConfigured(int,<wbr/>QGamepadManager::GamepadAxis)</code></p>
     */
    public final @NonNull Signal2<java.lang.@QtPrimitiveType@NonNull Integer, io.qt.gamepad.QGamepadManager.@NonNull GamepadAxis> axisConfigured = new Signal2<>();

    /**
     * <p>See <code>QGamepadManager::<wbr/>buttonConfigured(int,<wbr/>QGamepadManager::GamepadButton)</code></p>
     */
    public final @NonNull Signal2<java.lang.@QtPrimitiveType@NonNull Integer, io.qt.gamepad.QGamepadManager.@NonNull GamepadButton> buttonConfigured = new Signal2<>();

    /**
     * <p>See <code>QGamepadManager::<wbr/>configurationCanceled(int)</code></p>
     */
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Integer> configurationCanceled = new Signal1<>();

    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qgamepadmanager.html#connectedGamepads-prop">QGamepadManager::<wbr/>connectedGamepadsChanged()</a></code></p>
     */
    @QtPropertyNotify(name="connectedGamepads")
    public final @NonNull Signal0 connectedGamepadsChanged = new Signal0();

    /**
     * <p>See <code>QGamepadManager::<wbr/>gamepadAxisEvent(int,<wbr/>QGamepadManager::GamepadAxis,<wbr/>double)</code></p>
     */
    public final @NonNull Signal3<java.lang.@QtPrimitiveType@NonNull Integer, io.qt.gamepad.QGamepadManager.@NonNull GamepadAxis, java.lang.@QtPrimitiveType@NonNull Double> gamepadAxisEvent = new Signal3<>();

    /**
     * <p>See <code>QGamepadManager::<wbr/>gamepadButtonPressEvent(int,<wbr/>QGamepadManager::GamepadButton,<wbr/>double)</code></p>
     */
    public final @NonNull Signal3<java.lang.@QtPrimitiveType@NonNull Integer, io.qt.gamepad.QGamepadManager.@NonNull GamepadButton, java.lang.@QtPrimitiveType@NonNull Double> gamepadButtonPressEvent = new Signal3<>();

    /**
     * <p>See <code>QGamepadManager::<wbr/>gamepadButtonReleaseEvent(int,<wbr/>QGamepadManager::GamepadButton)</code></p>
     */
    public final @NonNull Signal2<java.lang.@QtPrimitiveType@NonNull Integer, io.qt.gamepad.QGamepadManager.@NonNull GamepadButton> gamepadButtonReleaseEvent = new Signal2<>();

    /**
     * <p>See <code>QGamepadManager::<wbr/>gamepadConnected(int)</code></p>
     */
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Integer> gamepadConnected = new Signal1<>();

    /**
     * <p>See <code>QGamepadManager::<wbr/>gamepadDisconnected(int)</code></p>
     */
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Integer> gamepadDisconnected = new Signal1<>();

    /**
     * <p>See <code>QGamepadManager::<wbr/>gamepadNameChanged(int,<wbr/>QString)</code></p>
     */
    public final @NonNull Signal2<java.lang.@QtPrimitiveType@NonNull Integer, java.lang.@NonNull String> gamepadNameChanged = new Signal2<>();
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qgamepadmanager.html#configureAxis">QGamepadManager::<wbr/>configureAxis(int,<wbr/>QGamepadManager::GamepadAxis)</a></code></p>
     */
    public final boolean configureAxis(int deviceId, io.qt.gamepad.QGamepadManager.@NonNull GamepadAxis axis){
        return configureAxis_native_int_QGamepadManager_GamepadAxis(QtJambi_LibraryUtilities.internal.nativeId(this), deviceId, axis.value());
    }
    
    private native boolean configureAxis_native_int_QGamepadManager_GamepadAxis(long __this__nativeId, int deviceId, int axis);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qgamepadmanager.html#configureButton">QGamepadManager::<wbr/>configureButton(int,<wbr/>QGamepadManager::GamepadButton)</a></code></p>
     */
    public final boolean configureButton(int deviceId, io.qt.gamepad.QGamepadManager.@NonNull GamepadButton button){
        return configureButton_native_int_QGamepadManager_GamepadButton(QtJambi_LibraryUtilities.internal.nativeId(this), deviceId, button.value());
    }
    
    private native boolean configureButton_native_int_QGamepadManager_GamepadButton(long __this__nativeId, int deviceId, int button);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qgamepadmanager.html#connectedGamepads">QGamepadManager::<wbr/>connectedGamepads()const</a></code></p>
     */
    @QtPropertyReader(name="connectedGamepads")
    @QtUninvokable
    public final io.qt.core.@NonNull QList<java.lang.@QtPrimitiveType@NonNull Integer> connectedGamepads(){
        return connectedGamepads_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QList<java.lang.@QtPrimitiveType Integer> connectedGamepads_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qgamepadmanager.html#gamepadName">QGamepadManager::<wbr/>gamepadName(int)const</a></code></p>
     */
    @QtUninvokable
    public final java.lang.@NonNull String gamepadName(int deviceId){
        return gamepadName_native_int_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), deviceId);
    }
    
    @QtUninvokable
    private native java.lang.String gamepadName_native_int_constfct(long __this__nativeId, int deviceId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qgamepadmanager.html#isConfigurationNeeded">QGamepadManager::<wbr/>isConfigurationNeeded(int)const</a></code></p>
     */
    public final boolean isConfigurationNeeded(int deviceId){
        return isConfigurationNeeded_native_int_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), deviceId);
    }
    
    private native boolean isConfigurationNeeded_native_int_constfct(long __this__nativeId, int deviceId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qgamepadmanager.html#isGamepadConnected">QGamepadManager::<wbr/>isGamepadConnected(int)const</a></code></p>
     */
    @QtUninvokable
    public final boolean isGamepadConnected(int deviceId){
        return isGamepadConnected_native_int_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), deviceId);
    }
    
    @QtUninvokable
    private native boolean isGamepadConnected_native_int_constfct(long __this__nativeId, int deviceId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qgamepadmanager.html#resetConfiguration">QGamepadManager::<wbr/>resetConfiguration(int)</a></code></p>
     */
    public final void resetConfiguration(int deviceId){
        resetConfiguration_native_int(QtJambi_LibraryUtilities.internal.nativeId(this), deviceId);
    }
    
    private native void resetConfiguration_native_int(long __this__nativeId, int deviceId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qgamepadmanager.html#setCancelConfigureButton">QGamepadManager::<wbr/>setCancelConfigureButton(int,<wbr/>QGamepadManager::GamepadButton)</a></code></p>
     */
    public final boolean setCancelConfigureButton(int deviceId, io.qt.gamepad.QGamepadManager.@NonNull GamepadButton button){
        return setCancelConfigureButton_native_int_QGamepadManager_GamepadButton(QtJambi_LibraryUtilities.internal.nativeId(this), deviceId, button.value());
    }
    
    private native boolean setCancelConfigureButton_native_int_QGamepadManager_GamepadButton(long __this__nativeId, int deviceId, int button);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qgamepadmanager.html#setSettingsFile">QGamepadManager::<wbr/>setSettingsFile(QString)</a></code></p>
     */
    public final void setSettingsFile(java.lang.@NonNull String file){
        setSettingsFile_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), file);
    }
    
    private native void setSettingsFile_native_cref_QString(long __this__nativeId, java.lang.String file);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qgamepadmanager.html#instance">QGamepadManager::<wbr/>instance()</a></code></p>
     */
    public native static io.qt.gamepad.@Nullable QGamepadManager instance();
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     * @hidden
     */
    @NativeAccess
    protected QGamepadManager(QPrivateConstructor p) { super(p); } 
    
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #connectedGamepads()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.core.@NonNull QList<java.lang.@QtPrimitiveType@NonNull Integer> getConnectedGamepads() {
        return connectedGamepads();
    }
}
