package io.qt.gamepad;

import io.qt.*;


/**
 * <p>A gamepad device connected to a system</p>
 * <p>Java wrapper for Qt class <code><a href="http://doc.qt.io/qt-5/qgamepad.html">QGamepad</a></code></p>
 */
public class QGamepad extends io.qt.core.QObject
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.@NonNull QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QGamepad.class);
    

    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qgamepad.html#axisLeftX-prop">QGamepad::<wbr/>axisLeftXChanged(double)</a></code></p>
     */
    @QtPropertyNotify(name="axisLeftX")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Double> axisLeftXChanged = new Signal1<>();

    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qgamepad.html#axisLeftY-prop">QGamepad::<wbr/>axisLeftYChanged(double)</a></code></p>
     */
    @QtPropertyNotify(name="axisLeftY")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Double> axisLeftYChanged = new Signal1<>();

    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qgamepad.html#axisRightX-prop">QGamepad::<wbr/>axisRightXChanged(double)</a></code></p>
     */
    @QtPropertyNotify(name="axisRightX")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Double> axisRightXChanged = new Signal1<>();

    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qgamepad.html#axisRightY-prop">QGamepad::<wbr/>axisRightYChanged(double)</a></code></p>
     */
    @QtPropertyNotify(name="axisRightY")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Double> axisRightYChanged = new Signal1<>();

    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qgamepad.html#buttonA-prop">QGamepad::<wbr/>buttonAChanged(bool)</a></code></p>
     */
    @QtPropertyNotify(name="buttonA")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Boolean> buttonAChanged = new Signal1<>();

    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qgamepad.html#buttonB-prop">QGamepad::<wbr/>buttonBChanged(bool)</a></code></p>
     */
    @QtPropertyNotify(name="buttonB")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Boolean> buttonBChanged = new Signal1<>();

    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qgamepad.html#buttonCenter-prop">QGamepad::<wbr/>buttonCenterChanged(bool)</a></code></p>
     */
    @QtPropertyNotify(name="buttonCenter")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Boolean> buttonCenterChanged = new Signal1<>();

    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qgamepad.html#buttonDown-prop">QGamepad::<wbr/>buttonDownChanged(bool)</a></code></p>
     */
    @QtPropertyNotify(name="buttonDown")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Boolean> buttonDownChanged = new Signal1<>();

    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qgamepad.html#buttonGuide-prop">QGamepad::<wbr/>buttonGuideChanged(bool)</a></code></p>
     */
    @QtPropertyNotify(name="buttonGuide")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Boolean> buttonGuideChanged = new Signal1<>();

    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qgamepad.html#buttonL1-prop">QGamepad::<wbr/>buttonL1Changed(bool)</a></code></p>
     */
    @QtPropertyNotify(name="buttonL1")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Boolean> buttonL1Changed = new Signal1<>();

    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qgamepad.html#buttonL2-prop">QGamepad::<wbr/>buttonL2Changed(double)</a></code></p>
     */
    @QtPropertyNotify(name="buttonL2")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Double> buttonL2Changed = new Signal1<>();

    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qgamepad.html#buttonL3-prop">QGamepad::<wbr/>buttonL3Changed(bool)</a></code></p>
     */
    @QtPropertyNotify(name="buttonL3")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Boolean> buttonL3Changed = new Signal1<>();

    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qgamepad.html#buttonLeft-prop">QGamepad::<wbr/>buttonLeftChanged(bool)</a></code></p>
     */
    @QtPropertyNotify(name="buttonLeft")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Boolean> buttonLeftChanged = new Signal1<>();

    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qgamepad.html#buttonR1-prop">QGamepad::<wbr/>buttonR1Changed(bool)</a></code></p>
     */
    @QtPropertyNotify(name="buttonR1")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Boolean> buttonR1Changed = new Signal1<>();

    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qgamepad.html#buttonR2-prop">QGamepad::<wbr/>buttonR2Changed(double)</a></code></p>
     */
    @QtPropertyNotify(name="buttonR2")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Double> buttonR2Changed = new Signal1<>();

    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qgamepad.html#buttonR3-prop">QGamepad::<wbr/>buttonR3Changed(bool)</a></code></p>
     */
    @QtPropertyNotify(name="buttonR3")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Boolean> buttonR3Changed = new Signal1<>();

    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qgamepad.html#buttonRight-prop">QGamepad::<wbr/>buttonRightChanged(bool)</a></code></p>
     */
    @QtPropertyNotify(name="buttonRight")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Boolean> buttonRightChanged = new Signal1<>();

    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qgamepad.html#buttonSelect-prop">QGamepad::<wbr/>buttonSelectChanged(bool)</a></code></p>
     */
    @QtPropertyNotify(name="buttonSelect")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Boolean> buttonSelectChanged = new Signal1<>();

    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qgamepad.html#buttonStart-prop">QGamepad::<wbr/>buttonStartChanged(bool)</a></code></p>
     */
    @QtPropertyNotify(name="buttonStart")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Boolean> buttonStartChanged = new Signal1<>();

    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qgamepad.html#buttonUp-prop">QGamepad::<wbr/>buttonUpChanged(bool)</a></code></p>
     */
    @QtPropertyNotify(name="buttonUp")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Boolean> buttonUpChanged = new Signal1<>();

    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qgamepad.html#buttonX-prop">QGamepad::<wbr/>buttonXChanged(bool)</a></code></p>
     */
    @QtPropertyNotify(name="buttonX")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Boolean> buttonXChanged = new Signal1<>();

    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qgamepad.html#buttonY-prop">QGamepad::<wbr/>buttonYChanged(bool)</a></code></p>
     */
    @QtPropertyNotify(name="buttonY")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Boolean> buttonYChanged = new Signal1<>();

    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qgamepad.html#connected-prop">QGamepad::<wbr/>connectedChanged(bool)</a></code></p>
     */
    @QtPropertyNotify(name="connected")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Boolean> connectedChanged = new Signal1<>();

    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qgamepad.html#deviceId-prop">QGamepad::<wbr/>deviceIdChanged(int)</a></code></p>
     */
    @QtPropertyNotify(name="deviceId")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Integer> deviceIdChanged = new Signal1<>();

    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qgamepad.html#name-prop">QGamepad::<wbr/>nameChanged(QString)</a></code></p>
     */
    @QtPropertyNotify(name="name")
    public final @NonNull Signal1<java.lang.@NonNull String> nameChanged = new Signal1<>();
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qgamepad.html#QGamepad">QGamepad::<wbr/>QGamepad(int,<wbr/>QObject*)</a></code></p>
     */
    public QGamepad(int deviceId, io.qt.core.@Nullable QObject parent){
        super((QPrivateConstructor)null);
        initialize_native(this, deviceId, parent);
    }
    
    private native static void initialize_native(QGamepad instance, int deviceId, io.qt.core.QObject parent);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qgamepad.html#axisLeftX-prop">QGamepad::<wbr/>axisLeftX()const</a></code></p>
     */
    @QtPropertyReader(name="axisLeftX")
    @QtUninvokable
    public final double axisLeftX(){
        return axisLeftX_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native double axisLeftX_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qgamepad.html#axisLeftY-prop">QGamepad::<wbr/>axisLeftY()const</a></code></p>
     */
    @QtPropertyReader(name="axisLeftY")
    @QtUninvokable
    public final double axisLeftY(){
        return axisLeftY_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native double axisLeftY_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qgamepad.html#axisRightX-prop">QGamepad::<wbr/>axisRightX()const</a></code></p>
     */
    @QtPropertyReader(name="axisRightX")
    @QtUninvokable
    public final double axisRightX(){
        return axisRightX_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native double axisRightX_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qgamepad.html#axisRightY-prop">QGamepad::<wbr/>axisRightY()const</a></code></p>
     */
    @QtPropertyReader(name="axisRightY")
    @QtUninvokable
    public final double axisRightY(){
        return axisRightY_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native double axisRightY_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qgamepad.html#buttonA-prop">QGamepad::<wbr/>buttonA()const</a></code></p>
     */
    @QtPropertyReader(name="buttonA")
    @QtUninvokable
    public final boolean buttonA(){
        return buttonA_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean buttonA_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qgamepad.html#buttonB-prop">QGamepad::<wbr/>buttonB()const</a></code></p>
     */
    @QtPropertyReader(name="buttonB")
    @QtUninvokable
    public final boolean buttonB(){
        return buttonB_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean buttonB_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qgamepad.html#buttonCenter-prop">QGamepad::<wbr/>buttonCenter()const</a></code></p>
     */
    @QtPropertyReader(name="buttonCenter")
    @QtUninvokable
    public final boolean buttonCenter(){
        return buttonCenter_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean buttonCenter_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qgamepad.html#buttonDown-prop">QGamepad::<wbr/>buttonDown()const</a></code></p>
     */
    @QtPropertyReader(name="buttonDown")
    @QtUninvokable
    public final boolean buttonDown(){
        return buttonDown_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean buttonDown_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qgamepad.html#buttonGuide-prop">QGamepad::<wbr/>buttonGuide()const</a></code></p>
     */
    @QtPropertyReader(name="buttonGuide")
    @QtUninvokable
    public final boolean buttonGuide(){
        return buttonGuide_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean buttonGuide_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qgamepad.html#buttonL1-prop">QGamepad::<wbr/>buttonL1()const</a></code></p>
     */
    @QtPropertyReader(name="buttonL1")
    @QtUninvokable
    public final boolean buttonL1(){
        return buttonL1_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean buttonL1_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qgamepad.html#buttonL2-prop">QGamepad::<wbr/>buttonL2()const</a></code></p>
     */
    @QtPropertyReader(name="buttonL2")
    @QtUninvokable
    public final double buttonL2(){
        return buttonL2_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native double buttonL2_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qgamepad.html#buttonL3-prop">QGamepad::<wbr/>buttonL3()const</a></code></p>
     */
    @QtPropertyReader(name="buttonL3")
    @QtUninvokable
    public final boolean buttonL3(){
        return buttonL3_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean buttonL3_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qgamepad.html#buttonLeft-prop">QGamepad::<wbr/>buttonLeft()const</a></code></p>
     */
    @QtPropertyReader(name="buttonLeft")
    @QtUninvokable
    public final boolean buttonLeft(){
        return buttonLeft_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean buttonLeft_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qgamepad.html#buttonR1-prop">QGamepad::<wbr/>buttonR1()const</a></code></p>
     */
    @QtPropertyReader(name="buttonR1")
    @QtUninvokable
    public final boolean buttonR1(){
        return buttonR1_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean buttonR1_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qgamepad.html#buttonR2-prop">QGamepad::<wbr/>buttonR2()const</a></code></p>
     */
    @QtPropertyReader(name="buttonR2")
    @QtUninvokable
    public final double buttonR2(){
        return buttonR2_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native double buttonR2_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qgamepad.html#buttonR3-prop">QGamepad::<wbr/>buttonR3()const</a></code></p>
     */
    @QtPropertyReader(name="buttonR3")
    @QtUninvokable
    public final boolean buttonR3(){
        return buttonR3_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean buttonR3_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qgamepad.html#buttonRight-prop">QGamepad::<wbr/>buttonRight()const</a></code></p>
     */
    @QtPropertyReader(name="buttonRight")
    @QtUninvokable
    public final boolean buttonRight(){
        return buttonRight_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean buttonRight_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qgamepad.html#buttonSelect-prop">QGamepad::<wbr/>buttonSelect()const</a></code></p>
     */
    @QtPropertyReader(name="buttonSelect")
    @QtUninvokable
    public final boolean buttonSelect(){
        return buttonSelect_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean buttonSelect_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qgamepad.html#buttonStart-prop">QGamepad::<wbr/>buttonStart()const</a></code></p>
     */
    @QtPropertyReader(name="buttonStart")
    @QtUninvokable
    public final boolean buttonStart(){
        return buttonStart_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean buttonStart_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qgamepad.html#buttonUp-prop">QGamepad::<wbr/>buttonUp()const</a></code></p>
     */
    @QtPropertyReader(name="buttonUp")
    @QtUninvokable
    public final boolean buttonUp(){
        return buttonUp_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean buttonUp_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qgamepad.html#buttonX-prop">QGamepad::<wbr/>buttonX()const</a></code></p>
     */
    @QtPropertyReader(name="buttonX")
    @QtUninvokable
    public final boolean buttonX(){
        return buttonX_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean buttonX_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qgamepad.html#buttonY-prop">QGamepad::<wbr/>buttonY()const</a></code></p>
     */
    @QtPropertyReader(name="buttonY")
    @QtUninvokable
    public final boolean buttonY(){
        return buttonY_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean buttonY_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qgamepad.html#deviceId-prop">QGamepad::<wbr/>deviceId()const</a></code></p>
     */
    @QtPropertyReader(name="deviceId")
    @QtUninvokable
    public final int deviceId(){
        return deviceId_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int deviceId_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qgamepad.html#connected-prop">QGamepad::<wbr/>isConnected()const</a></code></p>
     */
    @QtPropertyReader(name="connected")
    @QtUninvokable
    public final boolean isConnected(){
        return isConnected_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean isConnected_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qgamepad.html#name-prop">QGamepad::<wbr/>name()const</a></code></p>
     */
    @QtPropertyReader(name="name")
    @QtUninvokable
    public final java.lang.@NonNull String name(){
        return name_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native java.lang.String name_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qgamepad.html#deviceId-prop">QGamepad::<wbr/>setDeviceId(int)</a></code></p>
     */
    @QtPropertyWriter(name="deviceId")
    public final void setDeviceId(int number){
        setDeviceId_native_int(QtJambi_LibraryUtilities.internal.nativeId(this), number);
    }
    
    private native void setDeviceId_native_int(long __this__nativeId, int number);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     * @hidden
     */
    @NativeAccess
    protected QGamepad(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * It is not allowed to call the declarative constructor from inside Java.
     * @hidden
     */
    @NativeAccess
    protected QGamepad(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @QtUninvokable
    private static native void initialize_native(QGamepad instance, QDeclarativeConstructor constructor);
    
    
    /**
     * <p>Overloaded constructor for {@link #QGamepad(int, io.qt.core.QObject)}
     *  with <code>parent = null</code>.</p>
     */
    public QGamepad(int deviceId) {
        this(deviceId, (io.qt.core.QObject)null);
    }
    
    /**
     * <p>Overloaded constructor for {@link #QGamepad(int, io.qt.core.QObject)}</p>
     * <p>with: </p><ul>
     * <li><code>deviceId = 0</code></li>
     * <li><code>parent = null</code></li>
     * </ul>
     */
    public QGamepad() {
        this((int)0, (io.qt.core.QObject)null);
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #axisLeftX()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final double getAxisLeftX() {
        return axisLeftX();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #axisLeftY()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final double getAxisLeftY() {
        return axisLeftY();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #axisRightX()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final double getAxisRightX() {
        return axisRightX();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #axisRightY()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final double getAxisRightY() {
        return axisRightY();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #buttonA()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final boolean getButtonA() {
        return buttonA();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #buttonB()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final boolean getButtonB() {
        return buttonB();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #buttonCenter()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final boolean getButtonCenter() {
        return buttonCenter();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #buttonDown()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final boolean getButtonDown() {
        return buttonDown();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #buttonGuide()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final boolean getButtonGuide() {
        return buttonGuide();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #buttonL1()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final boolean getButtonL1() {
        return buttonL1();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #buttonL2()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final double getButtonL2() {
        return buttonL2();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #buttonL3()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final boolean getButtonL3() {
        return buttonL3();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #buttonLeft()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final boolean getButtonLeft() {
        return buttonLeft();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #buttonR1()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final boolean getButtonR1() {
        return buttonR1();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #buttonR2()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final double getButtonR2() {
        return buttonR2();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #buttonR3()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final boolean getButtonR3() {
        return buttonR3();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #buttonRight()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final boolean getButtonRight() {
        return buttonRight();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #buttonSelect()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final boolean getButtonSelect() {
        return buttonSelect();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #buttonStart()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final boolean getButtonStart() {
        return buttonStart();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #buttonUp()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final boolean getButtonUp() {
        return buttonUp();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #buttonX()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final boolean getButtonX() {
        return buttonX();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #buttonY()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final boolean getButtonY() {
        return buttonY();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #deviceId()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final int getDeviceId() {
        return deviceId();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #isConnected()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final boolean getConnected() {
        return isConnected();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #name()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final java.lang.@NonNull String getName() {
        return name();
    }
}
