package io.qt.gamepad;

import io.qt.*;


/**
 * <p>Queries attached gamepads and related events</p>
 * <p>Java wrapper for Qt's class <a href="http://doc.qt.io/qt-5/qgamepadmanager.html">QGamepadManager</a></p>
 */
public final class QGamepadManager extends io.qt.core.QObject
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.@NonNull QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QGamepadManager.class);
    
    /**
     * <p>Java wrapper for Qt enum QGamepadManager::GamepadAxis</p>
     * 
     * @see GamepadAxes
     */
    public enum GamepadAxis implements QtFlagEnumerator {
        AxisInvalid(-1),
        AxisLeftX(0),
        AxisLeftY(1),
        AxisRightX(2),
        AxisRightY(3);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private GamepadAxis(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Create a QFlags of the enum entry.
         * @return QFlags
         */
        public GamepadAxes asFlags() {
            return new GamepadAxes(value);
        }

        /**
         * Combines this entry with other enum entry.
         * @param e enum entry
         * @return new flag
         */
        public GamepadAxes combined(GamepadAxis e) {
            return new GamepadAxes(this, e);
        }

        /**
         * Creates a new {@link GamepadAxes} from the entries.
         * @param values entries
         * @return new flag
         */
        public static GamepadAxes flags(GamepadAxis ... values) {
            return new GamepadAxes(values);
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static GamepadAxis resolve(int value) {
            switch (value) {
            case -1: return AxisInvalid;
            case 0: return AxisLeftX;
            case 1: return AxisLeftY;
            case 2: return AxisRightX;
            case 3: return AxisRightY;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * QFlags type for enum {@link GamepadAxis}
     */
    public static final class GamepadAxes extends QFlags<GamepadAxis> implements Comparable<GamepadAxes> {
        private static final long serialVersionUID = 0xda70e9601c72f2ddL;
        static {
            QtJambi_LibraryUtilities.initialize();
        }

        /**
         * Creates a new GamepadAxes where the flags in <code>args</code> are set.
         * @param args enum entries
         */
        public GamepadAxes(GamepadAxis ... args){
            super(args);
        }

        /**
         * Creates a new GamepadAxes with given <code>value</code>.
         * @param value
         */
        public GamepadAxes(int value) {
            super(value);
        }

        /**
         * Combines this flags with enum entry.
         * @param e enum entry
         * @return new GamepadAxes
         */
        @Override
        public final GamepadAxes combined(GamepadAxis e){
            return new GamepadAxes(value() | e.value());
        }

        /**
         * Sets the flag <code>e</code>
         * @param e enum entry
         * @return this
         */
        public final GamepadAxes setFlag(GamepadAxis e){
            super.setFlag(e);
            return this;
        }

        /**
         * Sets or clears the flag <code>flag</code>
         * @param e enum entry
         * @param on set (true) or clear (false)
         * @return this
         */
        public final GamepadAxes setFlag(GamepadAxis e, boolean on){
            super.setFlag(e, on);
            return this;
        }

        /**
         * Returns an array of flag objects represented by this GamepadAxes.
         * @return array of enum entries
         */
        @Override
        public final GamepadAxis[] flags(){
            return super.flags(GamepadAxis.values());
        }

        /**
         * {@inheritDoc}
         */
        @Override
        public final GamepadAxes clone(){
            return new GamepadAxes(value());
        }

        /**
         * {@inheritDoc}
         */
        @Override
        public final int compareTo(GamepadAxes other){
            return Integer.compare(value(), other.value());
        }
    }
    
    /**
     * <p>Java wrapper for Qt enum QGamepadManager::GamepadButton</p>
     * 
     * @see GamepadButtons
     */
    public enum GamepadButton implements QtFlagEnumerator {
        ButtonInvalid(-1),
        ButtonA(0),
        ButtonB(1),
        ButtonX(2),
        ButtonY(3),
        ButtonL1(4),
        ButtonR1(5),
        ButtonL2(6),
        ButtonR2(7),
        ButtonSelect(8),
        ButtonStart(9),
        ButtonL3(10),
        ButtonR3(11),
        ButtonUp(12),
        ButtonDown(13),
        ButtonRight(14),
        ButtonLeft(15),
        ButtonCenter(16),
        ButtonGuide(17);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private GamepadButton(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Create a QFlags of the enum entry.
         * @return QFlags
         */
        public GamepadButtons asFlags() {
            return new GamepadButtons(value);
        }

        /**
         * Combines this entry with other enum entry.
         * @param e enum entry
         * @return new flag
         */
        public GamepadButtons combined(GamepadButton e) {
            return new GamepadButtons(this, e);
        }

        /**
         * Creates a new {@link GamepadButtons} from the entries.
         * @param values entries
         * @return new flag
         */
        public static GamepadButtons flags(GamepadButton ... values) {
            return new GamepadButtons(values);
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static GamepadButton resolve(int value) {
            switch (value) {
            case -1: return ButtonInvalid;
            case 0: return ButtonA;
            case 1: return ButtonB;
            case 2: return ButtonX;
            case 3: return ButtonY;
            case 4: return ButtonL1;
            case 5: return ButtonR1;
            case 6: return ButtonL2;
            case 7: return ButtonR2;
            case 8: return ButtonSelect;
            case 9: return ButtonStart;
            case 10: return ButtonL3;
            case 11: return ButtonR3;
            case 12: return ButtonUp;
            case 13: return ButtonDown;
            case 14: return ButtonRight;
            case 15: return ButtonLeft;
            case 16: return ButtonCenter;
            case 17: return ButtonGuide;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * QFlags type for enum {@link GamepadButton}
     */
    public static final class GamepadButtons extends QFlags<GamepadButton> implements Comparable<GamepadButtons> {
        private static final long serialVersionUID = 0x5ce4d2185530f07L;
        static {
            QtJambi_LibraryUtilities.initialize();
        }

        /**
         * Creates a new GamepadButtons where the flags in <code>args</code> are set.
         * @param args enum entries
         */
        public GamepadButtons(GamepadButton ... args){
            super(args);
        }

        /**
         * Creates a new GamepadButtons with given <code>value</code>.
         * @param value
         */
        public GamepadButtons(int value) {
            super(value);
        }

        /**
         * Combines this flags with enum entry.
         * @param e enum entry
         * @return new GamepadButtons
         */
        @Override
        public final GamepadButtons combined(GamepadButton e){
            return new GamepadButtons(value() | e.value());
        }

        /**
         * Sets the flag <code>e</code>
         * @param e enum entry
         * @return this
         */
        public final GamepadButtons setFlag(GamepadButton e){
            super.setFlag(e);
            return this;
        }

        /**
         * Sets or clears the flag <code>flag</code>
         * @param e enum entry
         * @param on set (true) or clear (false)
         * @return this
         */
        public final GamepadButtons setFlag(GamepadButton e, boolean on){
            super.setFlag(e, on);
            return this;
        }

        /**
         * Returns an array of flag objects represented by this GamepadButtons.
         * @return array of enum entries
         */
        @Override
        public final GamepadButton[] flags(){
            return super.flags(GamepadButton.values());
        }

        /**
         * {@inheritDoc}
         */
        @Override
        public final GamepadButtons clone(){
            return new GamepadButtons(value());
        }

        /**
         * {@inheritDoc}
         */
        @Override
        public final int compareTo(GamepadButtons other){
            return Integer.compare(value(), other.value());
        }
    }
    

    public final @NonNull Signal2<java.lang.@QtPrimitiveType@NonNull Integer, io.qt.gamepad.QGamepadManager.@NonNull GamepadAxis> axisConfigured = new Signal2<>();

    public final @NonNull Signal2<java.lang.@QtPrimitiveType@NonNull Integer, io.qt.gamepad.QGamepadManager.@NonNull GamepadButton> buttonConfigured = new Signal2<>();

    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Integer> configurationCanceled = new Signal1<>();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qgamepadmanager.html#connectedGamepads-prop">QGamepadManager::connectedGamepadsChanged()</a></p>
     */
    @QtPropertyNotify(name="connectedGamepads")
    public final @NonNull Signal0 connectedGamepadsChanged = new Signal0();

    public final @NonNull Signal3<java.lang.@QtPrimitiveType@NonNull Integer, io.qt.gamepad.QGamepadManager.@NonNull GamepadAxis, java.lang.@QtPrimitiveType@NonNull Double> gamepadAxisEvent = new Signal3<>();

    public final @NonNull Signal3<java.lang.@QtPrimitiveType@NonNull Integer, io.qt.gamepad.QGamepadManager.@NonNull GamepadButton, java.lang.@QtPrimitiveType@NonNull Double> gamepadButtonPressEvent = new Signal3<>();

    public final @NonNull Signal2<java.lang.@QtPrimitiveType@NonNull Integer, io.qt.gamepad.QGamepadManager.@NonNull GamepadButton> gamepadButtonReleaseEvent = new Signal2<>();

    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Integer> gamepadConnected = new Signal1<>();

    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Integer> gamepadDisconnected = new Signal1<>();

    public final @NonNull Signal2<java.lang.@QtPrimitiveType@NonNull Integer, java.lang.@NonNull String> gamepadNameChanged = new Signal2<>();
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qgamepadmanager.html#configureAxis">QGamepadManager::configureAxis(int,QGamepadManager::GamepadAxis)</a></p>
     */
    public final boolean configureAxis(int deviceId, io.qt.gamepad.QGamepadManager.@NonNull GamepadAxis axis){
        return configureAxis_native_int_QGamepadManager_GamepadAxis(QtJambi_LibraryUtilities.internal.nativeId(this), deviceId, axis.value());
    }
    
    private native boolean configureAxis_native_int_QGamepadManager_GamepadAxis(long __this__nativeId, int deviceId, int axis);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qgamepadmanager.html#configureButton">QGamepadManager::configureButton(int,QGamepadManager::GamepadButton)</a></p>
     */
    public final boolean configureButton(int deviceId, io.qt.gamepad.QGamepadManager.@NonNull GamepadButton button){
        return configureButton_native_int_QGamepadManager_GamepadButton(QtJambi_LibraryUtilities.internal.nativeId(this), deviceId, button.value());
    }
    
    private native boolean configureButton_native_int_QGamepadManager_GamepadButton(long __this__nativeId, int deviceId, int button);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #connectedGamepads()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.core.@NonNull QList<java.lang.@QtPrimitiveType@NonNull Integer> getConnectedGamepads() {
        return connectedGamepads();
    }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qgamepadmanager.html#connectedGamepads">QGamepadManager::connectedGamepads()const</a></p>
     */
    @QtPropertyReader(name="connectedGamepads")
    @QtUninvokable
    public final io.qt.core.@NonNull QList<java.lang.@QtPrimitiveType@NonNull Integer> connectedGamepads(){
        return connectedGamepads_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QList<java.lang.@QtPrimitiveType Integer> connectedGamepads_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qgamepadmanager.html#gamepadName">QGamepadManager::gamepadName(int)const</a></p>
     */
    @QtUninvokable
    public final java.lang.@NonNull String gamepadName(int deviceId){
        return gamepadName_native_int_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), deviceId);
    }
    
    @QtUninvokable
    private native java.lang.String gamepadName_native_int_constfct(long __this__nativeId, int deviceId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qgamepadmanager.html#isConfigurationNeeded">QGamepadManager::isConfigurationNeeded(int)const</a></p>
     */
    public final boolean isConfigurationNeeded(int deviceId){
        return isConfigurationNeeded_native_int_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), deviceId);
    }
    
    private native boolean isConfigurationNeeded_native_int_constfct(long __this__nativeId, int deviceId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qgamepadmanager.html#isGamepadConnected">QGamepadManager::isGamepadConnected(int)const</a></p>
     */
    @QtUninvokable
    public final boolean isGamepadConnected(int deviceId){
        return isGamepadConnected_native_int_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), deviceId);
    }
    
    @QtUninvokable
    private native boolean isGamepadConnected_native_int_constfct(long __this__nativeId, int deviceId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qgamepadmanager.html#resetConfiguration">QGamepadManager::resetConfiguration(int)</a></p>
     */
    public final void resetConfiguration(int deviceId){
        resetConfiguration_native_int(QtJambi_LibraryUtilities.internal.nativeId(this), deviceId);
    }
    
    private native void resetConfiguration_native_int(long __this__nativeId, int deviceId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qgamepadmanager.html#setCancelConfigureButton">QGamepadManager::setCancelConfigureButton(int,QGamepadManager::GamepadButton)</a></p>
     */
    public final boolean setCancelConfigureButton(int deviceId, io.qt.gamepad.QGamepadManager.@NonNull GamepadButton button){
        return setCancelConfigureButton_native_int_QGamepadManager_GamepadButton(QtJambi_LibraryUtilities.internal.nativeId(this), deviceId, button.value());
    }
    
    private native boolean setCancelConfigureButton_native_int_QGamepadManager_GamepadButton(long __this__nativeId, int deviceId, int button);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qgamepadmanager.html#setSettingsFile">QGamepadManager::setSettingsFile(QString)</a></p>
     */
    public final void setSettingsFile(java.lang.@NonNull String file){
        setSettingsFile_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), file);
    }
    
    private native void setSettingsFile_native_cref_QString(long __this__nativeId, java.lang.String file);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qgamepadmanager.html#instance">QGamepadManager::instance()</a></p>
     */
    public native static io.qt.gamepad.@Nullable QGamepadManager instance();
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @NativeAccess
    protected QGamepadManager(QPrivateConstructor p) { super(p); } 
    
}
