package io.qt.gamepad;


/**
 * <p>Queries attached gamepads and related events</p>
 * <p>Java wrapper for Qt's class <a href="http://doc.qt.io/qt-5/qgamepadmanager.html">QGamepadManager</a></p>
 */
public final class QGamepadManager extends io.qt.core.QObject
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QGamepadManager.class);
    
    /**
     * <p>Java wrapper for Qt enum QGamepadManager::GamepadAxis</p>
     */
    public enum GamepadAxis implements io.qt.QtEnumerator {
        AxisInvalid(-1),
        AxisLeftX(0),
        AxisLeftY(1),
        AxisRightX(2),
        AxisRightY(3);

        private GamepadAxis(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static GamepadAxis resolve(int value) {
            switch (value) {
            case -1: return AxisInvalid;
            case 0: return AxisLeftX;
            case 1: return AxisLeftY;
            case 2: return AxisRightX;
            case 3: return AxisRightY;
            default: throw new io.qt.QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * <p>Java wrapper for Qt enum QGamepadManager::GamepadButton</p>
     */
    public enum GamepadButton implements io.qt.QtEnumerator {
        ButtonInvalid(-1),
        ButtonA(0),
        ButtonB(1),
        ButtonX(2),
        ButtonY(3),
        ButtonL1(4),
        ButtonR1(5),
        ButtonL2(6),
        ButtonR2(7),
        ButtonSelect(8),
        ButtonStart(9),
        ButtonL3(10),
        ButtonR3(11),
        ButtonUp(12),
        ButtonDown(13),
        ButtonRight(14),
        ButtonLeft(15),
        ButtonCenter(16),
        ButtonGuide(17);

        private GamepadButton(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static GamepadButton resolve(int value) {
            switch (value) {
            case -1: return ButtonInvalid;
            case 0: return ButtonA;
            case 1: return ButtonB;
            case 2: return ButtonX;
            case 3: return ButtonY;
            case 4: return ButtonL1;
            case 5: return ButtonR1;
            case 6: return ButtonL2;
            case 7: return ButtonR2;
            case 8: return ButtonSelect;
            case 9: return ButtonStart;
            case 10: return ButtonL3;
            case 11: return ButtonR3;
            case 12: return ButtonUp;
            case 13: return ButtonDown;
            case 14: return ButtonRight;
            case 15: return ButtonLeft;
            case 16: return ButtonCenter;
            case 17: return ButtonGuide;
            default: throw new io.qt.QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    

    public final Signal2<@io.qt.QtPrimitiveType Integer, io.qt.gamepad.QGamepadManager.GamepadAxis> axisConfigured = new Signal2<>();

    public final Signal2<@io.qt.QtPrimitiveType Integer, io.qt.gamepad.QGamepadManager.GamepadButton> buttonConfigured = new Signal2<>();

    public final Signal1<@io.qt.QtPrimitiveType Integer> configurationCanceled = new Signal1<>();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qgamepadmanager.html#connectedGamepads-prop">QGamepadManager::connectedGamepadsChanged()</a></p>
     */
    @io.qt.QtPropertyNotify(name="connectedGamepads")
    public final Signal0 connectedGamepadsChanged = new Signal0();

    public final Signal3<@io.qt.QtPrimitiveType Integer, io.qt.gamepad.QGamepadManager.GamepadAxis, @io.qt.QtPrimitiveType Double> gamepadAxisEvent = new Signal3<>();

    public final Signal3<@io.qt.QtPrimitiveType Integer, io.qt.gamepad.QGamepadManager.GamepadButton, @io.qt.QtPrimitiveType Double> gamepadButtonPressEvent = new Signal3<>();

    public final Signal2<@io.qt.QtPrimitiveType Integer, io.qt.gamepad.QGamepadManager.GamepadButton> gamepadButtonReleaseEvent = new Signal2<>();

    public final Signal1<@io.qt.QtPrimitiveType Integer> gamepadConnected = new Signal1<>();

    public final Signal1<@io.qt.QtPrimitiveType Integer> gamepadDisconnected = new Signal1<>();

    public final Signal2<@io.qt.QtPrimitiveType Integer, java.lang.String> gamepadNameChanged = new Signal2<>();
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qgamepadmanager.html#configureAxis">QGamepadManager::configureAxis(int,QGamepadManager::GamepadAxis)</a></p>
     */
    public final boolean configureAxis(int deviceId, io.qt.gamepad.QGamepadManager.GamepadAxis axis){
        return configureAxis_native_int_QGamepadManager_GamepadAxis(QtJambi_LibraryUtilities.internal.nativeId(this), deviceId, axis.value());
    }
    
    private native boolean configureAxis_native_int_QGamepadManager_GamepadAxis(long __this__nativeId, int deviceId, int axis);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qgamepadmanager.html#configureButton">QGamepadManager::configureButton(int,QGamepadManager::GamepadButton)</a></p>
     */
    public final boolean configureButton(int deviceId, io.qt.gamepad.QGamepadManager.GamepadButton button){
        return configureButton_native_int_QGamepadManager_GamepadButton(QtJambi_LibraryUtilities.internal.nativeId(this), deviceId, button.value());
    }
    
    private native boolean configureButton_native_int_QGamepadManager_GamepadButton(long __this__nativeId, int deviceId, int button);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qgamepadmanager.html#connectedGamepads">QGamepadManager::connectedGamepads()const</a></p>
     */
    @io.qt.QtPropertyReader(name="connectedGamepads")
    @io.qt.QtUninvokable
    public final io.qt.core.QList<java.lang.Integer> connectedGamepads(){
        return connectedGamepads_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.core.QList<java.lang.Integer> connectedGamepads_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qgamepadmanager.html#gamepadName">QGamepadManager::gamepadName(int)const</a></p>
     */
    @io.qt.QtUninvokable
    public final java.lang.String gamepadName(int deviceId){
        return gamepadName_native_int_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), deviceId);
    }
    
    @io.qt.QtUninvokable
    private native java.lang.String gamepadName_native_int_constfct(long __this__nativeId, int deviceId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qgamepadmanager.html#isConfigurationNeeded">QGamepadManager::isConfigurationNeeded(int)const</a></p>
     */
    public final boolean isConfigurationNeeded(int deviceId){
        return isConfigurationNeeded_native_int_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), deviceId);
    }
    
    private native boolean isConfigurationNeeded_native_int_constfct(long __this__nativeId, int deviceId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qgamepadmanager.html#isGamepadConnected">QGamepadManager::isGamepadConnected(int)const</a></p>
     */
    @io.qt.QtUninvokable
    public final boolean isGamepadConnected(int deviceId){
        return isGamepadConnected_native_int_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), deviceId);
    }
    
    @io.qt.QtUninvokable
    private native boolean isGamepadConnected_native_int_constfct(long __this__nativeId, int deviceId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qgamepadmanager.html#resetConfiguration">QGamepadManager::resetConfiguration(int)</a></p>
     */
    public final void resetConfiguration(int deviceId){
        resetConfiguration_native_int(QtJambi_LibraryUtilities.internal.nativeId(this), deviceId);
    }
    
    private native void resetConfiguration_native_int(long __this__nativeId, int deviceId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qgamepadmanager.html#setCancelConfigureButton">QGamepadManager::setCancelConfigureButton(int,QGamepadManager::GamepadButton)</a></p>
     */
    public final boolean setCancelConfigureButton(int deviceId, io.qt.gamepad.QGamepadManager.GamepadButton button){
        return setCancelConfigureButton_native_int_QGamepadManager_GamepadButton(QtJambi_LibraryUtilities.internal.nativeId(this), deviceId, button.value());
    }
    
    private native boolean setCancelConfigureButton_native_int_QGamepadManager_GamepadButton(long __this__nativeId, int deviceId, int button);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qgamepadmanager.html#setSettingsFile">QGamepadManager::setSettingsFile(QString)</a></p>
     */
    public final void setSettingsFile(java.lang.String file){
        setSettingsFile_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), file);
    }
    
    private native void setSettingsFile_native_cref_QString(long __this__nativeId, java.lang.String file);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qgamepadmanager.html#instance">QGamepadManager::instance()</a></p>
     */
    public native static io.qt.gamepad.QGamepadManager instance();
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @io.qt.NativeAccess
    protected QGamepadManager(QPrivateConstructor p) { super(p); } 
    
}
