package io.qt.designer;


/**
 * <p>Allows you to manipulate a widget's properties which is displayed in Qt Designer's property editor</p>
 * <p>Java wrapper for Qt class <a href="https://doc.qt.io/qt/qdesignerpropertysheetextension.html">QDesignerPropertySheetExtension</a></p>
 */
public interface QDesignerPropertySheetExtension extends io.qt.QtObjectInterface
{
    /**
     * <p>Implementor class for interface {@link io.qt.designer.QDesignerPropertySheetExtension}</p>
     */
    public static abstract class Impl extends io.qt.QtObject
        implements io.qt.designer.QDesignerPropertySheetExtension
    {
        static {
            QtJambi_LibraryUtilities.initialize();
        }
        
        @io.qt.NativeAccess
        private static final class ConcreteWrapper extends QDesignerPropertySheetExtension.Impl {
            
            @io.qt.NativeAccess
            private ConcreteWrapper(QPrivateConstructor p) { super(p); }
            
            @Override
            @io.qt.QtUninvokable
            public int count(){
                return count_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
            }
            private native static int count_native_constfct(long __this__nativeId);
            
            
            @Override
            @io.qt.QtUninvokable
            public boolean hasReset(int index){
                return hasReset_native_int_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), index);
            }
            private native static boolean hasReset_native_int_constfct(long __this__nativeId, int index);
            
            
            @Override
            @io.qt.QtUninvokable
            public int indexOf(java.lang.String name){
                return indexOf_native_cref_QString_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), name);
            }
            private native static int indexOf_native_cref_QString_constfct(long __this__nativeId, java.lang.String name);
            
            
            @Override
            @io.qt.QtUninvokable
            public boolean isAttribute(int index){
                return isAttribute_native_int_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), index);
            }
            private native static boolean isAttribute_native_int_constfct(long __this__nativeId, int index);
            
            
            @Override
            @io.qt.QtUninvokable
            public boolean isChanged(int index){
                return isChanged_native_int_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), index);
            }
            private native static boolean isChanged_native_int_constfct(long __this__nativeId, int index);
            
            
            @Override
            @io.qt.QtUninvokable
            public boolean isEnabled(int index){
                return isEnabled_native_int_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), index);
            }
            private native static boolean isEnabled_native_int_constfct(long __this__nativeId, int index);
            
            
            @Override
            @io.qt.QtUninvokable
            public boolean isVisible(int index){
                return isVisible_native_int_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), index);
            }
            private native static boolean isVisible_native_int_constfct(long __this__nativeId, int index);
            
            
            @Override
            @io.qt.QtUninvokable
            public java.lang.Object property(int index){
                return property_native_int_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), index);
            }
            private native static java.lang.Object property_native_int_constfct(long __this__nativeId, int index);
            
            
            @Override
            @io.qt.QtUninvokable
            public java.lang.String propertyGroup(int index){
                return propertyGroup_native_int_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), index);
            }
            private native static java.lang.String propertyGroup_native_int_constfct(long __this__nativeId, int index);
            
            
            @Override
            @io.qt.QtUninvokable
            public java.lang.String propertyName(int index){
                return propertyName_native_int_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), index);
            }
            private native static java.lang.String propertyName_native_int_constfct(long __this__nativeId, int index);
            
            
            @Override
            @io.qt.QtUninvokable
            public boolean reset(int index){
                return reset_native_int(QtJambi_LibraryUtilities.internal.nativeId(this), index);
            }
            private native static boolean reset_native_int(long __this__nativeId, int index);
            
            
            @Override
            @io.qt.QtUninvokable
            public void setAttribute(int index, boolean b){
                setAttribute_native_int_bool(QtJambi_LibraryUtilities.internal.nativeId(this), index, b);
            }
            private native static void setAttribute_native_int_bool(long __this__nativeId, int index, boolean b);
            
            
            @Override
            @io.qt.QtUninvokable
            public void setChanged(int index, boolean changed){
                setChanged_native_int_bool(QtJambi_LibraryUtilities.internal.nativeId(this), index, changed);
            }
            private native static void setChanged_native_int_bool(long __this__nativeId, int index, boolean changed);
            
            
            @Override
            @io.qt.QtUninvokable
            public void setProperty(int index, java.lang.Object value){
                setProperty_native_int_cref_QVariant(QtJambi_LibraryUtilities.internal.nativeId(this), index, value);
            }
            private native static void setProperty_native_int_cref_QVariant(long __this__nativeId, int index, java.lang.Object value);
            
            
            @Override
            @io.qt.QtUninvokable
            public void setPropertyGroup(int index, java.lang.String group){
                setPropertyGroup_native_int_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), index, group);
            }
            private native static void setPropertyGroup_native_int_cref_QString(long __this__nativeId, int index, java.lang.String group);
            
            
            @Override
            @io.qt.QtUninvokable
            public void setVisible(int index, boolean b){
                setVisible_native_int_bool(QtJambi_LibraryUtilities.internal.nativeId(this), index, b);
            }
            private native static void setVisible_native_int_bool(long __this__nativeId, int index, boolean b);
            
        }
        
        
        public Impl(){
            super((QPrivateConstructor)null);
            initialize_native(this);
        }
        
        private native static void initialize_native(QDesignerPropertySheetExtension instance);
        
        /**
         * <p>See <a href="https://doc.qt.io/qt/qdesignerpropertysheetextension.html#count">QDesignerPropertySheetExtension::</a></p>
         */
        @io.qt.QtUninvokable
        public abstract int count();
        
        private native static int count_native_constfct(long __this__nativeId);
        
        /**
         * <p>See <a href="https://doc.qt.io/qt/qdesignerpropertysheetextension.html#hasReset">QDesignerPropertySheetExtension::</a></p>
         */
        @io.qt.QtUninvokable
        public abstract boolean hasReset(int index);
        
        private native static boolean hasReset_native_int_constfct(long __this__nativeId, int index);
        
        /**
         * <p>See <a href="https://doc.qt.io/qt/qdesignerpropertysheetextension.html#indexOf">QDesignerPropertySheetExtension::</a></p>
         */
        @io.qt.QtUninvokable
        public abstract int indexOf(java.lang.String name);
        
        private native static int indexOf_native_cref_QString_constfct(long __this__nativeId, java.lang.String name);
        
        /**
         * <p>See <a href="https://doc.qt.io/qt/qdesignerpropertysheetextension.html#isAttribute">QDesignerPropertySheetExtension::</a></p>
         */
        @io.qt.QtUninvokable
        public abstract boolean isAttribute(int index);
        
        private native static boolean isAttribute_native_int_constfct(long __this__nativeId, int index);
        
        /**
         * <p>See <a href="https://doc.qt.io/qt/qdesignerpropertysheetextension.html#isChanged">QDesignerPropertySheetExtension::</a></p>
         */
        @io.qt.QtUninvokable
        public abstract boolean isChanged(int index);
        
        private native static boolean isChanged_native_int_constfct(long __this__nativeId, int index);
        
        /**
         * <p>See <a href="https://doc.qt.io/qt/qdesignerpropertysheetextension.html#isEnabled">QDesignerPropertySheetExtension::</a></p>
         */
        @io.qt.QtUninvokable
        public abstract boolean isEnabled(int index);
        
        private native static boolean isEnabled_native_int_constfct(long __this__nativeId, int index);
        
        /**
         * <p>See <a href="https://doc.qt.io/qt/qdesignerpropertysheetextension.html#isVisible">QDesignerPropertySheetExtension::</a></p>
         */
        @io.qt.QtUninvokable
        public abstract boolean isVisible(int index);
        
        private native static boolean isVisible_native_int_constfct(long __this__nativeId, int index);
        
        /**
         * <p>See <a href="https://doc.qt.io/qt/qdesignerpropertysheetextension.html#property">QDesignerPropertySheetExtension::</a></p>
         */
        @io.qt.QtUninvokable
        public abstract java.lang.Object property(int index);
        
        private native static java.lang.Object property_native_int_constfct(long __this__nativeId, int index);
        
        /**
         * <p>See <a href="https://doc.qt.io/qt/qdesignerpropertysheetextension.html#propertyGroup">QDesignerPropertySheetExtension::</a></p>
         */
        @io.qt.QtUninvokable
        public abstract java.lang.String propertyGroup(int index);
        
        private native static java.lang.String propertyGroup_native_int_constfct(long __this__nativeId, int index);
        
        /**
         * <p>See <a href="https://doc.qt.io/qt/qdesignerpropertysheetextension.html#propertyName">QDesignerPropertySheetExtension::</a></p>
         */
        @io.qt.QtUninvokable
        public abstract java.lang.String propertyName(int index);
        
        private native static java.lang.String propertyName_native_int_constfct(long __this__nativeId, int index);
        
        /**
         * <p>See <a href="https://doc.qt.io/qt/qdesignerpropertysheetextension.html#reset">QDesignerPropertySheetExtension::</a></p>
         */
        @io.qt.QtUninvokable
        public abstract boolean reset(int index);
        
        private native static boolean reset_native_int(long __this__nativeId, int index);
        
        /**
         * <p>See <a href="https://doc.qt.io/qt/qdesignerpropertysheetextension.html#setAttribute">QDesignerPropertySheetExtension::</a></p>
         */
        @io.qt.QtUninvokable
        public abstract void setAttribute(int index, boolean b);
        
        private native static void setAttribute_native_int_bool(long __this__nativeId, int index, boolean b);
        
        /**
         * <p>See <a href="https://doc.qt.io/qt/qdesignerpropertysheetextension.html#setChanged">QDesignerPropertySheetExtension::</a></p>
         */
        @io.qt.QtUninvokable
        public abstract void setChanged(int index, boolean changed);
        
        private native static void setChanged_native_int_bool(long __this__nativeId, int index, boolean changed);
        
        /**
         * <p>See <a href="https://doc.qt.io/qt/qdesignerpropertysheetextension.html#setProperty">QDesignerPropertySheetExtension::</a></p>
         */
        @io.qt.QtUninvokable
        public abstract void setProperty(int index, java.lang.Object value);
        
        private native static void setProperty_native_int_cref_QVariant(long __this__nativeId, int index, java.lang.Object value);
        
        /**
         * <p>See <a href="https://doc.qt.io/qt/qdesignerpropertysheetextension.html#setPropertyGroup">QDesignerPropertySheetExtension::</a></p>
         */
        @io.qt.QtUninvokable
        public abstract void setPropertyGroup(int index, java.lang.String group);
        
        private native static void setPropertyGroup_native_int_cref_QString(long __this__nativeId, int index, java.lang.String group);
        
        /**
         * <p>See <a href="https://doc.qt.io/qt/qdesignerpropertysheetextension.html#setVisible">QDesignerPropertySheetExtension::</a></p>
         */
        @io.qt.QtUninvokable
        public abstract void setVisible(int index, boolean b);
        
        private native static void setVisible_native_int_bool(long __this__nativeId, int index, boolean b);
        
        /**
         * Constructor for internal use only.
         * @param p expected to be <code>null</code>.
         */
        @io.qt.NativeAccess
        protected Impl(QPrivateConstructor p) { super(p); } 
        
    }

    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qdesignerpropertysheetextension.html#count">QDesignerPropertySheetExtension::count()const</a></p>
     */
    @io.qt.QtUninvokable
    public int count();
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qdesignerpropertysheetextension.html#hasReset">QDesignerPropertySheetExtension::hasReset(int)const</a></p>
     */
    @io.qt.QtUninvokable
    public boolean hasReset(int index);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qdesignerpropertysheetextension.html#indexOf">QDesignerPropertySheetExtension::indexOf(QString)const</a></p>
     */
    @io.qt.QtUninvokable
    public int indexOf(java.lang.String name);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qdesignerpropertysheetextension.html#isAttribute">QDesignerPropertySheetExtension::isAttribute(int)const</a></p>
     */
    @io.qt.QtUninvokable
    public boolean isAttribute(int index);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qdesignerpropertysheetextension.html#isChanged">QDesignerPropertySheetExtension::isChanged(int)const</a></p>
     */
    @io.qt.QtUninvokable
    public boolean isChanged(int index);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qdesignerpropertysheetextension.html#isEnabled">QDesignerPropertySheetExtension::isEnabled(int)const</a></p>
     */
    @io.qt.QtUninvokable
    public boolean isEnabled(int index);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qdesignerpropertysheetextension.html#isVisible">QDesignerPropertySheetExtension::isVisible(int)const</a></p>
     */
    @io.qt.QtUninvokable
    public boolean isVisible(int index);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qdesignerpropertysheetextension.html#property">QDesignerPropertySheetExtension::property(int)const</a></p>
     */
    @io.qt.QtUninvokable
    public java.lang.Object property(int index);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qdesignerpropertysheetextension.html#propertyGroup">QDesignerPropertySheetExtension::propertyGroup(int)const</a></p>
     */
    @io.qt.QtUninvokable
    public java.lang.String propertyGroup(int index);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qdesignerpropertysheetextension.html#propertyName">QDesignerPropertySheetExtension::propertyName(int)const</a></p>
     */
    @io.qt.QtUninvokable
    public java.lang.String propertyName(int index);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qdesignerpropertysheetextension.html#reset">QDesignerPropertySheetExtension::reset(int)</a></p>
     */
    @io.qt.QtUninvokable
    public boolean reset(int index);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qdesignerpropertysheetextension.html#setAttribute">QDesignerPropertySheetExtension::setAttribute(int,bool)</a></p>
     */
    @io.qt.QtUninvokable
    public void setAttribute(int index, boolean b);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qdesignerpropertysheetextension.html#setChanged">QDesignerPropertySheetExtension::setChanged(int,bool)</a></p>
     */
    @io.qt.QtUninvokable
    public void setChanged(int index, boolean changed);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qdesignerpropertysheetextension.html#setProperty">QDesignerPropertySheetExtension::setProperty(int,QVariant)</a></p>
     */
    @io.qt.QtUninvokable
    public void setProperty(int index, java.lang.Object value);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qdesignerpropertysheetextension.html#setPropertyGroup">QDesignerPropertySheetExtension::setPropertyGroup(int,QString)</a></p>
     */
    @io.qt.QtUninvokable
    public void setPropertyGroup(int index, java.lang.String group);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qdesignerpropertysheetextension.html#setVisible">QDesignerPropertySheetExtension::setVisible(int,bool)</a></p>
     */
    @io.qt.QtUninvokable
    public void setVisible(int index, boolean b);
    
}
