package io.qt.designer;


/**
 * <p>Allows you to include several custom widgets in one single library</p>
 * <p>Java wrapper for Qt class <a href="https://doc.qt.io/qt/qdesignercustomwidgetcollectioninterface.html">QDesignerCustomWidgetCollectionInterface</a></p>
 */
public interface QDesignerCustomWidgetCollectionInterface extends io.qt.QtObjectInterface
{
    /**
     * <p>Implementor class for interface {@link io.qt.designer.QDesignerCustomWidgetCollectionInterface}</p>
     */
    public static abstract class Impl extends io.qt.QtObject
        implements io.qt.designer.QDesignerCustomWidgetCollectionInterface
    {
        static {
            QtJambi_LibraryUtilities.initialize();
        }
        
        @io.qt.NativeAccess
        private static final class ConcreteWrapper extends QDesignerCustomWidgetCollectionInterface.Impl {
            
            @io.qt.NativeAccess
            private ConcreteWrapper(QPrivateConstructor p) { super(p); }
            
            @Override
            @io.qt.QtUninvokable
            public java.util.List<io.qt.designer.QDesignerCustomWidgetInterface> customWidgets(){
                return customWidgets_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
            }
            private native static java.util.List<io.qt.designer.QDesignerCustomWidgetInterface> customWidgets_native_constfct(long __this__nativeId);
            
        }
        
        
        public Impl(){
            super((QPrivateConstructor)null);
            initialize_native(this);
        }
        
        private native static void initialize_native(QDesignerCustomWidgetCollectionInterface instance);
        
        /**
         * <p>See <a href="https://doc.qt.io/qt/qdesignercustomwidgetcollectioninterface.html#customWidgets">QDesignerCustomWidgetCollectionInterface::</a></p>
         */
        @io.qt.QtUninvokable
        public abstract java.util.List<io.qt.designer.QDesignerCustomWidgetInterface> customWidgets();
        
        private native static java.util.List<io.qt.designer.QDesignerCustomWidgetInterface> customWidgets_native_constfct(long __this__nativeId);
        
        /**
         * Constructor for internal use only.
         * @param p expected to be <code>null</code>.
         */
        @io.qt.NativeAccess
        protected Impl(QPrivateConstructor p) { super(p); } 
        
    }

    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qdesignercustomwidgetcollectioninterface.html#customWidgets">QDesignerCustomWidgetCollectionInterface::customWidgets()const</a></p>
     */
    @io.qt.QtUninvokable
    public java.util.List<io.qt.designer.QDesignerCustomWidgetInterface> customWidgets();
    
}
