package io.qt.designer;


/**
 * <p>Used to dynamically construct user interfaces from UI files at run-time</p>
 * <p>Java wrapper for Qt class <a href="http://doc.qt.io/qt-5/qformbuilder.html">QFormBuilder</a></p>
 */
public class QFormBuilder extends io.qt.designer.QAbstractFormBuilder
{
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qformbuilder.html#QFormBuilder">QFormBuilder::QFormBuilder()</a></p>
     */
    public QFormBuilder(){
        super((QPrivateConstructor)null);
        initialize_native(this);
    }
    
    private native static void initialize_native(QFormBuilder instance);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qformbuilder.html#addPluginPath">QFormBuilder::addPluginPath(QString)</a></p>
     */
    @io.qt.QtUninvokable
    public final void addPluginPath(java.lang.String pluginPath){
        addPluginPath_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), pluginPath);
    }
    
    @io.qt.QtUninvokable
    private native void addPluginPath_native_cref_QString(long __this__nativeId, java.lang.String pluginPath);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qformbuilder.html#clearPluginPaths">QFormBuilder::clearPluginPaths()</a></p>
     */
    @io.qt.QtUninvokable
    public final void clearPluginPaths(){
        clearPluginPaths_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native void clearPluginPaths_native(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qformbuilder.html#customWidgets">QFormBuilder::customWidgets()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.core.QList<io.qt.designer.QDesignerCustomWidgetInterface> customWidgets(){
        return customWidgets_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.core.QList<io.qt.designer.QDesignerCustomWidgetInterface> customWidgets_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qformbuilder.html#pluginPaths">QFormBuilder::pluginPaths()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.core.QStringList pluginPaths(){
        return pluginPaths_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.core.QStringList pluginPaths_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qformbuilder.html#setPluginPath">QFormBuilder::setPluginPath(QStringList)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setPluginPath(java.util.Collection<java.lang.String> pluginPaths){
        setPluginPath_native_cref_QStringList(QtJambi_LibraryUtilities.internal.nativeId(this), pluginPaths);
    }
    
    @io.qt.QtUninvokable
    private native void setPluginPath_native_cref_QStringList(long __this__nativeId, java.util.Collection<java.lang.String> pluginPaths);
    
    @io.qt.QtUninvokable
    protected io.qt.widgets.QLayout createLayout(java.lang.String layoutName, io.qt.core.QObject parent, java.lang.String name){
        return createLayout_native_cref_QString_QObject_ptr_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), layoutName, QtJambi_LibraryUtilities.internal.checkedNativeId(parent), name);
    }
    
    @io.qt.QtUninvokable
    private native io.qt.widgets.QLayout createLayout_native_cref_QString_QObject_ptr_cref_QString(long __this__nativeId, java.lang.String layoutName, long parent, java.lang.String name);
    
    @io.qt.QtUninvokable
    protected io.qt.widgets.QWidget createWidget(java.lang.String widgetName, io.qt.widgets.QWidget parentWidget, java.lang.String name){
        return createWidget_native_cref_QString_QWidget_ptr_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), widgetName, QtJambi_LibraryUtilities.internal.checkedNativeId(parentWidget), name);
    }
    
    @io.qt.QtUninvokable
    private native io.qt.widgets.QWidget createWidget_native_cref_QString_QWidget_ptr_cref_QString(long __this__nativeId, java.lang.String widgetName, long parentWidget, java.lang.String name);
    
    @io.qt.QtUninvokable
    protected void updateCustomWidgets(){
        updateCustomWidgets_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native void updateCustomWidgets_native(long __this__nativeId);
    
    protected static io.qt.widgets.QWidget widgetByName(io.qt.widgets.QWidget topLevel, java.lang.String name){
        return widgetByName_native_QWidget_ptr_cref_QString(QtJambi_LibraryUtilities.internal.checkedNativeId(topLevel), name);
    }
    
    private native static io.qt.widgets.QWidget widgetByName_native_QWidget_ptr_cref_QString(long topLevel, java.lang.String name);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @io.qt.NativeAccess
    protected QFormBuilder(QPrivateConstructor p) { super(p); } 
    
}
