package io.qt.designer;


/**
 * <p>Allows you to add pages to a custom multi-page container in Qt Designer's workspace</p>
 * <p>Java wrapper for Qt class <a href="http://doc.qt.io/qt-5/qdesignercontainerextension.html">QDesignerContainerExtension</a></p>
 */
public interface QDesignerContainerExtension extends io.qt.QtObjectInterface
{
    /**
     * <p>Implementor class for interface {@link io.qt.designer.QDesignerContainerExtension}</p>
     */
    public static abstract class Impl extends io.qt.QtObject
        implements io.qt.designer.QDesignerContainerExtension
    {
        static {
            QtJambi_LibraryUtilities.initialize();
        }
        
        
        @io.qt.NativeAccess
        private static final class ConcreteWrapper extends QDesignerContainerExtension.Impl {
            
            @io.qt.NativeAccess
            private ConcreteWrapper(QPrivateConstructor p) { super(p); }
            
            @Override
            @io.qt.QtUninvokable
            public void addWidget(io.qt.widgets.QWidget widget){
                addWidget_native_QWidget_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(widget));
            }
            private native static void addWidget_native_QWidget_ptr(long __this__nativeId, long widget);
            
            
            @Override
            @io.qt.QtUninvokable
            public int count(){
                return count_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
            }
            private native static int count_native_constfct(long __this__nativeId);
            
            
            @Override
            @io.qt.QtUninvokable
            public int currentIndex(){
                return currentIndex_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
            }
            private native static int currentIndex_native_constfct(long __this__nativeId);
            
            
            @Override
            @io.qt.QtUninvokable
            public void insertWidget(int index, io.qt.widgets.QWidget widget){
                insertWidget_native_int_QWidget_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), index, QtJambi_LibraryUtilities.internal.checkedNativeId(widget));
            }
            private native static void insertWidget_native_int_QWidget_ptr(long __this__nativeId, int index, long widget);
            
            
            @Override
            @io.qt.QtUninvokable
            public void remove(int index){
                remove_native_int(QtJambi_LibraryUtilities.internal.nativeId(this), index);
            }
            private native static void remove_native_int(long __this__nativeId, int index);
            
            
            @Override
            @io.qt.QtUninvokable
            public void setCurrentIndex(int index){
                setCurrentIndex_native_int(QtJambi_LibraryUtilities.internal.nativeId(this), index);
            }
            private native static void setCurrentIndex_native_int(long __this__nativeId, int index);
            
            
            @Override
            @io.qt.QtUninvokable
            public io.qt.widgets.QWidget widget(int index){
                return widget_native_int_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), index);
            }
            private native static io.qt.widgets.QWidget widget_native_int_constfct(long __this__nativeId, int index);
            
        }
        
        
        public Impl(){
            super((QPrivateConstructor)null);
            initialize_native(this);
        }
        
        private native static void initialize_native(QDesignerContainerExtension instance);
        
        /**
         * <p>See <a href="http://doc.qt.io/qt-5/qdesignercontainerextension.html#addWidget">QDesignerContainerExtension::addWidget(QWidget*)</a></p>
         */
        @io.qt.QtUninvokable
        public abstract void addWidget(io.qt.widgets.QWidget widget);
        
        private native static void addWidget_native_QWidget_ptr(long __this__nativeId, long widget);
        
        /**
         * <p>See <a href="http://doc.qt.io/qt-5/qdesignercontainerextension.html#canAddWidget">QDesignerContainerExtension::canAddWidget()const</a></p>
         */
        @io.qt.QtUninvokable
        public boolean canAddWidget(){
            return canAddWidget_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        
        private native static boolean canAddWidget_native_constfct(long __this__nativeId);
        
        /**
         * <p>See <a href="http://doc.qt.io/qt-5/qdesignercontainerextension.html#canRemove">QDesignerContainerExtension::canRemove(int)const</a></p>
         */
        @io.qt.QtUninvokable
        public boolean canRemove(int index){
            return canRemove_native_int_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), index);
        }
        
        private native static boolean canRemove_native_int_constfct(long __this__nativeId, int index);
        
        /**
         * <p>See <a href="http://doc.qt.io/qt-5/qdesignercontainerextension.html#count">QDesignerContainerExtension::count()const</a></p>
         */
        @io.qt.QtUninvokable
        public abstract int count();
        
        private native static int count_native_constfct(long __this__nativeId);
        
        /**
         * <p>See <a href="http://doc.qt.io/qt-5/qdesignercontainerextension.html#currentIndex">QDesignerContainerExtension::currentIndex()const</a></p>
         */
        @io.qt.QtUninvokable
        public abstract int currentIndex();
        
        private native static int currentIndex_native_constfct(long __this__nativeId);
        
        /**
         * <p>See <a href="http://doc.qt.io/qt-5/qdesignercontainerextension.html#insertWidget">QDesignerContainerExtension::insertWidget(int,QWidget*)</a></p>
         */
        @io.qt.QtUninvokable
        public abstract void insertWidget(int index, io.qt.widgets.QWidget widget);
        
        private native static void insertWidget_native_int_QWidget_ptr(long __this__nativeId, int index, long widget);
        
        /**
         * <p>See <a href="http://doc.qt.io/qt-5/qdesignercontainerextension.html#remove">QDesignerContainerExtension::remove(int)</a></p>
         */
        @io.qt.QtUninvokable
        public abstract void remove(int index);
        
        private native static void remove_native_int(long __this__nativeId, int index);
        
        /**
         * <p>See <a href="http://doc.qt.io/qt-5/qdesignercontainerextension.html#setCurrentIndex">QDesignerContainerExtension::setCurrentIndex(int)</a></p>
         */
        @io.qt.QtUninvokable
        public abstract void setCurrentIndex(int index);
        
        private native static void setCurrentIndex_native_int(long __this__nativeId, int index);
        
        /**
         * <p>See <a href="http://doc.qt.io/qt-5/qdesignercontainerextension.html#widget">QDesignerContainerExtension::widget(int)const</a></p>
         */
        @io.qt.QtUninvokable
        public abstract io.qt.widgets.QWidget widget(int index);
        
        private native static io.qt.widgets.QWidget widget_native_int_constfct(long __this__nativeId, int index);
        
        /**
         * Constructor for internal use only.
         * @param p expected to be <code>null</code>.
         */
        @io.qt.NativeAccess
        protected Impl(QPrivateConstructor p) { super(p); } 
        
    }

    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdesignercontainerextension.html#addWidget">QDesignerContainerExtension::addWidget(QWidget*)</a></p>
     */
    @io.qt.QtUninvokable
    public void addWidget(io.qt.widgets.QWidget widget);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdesignercontainerextension.html#canAddWidget">QDesignerContainerExtension::canAddWidget()const</a></p>
     */
    @io.qt.QtUninvokable
    public default boolean canAddWidget(){
        return Impl.canAddWidget_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdesignercontainerextension.html#canRemove">QDesignerContainerExtension::canRemove(int)const</a></p>
     */
    @io.qt.QtUninvokable
    public default boolean canRemove(int index){
        return Impl.canRemove_native_int_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), index);
    }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdesignercontainerextension.html#count">QDesignerContainerExtension::count()const</a></p>
     */
    @io.qt.QtUninvokable
    public int count();
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdesignercontainerextension.html#currentIndex">QDesignerContainerExtension::currentIndex()const</a></p>
     */
    @io.qt.QtUninvokable
    public int currentIndex();
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdesignercontainerextension.html#insertWidget">QDesignerContainerExtension::insertWidget(int,QWidget*)</a></p>
     */
    @io.qt.QtUninvokable
    public void insertWidget(int index, io.qt.widgets.QWidget widget);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdesignercontainerextension.html#remove">QDesignerContainerExtension::remove(int)</a></p>
     */
    @io.qt.QtUninvokable
    public void remove(int index);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdesignercontainerextension.html#setCurrentIndex">QDesignerContainerExtension::setCurrentIndex(int)</a></p>
     */
    @io.qt.QtUninvokable
    public void setCurrentIndex(int index);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdesignercontainerextension.html#widget">QDesignerContainerExtension::widget(int)const</a></p>
     */
    @io.qt.QtUninvokable
    public io.qt.widgets.QWidget widget(int index);
    
}
