package io.qt.designer;


/**
 * <p>Default implementation for classes that create user interfaces at run-time</p>
 * <p>Java wrapper for Qt class <a href="http://doc.qt.io/qt-5/qabstractformbuilder.html">QAbstractFormBuilder</a></p>
 */
public class QAbstractFormBuilder extends io.qt.QtObject
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qabstractformbuilder.html#QAbstractFormBuilder-1">QAbstractFormBuilder::QAbstractFormBuilder()</a></p>
     */
    public QAbstractFormBuilder(){
        super((QPrivateConstructor)null);
        initialize_native(this);
    }
    
    private native static void initialize_native(QAbstractFormBuilder instance);
    
    @io.qt.QtUninvokable
    protected final boolean applyPropertyInternally(io.qt.core.QObject o, java.lang.String propertyName, java.lang.Object value){
        return applyPropertyInternally_native_QObject_ptr_cref_QString_cref_QVariant(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(o), propertyName, value);
    }
    
    @io.qt.QtUninvokable
    private native boolean applyPropertyInternally_native_QObject_ptr_cref_QString_cref_QVariant(long __this__nativeId, long o, java.lang.String propertyName, java.lang.Object value);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qabstractformbuilder.html#errorString">QAbstractFormBuilder::errorString()const</a></p>
     */
    @io.qt.QtUninvokable
    public final java.lang.String errorString(){
        return errorString_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native java.lang.String errorString_native_constfct(long __this__nativeId);
    
    @io.qt.QtUninvokable
    protected final io.qt.core.QPair<java.lang.String, java.lang.String> iconPaths(io.qt.gui.QIcon arg__1){
        return iconPaths_native_cref_QIcon_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(arg__1));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.core.QPair<java.lang.String, java.lang.String> iconPaths_native_cref_QIcon_constfct(long __this__nativeId, long arg__1);
    
    @io.qt.QtUninvokable
    protected final io.qt.core.QPair<java.lang.String, java.lang.String> pixmapPaths(io.qt.gui.QPixmap arg__1){
        return pixmapPaths_native_cref_QPixmap_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(arg__1));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.core.QPair<java.lang.String, java.lang.String> pixmapPaths_native_cref_QPixmap_constfct(long __this__nativeId, long arg__1);
    
    @io.qt.QtUninvokable
    protected final void reset(){
        reset_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native void reset_native(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qabstractformbuilder.html#setWorkingDirectory">QAbstractFormBuilder::setWorkingDirectory(QDir)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setWorkingDirectory(io.qt.core.QDir directory){
        setWorkingDirectory_native_cref_QDir(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(directory));
    }
    
    @io.qt.QtUninvokable
    private native void setWorkingDirectory_native_cref_QDir(long __this__nativeId, long directory);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qabstractformbuilder.html#workingDirectory">QAbstractFormBuilder::workingDirectory()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.core.QDir workingDirectory(){
        return workingDirectory_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.core.QDir workingDirectory_native_constfct(long __this__nativeId);
    
    @io.qt.QtUninvokable
    protected void addMenuAction(io.qt.widgets.QAction action){
        addMenuAction_native_QAction_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(action));
    }
    
    @io.qt.QtUninvokable
    private native void addMenuAction_native_QAction_ptr(long __this__nativeId, long action);
    
    @io.qt.QtUninvokable
    protected boolean checkProperty(io.qt.core.QObject obj, java.lang.String prop){
        return checkProperty_native_QObject_ptr_cref_QString_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(obj), prop);
    }
    
    @io.qt.QtUninvokable
    private native boolean checkProperty_native_QObject_ptr_cref_QString_constfct(long __this__nativeId, long obj, java.lang.String prop);
    
    @io.qt.QtUninvokable
    protected io.qt.widgets.QAction createAction(io.qt.core.QObject parent, java.lang.String name){
        return createAction_native_QObject_ptr_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(parent), name);
    }
    
    @io.qt.QtUninvokable
    private native io.qt.widgets.QAction createAction_native_QObject_ptr_cref_QString(long __this__nativeId, long parent, java.lang.String name);
    
    @io.qt.QtUninvokable
    protected io.qt.widgets.QActionGroup createActionGroup(io.qt.core.QObject parent, java.lang.String name){
        return createActionGroup_native_QObject_ptr_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(parent), name);
    }
    
    @io.qt.QtUninvokable
    private native io.qt.widgets.QActionGroup createActionGroup_native_QObject_ptr_cref_QString(long __this__nativeId, long parent, java.lang.String name);
    
    @io.qt.QtUninvokable
    protected io.qt.widgets.QLayout createLayout(java.lang.String layoutName, io.qt.core.QObject parent, java.lang.String name){
        return createLayout_native_cref_QString_QObject_ptr_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), layoutName, QtJambi_LibraryUtilities.internal.checkedNativeId(parent), name);
    }
    
    @io.qt.QtUninvokable
    private native io.qt.widgets.QLayout createLayout_native_cref_QString_QObject_ptr_cref_QString(long __this__nativeId, java.lang.String layoutName, long parent, java.lang.String name);
    
    @io.qt.QtUninvokable
    protected io.qt.widgets.QWidget createWidget(java.lang.String widgetName, io.qt.widgets.QWidget parentWidget, java.lang.String name){
        return createWidget_native_cref_QString_QWidget_ptr_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), widgetName, QtJambi_LibraryUtilities.internal.checkedNativeId(parentWidget), name);
    }
    
    @io.qt.QtUninvokable
    private native io.qt.widgets.QWidget createWidget_native_cref_QString_QWidget_ptr_cref_QString(long __this__nativeId, java.lang.String widgetName, long parentWidget, java.lang.String name);
    
    /**
     * <p>Overloaded function for {@link #load(io.qt.core.QIODevice, io.qt.widgets.QWidget)}
     *  with <code>parentWidget = null</code>.</p>
     */
    @io.qt.QtUninvokable
    public final io.qt.widgets.QWidget load(io.qt.core.QIODevice dev) {
        return load(dev, (io.qt.widgets.QWidget)null);
    }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qabstractformbuilder.html#load">QAbstractFormBuilder::load(QIODevice*,QWidget*)</a></p>
     */
    @io.qt.QtUninvokable
    public io.qt.widgets.QWidget load(io.qt.core.QIODevice dev, io.qt.widgets.QWidget parentWidget){
        return load_native_QIODevice_ptr_QWidget_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(dev), QtJambi_LibraryUtilities.internal.checkedNativeId(parentWidget));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.widgets.QWidget load_native_QIODevice_ptr_QWidget_ptr(long __this__nativeId, long dev, long parentWidget);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qabstractformbuilder.html#save">QAbstractFormBuilder::save(QIODevice*,QWidget*)</a></p>
     */
    @io.qt.QtUninvokable
    public void save(io.qt.core.QIODevice dev, io.qt.widgets.QWidget widget){
        save_native_QIODevice_ptr_QWidget_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(dev), QtJambi_LibraryUtilities.internal.checkedNativeId(widget));
    }
    
    @io.qt.QtUninvokable
    private native void save_native_QIODevice_ptr_QWidget_ptr(long __this__nativeId, long dev, long widget);
    
    protected native static io.qt.core.QMetaEnum toolBarAreaMetaEnum();
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @io.qt.NativeAccess
    protected QAbstractFormBuilder(QPrivateConstructor p) { super(p); } 
    
}
