package io.qt.designer;


/**
 * <p>Allows you to control the contents of Qt Designer's widget box</p>
 * <p>Java wrapper for Qt's class <a href="http://doc.qt.io/qt-5/qdesignerwidgetboxinterface.html">QDesignerWidgetBoxInterface</a></p>
 */
public abstract class QDesignerWidgetBoxInterface extends io.qt.widgets.QWidget
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QDesignerWidgetBoxInterface.class);
    
    @io.qt.NativeAccess
    private static final class ConcreteWrapper extends QDesignerWidgetBoxInterface {
        
        @io.qt.NativeAccess
        private ConcreteWrapper(QPrivateConstructor p) { super(p); }
        
        @Override
        @io.qt.QtUninvokable
        public void addCategory(io.qt.designer.QDesignerWidgetBoxInterface.Category cat){
            addCategory_native_cref_QDesignerWidgetBoxInterface_Category(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(cat));
        }
        @io.qt.QtUninvokable
        private native void addCategory_native_cref_QDesignerWidgetBoxInterface_Category(long __this__nativeId, long cat);
        
        
        @Override
        @io.qt.QtUninvokable
        public void addWidget(int cat_idx, io.qt.designer.QDesignerWidgetBoxInterface.Widget wgt){
            addWidget_native_int_cref_QDesignerWidgetBoxInterface_Widget(QtJambi_LibraryUtilities.internal.nativeId(this), cat_idx, QtJambi_LibraryUtilities.internal.checkedNativeId(wgt));
        }
        @io.qt.QtUninvokable
        private native void addWidget_native_int_cref_QDesignerWidgetBoxInterface_Widget(long __this__nativeId, int cat_idx, long wgt);
        
        
        @Override
        @io.qt.QtUninvokable
        public io.qt.designer.QDesignerWidgetBoxInterface.Category category(int cat_idx){
            return category_native_int_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), cat_idx);
        }
        @io.qt.QtUninvokable
        private native io.qt.designer.QDesignerWidgetBoxInterface.Category category_native_int_constfct(long __this__nativeId, int cat_idx);
        
        
        @Override
        @io.qt.QtUninvokable
        public int categoryCount(){
            return categoryCount_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        @io.qt.QtUninvokable
        private native int categoryCount_native_constfct(long __this__nativeId);
        
        
        @Override
        @io.qt.QtUninvokable
        public java.lang.String fileName(){
            return fileName_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        @io.qt.QtUninvokable
        private native java.lang.String fileName_native_constfct(long __this__nativeId);
        
        
        @Override
        @io.qt.QtUninvokable
        public boolean load(){
            return load_native(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        @io.qt.QtUninvokable
        private native boolean load_native(long __this__nativeId);
        
        
        @Override
        @io.qt.QtUninvokable
        public void removeCategory(int cat_idx){
            removeCategory_native_int(QtJambi_LibraryUtilities.internal.nativeId(this), cat_idx);
        }
        @io.qt.QtUninvokable
        private native void removeCategory_native_int(long __this__nativeId, int cat_idx);
        
        
        @Override
        @io.qt.QtUninvokable
        public void removeWidget(int cat_idx, int wgt_idx){
            removeWidget_native_int_int(QtJambi_LibraryUtilities.internal.nativeId(this), cat_idx, wgt_idx);
        }
        @io.qt.QtUninvokable
        private native void removeWidget_native_int_int(long __this__nativeId, int cat_idx, int wgt_idx);
        
        
        @Override
        @io.qt.QtUninvokable
        public boolean save(){
            return save_native(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        @io.qt.QtUninvokable
        private native boolean save_native(long __this__nativeId);
        
        
        @Override
        @io.qt.QtUninvokable
        public void setFileName(java.lang.String file_name){
            setFileName_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), file_name);
        }
        @io.qt.QtUninvokable
        private native void setFileName_native_cref_QString(long __this__nativeId, java.lang.String file_name);
        
        
        @Override
        @io.qt.QtUninvokable
        public io.qt.designer.QDesignerWidgetBoxInterface.Widget widget(int cat_idx, int wgt_idx){
            return widget_native_int_int_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), cat_idx, wgt_idx);
        }
        @io.qt.QtUninvokable
        private native io.qt.designer.QDesignerWidgetBoxInterface.Widget widget_native_int_int_constfct(long __this__nativeId, int cat_idx, int wgt_idx);
        
        
        @Override
        @io.qt.QtUninvokable
        public int widgetCount(int cat_idx){
            return widgetCount_native_int_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), cat_idx);
        }
        @io.qt.QtUninvokable
        private native int widgetCount_native_int_constfct(long __this__nativeId, int cat_idx);
        
    }
    
    /**
     * <p>Java wrapper for Qt class QDesignerWidgetBoxInterface::Widget</p>
     */
    public static class Widget extends io.qt.QtObject
        implements java.lang.Cloneable
    {
        static {
            QtJambi_LibraryUtilities.initialize();
        }
        
        /**
         * <p>Java wrapper for Qt enum QDesignerWidgetBoxInterface::Widget::Type</p>
         */
        public enum Type implements io.qt.QtEnumerator {
            Default(0),
            Custom(1);

            private Type(int value) {
                this.value = value;
            }

            /**
             * {@inheritDoc}
             */
            public int value() {
                return value;
            }

            /**
             * Returns the corresponding enum entry for the given value.
             * @param value
             * @return enum entry
             */
            public static Type resolve(int value) {
                switch (value) {
                case 0: return Default;
                case 1: return Custom;
                default: throw new io.qt.QNoSuchEnumValueException(value);
                }
            }


            private final int value;
        }
        
        
        public Widget(io.qt.designer.QDesignerWidgetBoxInterface.Widget w){
            super((QPrivateConstructor)null);
            initialize_native(this, w);
        }
        
        private native static void initialize_native(Widget instance, io.qt.designer.QDesignerWidgetBoxInterface.Widget w);
        
        /**
         * <p>Overloaded constructor for {@link #Widget(java.lang.String, java.lang.String, java.lang.String, io.qt.designer.QDesignerWidgetBoxInterface.Widget.Type)}
         *  with <code>atype = io.qt.designer.QDesignerWidgetBoxInterface.Widget.Type.Default</code>.</p>
         */
        public Widget(java.lang.String aname, java.lang.String xml, java.lang.String icon_name) {
            this(aname, xml, icon_name, io.qt.designer.QDesignerWidgetBoxInterface.Widget.Type.Default);
        }
        
        /**
         * <p>Overloaded constructor for {@link #Widget(java.lang.String, java.lang.String, java.lang.String, io.qt.designer.QDesignerWidgetBoxInterface.Widget.Type)}</p>
         * <p>with: </p><ul>
         * <li><code>icon_name = (String)null</code></li>
         * <li><code>atype = io.qt.designer.QDesignerWidgetBoxInterface.Widget.Type.Default</code></li>
         * </ul>
         */
        public Widget(java.lang.String aname, java.lang.String xml) {
            this(aname, xml, (String)null, io.qt.designer.QDesignerWidgetBoxInterface.Widget.Type.Default);
        }
        
        /**
         * <p>Overloaded constructor for {@link #Widget(java.lang.String, java.lang.String, java.lang.String, io.qt.designer.QDesignerWidgetBoxInterface.Widget.Type)}</p>
         * <p>with: </p><ul>
         * <li><code>xml = (String)null</code></li>
         * <li><code>icon_name = (String)null</code></li>
         * <li><code>atype = io.qt.designer.QDesignerWidgetBoxInterface.Widget.Type.Default</code></li>
         * </ul>
         */
        public Widget(java.lang.String aname) {
            this(aname, (String)null, (String)null, io.qt.designer.QDesignerWidgetBoxInterface.Widget.Type.Default);
        }
        
        /**
         * <p>Overloaded constructor for {@link #Widget(java.lang.String, java.lang.String, java.lang.String, io.qt.designer.QDesignerWidgetBoxInterface.Widget.Type)}</p>
         * <p>with: </p><ul>
         * <li><code>aname = (String)null</code></li>
         * <li><code>xml = (String)null</code></li>
         * <li><code>icon_name = (String)null</code></li>
         * <li><code>atype = io.qt.designer.QDesignerWidgetBoxInterface.Widget.Type.Default</code></li>
         * </ul>
         */
        public Widget() {
            this((String)null, (String)null, (String)null, io.qt.designer.QDesignerWidgetBoxInterface.Widget.Type.Default);
        }
        
        public Widget(java.lang.String aname, java.lang.String xml, java.lang.String icon_name, io.qt.designer.QDesignerWidgetBoxInterface.Widget.Type atype){
            super((QPrivateConstructor)null);
            initialize_native(this, aname, xml, icon_name, atype);
        }
        
        private native static void initialize_native(Widget instance, java.lang.String aname, java.lang.String xml, java.lang.String icon_name, io.qt.designer.QDesignerWidgetBoxInterface.Widget.Type atype);
        
        @io.qt.QtUninvokable
        public final java.lang.String domXml(){
            return domXml_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        
        @io.qt.QtUninvokable
        private native java.lang.String domXml_native_constfct(long __this__nativeId);
        
        @io.qt.QtUninvokable
        public final java.lang.String iconName(){
            return iconName_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        
        @io.qt.QtUninvokable
        private native java.lang.String iconName_native_constfct(long __this__nativeId);
        
        @io.qt.QtUninvokable
        public final boolean isNull(){
            return isNull_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        
        @io.qt.QtUninvokable
        private native boolean isNull_native_constfct(long __this__nativeId);
        
        @io.qt.QtUninvokable
        public final java.lang.String name(){
            return name_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        
        @io.qt.QtUninvokable
        private native java.lang.String name_native_constfct(long __this__nativeId);
        
        @io.qt.QtUninvokable
        public final void setDomXml(java.lang.String xml){
            setDomXml_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), xml);
        }
        
        @io.qt.QtUninvokable
        private native void setDomXml_native_cref_QString(long __this__nativeId, java.lang.String xml);
        
        @io.qt.QtUninvokable
        public final void setIconName(java.lang.String icon_name){
            setIconName_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), icon_name);
        }
        
        @io.qt.QtUninvokable
        private native void setIconName_native_cref_QString(long __this__nativeId, java.lang.String icon_name);
        
        @io.qt.QtUninvokable
        public final void setName(java.lang.String aname){
            setName_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), aname);
        }
        
        @io.qt.QtUninvokable
        private native void setName_native_cref_QString(long __this__nativeId, java.lang.String aname);
        
        @io.qt.QtUninvokable
        public final void setType(io.qt.designer.QDesignerWidgetBoxInterface.Widget.Type atype){
            setType_native_QDesignerWidgetBoxInterface_Widget_Type(QtJambi_LibraryUtilities.internal.nativeId(this), atype.value());
        }
        
        @io.qt.QtUninvokable
        private native void setType_native_QDesignerWidgetBoxInterface_Widget_Type(long __this__nativeId, int atype);
        
        @io.qt.QtUninvokable
        public final io.qt.designer.QDesignerWidgetBoxInterface.Widget.Type type(){
            return io.qt.designer.QDesignerWidgetBoxInterface.Widget.Type.resolve(type_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
        }
        
        @io.qt.QtUninvokable
        private native int type_native_constfct(long __this__nativeId);
        
        /**
         * Constructor for internal use only.
         * @param p expected to be <code>null</code>.
         */
        @io.qt.NativeAccess
        protected Widget(QPrivateConstructor p) { super(p); } 
        
        
        @Override
        public Widget clone() {
            return clone_native(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        private native Widget clone_native(long __this_nativeId);
    }
    /**
     * <p>Java wrapper for Qt class QDesignerWidgetBoxInterface::Category</p>
     */
    public static class Category extends io.qt.QtObject
        implements java.lang.Cloneable
    {
        static {
            QtJambi_LibraryUtilities.initialize();
        }
        
        /**
         * <p>Java wrapper for Qt enum QDesignerWidgetBoxInterface::Category::Type</p>
         */
        public enum Type implements io.qt.QtEnumerator {
            Default(0),
            Scratchpad(1);

            private Type(int value) {
                this.value = value;
            }

            /**
             * {@inheritDoc}
             */
            public int value() {
                return value;
            }

            /**
             * Returns the corresponding enum entry for the given value.
             * @param value
             * @return enum entry
             */
            public static Type resolve(int value) {
                switch (value) {
                case 0: return Default;
                case 1: return Scratchpad;
                default: throw new io.qt.QNoSuchEnumValueException(value);
                }
            }


            private final int value;
        }
        
        
        /**
         * <p>Overloaded constructor for {@link #Category(java.lang.String, io.qt.designer.QDesignerWidgetBoxInterface.Category.Type)}
         *  with <code>atype = io.qt.designer.QDesignerWidgetBoxInterface.Category.Type.Default</code>.</p>
         */
        public Category(java.lang.String aname) {
            this(aname, io.qt.designer.QDesignerWidgetBoxInterface.Category.Type.Default);
        }
        
        /**
         * <p>Overloaded constructor for {@link #Category(java.lang.String, io.qt.designer.QDesignerWidgetBoxInterface.Category.Type)}</p>
         * <p>with: </p><ul>
         * <li><code>aname = (String)null</code></li>
         * <li><code>atype = io.qt.designer.QDesignerWidgetBoxInterface.Category.Type.Default</code></li>
         * </ul>
         */
        public Category() {
            this((String)null, io.qt.designer.QDesignerWidgetBoxInterface.Category.Type.Default);
        }
        
        public Category(java.lang.String aname, io.qt.designer.QDesignerWidgetBoxInterface.Category.Type atype){
            super((QPrivateConstructor)null);
            initialize_native(this, aname, atype);
        }
        
        private native static void initialize_native(Category instance, java.lang.String aname, io.qt.designer.QDesignerWidgetBoxInterface.Category.Type atype);
        
        @io.qt.QtUninvokable
        public final void addWidget(io.qt.designer.QDesignerWidgetBoxInterface.Widget awidget){
            addWidget_native_cref_QDesignerWidgetBoxInterface_Widget(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(awidget));
        }
        
        @io.qt.QtUninvokable
        private native void addWidget_native_cref_QDesignerWidgetBoxInterface_Widget(long __this__nativeId, long awidget);
        
        @io.qt.QtUninvokable
        public final boolean isNull(){
            return isNull_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        
        @io.qt.QtUninvokable
        private native boolean isNull_native_constfct(long __this__nativeId);
        
        @io.qt.QtUninvokable
        public final java.lang.String name(){
            return name_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        
        @io.qt.QtUninvokable
        private native java.lang.String name_native_constfct(long __this__nativeId);
        
        @io.qt.QtUninvokable
        public final void removeWidget(int idx){
            removeWidget_native_int(QtJambi_LibraryUtilities.internal.nativeId(this), idx);
        }
        
        @io.qt.QtUninvokable
        private native void removeWidget_native_int(long __this__nativeId, int idx);
        
        @io.qt.QtUninvokable
        public final void setName(java.lang.String aname){
            setName_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), aname);
        }
        
        @io.qt.QtUninvokable
        private native void setName_native_cref_QString(long __this__nativeId, java.lang.String aname);
        
        @io.qt.QtUninvokable
        public final void setType(io.qt.designer.QDesignerWidgetBoxInterface.Category.Type atype){
            setType_native_QDesignerWidgetBoxInterface_Category_Type(QtJambi_LibraryUtilities.internal.nativeId(this), atype.value());
        }
        
        @io.qt.QtUninvokable
        private native void setType_native_QDesignerWidgetBoxInterface_Category_Type(long __this__nativeId, int atype);
        
        @io.qt.QtUninvokable
        public final io.qt.designer.QDesignerWidgetBoxInterface.Category.Type type(){
            return io.qt.designer.QDesignerWidgetBoxInterface.Category.Type.resolve(type_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
        }
        
        @io.qt.QtUninvokable
        private native int type_native_constfct(long __this__nativeId);
        
        @io.qt.QtUninvokable
        public final io.qt.designer.QDesignerWidgetBoxInterface.Widget widget(int idx){
            return widget_native_int_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), idx);
        }
        
        @io.qt.QtUninvokable
        private native io.qt.designer.QDesignerWidgetBoxInterface.Widget widget_native_int_constfct(long __this__nativeId, int idx);
        
        @io.qt.QtUninvokable
        public final int widgetCount(){
            return widgetCount_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        
        @io.qt.QtUninvokable
        private native int widgetCount_native_constfct(long __this__nativeId);
        
        /**
         * Constructor for internal use only.
         * @param p expected to be <code>null</code>.
         */
        @io.qt.NativeAccess
        protected Category(QPrivateConstructor p) { super(p); } 
        
        
        @Override
        public Category clone() {
            return clone_native(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        private native Category clone_native(long __this_nativeId);
    }

    
    /**
     * This constructor is a place holder intended to prevent
     * users from subclassing the class. Certain classes can
     * unfortunately only be subclasses internally. The constructor
     * will indiscriminately throw an exception if called. If the
     * exception is ignored, any use of the constructed object will
     * cause an exception to occur.

     * @throws io.qt.QClassCannotBeSubclassedException
     **/
    @SuppressWarnings("unused")
    private QDesignerWidgetBoxInterface() throws io.qt.QClassCannotBeSubclassedException {
        super((QPrivateConstructor)null);
        throw new io.qt.QClassCannotBeSubclassedException(QDesignerWidgetBoxInterface.class);
    }

    @io.qt.QtUninvokable
    public final int findOrInsertCategory(java.lang.String categoryName){
        return findOrInsertCategory_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), categoryName);
    }
    
    @io.qt.QtUninvokable
    private native int findOrInsertCategory_native_cref_QString(long __this__nativeId, java.lang.String categoryName);
    
    @io.qt.QtUninvokable
    public abstract void addCategory(io.qt.designer.QDesignerWidgetBoxInterface.Category cat);
    
    @io.qt.QtUninvokable
    public abstract void addWidget(int cat_idx, io.qt.designer.QDesignerWidgetBoxInterface.Widget wgt);
    
    @io.qt.QtUninvokable
    public abstract io.qt.designer.QDesignerWidgetBoxInterface.Category category(int cat_idx);
    
    @io.qt.QtUninvokable
    public abstract int categoryCount();
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdesignerwidgetboxinterface.html#fileName">QDesignerWidgetBoxInterface::fileName()const</a></p>
     */
    @io.qt.QtUninvokable
    public abstract java.lang.String fileName();
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdesignerwidgetboxinterface.html#load">QDesignerWidgetBoxInterface::load()</a></p>
     */
    @io.qt.QtUninvokable
    public abstract boolean load();
    
    @io.qt.QtUninvokable
    public abstract void removeCategory(int cat_idx);
    
    @io.qt.QtUninvokable
    public abstract void removeWidget(int cat_idx, int wgt_idx);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdesignerwidgetboxinterface.html#save">QDesignerWidgetBoxInterface::save()</a></p>
     */
    @io.qt.QtUninvokable
    public abstract boolean save();
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdesignerwidgetboxinterface.html#setFileName">QDesignerWidgetBoxInterface::setFileName(QString)</a></p>
     */
    @io.qt.QtUninvokable
    public abstract void setFileName(java.lang.String file_name);
    
    @io.qt.QtUninvokable
    public abstract io.qt.designer.QDesignerWidgetBoxInterface.Widget widget(int cat_idx, int wgt_idx);
    
    @io.qt.QtUninvokable
    public abstract int widgetCount(int cat_idx);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @io.qt.NativeAccess
    protected QDesignerWidgetBoxInterface(QPrivateConstructor p) { super(p); } 
    
}
