package io.qt.designer;


/**
 * <p>Allows you to query and manipulate the current state of Qt Designer's property editor</p>
 * <p>Java wrapper for Qt's class <a href="http://doc.qt.io/qt-5/qdesignerpropertyeditorinterface.html">QDesignerPropertyEditorInterface</a></p>
 */
public abstract class QDesignerPropertyEditorInterface extends io.qt.widgets.QWidget
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    @io.qt.QtPropertyMember(enabled=false)
    private Object __rcObject = null;
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QDesignerPropertyEditorInterface.class);
    
    @io.qt.NativeAccess
    private static final class ConcreteWrapper extends QDesignerPropertyEditorInterface {
        
        @io.qt.NativeAccess
        private ConcreteWrapper(QPrivateConstructor p) { super(p); }
        
        @Override
        @io.qt.QtUninvokable
        public java.lang.String currentPropertyName(){
            return currentPropertyName_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        @io.qt.QtUninvokable
        private native java.lang.String currentPropertyName_native_constfct(long __this__nativeId);
        
        
        @Override
        @io.qt.QtUninvokable
        public boolean isReadOnly(){
            return isReadOnly_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        @io.qt.QtUninvokable
        private native boolean isReadOnly_native_constfct(long __this__nativeId);
        
        
        @Override
        @io.qt.QtUninvokable
        public io.qt.core.QObject object(){
            return object_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        @io.qt.QtUninvokable
        private native io.qt.core.QObject object_native_constfct(long __this__nativeId);
        
        
        @Override
        public void setObject(io.qt.core.QObject object){
            setObject_native_QObject_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(object));
            QtJambi_LibraryUtilities.internal.setReferenceCount(this, io.qt.designer.QDesignerPropertyEditorInterface.class, "__rcObject", false, false, object);
        }
        private native void setObject_native_QObject_ptr(long __this__nativeId, long object);
        
        
        @Override
        public void setPropertyValue(java.lang.String name, java.lang.Object value, boolean changed){
            setPropertyValue_native_cref_QString_cref_QVariant_bool(QtJambi_LibraryUtilities.internal.nativeId(this), name, value, changed);
        }
        private native void setPropertyValue_native_cref_QString_cref_QVariant_bool(long __this__nativeId, java.lang.String name, java.lang.Object value, boolean changed);
        
        
        @Override
        public void setReadOnly(boolean readOnly){
            setReadOnly_native_bool(QtJambi_LibraryUtilities.internal.nativeId(this), readOnly);
        }
        private native void setReadOnly_native_bool(long __this__nativeId, boolean readOnly);
        
    }
    

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdesignerpropertyeditorinterface.html#propertyChanged">QDesignerPropertyEditorInterface::propertyChanged(QString,QVariant)</a></p>
     */
    public final Signal2<java.lang.String, java.lang.Object> propertyChanged = new Signal2<>();
    
    /**
     * <p>Overloaded constructor for {@link #QDesignerPropertyEditorInterface(io.qt.widgets.QWidget, io.qt.core.Qt.WindowFlags)}.</p>
     */
    public QDesignerPropertyEditorInterface(io.qt.widgets.QWidget parent, io.qt.core.Qt.WindowType ... flags){
        this(parent, new io.qt.core.Qt.WindowFlags(flags));
    }
    
    /**
     * <p>Overloaded constructor for {@link #QDesignerPropertyEditorInterface(io.qt.widgets.QWidget, io.qt.core.Qt.WindowFlags)}
     *  with <code>flags = new io.qt.core.Qt.WindowFlags(0)</code>.</p>
     */
    public QDesignerPropertyEditorInterface(io.qt.widgets.QWidget parent) {
        this(parent, new io.qt.core.Qt.WindowFlags(0));
    }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdesignerpropertyeditorinterface.html#QDesignerPropertyEditorInterface">QDesignerPropertyEditorInterface::QDesignerPropertyEditorInterface(QWidget*,Qt::WindowFlags)</a></p>
     */
    public QDesignerPropertyEditorInterface(io.qt.widgets.QWidget parent, io.qt.core.Qt.WindowFlags flags){
        super((QPrivateConstructor)null);
        initialize_native(this, parent, flags);
    }
    
    private native static void initialize_native(QDesignerPropertyEditorInterface instance, io.qt.widgets.QWidget parent, io.qt.core.Qt.WindowFlags flags);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdesignerpropertyeditorinterface.html#core">QDesignerPropertyEditorInterface::core()const</a></p>
     */
    @io.qt.QtUninvokable
    public io.qt.designer.QDesignerFormEditorInterface core(){
        return core_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.designer.QDesignerFormEditorInterface core_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdesignerpropertyeditorinterface.html#currentPropertyName">QDesignerPropertyEditorInterface::currentPropertyName()const</a></p>
     */
    @io.qt.QtUninvokable
    public abstract java.lang.String currentPropertyName();
    
    @io.qt.QtUninvokable
    private native java.lang.String currentPropertyName_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdesignerpropertyeditorinterface.html#isReadOnly">QDesignerPropertyEditorInterface::isReadOnly()const</a></p>
     */
    @io.qt.QtUninvokable
    public abstract boolean isReadOnly();
    
    @io.qt.QtUninvokable
    private native boolean isReadOnly_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdesignerpropertyeditorinterface.html#object">QDesignerPropertyEditorInterface::object()const</a></p>
     */
    @io.qt.QtUninvokable
    public abstract io.qt.core.QObject object();
    
    @io.qt.QtUninvokable
    private native io.qt.core.QObject object_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdesignerpropertyeditorinterface.html#setObject">QDesignerPropertyEditorInterface::setObject(QObject*)</a></p>
     */
    public abstract void setObject(io.qt.core.QObject object);
    
    private native void setObject_native_QObject_ptr(long __this__nativeId, long object);
    
    /**
     * <p>Overloaded function for {@link #setPropertyValue(java.lang.String, java.lang.Object, boolean)}
     *  with <code>changed = true</code>.</p>
     */
    public final void setPropertyValue(java.lang.String name, java.lang.Object value) {
        setPropertyValue(name, value, (boolean)true);
    }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdesignerpropertyeditorinterface.html#setPropertyValue">QDesignerPropertyEditorInterface::setPropertyValue(QString,QVariant,bool)</a></p>
     */
    public abstract void setPropertyValue(java.lang.String name, java.lang.Object value, boolean changed);
    
    private native void setPropertyValue_native_cref_QString_cref_QVariant_bool(long __this__nativeId, java.lang.String name, java.lang.Object value, boolean changed);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdesignerpropertyeditorinterface.html#setReadOnly">QDesignerPropertyEditorInterface::setReadOnly(bool)</a></p>
     */
    public abstract void setReadOnly(boolean readOnly);
    
    private native void setReadOnly_native_bool(long __this__nativeId, boolean readOnly);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @io.qt.NativeAccess
    protected QDesignerPropertyEditorInterface(QPrivateConstructor p) { super(p); } 
    
}
