package io.qt.designer;


/**
 * <p>Allows you to query and manipulate form windows appearing in Qt Designer's workspace</p>
 * <p>Java wrapper for Qt's class <a href="http://doc.qt.io/qt-5/qdesignerformwindowinterface.html">QDesignerFormWindowInterface</a></p>
 */
public abstract class QDesignerFormWindowInterface extends io.qt.widgets.QWidget
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    @io.qt.QtPropertyMember(enabled=false)
    private Object __rcMainContainer = null;
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QDesignerFormWindowInterface.class);
    
    @io.qt.NativeAccess
    private static final class ConcreteWrapper extends QDesignerFormWindowInterface {
        
        @io.qt.NativeAccess
        private ConcreteWrapper(QPrivateConstructor p) { super(p); }
        
        @Override
        @io.qt.QtUninvokable
        public io.qt.core.QDir absoluteDir(){
            return absoluteDir_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        @io.qt.QtUninvokable
        private native io.qt.core.QDir absoluteDir_native_constfct(long __this__nativeId);
        
        
        @Override
        @io.qt.QtUninvokable
        public void addResourceFile(java.lang.String path){
            addResourceFile_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), path);
        }
        @io.qt.QtUninvokable
        private native void addResourceFile_native_cref_QString(long __this__nativeId, java.lang.String path);
        
        
        @Override
        @io.qt.QtUninvokable
        public java.lang.String author(){
            return author_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        @io.qt.QtUninvokable
        private native java.lang.String author_native_constfct(long __this__nativeId);
        
        
        @Override
        @io.qt.QtUninvokable
        public void beginCommand(java.lang.String description){
            beginCommand_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), description);
        }
        @io.qt.QtUninvokable
        private native void beginCommand_native_cref_QString(long __this__nativeId, java.lang.String description);
        
        
        @Override
        @io.qt.QtUninvokable
        public java.util.List<java.lang.String> checkContents(){
            return checkContents_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        @io.qt.QtUninvokable
        private native java.util.List<java.lang.String> checkContents_native_constfct(long __this__nativeId);
        
        
        @Override
        public void clearSelection(boolean changePropertyDisplay){
            clearSelection_native_bool(QtJambi_LibraryUtilities.internal.nativeId(this), changePropertyDisplay);
        }
        private native void clearSelection_native_bool(long __this__nativeId, boolean changePropertyDisplay);
        
        
        @Override
        @io.qt.QtUninvokable
        public io.qt.widgets.QUndoStack commandHistory(){
            return commandHistory_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        @io.qt.QtUninvokable
        private native io.qt.widgets.QUndoStack commandHistory_native_constfct(long __this__nativeId);
        
        
        @Override
        @io.qt.QtUninvokable
        public java.lang.String comment(){
            return comment_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        @io.qt.QtUninvokable
        private native java.lang.String comment_native_constfct(long __this__nativeId);
        
        
        @Override
        @io.qt.QtUninvokable
        public java.lang.String contents(){
            return contents_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        @io.qt.QtUninvokable
        private native java.lang.String contents_native_constfct(long __this__nativeId);
        
        
        @Override
        @io.qt.QtUninvokable
        public int currentTool(){
            return currentTool_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        @io.qt.QtUninvokable
        private native int currentTool_native_constfct(long __this__nativeId);
        
        
        @Override
        @io.qt.QtUninvokable
        public io.qt.designer.QDesignerFormWindowCursorInterface cursorInterface(){
            return cursorInterface_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        @io.qt.QtUninvokable
        private native io.qt.designer.QDesignerFormWindowCursorInterface cursorInterface_native_constfct(long __this__nativeId);
        
        
        @Override
        public void editWidgets(){
            editWidgets_native(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        private native void editWidgets_native(long __this__nativeId);
        
        
        @Override
        @io.qt.QtUninvokable
        public void emitSelectionChanged(){
            emitSelectionChanged_native(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        @io.qt.QtUninvokable
        private native void emitSelectionChanged_native(long __this__nativeId);
        
        
        @Override
        @io.qt.QtUninvokable
        public void endCommand(){
            endCommand_native(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        @io.qt.QtUninvokable
        private native void endCommand_native(long __this__nativeId);
        
        
        @Override
        @io.qt.QtUninvokable
        public void ensureUniqueObjectName(io.qt.core.QObject object){
            ensureUniqueObjectName_native_QObject_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(object));
        }
        @io.qt.QtUninvokable
        private native void ensureUniqueObjectName_native_QObject_ptr(long __this__nativeId, long object);
        
        
        @Override
        @io.qt.QtUninvokable
        public java.lang.String exportMacro(){
            return exportMacro_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        @io.qt.QtUninvokable
        private native java.lang.String exportMacro_native_constfct(long __this__nativeId);
        
        
        @Override
        @io.qt.QtUninvokable
        public io.qt.designer.QDesignerFormWindowInterface.Feature features(){
            return new io.qt.designer.QDesignerFormWindowInterface.Feature(features_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
        }
        @io.qt.QtUninvokable
        private native int features_native_constfct(long __this__nativeId);
        
        
        @Override
        @io.qt.QtUninvokable
        public java.lang.String fileName(){
            return fileName_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        @io.qt.QtUninvokable
        private native java.lang.String fileName_native_constfct(long __this__nativeId);
        
        
        @Override
        @io.qt.QtUninvokable
        public io.qt.widgets.QWidget formContainer(){
            return formContainer_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        @io.qt.QtUninvokable
        private native io.qt.widgets.QWidget formContainer_native_constfct(long __this__nativeId);
        
        
        @Override
        @io.qt.QtUninvokable
        public io.qt.core.QPoint grid(){
            return grid_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        @io.qt.QtUninvokable
        private native io.qt.core.QPoint grid_native_constfct(long __this__nativeId);
        
        
        @Override
        @io.qt.QtUninvokable
        public boolean hasFeature(io.qt.designer.QDesignerFormWindowInterface.Feature f){
            return hasFeature_native_QFlags_QDesignerFormWindowInterface_FeatureFlag__constfct(QtJambi_LibraryUtilities.internal.nativeId(this), f.value());
        }
        @io.qt.QtUninvokable
        private native boolean hasFeature_native_QFlags_QDesignerFormWindowInterface_FeatureFlag__constfct(long __this__nativeId, int f);
        
        
        @Override
        @io.qt.QtUninvokable
        public java.util.List<java.lang.String> includeHints(){
            return includeHints_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        @io.qt.QtUninvokable
        private native java.util.List<java.lang.String> includeHints_native_constfct(long __this__nativeId);
        
        
        @Override
        @io.qt.QtUninvokable
        public boolean isDirty(){
            return isDirty_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        @io.qt.QtUninvokable
        private native boolean isDirty_native_constfct(long __this__nativeId);
        
        
        @Override
        @io.qt.QtUninvokable
        public boolean isManaged(io.qt.widgets.QWidget widget){
            return isManaged_native_QWidget_ptr_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(widget));
        }
        @io.qt.QtUninvokable
        private native boolean isManaged_native_QWidget_ptr_constfct(long __this__nativeId, long widget);
        
        
        @Override
        @io.qt.QtUninvokable
        public void layoutDefault(int[] margin, int[] spacing){
            if(margin!=null && margin.length < 1)
                throw new IllegalArgumentException("Argument 'margin': Wrong number of elements in array. Found: " + margin.length + ", expected: 1");
            if(spacing!=null && spacing.length < 1)
                throw new IllegalArgumentException("Argument 'spacing': Wrong number of elements in array. Found: " + spacing.length + ", expected: 1");
            layoutDefault_native_int_ptr_int_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), margin, spacing);
        }
        @io.qt.QtUninvokable
        private native void layoutDefault_native_int_ptr_int_ptr(long __this__nativeId, int[] margin, int[] spacing);
        
        
        @Override
        @io.qt.QtUninvokable
        public void layoutFunction(java.lang.String[] margin, java.lang.String[] spacing){
            if(margin!=null && margin.length < 1)
                throw new IllegalArgumentException("Argument 'margin': Wrong number of elements in array. Found: " + margin.length + ", expected: 1");
            if(spacing!=null && spacing.length < 1)
                throw new IllegalArgumentException("Argument 'spacing': Wrong number of elements in array. Found: " + spacing.length + ", expected: 1");
            layoutFunction_native_QString_ptr_QString_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), margin, spacing);
        }
        @io.qt.QtUninvokable
        private native void layoutFunction_native_QString_ptr_QString_ptr(long __this__nativeId, java.lang.String[] margin, java.lang.String[] spacing);
        
        
        @Override
        @io.qt.QtUninvokable
        public io.qt.widgets.QWidget mainContainer(){
            return mainContainer_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        @io.qt.QtUninvokable
        private native io.qt.widgets.QWidget mainContainer_native_constfct(long __this__nativeId);
        
        
        @Override
        public void manageWidget(io.qt.widgets.QWidget widget){
            manageWidget_native_QWidget_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(widget));
        }
        private native void manageWidget_native_QWidget_ptr(long __this__nativeId, long widget);
        
        
        @Override
        @io.qt.QtUninvokable
        public java.lang.String pixmapFunction(){
            return pixmapFunction_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        @io.qt.QtUninvokable
        private native java.lang.String pixmapFunction_native_constfct(long __this__nativeId);
        
        
        @Override
        @io.qt.QtUninvokable
        public void registerTool(io.qt.designer.QDesignerFormWindowToolInterface tool){
            registerTool_native_QDesignerFormWindowToolInterface_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(tool));
        }
        @io.qt.QtUninvokable
        private native void registerTool_native_QDesignerFormWindowToolInterface_ptr(long __this__nativeId, long tool);
        
        
        @Override
        @io.qt.QtUninvokable
        public void removeResourceFile(java.lang.String path){
            removeResourceFile_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), path);
        }
        @io.qt.QtUninvokable
        private native void removeResourceFile_native_cref_QString(long __this__nativeId, java.lang.String path);
        
        
        @Override
        @io.qt.QtUninvokable
        public io.qt.designer.QDesignerFormWindowInterface.ResourceFileSaveMode resourceFileSaveMode(){
            return io.qt.designer.QDesignerFormWindowInterface.ResourceFileSaveMode.resolve(resourceFileSaveMode_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
        }
        @io.qt.QtUninvokable
        private native int resourceFileSaveMode_native_constfct(long __this__nativeId);
        
        
        @Override
        @io.qt.QtUninvokable
        public java.util.List<java.lang.String> resourceFiles(){
            return resourceFiles_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        @io.qt.QtUninvokable
        private native java.util.List<java.lang.String> resourceFiles_native_constfct(long __this__nativeId);
        
        
        @Override
        public void selectWidget(io.qt.widgets.QWidget w, boolean select){
            selectWidget_native_QWidget_ptr_bool(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(w), select);
        }
        private native void selectWidget_native_QWidget_ptr_bool(long __this__nativeId, long w, boolean select);
        
        
        @Override
        @io.qt.QtUninvokable
        public void setAuthor(java.lang.String author){
            setAuthor_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), author);
        }
        @io.qt.QtUninvokable
        private native void setAuthor_native_cref_QString(long __this__nativeId, java.lang.String author);
        
        
        @Override
        @io.qt.QtUninvokable
        public void setComment(java.lang.String comment){
            setComment_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), comment);
        }
        @io.qt.QtUninvokable
        private native void setComment_native_cref_QString(long __this__nativeId, java.lang.String comment);
        
        
        @Override
        @io.qt.QtUninvokable
        public boolean setContents(io.qt.core.QIODevice dev, java.lang.String[] errorMessage){
            if(errorMessage!=null && errorMessage.length < 1)
                throw new IllegalArgumentException("Argument 'errorMessage': Wrong number of elements in array. Found: " + errorMessage.length + ", expected: 1");
            return setContents_native_QIODevice_ptr_QString_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(dev), errorMessage);
        }
        @io.qt.QtUninvokable
        private native boolean setContents_native_QIODevice_ptr_QString_ptr(long __this__nativeId, long dev, java.lang.String[] errorMessage);
        
        
        @Override
        public boolean setContents(java.lang.String contents){
            return setContents_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), contents);
        }
        private native boolean setContents_native_cref_QString(long __this__nativeId, java.lang.String contents);
        
        
        @Override
        @io.qt.QtUninvokable
        public void setCurrentTool(int index){
            setCurrentTool_native_int(QtJambi_LibraryUtilities.internal.nativeId(this), index);
        }
        @io.qt.QtUninvokable
        private native void setCurrentTool_native_int(long __this__nativeId, int index);
        
        
        @Override
        public void setDirty(boolean dirty){
            setDirty_native_bool(QtJambi_LibraryUtilities.internal.nativeId(this), dirty);
        }
        private native void setDirty_native_bool(long __this__nativeId, boolean dirty);
        
        
        @Override
        @io.qt.QtUninvokable
        public void setExportMacro(java.lang.String exportMacro){
            setExportMacro_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), exportMacro);
        }
        @io.qt.QtUninvokable
        private native void setExportMacro_native_cref_QString(long __this__nativeId, java.lang.String exportMacro);
        
        
        @Override
        public void setFeatures(io.qt.designer.QDesignerFormWindowInterface.Feature f){
            setFeatures_native_QFlags_QDesignerFormWindowInterface_FeatureFlag_(QtJambi_LibraryUtilities.internal.nativeId(this), f.value());
        }
        private native void setFeatures_native_QFlags_QDesignerFormWindowInterface_FeatureFlag_(long __this__nativeId, int f);
        
        
        @Override
        public void setFileName(java.lang.String fileName){
            setFileName_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), fileName);
        }
        private native void setFileName_native_cref_QString(long __this__nativeId, java.lang.String fileName);
        
        
        @Override
        public void setGrid(io.qt.core.QPoint grid){
            setGrid_native_cref_QPoint(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(grid));
        }
        private native void setGrid_native_cref_QPoint(long __this__nativeId, long grid);
        
        
        @Override
        @io.qt.QtUninvokable
        public void setIncludeHints(java.util.Collection<java.lang.String> includeHints){
            setIncludeHints_native_cref_QStringList(QtJambi_LibraryUtilities.internal.nativeId(this), includeHints);
        }
        @io.qt.QtUninvokable
        private native void setIncludeHints_native_cref_QStringList(long __this__nativeId, java.util.Collection<java.lang.String> includeHints);
        
        
        @Override
        @io.qt.QtUninvokable
        public void setLayoutDefault(int margin, int spacing){
            setLayoutDefault_native_int_int(QtJambi_LibraryUtilities.internal.nativeId(this), margin, spacing);
        }
        @io.qt.QtUninvokable
        private native void setLayoutDefault_native_int_int(long __this__nativeId, int margin, int spacing);
        
        
        @Override
        @io.qt.QtUninvokable
        public void setLayoutFunction(java.lang.String margin, java.lang.String spacing){
            setLayoutFunction_native_cref_QString_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), margin, spacing);
        }
        @io.qt.QtUninvokable
        private native void setLayoutFunction_native_cref_QString_cref_QString(long __this__nativeId, java.lang.String margin, java.lang.String spacing);
        
        
        @Override
        @io.qt.QtUninvokable
        public void setMainContainer(io.qt.widgets.QWidget mainContainer){
            setMainContainer_native_QWidget_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(mainContainer));
            QtJambi_LibraryUtilities.internal.setReferenceCount(this, io.qt.designer.QDesignerFormWindowInterface.class, "__rcMainContainer", false, false, mainContainer);
        }
        @io.qt.QtUninvokable
        private native void setMainContainer_native_QWidget_ptr(long __this__nativeId, long mainContainer);
        
        
        @Override
        @io.qt.QtUninvokable
        public void setPixmapFunction(java.lang.String pixmapFunction){
            setPixmapFunction_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), pixmapFunction);
        }
        @io.qt.QtUninvokable
        private native void setPixmapFunction_native_cref_QString(long __this__nativeId, java.lang.String pixmapFunction);
        
        
        @Override
        @io.qt.QtUninvokable
        public void setResourceFileSaveMode(io.qt.designer.QDesignerFormWindowInterface.ResourceFileSaveMode behaviour){
            setResourceFileSaveMode_native_QDesignerFormWindowInterface_ResourceFileSaveMode(QtJambi_LibraryUtilities.internal.nativeId(this), behaviour.value());
        }
        @io.qt.QtUninvokable
        private native void setResourceFileSaveMode_native_QDesignerFormWindowInterface_ResourceFileSaveMode(long __this__nativeId, int behaviour);
        
        
        @Override
        @io.qt.QtUninvokable
        public void simplifySelection(java.util.Collection<? extends io.qt.widgets.QWidget> widgets){
            simplifySelection_native_QList_ptr_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), widgets);
        }
        @io.qt.QtUninvokable
        private native void simplifySelection_native_QList_ptr_constfct(long __this__nativeId, java.util.Collection<? extends io.qt.widgets.QWidget> widgets);
        
        
        @Override
        @io.qt.QtUninvokable
        public io.qt.designer.QDesignerFormWindowToolInterface tool(int index){
            return tool_native_int_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), index);
        }
        @io.qt.QtUninvokable
        private native io.qt.designer.QDesignerFormWindowToolInterface tool_native_int_constfct(long __this__nativeId, int index);
        
        
        @Override
        @io.qt.QtUninvokable
        public int toolCount(){
            return toolCount_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        @io.qt.QtUninvokable
        private native int toolCount_native_constfct(long __this__nativeId);
        
        
        @Override
        public void unmanageWidget(io.qt.widgets.QWidget widget){
            unmanageWidget_native_QWidget_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(widget));
        }
        private native void unmanageWidget_native_QWidget_ptr(long __this__nativeId, long widget);
        
    }
    
    /**
     * <p>Java wrapper for Qt enum <a href="http://doc.qt.io/qt-5/qdesignerformwindowinterface.html#FeatureFlag-enum">QDesignerFormWindowInterface::FeatureFlag</a></p>
     * 
     * @see Feature
     */
    public enum FeatureFlag implements io.qt.QtFlagEnumerator {
        EditFeature(1),
        GridFeature(2),
        TabOrderFeature(4),
        DefaultFeature(3);

        private FeatureFlag(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Create a QFlags of the enum entry.
         * @return QFlags
         */
        public Feature asFlags() {
            return new Feature(value);
        }

        /**
         * Combines this entry with other enum entry.
         * @param e enum entry
         * @return new flag
         */
        public Feature combined(FeatureFlag e) {
            return new Feature(this, e);
        }

        /**
         * Creates a new {@link Feature} from the entries.
         * @param values entries
         * @return new flag
         */
        public static Feature flags(FeatureFlag ... values) {
            return new Feature(values);
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static FeatureFlag resolve(int value) {
            switch (value) {
            case 1: return EditFeature;
            case 2: return GridFeature;
            case 4: return TabOrderFeature;
            case 3: return DefaultFeature;
            default: throw new io.qt.QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * QFlags type for enum {@link FeatureFlag}
     */
    public static final class Feature extends io.qt.QFlags<FeatureFlag> implements Comparable<Feature> {
        private static final long serialVersionUID = 0x777ad951fc5888b8L;

        /**
         * Creates a new Feature where the flags in <code>args</code> are set.
         * @param args enum entries
         */
        public Feature(FeatureFlag ... args){
            super(args);
        }

        /**
         * Creates a new Feature with given <code>value</code>.
         * @param value
         */
        public Feature(int value) {
            super(value);
        }

        /**
         * Combines this flags with enum entry.
         * @param e enum entry
         * @return new Feature
         */
        @Override
        public final Feature combined(FeatureFlag e){
            return new Feature(value() | e.value());
        }

        /**
         * Sets the flag <code>e</code>
         * @param e enum entry
         * @return this
         */
        public final Feature setFlag(FeatureFlag e){
            super.setFlag(e);
            return this;
        }

        /**
         * Sets or clears the flag <code>flag</code>
         * @param e enum entry
         * @param on set (true) or clear (false)
         * @return this
         */
        public final Feature setFlag(FeatureFlag e, boolean on){
            super.setFlag(e, on);
            return this;
        }

        /**
         * Returns an array of flag objects represented by this Feature.
         * @return array of enum entries
         */
        @Override
        public final FeatureFlag[] flags(){
            return super.flags(FeatureFlag.values());
        }

        /**
         * {@inheritDoc}
         */
        @Override
        public final Feature clone(){
            return new Feature(value());
        }

        /**
         * {@inheritDoc}
         */
        @Override
        public final int compareTo(Feature other){
            return Integer.compare(value(), other.value());
        }
    }
    
    /**
     * <p>Java wrapper for Qt enum <a href="http://doc.qt.io/qt-5/qdesignerformwindowinterface.html#ResourceFileSaveMode-enum">QDesignerFormWindowInterface::ResourceFileSaveMode</a></p>
     */
    @io.qt.QtUnlistedEnum
    public enum ResourceFileSaveMode implements io.qt.QtEnumerator {
        SaveAllResourceFiles(0),
        SaveOnlyUsedResourceFiles(1),
        DontSaveResourceFiles(2);

        private ResourceFileSaveMode(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static ResourceFileSaveMode resolve(int value) {
            switch (value) {
            case 0: return SaveAllResourceFiles;
            case 1: return SaveOnlyUsedResourceFiles;
            case 2: return DontSaveResourceFiles;
            default: throw new io.qt.QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdesignerformwindowinterface.html#aboutToUnmanageWidget">QDesignerFormWindowInterface::aboutToUnmanageWidget(QWidget*)</a></p>
     */
    public final Signal1<io.qt.widgets.QWidget> aboutToUnmanageWidget = new Signal1<>();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdesignerformwindowinterface.html#activated">QDesignerFormWindowInterface::activated(QWidget*)</a></p>
     */
    public final Signal1<io.qt.widgets.QWidget> activated = new Signal1<>();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdesignerformwindowinterface.html#changed">QDesignerFormWindowInterface::changed()</a></p>
     */
    public final Signal0 changed = new Signal0();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdesignerformwindowinterface.html#featureChanged">QDesignerFormWindowInterface::featureChanged(Feature)</a></p>
     */
    public final Signal1<io.qt.designer.QDesignerFormWindowInterface.Feature> featureChanged = new Signal1<>();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdesignerformwindowinterface.html#fileNameChanged">QDesignerFormWindowInterface::fileNameChanged(QString)</a></p>
     */
    public final Signal1<java.lang.String> fileNameChanged = new Signal1<>();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdesignerformwindowinterface.html#geometryChanged">QDesignerFormWindowInterface::geometryChanged()</a></p>
     */
    public final Signal0 geometryChanged = new Signal0();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdesignerformwindowinterface.html#mainContainerChanged">QDesignerFormWindowInterface::mainContainerChanged(QWidget*)</a></p>
     */
    public final Signal1<io.qt.widgets.QWidget> mainContainerChanged = new Signal1<>();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdesignerformwindowinterface.html#objectRemoved">QDesignerFormWindowInterface::objectRemoved(QObject*)</a></p>
     */
    public final Signal1<io.qt.core.QObject> objectRemoved = new Signal1<>();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdesignerformwindowinterface.html#resourceFilesChanged">QDesignerFormWindowInterface::resourceFilesChanged()</a></p>
     */
    public final Signal0 resourceFilesChanged = new Signal0();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdesignerformwindowinterface.html#selectionChanged">QDesignerFormWindowInterface::selectionChanged()</a></p>
     */
    public final Signal0 selectionChanged = new Signal0();

    public final Signal1<@io.qt.QtPrimitiveType Integer> toolChanged = new Signal1<>();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdesignerformwindowinterface.html#widgetManaged">QDesignerFormWindowInterface::widgetManaged(QWidget*)</a></p>
     */
    public final Signal1<io.qt.widgets.QWidget> widgetManaged = new Signal1<>();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdesignerformwindowinterface.html#widgetRemoved">QDesignerFormWindowInterface::widgetRemoved(QWidget*)</a></p>
     */
    public final Signal1<io.qt.widgets.QWidget> widgetRemoved = new Signal1<>();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdesignerformwindowinterface.html#widgetUnmanaged">QDesignerFormWindowInterface::widgetUnmanaged(QWidget*)</a></p>
     */
    public final Signal1<io.qt.widgets.QWidget> widgetUnmanaged = new Signal1<>();
    
    /**
     * <p>Overloaded constructor for {@link #QDesignerFormWindowInterface(io.qt.widgets.QWidget, io.qt.core.Qt.WindowFlags)}.</p>
     */
    public QDesignerFormWindowInterface(io.qt.widgets.QWidget parent, io.qt.core.Qt.WindowType ... flags){
        this(parent, new io.qt.core.Qt.WindowFlags(flags));
    }
    
    /**
     * <p>Overloaded constructor for {@link #QDesignerFormWindowInterface(io.qt.widgets.QWidget, io.qt.core.Qt.WindowFlags)}
     *  with <code>flags = new io.qt.core.Qt.WindowFlags(0)</code>.</p>
     */
    public QDesignerFormWindowInterface(io.qt.widgets.QWidget parent) {
        this(parent, new io.qt.core.Qt.WindowFlags(0));
    }
    
    /**
     * <p>Overloaded constructor for {@link #QDesignerFormWindowInterface(io.qt.widgets.QWidget, io.qt.core.Qt.WindowFlags)}</p>
     * <p>with: </p><ul>
     * <li><code>parent = null</code></li>
     * <li><code>flags = new io.qt.core.Qt.WindowFlags(0)</code></li>
     * </ul>
     */
    public QDesignerFormWindowInterface() {
        this((io.qt.widgets.QWidget)null, new io.qt.core.Qt.WindowFlags(0));
    }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdesignerformwindowinterface.html#QDesignerFormWindowInterface">QDesignerFormWindowInterface::QDesignerFormWindowInterface(QWidget*,Qt::WindowFlags)</a></p>
     */
    public QDesignerFormWindowInterface(io.qt.widgets.QWidget parent, io.qt.core.Qt.WindowFlags flags){
        super((QPrivateConstructor)null);
        initialize_native(this, parent, flags);
    }
    
    private native static void initialize_native(QDesignerFormWindowInterface instance, io.qt.widgets.QWidget parent, io.qt.core.Qt.WindowFlags flags);
    
    /**
     * <p>Overloaded function for {@link #activateResourceFilePaths(java.util.Collection, int[], java.lang.String[])}
     *  with <code>errorMessages = null</code>.</p>
     */
    public final void activateResourceFilePaths(java.util.Collection<java.lang.String> paths, int[] errorCount) {
        activateResourceFilePaths(paths, errorCount, null);
    }
    
    /**
     * <p>Overloaded function for {@link #activateResourceFilePaths(java.util.Collection, int[], java.lang.String[])}</p>
     * <p>with: </p><ul>
     * <li><code>errorCount = null</code></li>
     * <li><code>errorMessages = null</code></li>
     * </ul>
     */
    public final void activateResourceFilePaths(java.util.Collection<java.lang.String> paths) {
        activateResourceFilePaths(paths, null, null);
    }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdesignerformwindowinterface.html#activateResourceFilePaths">QDesignerFormWindowInterface::activateResourceFilePaths(QStringList,int*,QString*)</a></p>
     */
    public final void activateResourceFilePaths(java.util.Collection<java.lang.String> paths, int[] errorCount, java.lang.String[] errorMessages){
        if(errorCount!=null && errorCount.length < 1)
            throw new IllegalArgumentException("Argument 'errorCount': Wrong number of elements in array. Found: " + errorCount.length + ", expected: 1");
        if(errorMessages!=null && errorMessages.length < 1)
            throw new IllegalArgumentException("Argument 'errorMessages': Wrong number of elements in array. Found: " + errorMessages.length + ", expected: 1");
        activateResourceFilePaths_native_cref_QStringList_int_ptr_QString_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), paths, errorCount, errorMessages);
    }
    
    private native void activateResourceFilePaths_native_cref_QStringList_int_ptr_QString_ptr(long __this__nativeId, java.util.Collection<java.lang.String> paths, int[] errorCount, java.lang.String[] errorMessages);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdesignerformwindowinterface.html#activeResourceFilePaths">QDesignerFormWindowInterface::activeResourceFilePaths()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.core.QStringList activeResourceFilePaths(){
        return activeResourceFilePaths_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.core.QStringList activeResourceFilePaths_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdesignerformwindowinterface.html#absoluteDir">QDesignerFormWindowInterface::absoluteDir()const</a></p>
     */
    @io.qt.QtUninvokable
    public abstract io.qt.core.QDir absoluteDir();
    
    @io.qt.QtUninvokable
    private native io.qt.core.QDir absoluteDir_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdesignerformwindowinterface.html#addResourceFile">QDesignerFormWindowInterface::addResourceFile(QString)</a></p>
     */
    @io.qt.QtUninvokable
    public abstract void addResourceFile(java.lang.String path);
    
    @io.qt.QtUninvokable
    private native void addResourceFile_native_cref_QString(long __this__nativeId, java.lang.String path);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdesignerformwindowinterface.html#author">QDesignerFormWindowInterface::author()const</a></p>
     */
    @io.qt.QtUninvokable
    public abstract java.lang.String author();
    
    @io.qt.QtUninvokable
    private native java.lang.String author_native_constfct(long __this__nativeId);
    
    @io.qt.QtUninvokable
    public abstract void beginCommand(java.lang.String description);
    
    @io.qt.QtUninvokable
    private native void beginCommand_native_cref_QString(long __this__nativeId, java.lang.String description);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdesignerformwindowinterface.html#checkContents">QDesignerFormWindowInterface::checkContents()const</a></p>
     */
    @io.qt.QtUninvokable
    public abstract java.util.List<java.lang.String> checkContents();
    
    @io.qt.QtUninvokable
    private native java.util.List<java.lang.String> checkContents_native_constfct(long __this__nativeId);
    
    /**
     * <p>Overloaded function for {@link #clearSelection(boolean)}
     *  with <code>changePropertyDisplay = true</code>.</p>
     */
    public final void clearSelection() {
        clearSelection((boolean)true);
    }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdesignerformwindowinterface.html#clearSelection">QDesignerFormWindowInterface::clearSelection(bool)</a></p>
     */
    public abstract void clearSelection(boolean changePropertyDisplay);
    
    private native void clearSelection_native_bool(long __this__nativeId, boolean changePropertyDisplay);
    
    @io.qt.QtUninvokable
    public abstract io.qt.widgets.QUndoStack commandHistory();
    
    @io.qt.QtUninvokable
    private native io.qt.widgets.QUndoStack commandHistory_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdesignerformwindowinterface.html#comment">QDesignerFormWindowInterface::comment()const</a></p>
     */
    @io.qt.QtUninvokable
    public abstract java.lang.String comment();
    
    @io.qt.QtUninvokable
    private native java.lang.String comment_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdesignerformwindowinterface.html#contents">QDesignerFormWindowInterface::contents()const</a></p>
     */
    @io.qt.QtUninvokable
    public abstract java.lang.String contents();
    
    @io.qt.QtUninvokable
    private native java.lang.String contents_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdesignerformwindowinterface.html#core">QDesignerFormWindowInterface::core()const</a></p>
     */
    @io.qt.QtUninvokable
    public io.qt.designer.QDesignerFormEditorInterface core(){
        return core_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.designer.QDesignerFormEditorInterface core_native_constfct(long __this__nativeId);
    
    @io.qt.QtUninvokable
    public abstract int currentTool();
    
    @io.qt.QtUninvokable
    private native int currentTool_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdesignerformwindowinterface.html#cursor">QDesignerFormWindowInterface::cursor()const</a></p>
     */
    @io.qt.QtUninvokable
    public abstract io.qt.designer.QDesignerFormWindowCursorInterface cursorInterface();
    
    @io.qt.QtUninvokable
    private native io.qt.designer.QDesignerFormWindowCursorInterface cursorInterface_native_constfct(long __this__nativeId);
    
    public abstract void editWidgets();
    
    private native void editWidgets_native(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdesignerformwindowinterface.html#emitSelectionChanged">QDesignerFormWindowInterface::emitSelectionChanged()</a></p>
     */
    @io.qt.QtUninvokable
    public abstract void emitSelectionChanged();
    
    @io.qt.QtUninvokable
    private native void emitSelectionChanged_native(long __this__nativeId);
    
    @io.qt.QtUninvokable
    public abstract void endCommand();
    
    @io.qt.QtUninvokable
    private native void endCommand_native(long __this__nativeId);
    
    @io.qt.QtUninvokable
    public abstract void ensureUniqueObjectName(io.qt.core.QObject object);
    
    @io.qt.QtUninvokable
    private native void ensureUniqueObjectName_native_QObject_ptr(long __this__nativeId, long object);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdesignerformwindowinterface.html#exportMacro">QDesignerFormWindowInterface::exportMacro()const</a></p>
     */
    @io.qt.QtUninvokable
    public abstract java.lang.String exportMacro();
    
    @io.qt.QtUninvokable
    private native java.lang.String exportMacro_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdesignerformwindowinterface.html#features">QDesignerFormWindowInterface::features()const</a></p>
     */
    @io.qt.QtUninvokable
    public abstract io.qt.designer.QDesignerFormWindowInterface.Feature features();
    
    @io.qt.QtUninvokable
    private native int features_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdesignerformwindowinterface.html#fileName">QDesignerFormWindowInterface::fileName()const</a></p>
     */
    @io.qt.QtUninvokable
    public abstract java.lang.String fileName();
    
    @io.qt.QtUninvokable
    private native java.lang.String fileName_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdesignerformwindowinterface.html#formContainer">QDesignerFormWindowInterface::formContainer()const</a></p>
     */
    @io.qt.QtUninvokable
    public abstract io.qt.widgets.QWidget formContainer();
    
    @io.qt.QtUninvokable
    private native io.qt.widgets.QWidget formContainer_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdesignerformwindowinterface.html#grid">QDesignerFormWindowInterface::grid()const</a></p>
     */
    @io.qt.QtUninvokable
    public abstract io.qt.core.QPoint grid();
    
    @io.qt.QtUninvokable
    private native io.qt.core.QPoint grid_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdesignerformwindowinterface.html#hasFeature">QDesignerFormWindowInterface::hasFeature(Feature)const</a></p>
     */
    @io.qt.QtUninvokable
    public abstract boolean hasFeature(io.qt.designer.QDesignerFormWindowInterface.Feature f);
    
    @io.qt.QtUninvokable
    private native boolean hasFeature_native_QFlags_QDesignerFormWindowInterface_FeatureFlag__constfct(long __this__nativeId, int f);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdesignerformwindowinterface.html#includeHints">QDesignerFormWindowInterface::includeHints()const</a></p>
     */
    @io.qt.QtUninvokable
    public abstract java.util.List<java.lang.String> includeHints();
    
    @io.qt.QtUninvokable
    private native java.util.List<java.lang.String> includeHints_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdesignerformwindowinterface.html#isDirty">QDesignerFormWindowInterface::isDirty()const</a></p>
     */
    @io.qt.QtUninvokable
    public abstract boolean isDirty();
    
    @io.qt.QtUninvokable
    private native boolean isDirty_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdesignerformwindowinterface.html#isManaged">QDesignerFormWindowInterface::isManaged(QWidget*)const</a></p>
     */
    @io.qt.QtUninvokable
    public abstract boolean isManaged(io.qt.widgets.QWidget widget);
    
    @io.qt.QtUninvokable
    private native boolean isManaged_native_QWidget_ptr_constfct(long __this__nativeId, long widget);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdesignerformwindowinterface.html#layoutDefault">QDesignerFormWindowInterface::layoutDefault(int*,int*)</a></p>
     */
    @io.qt.QtUninvokable
    public abstract void layoutDefault(int[] margin, int[] spacing);
    
    @io.qt.QtUninvokable
    private native void layoutDefault_native_int_ptr_int_ptr(long __this__nativeId, int[] margin, int[] spacing);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdesignerformwindowinterface.html#layoutFunction">QDesignerFormWindowInterface::layoutFunction(QString*,QString*)</a></p>
     */
    @io.qt.QtUninvokable
    public abstract void layoutFunction(java.lang.String[] margin, java.lang.String[] spacing);
    
    @io.qt.QtUninvokable
    private native void layoutFunction_native_QString_ptr_QString_ptr(long __this__nativeId, java.lang.String[] margin, java.lang.String[] spacing);
    
    @io.qt.QtUninvokable
    public abstract io.qt.widgets.QWidget mainContainer();
    
    @io.qt.QtUninvokable
    private native io.qt.widgets.QWidget mainContainer_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdesignerformwindowinterface.html#manageWidget">QDesignerFormWindowInterface::manageWidget(QWidget*)</a></p>
     */
    public abstract void manageWidget(io.qt.widgets.QWidget widget);
    
    private native void manageWidget_native_QWidget_ptr(long __this__nativeId, long widget);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdesignerformwindowinterface.html#pixmapFunction">QDesignerFormWindowInterface::pixmapFunction()const</a></p>
     */
    @io.qt.QtUninvokable
    public abstract java.lang.String pixmapFunction();
    
    @io.qt.QtUninvokable
    private native java.lang.String pixmapFunction_native_constfct(long __this__nativeId);
    
    @io.qt.QtUninvokable
    public abstract void registerTool(io.qt.designer.QDesignerFormWindowToolInterface tool);
    
    @io.qt.QtUninvokable
    private native void registerTool_native_QDesignerFormWindowToolInterface_ptr(long __this__nativeId, long tool);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdesignerformwindowinterface.html#removeResourceFile">QDesignerFormWindowInterface::removeResourceFile(QString)</a></p>
     */
    @io.qt.QtUninvokable
    public abstract void removeResourceFile(java.lang.String path);
    
    @io.qt.QtUninvokable
    private native void removeResourceFile_native_cref_QString(long __this__nativeId, java.lang.String path);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdesignerformwindowinterface.html#resourceFileSaveMode">QDesignerFormWindowInterface::resourceFileSaveMode()const</a></p>
     */
    @io.qt.QtUninvokable
    public abstract io.qt.designer.QDesignerFormWindowInterface.ResourceFileSaveMode resourceFileSaveMode();
    
    @io.qt.QtUninvokable
    private native int resourceFileSaveMode_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdesignerformwindowinterface.html#resourceFiles">QDesignerFormWindowInterface::resourceFiles()const</a></p>
     */
    @io.qt.QtUninvokable
    public abstract java.util.List<java.lang.String> resourceFiles();
    
    @io.qt.QtUninvokable
    private native java.util.List<java.lang.String> resourceFiles_native_constfct(long __this__nativeId);
    
    /**
     * <p>Overloaded function for {@link #selectWidget(io.qt.widgets.QWidget, boolean)}
     *  with <code>select = true</code>.</p>
     */
    public final void selectWidget(io.qt.widgets.QWidget w) {
        selectWidget(w, (boolean)true);
    }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdesignerformwindowinterface.html#selectWidget">QDesignerFormWindowInterface::selectWidget(QWidget*,bool)</a></p>
     */
    public abstract void selectWidget(io.qt.widgets.QWidget w, boolean select);
    
    private native void selectWidget_native_QWidget_ptr_bool(long __this__nativeId, long w, boolean select);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdesignerformwindowinterface.html#setAuthor">QDesignerFormWindowInterface::setAuthor(QString)</a></p>
     */
    @io.qt.QtUninvokable
    public abstract void setAuthor(java.lang.String author);
    
    @io.qt.QtUninvokable
    private native void setAuthor_native_cref_QString(long __this__nativeId, java.lang.String author);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdesignerformwindowinterface.html#setComment">QDesignerFormWindowInterface::setComment(QString)</a></p>
     */
    @io.qt.QtUninvokable
    public abstract void setComment(java.lang.String comment);
    
    @io.qt.QtUninvokable
    private native void setComment_native_cref_QString(long __this__nativeId, java.lang.String comment);
    
    /**
     * <p>Overloaded function for {@link #setContents(io.qt.core.QIODevice, java.lang.String[])}
     *  with <code>errorMessage = null</code>.</p>
     */
    @io.qt.QtUninvokable
    public final boolean setContents(io.qt.core.QIODevice dev) {
        return setContents(dev, null);
    }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdesignerformwindowinterface.html#setContents">QDesignerFormWindowInterface::setContents(QIODevice*,QString*)</a></p>
     */
    @io.qt.QtUninvokable
    public abstract boolean setContents(io.qt.core.QIODevice dev, java.lang.String[] errorMessage);
    
    @io.qt.QtUninvokable
    private native boolean setContents_native_QIODevice_ptr_QString_ptr(long __this__nativeId, long dev, java.lang.String[] errorMessage);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdesignerformwindowinterface.html#setContents-1">QDesignerFormWindowInterface::setContents(QString)</a></p>
     */
    public abstract boolean setContents(java.lang.String contents);
    
    private native boolean setContents_native_cref_QString(long __this__nativeId, java.lang.String contents);
    
    @io.qt.QtUninvokable
    public abstract void setCurrentTool(int index);
    
    @io.qt.QtUninvokable
    private native void setCurrentTool_native_int(long __this__nativeId, int index);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdesignerformwindowinterface.html#setDirty">QDesignerFormWindowInterface::setDirty(bool)</a></p>
     */
    public abstract void setDirty(boolean dirty);
    
    private native void setDirty_native_bool(long __this__nativeId, boolean dirty);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdesignerformwindowinterface.html#setExportMacro">QDesignerFormWindowInterface::setExportMacro(QString)</a></p>
     */
    @io.qt.QtUninvokable
    public abstract void setExportMacro(java.lang.String exportMacro);
    
    @io.qt.QtUninvokable
    private native void setExportMacro_native_cref_QString(long __this__nativeId, java.lang.String exportMacro);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdesignerformwindowinterface.html#setFeatures">QDesignerFormWindowInterface::setFeatures(Feature)</a></p>
     */
    public abstract void setFeatures(io.qt.designer.QDesignerFormWindowInterface.Feature f);
    
    private native void setFeatures_native_QFlags_QDesignerFormWindowInterface_FeatureFlag_(long __this__nativeId, int f);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdesignerformwindowinterface.html#setFileName">QDesignerFormWindowInterface::setFileName(QString)</a></p>
     */
    public abstract void setFileName(java.lang.String fileName);
    
    private native void setFileName_native_cref_QString(long __this__nativeId, java.lang.String fileName);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdesignerformwindowinterface.html#setGrid">QDesignerFormWindowInterface::setGrid(QPoint)</a></p>
     */
    public abstract void setGrid(io.qt.core.QPoint grid);
    
    private native void setGrid_native_cref_QPoint(long __this__nativeId, long grid);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdesignerformwindowinterface.html#setIncludeHints">QDesignerFormWindowInterface::setIncludeHints(QStringList)</a></p>
     */
    @io.qt.QtUninvokable
    public abstract void setIncludeHints(java.util.Collection<java.lang.String> includeHints);
    
    @io.qt.QtUninvokable
    private native void setIncludeHints_native_cref_QStringList(long __this__nativeId, java.util.Collection<java.lang.String> includeHints);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdesignerformwindowinterface.html#setLayoutDefault">QDesignerFormWindowInterface::setLayoutDefault(int,int)</a></p>
     */
    @io.qt.QtUninvokable
    public abstract void setLayoutDefault(int margin, int spacing);
    
    @io.qt.QtUninvokable
    private native void setLayoutDefault_native_int_int(long __this__nativeId, int margin, int spacing);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdesignerformwindowinterface.html#setLayoutFunction">QDesignerFormWindowInterface::setLayoutFunction(QString,QString)</a></p>
     */
    @io.qt.QtUninvokable
    public abstract void setLayoutFunction(java.lang.String margin, java.lang.String spacing);
    
    @io.qt.QtUninvokable
    private native void setLayoutFunction_native_cref_QString_cref_QString(long __this__nativeId, java.lang.String margin, java.lang.String spacing);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdesignerformwindowinterface.html#setMainContainer">QDesignerFormWindowInterface::setMainContainer(QWidget*)</a></p>
     */
    @io.qt.QtUninvokable
    public abstract void setMainContainer(io.qt.widgets.QWidget mainContainer);
    
    @io.qt.QtUninvokable
    private native void setMainContainer_native_QWidget_ptr(long __this__nativeId, long mainContainer);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdesignerformwindowinterface.html#setPixmapFunction">QDesignerFormWindowInterface::setPixmapFunction(QString)</a></p>
     */
    @io.qt.QtUninvokable
    public abstract void setPixmapFunction(java.lang.String pixmapFunction);
    
    @io.qt.QtUninvokable
    private native void setPixmapFunction_native_cref_QString(long __this__nativeId, java.lang.String pixmapFunction);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdesignerformwindowinterface.html#setResourceFileSaveMode">QDesignerFormWindowInterface::setResourceFileSaveMode(QDesignerFormWindowInterface::ResourceFileSaveMode)</a></p>
     */
    @io.qt.QtUninvokable
    public abstract void setResourceFileSaveMode(io.qt.designer.QDesignerFormWindowInterface.ResourceFileSaveMode behaviour);
    
    @io.qt.QtUninvokable
    private native void setResourceFileSaveMode_native_QDesignerFormWindowInterface_ResourceFileSaveMode(long __this__nativeId, int behaviour);
    
    @io.qt.QtUninvokable
    public abstract void simplifySelection(java.util.Collection<? extends io.qt.widgets.QWidget> widgets);
    
    @io.qt.QtUninvokable
    private native void simplifySelection_native_QList_ptr_constfct(long __this__nativeId, java.util.Collection<? extends io.qt.widgets.QWidget> widgets);
    
    @io.qt.QtUninvokable
    public abstract io.qt.designer.QDesignerFormWindowToolInterface tool(int index);
    
    @io.qt.QtUninvokable
    private native io.qt.designer.QDesignerFormWindowToolInterface tool_native_int_constfct(long __this__nativeId, int index);
    
    @io.qt.QtUninvokable
    public abstract int toolCount();
    
    @io.qt.QtUninvokable
    private native int toolCount_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdesignerformwindowinterface.html#unmanageWidget">QDesignerFormWindowInterface::unmanageWidget(QWidget*)</a></p>
     */
    public abstract void unmanageWidget(io.qt.widgets.QWidget widget);
    
    private native void unmanageWidget_native_QWidget_ptr(long __this__nativeId, long widget);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdesignerformwindowinterface.html#findFormWindow-1">QDesignerFormWindowInterface::findFormWindow(QObject*)</a></p>
     */
    public static io.qt.designer.QDesignerFormWindowInterface findFormWindow(io.qt.core.QObject obj){
        return findFormWindow_native_QObject_ptr(QtJambi_LibraryUtilities.internal.checkedNativeId(obj));
    }
    
    private native static io.qt.designer.QDesignerFormWindowInterface findFormWindow_native_QObject_ptr(long obj);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdesignerformwindowinterface.html#findFormWindow">QDesignerFormWindowInterface::findFormWindow(QWidget*)</a></p>
     */
    public static io.qt.designer.QDesignerFormWindowInterface findFormWindow(io.qt.widgets.QWidget w){
        return findFormWindow_native_QWidget_ptr(QtJambi_LibraryUtilities.internal.checkedNativeId(w));
    }
    
    private native static io.qt.designer.QDesignerFormWindowInterface findFormWindow_native_QWidget_ptr(long w);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @io.qt.NativeAccess
    protected QDesignerFormWindowInterface(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * It is not allowed to call the declarative constructor from inside Java.
     */
    @io.qt.NativeAccess
    protected QDesignerFormWindowInterface(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @io.qt.QtUninvokable
    private static native void initialize_native(QDesignerFormWindowInterface instance, QDeclarativeConstructor constructor);
    
}
