package io.qt.designer;


/**
 * <p>Allows you to query and modify a form window's widget selection, and in addition modify the properties of all the form's widgets</p>
 * <p>Java wrapper for Qt's class <a href="http://doc.qt.io/qt-5/qdesignerformwindowcursorinterface.html">QDesignerFormWindowCursorInterface</a></p>
 */
public interface QDesignerFormWindowCursorInterface extends io.qt.QtObjectInterface
{
    /**
     * <p>Java wrapper for Qt enum <a href="http://doc.qt.io/qt-5/qdesignerformwindowcursorinterface.html#MoveMode-enum">QDesignerFormWindowCursorInterface::MoveMode</a></p>
     */
    public enum MoveMode implements io.qt.QtEnumerator {
        MoveAnchor(0),
        KeepAnchor(1);

        private MoveMode(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static MoveMode resolve(int value) {
            switch (value) {
            case 0: return MoveAnchor;
            case 1: return KeepAnchor;
            default: throw new io.qt.QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * <p>Java wrapper for Qt enum <a href="http://doc.qt.io/qt-5/qdesignerformwindowcursorinterface.html#MoveOperation-enum">QDesignerFormWindowCursorInterface::MoveOperation</a></p>
     */
    public enum MoveOperation implements io.qt.QtEnumerator {
        NoMove(0),
        Start(1),
        End(2),
        Next(3),
        Prev(4),
        Left(5),
        Right(6),
        Up(7),
        Down(8);

        private MoveOperation(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static MoveOperation resolve(int value) {
            switch (value) {
            case 0: return NoMove;
            case 1: return Start;
            case 2: return End;
            case 3: return Next;
            case 4: return Prev;
            case 5: return Left;
            case 6: return Right;
            case 7: return Up;
            case 8: return Down;
            default: throw new io.qt.QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    

    /**
     * <p>Implementor class for interface {@link io.qt.designer.QDesignerFormWindowCursorInterface}</p>
     */
    public static abstract class Impl extends io.qt.QtObject
        implements io.qt.designer.QDesignerFormWindowCursorInterface
    {
        static {
            QtJambi_LibraryUtilities.initialize();
        }
        
        
        @io.qt.NativeAccess
        private static final class ConcreteWrapper extends QDesignerFormWindowCursorInterface.Impl {
            
            @io.qt.NativeAccess
            private ConcreteWrapper(QPrivateConstructor p) { super(p); }
            
            @Override
            @io.qt.QtUninvokable
            public io.qt.widgets.QWidget current(){
                return current_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
            }
            private native static io.qt.widgets.QWidget current_native_constfct(long __this__nativeId);
            
            
            @Override
            @io.qt.QtUninvokable
            public io.qt.designer.QDesignerFormWindowInterface formWindow(){
                return formWindow_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
            }
            private native static io.qt.designer.QDesignerFormWindowInterface formWindow_native_constfct(long __this__nativeId);
            
            
            @Override
            @io.qt.QtUninvokable
            public boolean hasSelection(){
                return hasSelection_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
            }
            private native static boolean hasSelection_native_constfct(long __this__nativeId);
            
            
            @Override
            @io.qt.QtUninvokable
            public boolean movePosition(io.qt.designer.QDesignerFormWindowCursorInterface.MoveOperation op, io.qt.designer.QDesignerFormWindowCursorInterface.MoveMode mode){
                return movePosition_native_QDesignerFormWindowCursorInterface_MoveOperation_QDesignerFormWindowCursorInterface_MoveMode(QtJambi_LibraryUtilities.internal.nativeId(this), op.value(), mode.value());
            }
            private native static boolean movePosition_native_QDesignerFormWindowCursorInterface_MoveOperation_QDesignerFormWindowCursorInterface_MoveMode(long __this__nativeId, int op, int mode);
            
            
            @Override
            @io.qt.QtUninvokable
            public int position(){
                return position_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
            }
            private native static int position_native_constfct(long __this__nativeId);
            
            
            @Override
            @io.qt.QtUninvokable
            public void resetWidgetProperty(io.qt.widgets.QWidget widget, java.lang.String name){
                resetWidgetProperty_native_QWidget_ptr_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(widget), name);
            }
            private native static void resetWidgetProperty_native_QWidget_ptr_cref_QString(long __this__nativeId, long widget, java.lang.String name);
            
            
            @Override
            @io.qt.QtUninvokable
            public io.qt.widgets.QWidget selectedWidget(int index){
                return selectedWidget_native_int_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), index);
            }
            private native static io.qt.widgets.QWidget selectedWidget_native_int_constfct(long __this__nativeId, int index);
            
            
            @Override
            @io.qt.QtUninvokable
            public int selectedWidgetCount(){
                return selectedWidgetCount_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
            }
            private native static int selectedWidgetCount_native_constfct(long __this__nativeId);
            
            
            @Override
            @io.qt.QtUninvokable
            public void setPosition(int pos, io.qt.designer.QDesignerFormWindowCursorInterface.MoveMode mode){
                setPosition_native_int_QDesignerFormWindowCursorInterface_MoveMode(QtJambi_LibraryUtilities.internal.nativeId(this), pos, mode.value());
            }
            private native static void setPosition_native_int_QDesignerFormWindowCursorInterface_MoveMode(long __this__nativeId, int pos, int mode);
            
            
            @Override
            @io.qt.QtUninvokable
            public void setProperty(java.lang.String name, java.lang.Object value){
                setProperty_native_cref_QString_cref_QVariant(QtJambi_LibraryUtilities.internal.nativeId(this), name, value);
            }
            private native static void setProperty_native_cref_QString_cref_QVariant(long __this__nativeId, java.lang.String name, java.lang.Object value);
            
            
            @Override
            @io.qt.QtUninvokable
            public void setWidgetProperty(io.qt.widgets.QWidget widget, java.lang.String name, java.lang.Object value){
                setWidgetProperty_native_QWidget_ptr_cref_QString_cref_QVariant(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(widget), name, value);
            }
            private native static void setWidgetProperty_native_QWidget_ptr_cref_QString_cref_QVariant(long __this__nativeId, long widget, java.lang.String name, java.lang.Object value);
            
            
            @Override
            @io.qt.QtUninvokable
            public io.qt.widgets.QWidget widget(int index){
                return widget_native_int_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), index);
            }
            private native static io.qt.widgets.QWidget widget_native_int_constfct(long __this__nativeId, int index);
            
            
            @Override
            @io.qt.QtUninvokable
            public int widgetCount(){
                return widgetCount_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
            }
            private native static int widgetCount_native_constfct(long __this__nativeId);
            
        }
        
        
        public Impl(){
            super((QPrivateConstructor)null);
            initialize_native(this);
        }
        
        private native static void initialize_native(QDesignerFormWindowCursorInterface instance);
        
        /**
         * <p>See <a href="http://doc.qt.io/qt-5/qdesignerformwindowcursorinterface.html#isWidgetSelected">QDesignerFormWindowCursorInterface::isWidgetSelected(QWidget*)const</a></p>
         */
        @io.qt.QtUninvokable
        public final boolean isWidgetSelected(io.qt.widgets.QWidget widget){
            return isWidgetSelected_native_QWidget_ptr_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(widget));
        }
        
        private native static boolean isWidgetSelected_native_QWidget_ptr_constfct(long __this__nativeId, long widget);
        
        /**
         * <p>See <a href="http://doc.qt.io/qt-5/qdesignerformwindowcursorinterface.html#current">QDesignerFormWindowCursorInterface::current()const</a></p>
         */
        @io.qt.QtUninvokable
        public abstract io.qt.widgets.QWidget current();
        
        private native static io.qt.widgets.QWidget current_native_constfct(long __this__nativeId);
        
        /**
         * <p>See <a href="http://doc.qt.io/qt-5/qdesignerformwindowcursorinterface.html#formWindow">QDesignerFormWindowCursorInterface::formWindow()const</a></p>
         */
        @io.qt.QtUninvokable
        public abstract io.qt.designer.QDesignerFormWindowInterface formWindow();
        
        private native static io.qt.designer.QDesignerFormWindowInterface formWindow_native_constfct(long __this__nativeId);
        
        /**
         * <p>See <a href="http://doc.qt.io/qt-5/qdesignerformwindowcursorinterface.html#hasSelection">QDesignerFormWindowCursorInterface::hasSelection()const</a></p>
         */
        @io.qt.QtUninvokable
        public abstract boolean hasSelection();
        
        private native static boolean hasSelection_native_constfct(long __this__nativeId);
        
        /**
         * <p>Overloaded function for {@link #movePosition(io.qt.designer.QDesignerFormWindowCursorInterface.MoveOperation, io.qt.designer.QDesignerFormWindowCursorInterface.MoveMode)}
         *  with <code>mode = io.qt.designer.QDesignerFormWindowCursorInterface.MoveMode.MoveAnchor</code>.</p>
         */
        @io.qt.QtUninvokable
        public final boolean movePosition(io.qt.designer.QDesignerFormWindowCursorInterface.MoveOperation op) {
            return movePosition(op, io.qt.designer.QDesignerFormWindowCursorInterface.MoveMode.MoveAnchor);
        }
        
        /**
         * <p>See <a href="http://doc.qt.io/qt-5/qdesignerformwindowcursorinterface.html#movePosition">QDesignerFormWindowCursorInterface::movePosition(QDesignerFormWindowCursorInterface::MoveOperation,QDesignerFormWindowCursorInterface::MoveMode)</a></p>
         */
        @io.qt.QtUninvokable
        public abstract boolean movePosition(io.qt.designer.QDesignerFormWindowCursorInterface.MoveOperation op, io.qt.designer.QDesignerFormWindowCursorInterface.MoveMode mode);
        
        private native static boolean movePosition_native_QDesignerFormWindowCursorInterface_MoveOperation_QDesignerFormWindowCursorInterface_MoveMode(long __this__nativeId, int op, int mode);
        
        /**
         * <p>See <a href="http://doc.qt.io/qt-5/qdesignerformwindowcursorinterface.html#position">QDesignerFormWindowCursorInterface::position()const</a></p>
         */
        @io.qt.QtUninvokable
        public abstract int position();
        
        private native static int position_native_constfct(long __this__nativeId);
        
        /**
         * <p>See <a href="http://doc.qt.io/qt-5/qdesignerformwindowcursorinterface.html#resetWidgetProperty">QDesignerFormWindowCursorInterface::resetWidgetProperty(QWidget*,QString)</a></p>
         */
        @io.qt.QtUninvokable
        public abstract void resetWidgetProperty(io.qt.widgets.QWidget widget, java.lang.String name);
        
        private native static void resetWidgetProperty_native_QWidget_ptr_cref_QString(long __this__nativeId, long widget, java.lang.String name);
        
        /**
         * <p>See <a href="http://doc.qt.io/qt-5/qdesignerformwindowcursorinterface.html#selectedWidget">QDesignerFormWindowCursorInterface::selectedWidget(int)const</a></p>
         */
        @io.qt.QtUninvokable
        public abstract io.qt.widgets.QWidget selectedWidget(int index);
        
        private native static io.qt.widgets.QWidget selectedWidget_native_int_constfct(long __this__nativeId, int index);
        
        /**
         * <p>See <a href="http://doc.qt.io/qt-5/qdesignerformwindowcursorinterface.html#selectedWidgetCount">QDesignerFormWindowCursorInterface::selectedWidgetCount()const</a></p>
         */
        @io.qt.QtUninvokable
        public abstract int selectedWidgetCount();
        
        private native static int selectedWidgetCount_native_constfct(long __this__nativeId);
        
        /**
         * <p>Overloaded function for {@link #setPosition(int, io.qt.designer.QDesignerFormWindowCursorInterface.MoveMode)}
         *  with <code>mode = io.qt.designer.QDesignerFormWindowCursorInterface.MoveMode.MoveAnchor</code>.</p>
         */
        @io.qt.QtUninvokable
        public final void setPosition(int pos) {
            setPosition(pos, io.qt.designer.QDesignerFormWindowCursorInterface.MoveMode.MoveAnchor);
        }
        
        /**
         * <p>See <a href="http://doc.qt.io/qt-5/qdesignerformwindowcursorinterface.html#setPosition">QDesignerFormWindowCursorInterface::setPosition(int,QDesignerFormWindowCursorInterface::MoveMode)</a></p>
         */
        @io.qt.QtUninvokable
        public abstract void setPosition(int pos, io.qt.designer.QDesignerFormWindowCursorInterface.MoveMode mode);
        
        private native static void setPosition_native_int_QDesignerFormWindowCursorInterface_MoveMode(long __this__nativeId, int pos, int mode);
        
        /**
         * <p>See <a href="http://doc.qt.io/qt-5/qdesignerformwindowcursorinterface.html#setProperty">QDesignerFormWindowCursorInterface::setProperty(QString,QVariant)</a></p>
         */
        @io.qt.QtUninvokable
        public abstract void setProperty(java.lang.String name, java.lang.Object value);
        
        private native static void setProperty_native_cref_QString_cref_QVariant(long __this__nativeId, java.lang.String name, java.lang.Object value);
        
        /**
         * <p>See <a href="http://doc.qt.io/qt-5/qdesignerformwindowcursorinterface.html#setWidgetProperty">QDesignerFormWindowCursorInterface::setWidgetProperty(QWidget*,QString,QVariant)</a></p>
         */
        @io.qt.QtUninvokable
        public abstract void setWidgetProperty(io.qt.widgets.QWidget widget, java.lang.String name, java.lang.Object value);
        
        private native static void setWidgetProperty_native_QWidget_ptr_cref_QString_cref_QVariant(long __this__nativeId, long widget, java.lang.String name, java.lang.Object value);
        
        /**
         * <p>See <a href="http://doc.qt.io/qt-5/qdesignerformwindowcursorinterface.html#widget">QDesignerFormWindowCursorInterface::widget(int)const</a></p>
         */
        @io.qt.QtUninvokable
        public abstract io.qt.widgets.QWidget widget(int index);
        
        private native static io.qt.widgets.QWidget widget_native_int_constfct(long __this__nativeId, int index);
        
        /**
         * <p>See <a href="http://doc.qt.io/qt-5/qdesignerformwindowcursorinterface.html#widgetCount">QDesignerFormWindowCursorInterface::widgetCount()const</a></p>
         */
        @io.qt.QtUninvokable
        public abstract int widgetCount();
        
        private native static int widgetCount_native_constfct(long __this__nativeId);
        
        /**
         * Constructor for internal use only.
         * @param p expected to be <code>null</code>.
         */
        @io.qt.NativeAccess
        protected Impl(QPrivateConstructor p) { super(p); } 
        
    }

    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdesignerformwindowcursorinterface.html#isWidgetSelected">QDesignerFormWindowCursorInterface::isWidgetSelected(QWidget*)const</a></p>
     */
    @io.qt.QtDeclaredFinal
    @io.qt.QtUninvokable
    public default boolean isWidgetSelected(io.qt.widgets.QWidget widget){
        return Impl.isWidgetSelected_native_QWidget_ptr_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(widget));
    }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdesignerformwindowcursorinterface.html#current">QDesignerFormWindowCursorInterface::current()const</a></p>
     */
    @io.qt.QtUninvokable
    public io.qt.widgets.QWidget current();
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdesignerformwindowcursorinterface.html#formWindow">QDesignerFormWindowCursorInterface::formWindow()const</a></p>
     */
    @io.qt.QtUninvokable
    public io.qt.designer.QDesignerFormWindowInterface formWindow();
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdesignerformwindowcursorinterface.html#hasSelection">QDesignerFormWindowCursorInterface::hasSelection()const</a></p>
     */
    @io.qt.QtUninvokable
    public boolean hasSelection();
    
    /**
     * <p>Overloaded function for {@link #movePosition(io.qt.designer.QDesignerFormWindowCursorInterface.MoveOperation, io.qt.designer.QDesignerFormWindowCursorInterface.MoveMode)}
     *  with <code>mode = io.qt.designer.QDesignerFormWindowCursorInterface.MoveMode.MoveAnchor</code>.</p>
     */
    @io.qt.QtUninvokable
    public default boolean movePosition(io.qt.designer.QDesignerFormWindowCursorInterface.MoveOperation op) {
        return movePosition(op, io.qt.designer.QDesignerFormWindowCursorInterface.MoveMode.MoveAnchor);
    }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdesignerformwindowcursorinterface.html#movePosition">QDesignerFormWindowCursorInterface::movePosition(QDesignerFormWindowCursorInterface::MoveOperation,QDesignerFormWindowCursorInterface::MoveMode)</a></p>
     */
    @io.qt.QtUninvokable
    public boolean movePosition(io.qt.designer.QDesignerFormWindowCursorInterface.MoveOperation op, io.qt.designer.QDesignerFormWindowCursorInterface.MoveMode mode);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdesignerformwindowcursorinterface.html#position">QDesignerFormWindowCursorInterface::position()const</a></p>
     */
    @io.qt.QtUninvokable
    public int position();
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdesignerformwindowcursorinterface.html#resetWidgetProperty">QDesignerFormWindowCursorInterface::resetWidgetProperty(QWidget*,QString)</a></p>
     */
    @io.qt.QtUninvokable
    public void resetWidgetProperty(io.qt.widgets.QWidget widget, java.lang.String name);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdesignerformwindowcursorinterface.html#selectedWidget">QDesignerFormWindowCursorInterface::selectedWidget(int)const</a></p>
     */
    @io.qt.QtUninvokable
    public io.qt.widgets.QWidget selectedWidget(int index);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdesignerformwindowcursorinterface.html#selectedWidgetCount">QDesignerFormWindowCursorInterface::selectedWidgetCount()const</a></p>
     */
    @io.qt.QtUninvokable
    public int selectedWidgetCount();
    
    /**
     * <p>Overloaded function for {@link #setPosition(int, io.qt.designer.QDesignerFormWindowCursorInterface.MoveMode)}
     *  with <code>mode = io.qt.designer.QDesignerFormWindowCursorInterface.MoveMode.MoveAnchor</code>.</p>
     */
    @io.qt.QtUninvokable
    public default void setPosition(int pos) {
        setPosition(pos, io.qt.designer.QDesignerFormWindowCursorInterface.MoveMode.MoveAnchor);
    }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdesignerformwindowcursorinterface.html#setPosition">QDesignerFormWindowCursorInterface::setPosition(int,QDesignerFormWindowCursorInterface::MoveMode)</a></p>
     */
    @io.qt.QtUninvokable
    public void setPosition(int pos, io.qt.designer.QDesignerFormWindowCursorInterface.MoveMode mode);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdesignerformwindowcursorinterface.html#setProperty">QDesignerFormWindowCursorInterface::setProperty(QString,QVariant)</a></p>
     */
    @io.qt.QtUninvokable
    public void setProperty(java.lang.String name, java.lang.Object value);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdesignerformwindowcursorinterface.html#setWidgetProperty">QDesignerFormWindowCursorInterface::setWidgetProperty(QWidget*,QString,QVariant)</a></p>
     */
    @io.qt.QtUninvokable
    public void setWidgetProperty(io.qt.widgets.QWidget widget, java.lang.String name, java.lang.Object value);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdesignerformwindowcursorinterface.html#widget">QDesignerFormWindowCursorInterface::widget(int)const</a></p>
     */
    @io.qt.QtUninvokable
    public io.qt.widgets.QWidget widget(int index);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdesignerformwindowcursorinterface.html#widgetCount">QDesignerFormWindowCursorInterface::widgetCount()const</a></p>
     */
    @io.qt.QtUninvokable
    public int widgetCount();
    
}
