package io.qt.designer;


/**
 * <p>Allows you to manipulate a widget's dynamic properties in Qt Designer's property editor</p>
 * <p>Java wrapper for Qt's class <a href="http://doc.qt.io/qt-5/qdesignerdynamicpropertysheetextension.html">QDesignerDynamicPropertySheetExtension</a></p>
 */
public interface QDesignerDynamicPropertySheetExtension extends io.qt.QtObjectInterface
{
    /**
     * <p>Implementor class for interface {@link io.qt.designer.QDesignerDynamicPropertySheetExtension}</p>
     */
    public static abstract class Impl extends io.qt.QtObject
        implements io.qt.designer.QDesignerDynamicPropertySheetExtension
    {
        static {
            QtJambi_LibraryUtilities.initialize();
        }
        
        @io.qt.NativeAccess
        private static final class ConcreteWrapper extends QDesignerDynamicPropertySheetExtension.Impl {
            
            @io.qt.NativeAccess
            private ConcreteWrapper(QPrivateConstructor p) { super(p); }
            
            @Override
            @io.qt.QtUninvokable
            public int addDynamicProperty(java.lang.String propertyName, java.lang.Object value){
                return addDynamicProperty_native_cref_QString_cref_QVariant(QtJambi_LibraryUtilities.internal.nativeId(this), propertyName, value);
            }
            private native static int addDynamicProperty_native_cref_QString_cref_QVariant(long __this__nativeId, java.lang.String propertyName, java.lang.Object value);
            
            
            @Override
            @io.qt.QtUninvokable
            public boolean canAddDynamicProperty(java.lang.String propertyName){
                return canAddDynamicProperty_native_cref_QString_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), propertyName);
            }
            private native static boolean canAddDynamicProperty_native_cref_QString_constfct(long __this__nativeId, java.lang.String propertyName);
            
            
            @Override
            @io.qt.QtUninvokable
            public boolean dynamicPropertiesAllowed(){
                return dynamicPropertiesAllowed_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
            }
            private native static boolean dynamicPropertiesAllowed_native_constfct(long __this__nativeId);
            
            
            @Override
            @io.qt.QtUninvokable
            public boolean isDynamicProperty(int index){
                return isDynamicProperty_native_int_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), index);
            }
            private native static boolean isDynamicProperty_native_int_constfct(long __this__nativeId, int index);
            
            
            @Override
            @io.qt.QtUninvokable
            public boolean removeDynamicProperty(int index){
                return removeDynamicProperty_native_int(QtJambi_LibraryUtilities.internal.nativeId(this), index);
            }
            private native static boolean removeDynamicProperty_native_int(long __this__nativeId, int index);
            
        }
        
        
        public Impl(){
            super((QPrivateConstructor)null);
            initialize_native(this);
        }
        
        private native static void initialize_native(QDesignerDynamicPropertySheetExtension instance);
        
        /**
         * <p>See <a href="http://doc.qt.io/qt-5/qdesignerdynamicpropertysheetextension.html#addDynamicProperty">QDesignerDynamicPropertySheetExtension::addDynamicProperty(QString,QVariant)</a></p>
         */
        @io.qt.QtUninvokable
        public abstract int addDynamicProperty(java.lang.String propertyName, java.lang.Object value);
        
        private native static int addDynamicProperty_native_cref_QString_cref_QVariant(long __this__nativeId, java.lang.String propertyName, java.lang.Object value);
        
        /**
         * <p>See <a href="http://doc.qt.io/qt-5/qdesignerdynamicpropertysheetextension.html#canAddDynamicProperty">QDesignerDynamicPropertySheetExtension::canAddDynamicProperty(QString)const</a></p>
         */
        @io.qt.QtUninvokable
        public abstract boolean canAddDynamicProperty(java.lang.String propertyName);
        
        private native static boolean canAddDynamicProperty_native_cref_QString_constfct(long __this__nativeId, java.lang.String propertyName);
        
        /**
         * <p>See <a href="http://doc.qt.io/qt-5/qdesignerdynamicpropertysheetextension.html#dynamicPropertiesAllowed">QDesignerDynamicPropertySheetExtension::dynamicPropertiesAllowed()const</a></p>
         */
        @io.qt.QtUninvokable
        public abstract boolean dynamicPropertiesAllowed();
        
        private native static boolean dynamicPropertiesAllowed_native_constfct(long __this__nativeId);
        
        /**
         * <p>See <a href="http://doc.qt.io/qt-5/qdesignerdynamicpropertysheetextension.html#isDynamicProperty">QDesignerDynamicPropertySheetExtension::isDynamicProperty(int)const</a></p>
         */
        @io.qt.QtUninvokable
        public abstract boolean isDynamicProperty(int index);
        
        private native static boolean isDynamicProperty_native_int_constfct(long __this__nativeId, int index);
        
        /**
         * <p>See <a href="http://doc.qt.io/qt-5/qdesignerdynamicpropertysheetextension.html#removeDynamicProperty">QDesignerDynamicPropertySheetExtension::removeDynamicProperty(int)</a></p>
         */
        @io.qt.QtUninvokable
        public abstract boolean removeDynamicProperty(int index);
        
        private native static boolean removeDynamicProperty_native_int(long __this__nativeId, int index);
        
        /**
         * Constructor for internal use only.
         * @param p expected to be <code>null</code>.
         */
        @io.qt.NativeAccess
        protected Impl(QPrivateConstructor p) { super(p); } 
        
    }

    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdesignerdynamicpropertysheetextension.html#addDynamicProperty">QDesignerDynamicPropertySheetExtension::addDynamicProperty(QString,QVariant)</a></p>
     */
    @io.qt.QtUninvokable
    public int addDynamicProperty(java.lang.String propertyName, java.lang.Object value);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdesignerdynamicpropertysheetextension.html#canAddDynamicProperty">QDesignerDynamicPropertySheetExtension::canAddDynamicProperty(QString)const</a></p>
     */
    @io.qt.QtUninvokable
    public boolean canAddDynamicProperty(java.lang.String propertyName);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdesignerdynamicpropertysheetextension.html#dynamicPropertiesAllowed">QDesignerDynamicPropertySheetExtension::dynamicPropertiesAllowed()const</a></p>
     */
    @io.qt.QtUninvokable
    public boolean dynamicPropertiesAllowed();
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdesignerdynamicpropertysheetextension.html#isDynamicProperty">QDesignerDynamicPropertySheetExtension::isDynamicProperty(int)const</a></p>
     */
    @io.qt.QtUninvokable
    public boolean isDynamicProperty(int index);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdesignerdynamicpropertysheetextension.html#removeDynamicProperty">QDesignerDynamicPropertySheetExtension::removeDynamicProperty(int)</a></p>
     */
    @io.qt.QtUninvokable
    public boolean removeDynamicProperty(int index);
    
}
