package io.qt.designer;


/**
 * <p>Enables Qt Designer to access and construct custom widgets</p>
 * <p>Java wrapper for Qt's class <a href="http://doc.qt.io/qt-5/qdesignercustomwidgetinterface.html">QDesignerCustomWidgetInterface</a></p>
 */
public interface QDesignerCustomWidgetInterface extends io.qt.QtObjectInterface
{
    /**
     * <p>Implementor class for interface {@link io.qt.designer.QDesignerCustomWidgetInterface}</p>
     */
    public static abstract class Impl extends io.qt.QtObject
        implements io.qt.designer.QDesignerCustomWidgetInterface
    {
        static {
            QtJambi_LibraryUtilities.initialize();
        }
        
        @io.qt.NativeAccess
        private static final class ConcreteWrapper extends QDesignerCustomWidgetInterface.Impl {
            
            @io.qt.NativeAccess
            private ConcreteWrapper(QPrivateConstructor p) { super(p); }
            
            @Override
            @io.qt.QtUninvokable
            public io.qt.widgets.QWidget createWidget(io.qt.widgets.QWidget parent){
                return createWidget_native_QWidget_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(parent));
            }
            private native static io.qt.widgets.QWidget createWidget_native_QWidget_ptr(long __this__nativeId, long parent);
            
            
            @Override
            @io.qt.QtUninvokable
            public java.lang.String group(){
                return group_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
            }
            private native static java.lang.String group_native_constfct(long __this__nativeId);
            
            
            @Override
            @io.qt.QtUninvokable
            public io.qt.gui.QIcon icon(){
                return icon_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
            }
            private native static io.qt.gui.QIcon icon_native_constfct(long __this__nativeId);
            
            
            @Override
            @io.qt.QtUninvokable
            public java.lang.String includeFile(){
                return includeFile_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
            }
            private native static java.lang.String includeFile_native_constfct(long __this__nativeId);
            
            
            @Override
            @io.qt.QtUninvokable
            public boolean isContainer(){
                return isContainer_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
            }
            private native static boolean isContainer_native_constfct(long __this__nativeId);
            
            
            @Override
            @io.qt.QtUninvokable
            public java.lang.String name(){
                return name_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
            }
            private native static java.lang.String name_native_constfct(long __this__nativeId);
            
            
            @Override
            @io.qt.QtUninvokable
            public java.lang.String toolTip(){
                return toolTip_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
            }
            private native static java.lang.String toolTip_native_constfct(long __this__nativeId);
            
            
            @Override
            @io.qt.QtUninvokable
            public java.lang.String whatsThis(){
                return whatsThis_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
            }
            private native static java.lang.String whatsThis_native_constfct(long __this__nativeId);
            
        }
        
        
        public Impl(){
            super((QPrivateConstructor)null);
            initialize_native(this);
        }
        
        private native static void initialize_native(QDesignerCustomWidgetInterface instance);
        
        /**
         * <p>See <a href="http://doc.qt.io/qt-5/qdesignercustomwidgetinterface.html#codeTemplate">QDesignerCustomWidgetInterface::codeTemplate()const</a></p>
         */
        @io.qt.QtUninvokable
        public java.lang.String codeTemplate(){
            return codeTemplate_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        
        private native static java.lang.String codeTemplate_native_constfct(long __this__nativeId);
        
        /**
         * <p>See <a href="http://doc.qt.io/qt-5/qdesignercustomwidgetinterface.html#createWidget">QDesignerCustomWidgetInterface::createWidget(QWidget*)</a></p>
         */
        @io.qt.QtUninvokable
        public abstract io.qt.widgets.QWidget createWidget(io.qt.widgets.QWidget parent);
        
        private native static io.qt.widgets.QWidget createWidget_native_QWidget_ptr(long __this__nativeId, long parent);
        
        /**
         * <p>See <a href="http://doc.qt.io/qt-5/qdesignercustomwidgetinterface.html#domXml">QDesignerCustomWidgetInterface::domXml()const</a></p>
         */
        @io.qt.QtUninvokable
        public java.lang.String domXml(){
            return domXml_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        
        private native static java.lang.String domXml_native_constfct(long __this__nativeId);
        
        /**
         * <p>See <a href="http://doc.qt.io/qt-5/qdesignercustomwidgetinterface.html#group">QDesignerCustomWidgetInterface::group()const</a></p>
         */
        @io.qt.QtUninvokable
        public abstract java.lang.String group();
        
        private native static java.lang.String group_native_constfct(long __this__nativeId);
        
        /**
         * <p>See <a href="http://doc.qt.io/qt-5/qdesignercustomwidgetinterface.html#icon">QDesignerCustomWidgetInterface::icon()const</a></p>
         */
        @io.qt.QtUninvokable
        public abstract io.qt.gui.QIcon icon();
        
        private native static io.qt.gui.QIcon icon_native_constfct(long __this__nativeId);
        
        /**
         * <p>See <a href="http://doc.qt.io/qt-5/qdesignercustomwidgetinterface.html#includeFile">QDesignerCustomWidgetInterface::includeFile()const</a></p>
         */
        @io.qt.QtUninvokable
        public abstract java.lang.String includeFile();
        
        private native static java.lang.String includeFile_native_constfct(long __this__nativeId);
        
        /**
         * <p>See <a href="http://doc.qt.io/qt-5/qdesignercustomwidgetinterface.html#initialize">QDesignerCustomWidgetInterface::initialize(QDesignerFormEditorInterface*)</a></p>
         */
        @io.qt.QtUninvokable
        public void initialize(io.qt.designer.QDesignerFormEditorInterface core){
            initialize_native_QDesignerFormEditorInterface_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(core));
        }
        
        private native static void initialize_native_QDesignerFormEditorInterface_ptr(long __this__nativeId, long core);
        
        /**
         * <p>See <a href="http://doc.qt.io/qt-5/qdesignercustomwidgetinterface.html#isContainer">QDesignerCustomWidgetInterface::isContainer()const</a></p>
         */
        @io.qt.QtUninvokable
        public abstract boolean isContainer();
        
        private native static boolean isContainer_native_constfct(long __this__nativeId);
        
        /**
         * <p>See <a href="http://doc.qt.io/qt-5/qdesignercustomwidgetinterface.html#isInitialized">QDesignerCustomWidgetInterface::isInitialized()const</a></p>
         */
        @io.qt.QtUninvokable
        public boolean isInitialized(){
            return isInitialized_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        
        private native static boolean isInitialized_native_constfct(long __this__nativeId);
        
        /**
         * <p>See <a href="http://doc.qt.io/qt-5/qdesignercustomwidgetinterface.html#name">QDesignerCustomWidgetInterface::name()const</a></p>
         */
        @io.qt.QtUninvokable
        public abstract java.lang.String name();
        
        private native static java.lang.String name_native_constfct(long __this__nativeId);
        
        /**
         * <p>See <a href="http://doc.qt.io/qt-5/qdesignercustomwidgetinterface.html#toolTip">QDesignerCustomWidgetInterface::toolTip()const</a></p>
         */
        @io.qt.QtUninvokable
        public abstract java.lang.String toolTip();
        
        private native static java.lang.String toolTip_native_constfct(long __this__nativeId);
        
        /**
         * <p>See <a href="http://doc.qt.io/qt-5/qdesignercustomwidgetinterface.html#whatsThis">QDesignerCustomWidgetInterface::whatsThis()const</a></p>
         */
        @io.qt.QtUninvokable
        public abstract java.lang.String whatsThis();
        
        private native static java.lang.String whatsThis_native_constfct(long __this__nativeId);
        
        /**
         * Constructor for internal use only.
         * @param p expected to be <code>null</code>.
         */
        @io.qt.NativeAccess
        protected Impl(QPrivateConstructor p) { super(p); } 
        
    }

    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdesignercustomwidgetinterface.html#codeTemplate">QDesignerCustomWidgetInterface::codeTemplate()const</a></p>
     */
    @io.qt.QtUninvokable
    public default java.lang.String codeTemplate(){
        return Impl.codeTemplate_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdesignercustomwidgetinterface.html#createWidget">QDesignerCustomWidgetInterface::createWidget(QWidget*)</a></p>
     */
    @io.qt.QtUninvokable
    public io.qt.widgets.QWidget createWidget(io.qt.widgets.QWidget parent);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdesignercustomwidgetinterface.html#domXml">QDesignerCustomWidgetInterface::domXml()const</a></p>
     */
    @io.qt.QtUninvokable
    public default java.lang.String domXml(){
        return Impl.domXml_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdesignercustomwidgetinterface.html#group">QDesignerCustomWidgetInterface::group()const</a></p>
     */
    @io.qt.QtUninvokable
    public java.lang.String group();
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdesignercustomwidgetinterface.html#icon">QDesignerCustomWidgetInterface::icon()const</a></p>
     */
    @io.qt.QtUninvokable
    public io.qt.gui.QIcon icon();
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdesignercustomwidgetinterface.html#includeFile">QDesignerCustomWidgetInterface::includeFile()const</a></p>
     */
    @io.qt.QtUninvokable
    public java.lang.String includeFile();
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdesignercustomwidgetinterface.html#initialize">QDesignerCustomWidgetInterface::initialize(QDesignerFormEditorInterface*)</a></p>
     */
    @io.qt.QtUninvokable
    public default void initialize(io.qt.designer.QDesignerFormEditorInterface core){
        Impl.initialize_native_QDesignerFormEditorInterface_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(core));
    }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdesignercustomwidgetinterface.html#isContainer">QDesignerCustomWidgetInterface::isContainer()const</a></p>
     */
    @io.qt.QtUninvokable
    public boolean isContainer();
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdesignercustomwidgetinterface.html#isInitialized">QDesignerCustomWidgetInterface::isInitialized()const</a></p>
     */
    @io.qt.QtUninvokable
    public default boolean isInitialized(){
        return Impl.isInitialized_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdesignercustomwidgetinterface.html#name">QDesignerCustomWidgetInterface::name()const</a></p>
     */
    @io.qt.QtUninvokable
    public java.lang.String name();
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdesignercustomwidgetinterface.html#toolTip">QDesignerCustomWidgetInterface::toolTip()const</a></p>
     */
    @io.qt.QtUninvokable
    public java.lang.String toolTip();
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdesignercustomwidgetinterface.html#whatsThis">QDesignerCustomWidgetInterface::whatsThis()const</a></p>
     */
    @io.qt.QtUninvokable
    public java.lang.String whatsThis();
    
}
