/*
 * Decompiled with CFR 0.152.
 */
package io.qt.qtjambi.deployer;

import io.qt.core.QByteArray;
import io.qt.core.QCborMap;
import io.qt.core.QCborValue;
import io.qt.core.QCommandLineOption;
import io.qt.core.QCommandLineParser;
import io.qt.core.QDir;
import io.qt.core.QFile;
import io.qt.core.QIODevice;
import io.qt.core.QIODeviceBase;
import io.qt.core.QJsonDocument;
import io.qt.core.QJsonObject;
import io.qt.core.QJsonParseError;
import io.qt.core.QStringList;
import io.qt.core.QTextStream;
import io.qt.internal.DeployerUtility;
import io.qt.qtjambi.deployer.Main;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

final class PluginGenerator {
    PluginGenerator() {
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static void generate(QCommandLineParser parser, String[] args, QCommandLineOption platformOption, QCommandLineOption dirOption, QCommandLineOption classPathOption, QCommandLineOption configurationOption) throws InterruptedException, IOException {
        File subdirectory;
        File file;
        String string;
        QCommandLineOption subdirOption = new QCommandLineOption((Collection)QStringList.of((String)"subdir", (String[])new String[0]), "Plugin sub-directory", "subdir");
        QCommandLineOption pluginIIDOption = new QCommandLineOption((Collection)QStringList.of((String)"iid", (String[])new String[0]), "Plugin IID", "iid");
        QCommandLineOption pluginClassNameOption = new QCommandLineOption((Collection)QStringList.of((String)"class-name", (String[])new String[0]), "Class name", "name");
        QCommandLineOption pluginNameOption = new QCommandLineOption((Collection)QStringList.of((String)"plugin-name", (String[])new String[0]), "Plugin name", "name");
        QCommandLineOption pluginLibraryOption = new QCommandLineOption((Collection)QStringList.of((String)"plugin-library", (String[])new String[0]), "Path to QtJambiPlugin library.\nExamples:\n--plugin-library=path" + File.separator + "QtJambiPlugin.dll\n--plugin-library=macos" + File.pathSeparator + "path" + File.separator + "libQtJambiPlugin.dylib", "file");
        QCommandLineOption pluginLibraryLocationOption = new QCommandLineOption((Collection)QStringList.of((String)"plugin-library-location", (String[])new String[0]), "Directory containing QtJambiPlugin library", "path");
        QCommandLineOption pluginMetaDataOption = new QCommandLineOption((Collection)QStringList.of((String)"meta-data", (String[])new String[0]), "Plugin meta data as json code or path to existing json file.", "json|file");
        QCommandLineOption pluginSourceOption = new QCommandLineOption((Collection)QStringList.of((String)"source", (String[])new String[0]), "Generate C++ source project");
        parser.addOptions(Arrays.asList(platformOption, pluginIIDOption, configurationOption, pluginClassNameOption, pluginNameOption, pluginLibraryOption, pluginLibraryLocationOption, pluginMetaDataOption, pluginSourceOption, dirOption, subdirOption, classPathOption));
        if (args.length == 1) {
            parser.showHelp();
        }
        parser.process((Collection)new QStringList(args));
        QStringList unusedArguments = new QStringList((Collection)parser.positionalArguments());
        if (unusedArguments.size() == 1) {
            throw new Error("Qt plugin generation, illegal argument: " + unusedArguments.join(", "));
        }
        if (unusedArguments.size() > 1) {
            throw new Error("Qt plugin generation, illegal argument: " + unusedArguments.join(", "));
        }
        String iid = null;
        if (parser.isSet(pluginIIDOption)) {
            iid = parser.value(pluginIIDOption);
        }
        String className = null;
        if (parser.isSet(pluginClassNameOption)) {
            className = parser.value(pluginClassNameOption);
        }
        String pluginName = null;
        if (parser.isSet(pluginNameOption)) {
            pluginName = parser.value(pluginNameOption);
        }
        File dir = null;
        if (!parser.isSet(dirOption)) {
            throw new Error("Missing target directory. Please use --dir=...");
        }
        dir = new File(parser.value(dirOption));
        String subdir = null;
        if (parser.isSet(subdirOption)) {
            subdir = parser.value(subdirOption);
        }
        QJsonObject metaData = null;
        if (parser.isSet(pluginMetaDataOption)) {
            File file2;
            QByteArray data;
            String _metaData = parser.value(pluginMetaDataOption);
            if (_metaData.startsWith("\"") && _metaData.endsWith("\"")) {
                _metaData = _metaData.substring(1, _metaData.length() - 2);
            }
            if ((data = _metaData.startsWith("{") && _metaData.endsWith("}") ? new QByteArray(_metaData.replace("''", "\"")) : ((file2 = new File(_metaData)).exists() ? new QByteArray(Files.readAllBytes(file2.toPath())) : null)) != null) {
                QJsonDocument.FromJsonResult result = QJsonDocument.fromJson((QByteArray)data);
                if (result.error.error() == QJsonParseError.ParseError.NoError && result.document.isObject()) {
                    metaData = result.document.object();
                }
            }
        }
        Boolean isDebug = null;
        if (parser.isSet(configurationOption)) {
            isDebug = "debug".equals(parser.value(configurationOption));
        }
        ArrayList classPath = new ArrayList();
        if (parser.isSet(classPathOption)) {
            Collections.addAll(classPath, parser.value(classPathOption).split(File.pathSeparator));
        }
        if (classPath.isEmpty()) {
            throw new Error("Missing classpath. Please use --class-path=...");
        }
        String platform = null;
        if (parser.isSet(platformOption)) {
            platform = parser.value(platformOption);
        }
        ArrayList<AbstractMap.SimpleEntry<Object, URL>> libraries = new ArrayList<AbstractMap.SimpleEntry<Object, URL>>();
        boolean generateSource = parser.isSet(pluginSourceOption);
        if (parser.isSet(pluginLibraryOption)) {
            String[] libinfo = parser.value(pluginLibraryOption).split(File.pathSeparator);
            if (libinfo.length == 2) {
                File file3 = new File(libinfo[1]);
                if (!file3.isFile()) {
                    throw new Error("Specified QtJambiPlugin library does not exist: " + libinfo[1]);
                }
                libraries.add(new AbstractMap.SimpleEntry<String, URL>(libinfo[0], file3.toURI().toURL()));
            } else {
                void var27_36;
                Object var27_28 = null;
                if (libinfo[0].endsWith(".dll")) {
                    String string2 = "windows";
                } else if (libinfo[0].endsWith(".dylib")) {
                    String string3 = "macos";
                } else if (libinfo[0].endsWith("_x86_64.so")) {
                    String string4 = "android-x64";
                } else if (libinfo[0].endsWith("_x86.so")) {
                    String string5 = "android-x86";
                } else if (libinfo[0].endsWith("_arm64-v8a.so")) {
                    String string6 = "android-arm64";
                } else if (libinfo[0].endsWith("_armeabi-v7a.so")) {
                    String string7 = "android-arm";
                } else if (libinfo[0].endsWith(".so")) {
                    String string8 = "linux";
                }
                if (var27_36 == null) throw new Error("Unable to determine platform for library " + libinfo[0] + ". Please use --plugin-library=<platform>" + File.pathSeparatorChar + "<path to library>");
                File libFile = new File(libinfo[0]);
                if (!libFile.isFile()) {
                    throw new Error("Specified QtJambiPlugin library does not exist: " + libinfo[0]);
                }
                libraries.add(new AbstractMap.SimpleEntry<void, URL>(var27_36, libFile.toURI().toURL()));
            }
        } else if (parser.isSet(pluginLibraryLocationOption)) {
            File location = new File(parser.value(pluginLibraryLocationOption));
            if (isDebug == null) {
                throw new Error("Please specify --configuration=debug or --configuration=release prior to --plugin-library-location");
            }
            if (location.isDirectory()) {
                for (File entry : location.listFiles()) {
                    void var31_63;
                    if (!entry.isFile()) continue;
                    Object var31_64 = null;
                    if (isDebug.booleanValue()) {
                        if (entry.getName().equals("QtJambiPlugind.dll")) {
                            String string9 = "windows";
                        } else if (entry.getName().equals("libQtJambiPlugin_debug.dylib")) {
                            String string10 = "macos";
                        } else if (entry.getName().equals("libjarimport_debug_x86_64.so") || entry.getName().equals("libjarimport_x86_64.so")) {
                            String string11 = "android-x64";
                        } else if (entry.getName().equals("libjarimport_debug_x86.so") || entry.getName().equals("libjarimport_x86.so")) {
                            String string12 = "android-x86";
                        } else if (entry.getName().equals("libjarimport_debug_arm64-v8a.so") || entry.getName().equals("libjarimport_arm64-v8a.so")) {
                            String string13 = "android-arm64";
                        } else if (entry.getName().equals("libjarimport_debug_armeabi-v7a.so") || entry.getName().equals("libjarimport_armeabi-v7a.so")) {
                            String string14 = "android-arm";
                        } else if (entry.getName().equals("libQtJambiPlugin_debug.so")) {
                            String string15 = "linux";
                        }
                    } else if (entry.getName().equals("QtJambiPlugin.dll")) {
                        String string16 = "windows";
                    } else if (entry.getName().equals("libQtJambiPlugin.dylib")) {
                        String string17 = "macos";
                    } else if (entry.getName().equals("libjarimport_x86_64.so")) {
                        String string18 = "android-x64";
                    } else if (entry.getName().equals("libjarimport_x86.so")) {
                        String string19 = "android-x86";
                    } else if (entry.getName().equals("libjarimport_arm64-v8a.so")) {
                        String string20 = "android-arm64";
                    } else if (entry.getName().equals("libjarimport_armeabi-v7a.so")) {
                        String string21 = "android-arm";
                    } else if (entry.getName().equals("libQtJambiPlugin.so")) {
                        String string22 = "linux";
                    }
                    if (var31_63 == null || !entry.getName().contains("QtJambiPlugin")) continue;
                    libraries.add(new AbstractMap.SimpleEntry<void, URL>(var31_63, entry.toURI().toURL()));
                }
            }
        }
        if (className == null || metaData == null || pluginName == null) {
            try (JarFile jarFile = new JarFile(new File((String)classPath.get(0)));){
                String _metaData;
                Attributes attributes = jarFile.getManifest().getMainAttributes();
                if (metaData == null && (_metaData = attributes.getValue("QtJambi-Plugin-Metadata")) != null) {
                    QByteArray data = new QByteArray(_metaData.replace("''", "\""));
                    QJsonDocument.FromJsonResult result = QJsonDocument.fromJson((QByteArray)data);
                    if (result.error.error() == QJsonParseError.ParseError.NoError && result.document.isObject()) {
                        metaData = result.document.object();
                    }
                }
                if (className == null) {
                    className = attributes.getValue("QtJambi-Plugin-Class");
                }
                if (pluginName == null) {
                    pluginName = attributes.getValue("QtJambi-Plugin-Name");
                }
            }
        }
        if (className == null || className.isEmpty()) {
            throw new Error("Missing class name. Please use --class-name=...");
        }
        if (metaData == null) {
            throw new Error("Missing metadata. Please use --meta-data=...");
        }
        if (libraries.isEmpty() && !generateSource) {
            Enumeration<URL> specsFound = Main.findSpecs();
            HashSet<Object> hashSet = new HashSet<Object>();
            while (specsFound.hasMoreElements()) {
                int n;
                String eform;
                int end;
                URL url = specsFound.nextElement();
                if (hashSet.contains(url)) continue;
                hashSet.add(url);
                String protocol = url.getProtocol();
                if (!protocol.equals("jar") || (end = (eform = url.toExternalForm()).indexOf("!/", n = 4)) == -1) continue;
                try {
                    Document doc;
                    try (InputStream inStream = url.openStream();){
                        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                        factory.setValidating(false);
                        DocumentBuilder builder = factory.newDocumentBuilder();
                        doc = builder.parse(inStream);
                    }
                    String system = doc.getDocumentElement().getAttribute("system");
                    String configuration = doc.getDocumentElement().getAttribute("configuration");
                    if (isDebug != null && isDebug.booleanValue() != "debug".equals(configuration)) continue;
                    for (int i = 0; i < doc.getDocumentElement().getChildNodes().getLength(); ++i) {
                        Element element;
                        String library;
                        Node child = doc.getDocumentElement().getChildNodes().item(i);
                        if (!(child instanceof Element) || !child.getNodeName().equals("library") || !(library = (element = (Element)child).getAttribute("name")).contains("QtJambiPlugin")) continue;
                        URL libraryURL = Main.createURL(eform.substring(0, end + 2) + library);
                        libraries.add(new AbstractMap.SimpleEntry<String, URL>(system, libraryURL));
                    }
                }
                catch (Exception e) {
                    Logger.getLogger("io.qt").log(Level.WARNING, "", e);
                }
            }
            if (libraries.isEmpty()) {
                throw new Error("Missing paths to QtJambiPlugin library. Please use --plugin-library=<path to library>, --plugin-library=<platform>" + File.pathSeparatorChar + "<path to library> or --plugin-library-location=<path> in combination with --configuration=debug/release");
            }
        }
        if (pluginName == null && classPath.size() == 1 && (string = (file = new File((String)classPath.get(0))).getName()).endsWith(".jar")) {
            pluginName = string.substring(0, string.length() - 4);
        }
        if (pluginName == null) {
            throw new Error("Missing plugin name. Please use --plugin-name=...");
        }
        if (iid == null) {
            Class<?> cls;
            ArrayList<URL> urls = new ArrayList<URL>();
            ArrayList<File> arrayList = new ArrayList<File>();
            for (String path : classPath) {
                File file4 = new File(path);
                if (!file4.exists()) throw new Error("Classpath not a file or directory: " + path);
                if (file4.isFile() && !file4.getName().endsWith(".jar")) {
                    arrayList.add(file4.getParentFile());
                    continue;
                }
                urls.add(file4.toURI().toURL());
            }
            StringBuilder lp = new StringBuilder(System.getProperty("java.library.path", ""));
            if (!arrayList.isEmpty()) {
                for (File file4 : arrayList) {
                    if (lp.length() != 0) {
                        lp.append(File.pathSeparator);
                    }
                    lp.append(file4.getAbsolutePath());
                }
                System.setProperty("java.library.path", lp.toString());
            }
            PluginClassLoader pluginClassLoader = new PluginClassLoader();
            pluginClassLoader.addURLs(urls);
            try {
                cls = pluginClassLoader.loadClass(className);
            }
            catch (ClassNotFoundException | NoClassDefFoundError throwable) {
                System.err.println("Loading class " + className + " failed. Trying to extend classpath.");
                URL url = QFile.class.getResource("QFile.class");
                if (url != null) {
                    String path = url.toString();
                    int idx = -1;
                    File jarFile = null;
                    if (path.startsWith("jar:file:") && (idx = path.indexOf("!/")) >= 0) {
                        path = path.substring(4, idx);
                        try {
                            jarFile = new File(Main.createURL(path).toURI());
                        }
                        catch (Exception e1) {
                            throw new Error("Unable to find class: " + className, e1);
                        }
                    }
                    try {
                        File[] connection = url.openConnection();
                        if (connection instanceof JarURLConnection) {
                            jarFile = new File(((JarURLConnection)connection).getJarFile().getName());
                        }
                    }
                    catch (Throwable connection) {
                        // empty catch block
                    }
                    if (jarFile != null) {
                        if (jarFile.getParentFile().isDirectory()) {
                            for (File other : jarFile.getParentFile().listFiles()) {
                                if (!other.isFile() || !other.getName().startsWith("qtjambi") || other.getName().endsWith("javadoc.jar") || other.getName().endsWith("sources.jar") || !other.getName().endsWith(".jar")) continue;
                                urls.add(other.toURI().toURL());
                            }
                        }
                        pluginClassLoader.close();
                        pluginClassLoader = new PluginClassLoader();
                        pluginClassLoader.addURLs(urls);
                        try {
                            cls = pluginClassLoader.loadClass(className);
                        }
                        catch (Exception e1) {
                            throw new Error("Unable to find class: " + className, e1);
                        }
                    }
                    System.err.println(url);
                    throw new Error("Unable to find class: " + className);
                }
                System.err.println(url);
                throw new Error("Unable to find class: " + className);
            }
            iid = DeployerUtility.getInterfaceIID(cls);
            if (iid == null) {
                throw new Error("Unable to detect IID from class: " + cls.getName());
            }
        }
        if (iid == null || className == null) return;
        QCborMap cborValue = new QCborMap();
        cborValue.setValue(2L, new QCborValue(iid));
        cborValue.setValue(3L, new QCborValue(className.replace(".", "::")));
        cborValue.setValue(4L, new QCborValue(QCborMap.fromJsonObject((QJsonObject)metaData)));
        cborValue.setValue(54491065312L, new QCborValue(pluginName));
        QByteArray qByteArray = cborValue.toCborValue().toCbor();
        System.gc();
        if (generateSource) {
            subdirectory = new File(dir, pluginName);
            subdirectory.mkdirs();
            if (classPath.size() == 1) {
                File file5 = new File((String)classPath.get(0));
                Files.copy(file5.toPath(), new File(subdirectory, pluginName + ".jar").toPath(), StandardCopyOption.REPLACE_EXISTING);
            } else {
                subdirectory = new File(subdirectory, pluginName);
                subdirectory.mkdirs();
                for (String path : classPath) {
                    File file6 = new File(subdirectory, path);
                    file6.getParentFile().mkdirs();
                    Files.copy(new File(path).toPath(), file6.toPath(), StandardCopyOption.REPLACE_EXISTING);
                }
            }
            PluginGenerator.generateSource(dir, subdir, pluginName, qByteArray);
            return;
        } else {
            if (subdir != null) {
                subdirectory = new File(new File(dir, "plugins"), subdir);
                subdirectory.mkdirs();
            } else {
                subdirectory = dir;
            }
            if (classPath.size() == 1) {
                File file7 = new File((String)classPath.get(0));
                Files.copy(file7.toPath(), new File(subdirectory, pluginName + ".jar").toPath(), StandardCopyOption.REPLACE_EXISTING);
            } else {
                subdirectory = new File(subdirectory, pluginName);
                subdirectory.mkdirs();
                for (String path : classPath) {
                    File file8 = new File(subdirectory, path);
                    file8.getParentFile().mkdirs();
                    Files.copy(new File(path).toPath(), file8.toPath(), StandardCopyOption.REPLACE_EXISTING);
                }
            }
            QCborMap map = new QCborMap();
            map.insert(-889275714L, QCborValue.fromVariant((Object)new QByteArray(1006L, 10)));
            map.insert(-1161901314L, QCborValue.fromVariant((Object)"END"));
            QByteArray QTMETADATA = map.toCborValue().toCbor();
            if (qByteArray.size() > QTMETADATA.size()) {
                throw new Error("Plugin metadata exceeds maximum size of " + QTMETADATA.size() + " byte.");
            }
            if (qByteArray.size() < QTMETADATA.size()) {
                qByteArray.resize(QTMETADATA.size());
            }
            block63: for (Map.Entry entry : libraries) {
                File newFile;
                String os = (String)entry.getKey();
                if (os == null || platform != null && !platform.startsWith(os)) continue;
                if (os.toLowerCase().startsWith("android-")) {
                    subdirectory = dir;
                } else if (subdir != null) {
                    subdirectory = new File(new File(dir, "plugins"), subdir);
                    subdirectory.mkdirs();
                } else {
                    subdirectory = dir;
                }
                switch (os.toLowerCase()) {
                    case "win32": 
                    case "win64": 
                    case "windows": 
                    case "windows-arm": 
                    case "windows-arm32": 
                    case "windows-aarch64": 
                    case "windows-arm64": 
                    case "windows-x86": 
                    case "windows-x64": {
                        newFile = isDebug == null ? new File(subdirectory, pluginName + (((URL)entry.getValue()).toExternalForm().endsWith("d.dll") ? "d.dll" : ".dll")) : new File(subdirectory, pluginName + (isDebug != false ? "d.dll" : ".dll"));
                        System.gc();
                        break;
                    }
                    case "macos": 
                    case "osx": {
                        newFile = new File(subdirectory, "lib" + pluginName + ".dylib");
                        break;
                    }
                    case "linux": 
                    case "linux32": 
                    case "linux64": 
                    case "linux-arm64": 
                    case "linux-aarch64": 
                    case "linux-x86": 
                    case "linux-x64": {
                        newFile = new File(subdirectory, "lib" + pluginName + ".so");
                        break;
                    }
                    case "android-x64": {
                        if (subdir != null) {
                            subdirectory = new File(new File(dir, "lib"), "x86_64");
                            subdirectory.mkdirs();
                            newFile = new File(subdirectory, "libplugins_" + subdir + "_" + pluginName + "_x86_64.so");
                            break;
                        }
                        newFile = new File(subdirectory, "libplugins_" + dir.getName() + "_" + pluginName + "_x86_64.so");
                        break;
                    }
                    case "android-x86": {
                        if (subdir != null) {
                            subdirectory = new File(new File(dir, "lib"), "x86");
                            subdirectory.mkdirs();
                            newFile = new File(subdirectory, "libplugins_" + subdir + "_" + pluginName + "_x86.so");
                            break;
                        }
                        newFile = new File(subdirectory, "libplugins_" + dir.getName() + "_" + pluginName + "_x86.so");
                        break;
                    }
                    case "android-arm64": {
                        if (subdir != null) {
                            subdirectory = new File(new File(dir, "lib"), "arm64-v8a");
                            subdirectory.mkdirs();
                            newFile = new File(subdirectory, "libplugins_" + subdir + "_" + pluginName + "_arm64-v8a.so");
                            break;
                        }
                        newFile = new File(subdirectory, "libplugins_" + dir.getName() + "_" + pluginName + "_arm64-v8a.so");
                        break;
                    }
                    case "android-arm": {
                        if (subdir != null) {
                            subdirectory = new File(new File(dir, "lib"), "armeabi-v7a");
                            subdirectory.mkdirs();
                            newFile = new File(subdirectory, "libplugins_" + subdir + "_" + pluginName + "_armeabi-v7a.so");
                            break;
                        }
                        newFile = new File(subdirectory, "libplugins_" + dir.getName() + "_" + pluginName + "_armeabi-v7a.so");
                        break;
                    }
                    default: {
                        continue block63;
                    }
                }
                try {
                    QIODevice device = QIODevice.fromInputStream((InputStream)((URL)entry.getValue()).openStream());
                    QByteArray libData = device.readAll();
                    device.close();
                    int idx = (int)libData.indexOf(QTMETADATA);
                    if (idx <= 0) throw new Error("Unable to find plugin meta data in file " + ((URL)entry.getValue()).toExternalForm());
                    QFile _newFile = new QFile(QDir.fromNativeSeparators((String)newFile.getAbsolutePath()));
                    if (!_newFile.open(new QIODeviceBase.OpenModeFlag[]{QIODeviceBase.OpenModeFlag.WriteOnly})) throw new Error("Unable to write file " + _newFile.fileName());
                    _newFile.write(libData);
                    while (idx > 0) {
                        _newFile.seek((long)idx);
                        _newFile.write(qByteArray);
                        idx = (int)libData.indexOf(QTMETADATA, (long)idx + QTMETADATA.size());
                    }
                    _newFile.close();
                }
                catch (IOException e) {
                    throw new Error("Unable to read file " + ((URL)entry.getValue()).toExternalForm(), e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void generateSource(File dir, String subdir, String pluginName, QByteArray cborData) {
        block26: {
            QTextStream s;
            QFile fileout;
            QFile filein;
            String fileName;
            QDir subdirectory;
            block25: {
                subdirectory = new QDir(dir.getAbsolutePath());
                subdirectory.mkpath(pluginName);
                subdirectory.cd(pluginName);
                fileName = subdirectory.absoluteFilePath("plugin.cpp");
                filein = new QFile(":io/qt/qtjambi/deployer/plugin.cpp");
                fileout = new QFile(fileName);
                if (filein.open(new QIODeviceBase.OpenModeFlag[]{QIODeviceBase.OpenModeFlag.ReadOnly})) {
                    try {
                        if (fileout.open(new QIODeviceBase.OpenModeFlag[]{QIODeviceBase.OpenModeFlag.WriteOnly, QIODeviceBase.OpenModeFlag.Text})) {
                            s = new QTextStream((QIODevice)fileout);
                            try {
                                s.append("#include <QtCore/QtPlugin>").endl().append("#include <QtCore/QPluginLoader>").endl().endl().append("#define CBOR_DATA \\").endl().append("    ");
                                byte[] data = cborData.toArray();
                                int i = 0;
                                int j = 0;
                                while (i < data.length) {
                                    byte b = data[i];
                                    if (Character.isAlphabetic(b)) {
                                        s.append('\'').append((char)b).append("', ");
                                    } else {
                                        String hex = Integer.toHexString(Byte.toUnsignedInt(b));
                                        while (hex.length() > 2 && hex.charAt(0) == '0') {
                                            hex = hex.substring(1);
                                        }
                                        s.append("0x").append(hex).append(", ");
                                    }
                                    if (j == 7) {
                                        s.append("\\").endl().append("    ");
                                        j = 0;
                                    }
                                    ++i;
                                    ++j;
                                }
                                s.endl().endl().flush();
                                QTextStream in = new QTextStream((QIODevice)filein);
                                while (!in.atEnd()) {
                                    s.append(in.readLine()).endl();
                                }
                                in.dispose();
                                break block25;
                            }
                            finally {
                                s.flush();
                                s.dispose();
                                fileout.close();
                            }
                        }
                        throw new Error("Unable to write file " + fileName);
                    }
                    finally {
                        filein.close();
                    }
                }
                throw new Error("Unable to read resource plugin.cpp");
            }
            fileName = subdirectory.absoluteFilePath("plugin.pro");
            fileout = new QFile(fileName);
            filein = new QFile(":io/qt/qtjambi/deployer/plugin.pro");
            if (filein.open(new QIODeviceBase.OpenModeFlag[]{QIODeviceBase.OpenModeFlag.ReadOnly})) {
                try {
                    if (fileout.open(new QIODeviceBase.OpenModeFlag[]{QIODeviceBase.OpenModeFlag.WriteOnly, QIODeviceBase.OpenModeFlag.Text})) {
                        s = new QTextStream((QIODevice)fileout);
                        try {
                            if (subdir != null) {
                                s.append("android:TARGET = plugins_").append(subdir).append('_').append(pluginName).endl().append("else:TARGET = ").append(pluginName).endl();
                            } else {
                                s.append("TARGET = ").append(pluginName).endl();
                            }
                            QTextStream in = new QTextStream((QIODevice)filein);
                            while (!in.atEnd()) {
                                s.append(in.readLine()).endl();
                            }
                            in.dispose();
                            break block26;
                        }
                        finally {
                            s.flush();
                            s.dispose();
                            fileout.close();
                        }
                    }
                    throw new Error("Unable to write file " + fileName);
                }
                finally {
                    filein.close();
                }
            }
            throw new Error("Unable to read resource plugin.pro");
        }
    }

    private static class PluginClassLoader
    extends URLClassLoader {
        public PluginClassLoader() {
            super(new URL[0]);
        }

        protected void addURLs(Collection<URL> urls) {
            for (URL url : urls) {
                super.addURL(url);
            }
        }
    }
}

