/*
 * Decompiled with CFR 0.152.
 */
package io.qt.qtjambi.deployer;

import io.qt.QtLongEnumerator;
import io.qt.QtUtilities;
import io.qt.core.QByteArray;
import io.qt.core.QCommandLineOption;
import io.qt.core.QCommandLineParser;
import io.qt.core.QCoreApplication;
import io.qt.core.QList;
import io.qt.core.QScopeGuard;
import io.qt.qtjambi.deployer.AppGenerator;
import io.qt.qtjambi.deployer.BundleGenerator;
import io.qt.qtjambi.deployer.ContainerAccessGenerator;
import io.qt.qtjambi.deployer.PluginGenerator;
import io.qt.qtjambi.deployer.QMLGenerator;
import java.io.File;
import java.io.IOException;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Main {
    private static void printout(QByteArray data) {
        int i = 0;
        while ((long)i < data.size()) {
            for (int j = 0; j < 32 && (long)i < data.size(); ++j) {
                System.out.print(Byte.toUnsignedInt(data.at((long)i++)));
                System.out.print(',');
            }
            System.out.println();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void main(String[] args) throws InterruptedException, IOException {
        if (args.length > 0) {
            try {
                boolean doInit;
                boolean bl = doInit = QCoreApplication.instance() == null;
                if (doInit) {
                    QCoreApplication.setApplicationName((String)("deployer " + args[0]));
                    QCoreApplication.setApplicationVersion((String)QtUtilities.qtjambiVersion().toString());
                    QCoreApplication.initialize((String[])args);
                    QCoreApplication.setApplicationName((String)"deployer");
                }
                try (QScopeGuard guard = new QScopeGuard(QCoreApplication::shutdown);){
                    if (!doInit) {
                        guard.dismiss();
                    }
                    QCommandLineParser parser = new QCommandLineParser();
                    parser.setSingleDashWordOptionMode(QCommandLineParser.SingleDashWordOptionMode.ParseAsLongOptions);
                    parser.setApplicationDescription(String.format("QtJambi Deployer version %1$s", QtUtilities.qtjambiVersion().toString()));
                    parser.addHelpOption();
                    parser.addVersionOption();
                    QCommandLineOption platformOption = new QCommandLineOption((Collection)QList.of((String)"platform", (String[])new String[0]), "Target platform", "platform");
                    QCommandLineOption dirOption = new QCommandLineOption((Collection)QList.of((String)"d", (String[])new String[]{"dir", "target-directory"}), "Target directory", "dir");
                    QCommandLineOption classPathOption = new QCommandLineOption((Collection)QList.of((String)"cp", (String[])new String[]{"class-path"}), "Class path for plugin/app execution", "path");
                    QCommandLineOption configurationOption = new QCommandLineOption((Collection)QList.of((String)"c", (String[])new String[]{"configuration"}), "Library configuration", "debug|release", "release");
                    switch (args[0]) {
                        case "plugin": 
                        case "pluginlib": {
                            PluginGenerator.generate(parser, args, platformOption, dirOption, classPathOption, configurationOption);
                            return;
                        }
                        case "qml": 
                        case "qmllib": {
                            QMLGenerator.generate(parser, args, platformOption, dirOption, classPathOption, configurationOption);
                            return;
                        }
                        case "app": 
                        case "application": {
                            AppGenerator.generate(parser, args, platformOption, dirOption, classPathOption, configurationOption);
                            return;
                        }
                        case "qt": 
                        case "qtlib": 
                        case "qtbundles": {
                            BundleGenerator.generate(parser, args, platformOption, dirOption, configurationOption);
                            return;
                        }
                        case "container": 
                        case "containeraccess": 
                        case "ca": {
                            ContainerAccessGenerator.generate(parser, args, dirOption);
                            return;
                        }
                        default: {
                            throw new Error("QtJambi Deployer, illegal argument: " + args[0] + ", expected: one of plugin|qml|application|qtbundles|containeraccess");
                        }
                    }
                }
            }
            catch (Error e) {
                System.err.println(e.getMessage());
                System.exit(-1);
            }
            return;
        }
        String version = QtUtilities.qtjambiVersion().toString();
        System.out.println("Usage: deployer [plugin|qml|application|qt]");
        System.out.println(String.format("QtJambi Deployer version %1$s", version));
    }

    static Enumeration<URL> findSpecs() throws MalformedURLException {
        URL url;
        Enumeration<Object> specsFound = Collections.emptyEnumeration();
        try {
            specsFound = Main.class.getClassLoader().getResources("qtjambi-utilities.xml");
        }
        catch (IOException e) {
            Logger.getLogger("io.qt").log(Level.WARNING, "", e);
        }
        if (!specsFound.hasMoreElements() && (url = Main.class.getResource("Main.class")) != null) {
            int index;
            String classURL = url.toString();
            File jarFile = null;
            if (classURL.startsWith("jar:file:") && (index = classURL.indexOf("!/")) > 0) {
                String jarFileURL = classURL.substring(4, index);
                try {
                    jarFile = new File(new URL(jarFileURL).toURI());
                }
                catch (URISyntaxException uRISyntaxException) {}
            } else {
                try {
                    URLConnection connection = url.openConnection();
                    if (connection instanceof JarURLConnection) {
                        jarFile = new File(((JarURLConnection)connection).getJarFile().getName());
                    }
                }
                catch (Throwable connection) {
                    // empty catch block
                }
            }
            if (jarFile != null && jarFile.exists()) {
                URL nativeFileURL;
                File nativeFile;
                File directory = jarFile.getParentFile();
                String fileName = jarFile.getName();
                String suffix = String.format("-%1$s.jar", QtUtilities.qtjambiVersion().toString());
                index = fileName.indexOf(suffix);
                fileName = fileName.substring(0, index) + "-native-";
                ArrayList<URL> foundURLs = new ArrayList<URL>();
                for (String jar : directory.list()) {
                    if (!jar.startsWith(fileName) || !jar.endsWith(suffix)) continue;
                    nativeFile = new File(directory, jar);
                    nativeFileURL = new URL("jar:" + nativeFile.toURI() + "!/qtjambi-utilities.xml");
                    foundURLs.add(nativeFileURL);
                }
                if (foundURLs.isEmpty()) {
                    for (String jar : new File(directory, "native").list()) {
                        if (!jar.startsWith(fileName) || !jar.endsWith(suffix)) continue;
                        nativeFile = new File(new File(directory, "native"), jar);
                        nativeFileURL = new URL("jar:" + nativeFile.toURI() + "!/qtjambi-utilities.xml");
                        foundURLs.add(nativeFileURL);
                    }
                }
                if (!foundURLs.isEmpty()) {
                    specsFound = Collections.enumeration(foundURLs);
                }
            }
        }
        return specsFound;
    }

    static enum Parameters implements QtLongEnumerator
    {
        JVMDetectionMode,
        JVMPath,
        MinimumJVM,
        MainClass,
        ClassPath,
        ModulePath,
        LibraryPath,
        JVMArguments,
        JNIMinimumVersion,
        JVMArgumentFilters;

    }

    static enum JVMDetectionModes implements QtLongEnumerator
    {
        AutoDetect,
        UseRelativePath;

    }
}

