/*
 * Decompiled with CFR 0.152.
 */
package io.qt.qtjambi.deployer;

import io.qt.core.QByteArray;
import io.qt.core.QCborArray;
import io.qt.core.QCborMap;
import io.qt.core.QCborValue;
import io.qt.core.QCommandLineOption;
import io.qt.core.QCommandLineParser;
import io.qt.core.QDir;
import io.qt.core.QFile;
import io.qt.core.QFileDevice;
import io.qt.core.QIODevice;
import io.qt.core.QIODeviceBase;
import io.qt.core.QStringList;
import io.qt.qtjambi.deployer.Main;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.LambdaMetafactory;
import java.net.URL;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Element;

final class AppGenerator {
    AppGenerator() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    static void generate(QCommandLineParser parser, String[] args, QCommandLineOption platformOption, QCommandLineOption dirOption, QCommandLineOption classPathOption, QCommandLineOption configurationOption) throws InterruptedException, IOException {
        block150: {
            block148: {
                block149: {
                    applicationJNIMinVersionOption = new QCommandLineOption((Collection)QStringList.of((String)"jni-minimum-version", (String[])new String[0]), "Minimum version for the required JNI", "version");
                    applicationNameOption = new QCommandLineOption((Collection)QStringList.of((String)"application", (String[])new String[]{"application-name"}), "Application name", "name");
                    applicationIcoOption = new QCommandLineOption((Collection)QStringList.of((String)"ico", (String[])new String[]{"application-icon"}), "Application icon", "file");
                    applicationMPOption = new QCommandLineOption((Collection)QStringList.of((String)"mp", (String[])new String[]{"module-path"}), "Module path for application execution", "path");
                    applicationLPOption = new QCommandLineOption((Collection)QStringList.of((String)"lp", (String[])new String[]{"library-path"}), "Library path for application execution", "path");
                    applicationMainClassOption = new QCommandLineOption((Collection)QStringList.of((String)"main-class", (String[])new String[0]), "Main class", "class");
                    applicationAutodetectJvmOption = new QCommandLineOption((Collection)QStringList.of((String)"autodetect-jvm", (String[])new String[0]), "Autodetect Java Virtual Machine at runtime");
                    applicationJVMMinVersionOption = new QCommandLineOption((Collection)QStringList.of((String)"minversion-jvm", (String[])new String[]{"jvm-minimum-version"}), "Minimum version for the autodetected Java Virtual Machine", "version");
                    applicationJVMPathOption = new QCommandLineOption((Collection)QStringList.of((String)"jvm-path", (String[])new String[0]), "Path to Java Virtual Machine (absolute or relative to app binary)", "version");
                    applicationExeOption = new QCommandLineOption((Collection)QStringList.of((String)"executable", (String[])new String[0]), "Path to executable file.\nExamples:\n--executable=path" + File.separator + "QtJambiLauncher.exe\n--executable=macos" + File.pathSeparator + "path" + File.separator + "QtJambiLauncher.app", "file");
                    applicationExeLocationOption = new QCommandLineOption((Collection)QStringList.of((String)"executable-location", (String[])new String[0]), "Directory containing QtJambiLauncher executable", "path");
                    applicationJVMArgOption = new QCommandLineOption((Collection)QStringList.of((String)"jvmarg", (String[])new String[0]), "JVM argument", "arg");
                    parser.addOptions(Arrays.asList(new QCommandLineOption[]{platformOption, configurationOption, applicationJNIMinVersionOption, applicationNameOption, applicationIcoOption, applicationMPOption, applicationLPOption, applicationMainClassOption, applicationAutodetectJvmOption, applicationJVMMinVersionOption, applicationJVMPathOption, applicationExeOption, applicationExeLocationOption, applicationJVMArgOption, dirOption, classPathOption}));
                    parser.addPositionalArgument("jvmargs", "Argument for Java Virtual Machine");
                    if (args.length == 1) {
                        parser.showHelp();
                    }
                    parser.process((Collection)new QStringList(args));
                    additionalArguments = new QStringList((Collection)parser.positionalArguments());
                    platform = null;
                    if (parser.isSet(platformOption)) {
                        platform = parser.value(platformOption);
                    }
                    appName = null;
                    if (parser.isSet(applicationNameOption)) {
                        appName = parser.value(applicationNameOption);
                    }
                    mainClass = null;
                    if (parser.isSet(applicationMainClassOption)) {
                        mainClass = parser.value(applicationMainClassOption);
                    }
                    jvmPath = null;
                    if (parser.isSet(applicationJVMPathOption)) {
                        jvmPath = parser.value(applicationJVMPathOption);
                    }
                    dir = null;
                    if (parser.isSet(dirOption)) {
                        dir = new QDir(QDir.fromNativeSeparators((String)parser.value(dirOption)));
                    }
                    ico = null;
                    if (parser.isSet(applicationIcoOption)) {
                        ico = new QFile(QDir.fromNativeSeparators((String)parser.value(applicationIcoOption)));
                        System.out.println("Setting application icon is deprecated.");
                    }
                    jniMinimumVersion = null;
                    if (parser.isSet(applicationJNIMinVersionOption)) {
                        jniMinimumVersion = Integer.parseInt(parser.value(applicationJNIMinVersionOption), 16);
                    }
                    classPaths = new ArrayList<String>();
                    if (parser.isSet(classPathOption)) {
                        classPaths.addAll(Arrays.asList(parser.value(classPathOption).split(File.pathSeparator)));
                    }
                    modulePaths = new ArrayList<String>();
                    if (parser.isSet(applicationMPOption)) {
                        modulePaths.addAll(Arrays.asList(parser.value(applicationMPOption).split(File.pathSeparator)));
                    }
                    libraryPaths = new ArrayList<String>();
                    if (parser.isSet(applicationLPOption)) {
                        libraryPaths.addAll(Arrays.asList(parser.value(applicationLPOption).split(File.pathSeparator)));
                    }
                    executables = new ArrayList<AbstractMap.SimpleEntry<Object, URL>>();
                    if (!parser.isSet(applicationExeOption)) break block148;
                    exeinfo = parser.value(applicationExeOption).split(File.pathSeparator);
                    if (exeinfo.length != 2) break block149;
                    exeFile = new File(exeinfo[1]);
                    if (!exeFile.isFile()) {
                        throw new Error("Specified launcher executable does not exist: " + exeinfo[1]);
                    }
                    executables.add(new AbstractMap.SimpleEntry<String, URL>(exeinfo[0], exeFile.toURI().toURL()));
                    break block150;
                }
                os = null;
                exeFile = new File(exeinfo[0]);
                if (exeinfo[0].endsWith(".exe")) {
                    os = "windows";
                    if (!exeFile.isFile()) {
                        throw new Error("Specified launcher executable does not exist: " + exeinfo[0]);
                    }
                } else if (exeinfo[0].endsWith(".app")) {
                    if (!exeFile.isDirectory()) {
                        throw new Error("Specified launcher executable does not exist: " + exeinfo[0]);
                    }
                    os = "macos";
                } else if (exeinfo[0].endsWith("_x86_64")) {
                    if (!exeFile.isDirectory()) {
                        throw new Error("Specified launcher executable does not exist: " + exeinfo[0]);
                    }
                    os = "android-x64";
                } else if (exeinfo[0].endsWith("_x86")) {
                    if (!exeFile.isDirectory()) {
                        throw new Error("Specified launcher executable does not exist: " + exeinfo[0]);
                    }
                    os = "android-x86";
                } else if (exeinfo[0].endsWith("_arm64-v8a")) {
                    if (!exeFile.isDirectory()) {
                        throw new Error("Specified launcher executable does not exist: " + exeinfo[0]);
                    }
                    os = "android-arm64";
                } else if (exeinfo[0].endsWith("_armeabi-v7a")) {
                    if (!exeFile.isDirectory()) {
                        throw new Error("Specified launcher executable does not exist: " + exeinfo[0]);
                    }
                    os = "android-arm";
                } else {
                    if (!exeFile.isFile()) {
                        throw new Error("Specified launcher executable does not exist: " + exeinfo[0]);
                    }
                    os = "linux";
                }
                if (os == null) break block150;
                executables.add(new AbstractMap.SimpleEntry<Object, URL>(os, exeFile.toURI().toURL()));
                break block150;
            }
            if (parser.isSet(applicationExeLocationOption)) {
                location = new QDir(parser.value(applicationExeLocationOption));
                for (String entry : location.entryList(new QDir.Filter[]{QDir.Filter.Files})) {
                    os = null;
                    if (entry.equals("QtJambiLauncher.exe")) {
                        os = "windows";
                    } else if (entry.equals("QtJambiLauncher.app")) {
                        os = "macos";
                    } else if (entry.equals("QtJambiLauncher_x86_64")) {
                        os = "android-x64";
                    } else if (entry.equals("QtJambiLauncher_x86")) {
                        os = "android-x86";
                    } else if (entry.equals("QtJambiLauncher_armeabi-v7a")) {
                        os = "android-arm";
                    } else if (entry.equals("QtJambiLauncher_arm64-v8a")) {
                        os = "android-arm64";
                    } else if (entry.equals("QtJambiLauncher")) {
                        os = "linux";
                    }
                    if (os == null || !entry.contains("QtJambiLauncher")) continue;
                    libFile = new File(location.absoluteFilePath(entry));
                    executables.add(new AbstractMap.SimpleEntry<String, URL>(os, libFile.toURI().toURL()));
                }
            }
        }
        autoDetect = parser.isSet(applicationAutodetectJvmOption);
        minimumJVMVersion = 11;
        if (parser.isSet(applicationJVMMinVersionOption)) {
            minimumJVMVersion = Integer.parseInt(parser.value(applicationJVMMinVersionOption));
        }
        arguments = new ArrayList<E>(additionalArguments);
        if (parser.isSet(applicationJVMArgOption)) {
            arguments.addAll(parser.values(applicationJVMArgOption));
        }
        if (appName == null || appName.isEmpty()) {
            throw new Error("Missing application name. Please use --application=...");
        }
        if (!autoDetect && (jvmPath == null || jvmPath.isEmpty())) {
            throw new Error("Missing JVM path. Please use --jvm-path=...");
        }
        if (dir == null) {
            throw new Error("Missing target directory. Please use --dir=...");
        }
        if (mainClass == null || mainClass.isEmpty()) {
            throw new Error("Missing main class. Please use --main-class=...");
        }
        if (executables.isEmpty()) {
            specsFound = Main.findSpecs();
            specsUrls = new HashSet<URL>();
            while (specsFound.hasMoreElements()) {
                url = specsFound.nextElement();
                if (specsUrls.contains(url)) continue;
                specsUrls.add(url);
                protocol = url.getProtocol();
                if (!protocol.equals("jar") || (end = (eform = url.toExternalForm()).indexOf("!/", start = 4)) == -1) continue;
                try {
                    inStream = url.openStream();
                    try {
                        factory = DocumentBuilderFactory.newInstance();
                        factory.setValidating(false);
                        builder = factory.newDocumentBuilder();
                        doc = builder.parse(inStream);
                    }
                    finally {
                        if (inStream != null) {
                            inStream.close();
                        }
                    }
                    system = doc.getDocumentElement().getAttribute("system");
                    for (i = 0; i < doc.getDocumentElement().getChildNodes().getLength(); ++i) {
                        child = doc.getDocumentElement().getChildNodes().item(i);
                        if (!(child instanceof Element) || !child.getNodeName().equals("library") && !child.getNodeName().equals("file") || !(library = (element = (Element)child).getAttribute("name")).endsWith("QtJambiLauncher") && !library.endsWith("QtJambiLauncher_debug") && !library.endsWith(".exe")) continue;
                        libraryURL = new URL(eform.substring(0, end + 2) + library);
                        executables.add(new AbstractMap.SimpleEntry<String, URL>(system, (URL)libraryURL));
                    }
                }
                catch (Exception e) {
                    Logger.getLogger("io.qt").log(Level.WARNING, "", e);
                }
            }
        }
        if (executables.isEmpty()) {
            throw new Error("Missing paths to QtJambiLauncher executables. Please use --executable=<path to executable>, --executable=<platform>" + File.pathSeparatorChar + "<path to executable> or --executable-location=<path>");
        }
        cborValue = new QCborMap();
        cborValue.setValue(Main.Parameters.JVMDetectionMode.value(), new QCborValue(autoDetect != false ? Main.JVMDetectionModes.AutoDetect.value() : Main.JVMDetectionModes.UseRelativePath.value()));
        if (autoDetect) {
            cborValue.setValue(Main.Parameters.MinimumJVM.value(), new QCborValue(minimumJVMVersion));
        } else {
            cborValue.setValue(Main.Parameters.JVMPath.value(), new QCborValue(jvmPath));
        }
        arrayFactory = (IntFunction<QCborValue[]>)LambdaMetafactory.metafactory(null, null, null, (I)Ljava/lang/Object;, lambda$generate$0(int ), (I)[Lio/qt/core/QCborValue;)();
        cborValue.setValue(Main.Parameters.MainClass.value(), new QCborValue(mainClass));
        argumentArray = new QCborArray((QCborValue[])arguments.stream().map((Function<String, QByteArray>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, <init>(java.lang.String ), (Ljava/lang/String;)Lio/qt/core/QByteArray;)()).map((Function<QByteArray, QCborValue>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, <init>(io.qt.core.QByteArray ), (Lio/qt/core/QByteArray;)Lio/qt/core/QCborValue;)()).toArray(arrayFactory));
        cborValue.setValue(Main.Parameters.JVMArguments.value(), new QCborValue(argumentArray));
        classPathArray = new QCborArray((QCborValue[])classPaths.stream().map((Function<String, QCborValue>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, <init>(java.lang.String ), (Ljava/lang/String;)Lio/qt/core/QCborValue;)()).toArray(arrayFactory));
        cborValue.setValue(Main.Parameters.ClassPath.value(), new QCborValue(classPathArray));
        modulePathArray = new QCborArray((QCborValue[])modulePaths.stream().map((Function<String, QCborValue>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, <init>(java.lang.String ), (Ljava/lang/String;)Lio/qt/core/QCborValue;)()).toArray(arrayFactory));
        cborValue.setValue(Main.Parameters.ModulePath.value(), new QCborValue(modulePathArray));
        libraryPathArray = new QCborArray((QCborValue[])libraryPaths.stream().map((Function<String, QCborValue>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, <init>(java.lang.String ), (Ljava/lang/String;)Lio/qt/core/QCborValue;)()).toArray(arrayFactory));
        cborValue.setValue(Main.Parameters.LibraryPath.value(), new QCborValue(libraryPathArray));
        if (jniMinimumVersion != null) {
            cborValue.setValue(Main.Parameters.JNIMinimumVersion.value(), new QCborValue(jniMinimumVersion.intValue()));
        }
        if ((cborData = cborValue.toCborValue().toCbor()).size() > 16384L) {
            throw new Error("Launcher metadata exceeds maximum size of 16384 byte.");
        }
        System.gc();
        QTJAMBI_LAUNCHER = new QByteArray("QTJAMBI_LAUNCHER!");
        block74: for (Map.Entry entry : executables) {
            os = (String)entry.getKey();
            if (os == null || platform != null && !platform.startsWith(os)) continue;
            file = (URL)entry.getValue();
            libraryURL = os.toLowerCase();
            var47_57 = -1;
            switch (libraryURL.hashCode()) {
                case 102977780: {
                    if (!libraryURL.equals("linux")) break;
                    var47_57 = 0;
                    break;
                }
                case 177400403: {
                    if (!libraryURL.equals("linux32")) break;
                    var47_57 = 1;
                    break;
                }
                case 177400498: {
                    if (!libraryURL.equals("linux64")) break;
                    var47_57 = 2;
                    break;
                }
                case -1317034493: {
                    if (!libraryURL.equals("linux-arm")) break;
                    var47_57 = 3;
                    break;
                }
                case 1345206178: {
                    if (!libraryURL.equals("linux-arm32")) break;
                    var47_57 = 4;
                    break;
                }
                case 1345206273: {
                    if (!libraryURL.equals("linux-arm64")) break;
                    var47_57 = 5;
                    break;
                }
                case -522613412: {
                    if (!libraryURL.equals("linux-aarch64")) break;
                    var47_57 = 6;
                    break;
                }
                case -1317014243: {
                    if (!libraryURL.equals("linux-x86")) break;
                    var47_57 = 7;
                    break;
                }
                case -1317014307: {
                    if (!libraryURL.equals("linux-x64")) break;
                    var47_57 = 8;
                    break;
                }
                case 936334846: {
                    if (!libraryURL.equals("android-arm")) break;
                    var47_57 = 9;
                    break;
                }
                case -2125343523: {
                    if (!libraryURL.equals("android-arm32")) break;
                    var47_57 = 10;
                    break;
                }
                case -2125343428: {
                    if (!libraryURL.equals("android-arm64")) break;
                    var47_57 = 11;
                    break;
                }
                case 1468712919: {
                    if (!libraryURL.equals("android-aarch64")) break;
                    var47_57 = 12;
                    break;
                }
                case 936355096: {
                    if (!libraryURL.equals("android-x86")) break;
                    var47_57 = 13;
                    break;
                }
                case 936355032: {
                    if (!libraryURL.equals("android-x64")) break;
                    var47_57 = 14;
                    break;
                }
                case 113134395: {
                    if (!libraryURL.equals("win32")) break;
                    var47_57 = 15;
                    break;
                }
                case 113134490: {
                    if (!libraryURL.equals("win64")) break;
                    var47_57 = 16;
                    break;
                }
                case 1349493379: {
                    if (!libraryURL.equals("windows")) break;
                    var47_57 = 17;
                    break;
                }
                case 1931122706: {
                    if (!libraryURL.equals("windows-arm")) break;
                    var47_57 = 18;
                    break;
                }
                case 383050225: {
                    if (!libraryURL.equals("windows-arm32")) break;
                    var47_57 = 19;
                    break;
                }
                case -1736515605: {
                    if (!libraryURL.equals("windows-aarch64")) break;
                    var47_57 = 20;
                    break;
                }
                case 383050320: {
                    if (!libraryURL.equals("windows-arm64")) break;
                    var47_57 = 21;
                    break;
                }
                case 1931142956: {
                    if (!libraryURL.equals("windows-x86")) break;
                    var47_57 = 22;
                    break;
                }
                case 1931142892: {
                    if (!libraryURL.equals("windows-x64")) break;
                    var47_57 = 23;
                    break;
                }
                case 103652211: {
                    if (!libraryURL.equals("macos")) break;
                    var47_57 = 24;
                    break;
                }
                case 110356: {
                    if (!libraryURL.equals("osx")) break;
                    var47_57 = 25;
                }
            }
            switch (var47_57) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    newFile = new QFile(dir.absoluteFilePath(appName));
                    break;
                }
                case 9: 
                case 10: {
                    newFile = new QFile(dir.absoluteFilePath(appName + "_armeabi-v7a"));
                    break;
                }
                case 11: 
                case 12: {
                    newFile = new QFile(dir.absoluteFilePath(appName + "_arm64-v8a"));
                    break;
                }
                case 13: {
                    newFile = new QFile(dir.absoluteFilePath(appName + "_x86"));
                    break;
                }
                case 14: {
                    newFile = new QFile(dir.absoluteFilePath(appName + "_x86_64"));
                    break;
                }
                case 15: 
                case 16: 
                case 17: 
                case 18: 
                case 19: 
                case 20: 
                case 21: 
                case 22: 
                case 23: {
                    newFile = new QFile(dir.absoluteFilePath(appName + ".exe"));
                    System.gc();
                    break;
                }
                case 24: 
                case 25: {
                    fileBase = file.toExternalForm();
                    if (fileBase.endsWith("/")) {
                        fileBase = fileBase.substring(0, fileBase.length() - 1);
                    }
                    if ((idx = (baseName = fileBase).lastIndexOf(47)) > 0) {
                        baseName = baseName.substring(idx + 1);
                    }
                    if (baseName.endsWith(".app")) {
                        baseName = baseName.substring(0, baseName.length() - 4);
                    }
                    dir.mkpath(appName + ".app/Contents/MacOS");
                    dir.mkpath(appName + ".app/Contents/Resources");
                    try {
                        infoPListUrl = new URL(fileBase + "/Contents/Info.plist");
                        device = QIODevice.fromInputStream((InputStream)infoPListUrl.openStream());
                        data = device.readAll();
                        device.close();
                        idx = (int)data.indexOf("<key>CFBundleIdentifier</key>");
                        if (idx > 0 && (idx = (int)data.indexOf("<string>", (long)idx)) > 0 && (idxEnd = (int)data.indexOf("</string>", (long)(idx += 8))) > idx) {
                            data = data.remove((long)idx, (long)(idxEnd - idx));
                            data.insert((long)idx, mainClass);
                        }
                        data = data.replace(baseName, appName);
                        data = data.replace("QtJambiLauncher", appName);
                        infoPList = new QFile(dir.absoluteFilePath(appName + ".app/Contents/Info.plist"));
                        infoPList.remove();
                        if (infoPList.open(new QIODeviceBase.OpenModeFlag[]{QIODeviceBase.OpenModeFlag.WriteOnly})) {
                            infoPList.write(data);
                            infoPList.close();
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    try {
                        pkgInfoUrl = new URL(fileBase + "/Contents/PkgInfo");
                        device = QIODevice.fromInputStream((InputStream)pkgInfoUrl.openStream());
                        data = device.readAll();
                        device.close();
                        dir.mkpath(appName + ".app/Contents");
                        pkgInfo = new QFile(dir.absoluteFilePath(appName + ".app/Contents/PkgInfo"));
                        pkgInfo.remove();
                        if (pkgInfo.open(new QIODeviceBase.OpenModeFlag[]{QIODeviceBase.OpenModeFlag.WriteOnly})) {
                            pkgInfo.write(data);
                            pkgInfo.close();
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    try {
                        emptylprojUrl = new URL(fileBase + "/Contents/Resources/empty.lproj");
                        device = QIODevice.fromInputStream((InputStream)emptylprojUrl.openStream());
                        data = device.readAll();
                        device.close();
                        dir.mkpath(appName + ".app/Contents/Resources");
                        emptylproj = new QFile(dir.absoluteFilePath(appName + ".app/Contents/Resources/empty.lproj"));
                        emptylproj.remove();
                        if (emptylproj.open(new QIODeviceBase.OpenModeFlag[]{QIODeviceBase.OpenModeFlag.WriteOnly})) {
                            emptylproj.write(data);
                            emptylproj.close();
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    try {
                        executableUrl = new URL(fileBase + "/Contents/MacOS/" + baseName);
                        device = QIODevice.fromInputStream((InputStream)executableUrl.openStream());
                        data = device.readAll();
                        device.close();
                        dir.mkpath(appName + ".app/Contents/MacOS");
                        executable = new QFile(dir.absoluteFilePath(appName + ".app/Contents/MacOS/" + appName));
                        executable.remove();
                        if (executable.open(new QIODeviceBase.OpenModeFlag[]{QIODeviceBase.OpenModeFlag.WriteOnly})) {
                            executable.write(data);
                            executable.close();
                            executable.setPermissions(executable.permissions().combined(QFileDevice.Permission.ExeGroup).combined(QFileDevice.Permission.ExeOther).combined(QFileDevice.Permission.ExeOwner).combined(QFileDevice.Permission.ExeUser));
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    dir.mkpath(appName + ".app/Contents/Resources");
                    params = new QFile(dir.absoluteFilePath(appName + ".app/Contents/Resources/params.cbor"));
                    params.remove();
                    if (!params.open(new QIODeviceBase.OpenModeFlag[]{QIODeviceBase.OpenModeFlag.WriteOnly})) continue block74;
                    params.write(cborData);
                    params.close();
                    continue block74;
                }
                default: {
                    continue block74;
                }
            }
            try {
                device = QIODevice.fromInputStream((InputStream)file.openStream());
                exeData = device.readAll();
                device.close();
                idx = (int)exeData.indexOf(QTJAMBI_LAUNCHER);
                if (idx > 0) {
                    newFile.remove();
                    if (newFile.open(new QIODeviceBase.OpenModeFlag[]{QIODeviceBase.OpenModeFlag.WriteOnly})) {
                        try {
                            newFile.write(exeData);
                            while (idx > 0) {
                                newFile.seek((long)idx);
                                newFile.write(cborData);
                                idx = (int)exeData.indexOf(QTJAMBI_LAUNCHER, (long)idx + cborData.length());
                            }
                            var49_61 = os.toLowerCase();
                            var50_68 = -1;
                            switch (var49_61.hashCode()) {
                                case 113134395: {
                                    if (!var49_61.equals("win32")) break;
                                    var50_68 = 0;
                                    break;
                                }
                                case 113134490: {
                                    if (!var49_61.equals("win64")) break;
                                    var50_68 = 1;
                                    break;
                                }
                                case 1349493379: {
                                    if (!var49_61.equals("windows")) break;
                                    var50_68 = 2;
                                    break;
                                }
                                case 1931122706: {
                                    if (!var49_61.equals("windows-arm")) break;
                                    var50_68 = 3;
                                    break;
                                }
                                case 383050225: {
                                    if (!var49_61.equals("windows-arm32")) break;
                                    var50_68 = 4;
                                    break;
                                }
                                case -1736515605: {
                                    if (!var49_61.equals("windows-aarch64")) break;
                                    var50_68 = 5;
                                    break;
                                }
                                case 382892716: {
                                    if (!var49_61.equals("windows-amd64")) break;
                                    var50_68 = 6;
                                    break;
                                }
                                case 1931142892: {
                                    if (!var49_61.equals("windows-x64")) break;
                                    var50_68 = 7;
                                    break;
                                }
                                case 1931142956: {
                                    if (!var49_61.equals("windows-x86")) break;
                                    var50_68 = 8;
                                }
                            }
                            switch (var50_68) {
                                case 0: 
                                case 1: 
                                case 2: 
                                case 3: 
                                case 4: 
                                case 5: 
                                case 6: 
                                case 7: 
                                case 8: {
                                    idx = (int)exeData.indexOf(new QByteArray("QTJAMBI_ICO!"));
                                    if (idx > 254 && ico != null && ico.open(new QIODeviceBase.OpenModeFlag[]{QIODeviceBase.OpenModeFlag.ReadOnly})) {
                                        icoData = ico.readAll();
                                        if (icoData.size() >= 92482L) {
                                            throw new Error("Icon size too big.");
                                        }
                                        newFile.seek((long)(idx - 254));
                                        newFile.write(icoData);
                                        ** break;
                                    }
lbl508:
                                    // 3 sources

                                    break;
                                }
                                ** default:
lbl510:
                                // 1 sources

                                break;
                            }
                        }
                        finally {
                            newFile.close();
                        }
                        newFile.setPermissions(newFile.permissions().combined(QFileDevice.Permission.ExeGroup).combined(QFileDevice.Permission.ExeOther).combined(QFileDevice.Permission.ExeOwner).combined(QFileDevice.Permission.ExeUser));
                        continue;
                    }
                    throw new Error("Unable to write file " + newFile.fileName());
                }
                throw new Error("Unable to find \"" + QTJAMBI_LAUNCHER + "\" in file " + file.toExternalForm());
            }
            catch (IOException e) {
                throw new Error("Unable to read file " + file.toExternalForm(), e);
            }
        }
    }

    private static /* synthetic */ QCborValue[] lambda$generate$0(int x$0) {
        return new QCborValue[x$0];
    }
}

