/*
 * Decompiled with CFR 0.152.
 */
package io.qt.qtjambi.deployer;

import io.qt.core.QCommandLineOption;
import io.qt.core.QCommandLineParser;
import io.qt.core.QDir;
import io.qt.core.QList;
import io.qt.core.QStringList;
import io.qt.qtjambi.deployer.Main;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

class QMLGenerator {
    QMLGenerator() {
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static void generate(QCommandLineParser parser, String[] args, QCommandLineOption dirOption, QCommandLineOption classPathOption, QCommandLineOption configurationOption) throws InterruptedException, IOException {
        QCommandLineOption qmlTargetOption = new QCommandLineOption((Collection)QList.of((String)"library", (String[])new String[0]), "Java library for qml.", "jar");
        QCommandLineOption qmlLibraryOption = new QCommandLineOption((Collection)QList.of((String)"jarimport", (String[])new String[0]), "Path to jarimport library.\nExamples:\n--jarimport=path" + File.separator + "jarimport.dll\n--jarimport=macos" + File.pathSeparator + "path" + File.separator + "jarimport.dylib", "file");
        QCommandLineOption qmlLibraryLocationOption = new QCommandLineOption((Collection)QList.of((String)"jarimport-location", (String[])new String[0]), "Directory containing jarimport library", "path");
        QCommandLineOption qmlNativeLibraryPathOption = new QCommandLineOption((Collection)QList.of((String)"native-library-path", (String[])new String[0]), "Native library path", "path");
        parser.addOptions((Collection)QList.of((Object)configurationOption, (Object[])new QCommandLineOption[]{qmlTargetOption, qmlLibraryOption, qmlLibraryLocationOption, qmlNativeLibraryPathOption, dirOption, classPathOption}));
        if (args.length == 1) {
            parser.showHelp();
        }
        parser.process((Collection)new QStringList(args));
        QStringList unusedArguments = new QStringList((Collection)parser.positionalArguments());
        if (unusedArguments.size() == 1) {
            throw new Error("QML import library generation, illegal argument: " + unusedArguments.join(", "));
        }
        if (unusedArguments.size() > 1) {
            throw new Error("QML import library generation, illegal argument: " + unusedArguments.join(", "));
        }
        File library = null;
        if (parser.isSet(qmlTargetOption)) {
            library = new File(parser.value(qmlTargetOption));
        }
        ArrayList<String> classPaths = new ArrayList<String>();
        if (parser.isSet(classPathOption)) {
            classPaths.addAll(Arrays.asList(parser.value(classPathOption).split(File.pathSeparator)));
        }
        ArrayList natives = new ArrayList();
        if (parser.isSet(qmlNativeLibraryPathOption)) {
            classPaths.addAll(Arrays.asList(parser.value(qmlNativeLibraryPathOption).split(File.pathSeparator)));
        }
        File dir = null;
        if (parser.isSet(dirOption)) {
            dir = new File(parser.value(dirOption));
        }
        Boolean isDebug = null;
        if (parser.isSet(configurationOption)) {
            isDebug = "debug".equals(parser.value(configurationOption));
        }
        ArrayList<AbstractMap.SimpleEntry<Object, URL>> libraries = new ArrayList<AbstractMap.SimpleEntry<Object, URL>>();
        if (parser.isSet(qmlLibraryOption)) {
            String[] libinfo = parser.value(qmlLibraryOption).split(File.pathSeparator);
            if (libinfo.length == 2) {
                File libFile = new File(libinfo[1]);
                if (!libFile.isFile()) {
                    throw new Error("Specified jarimport library does not exist: " + libinfo[1]);
                }
                libraries.add(new AbstractMap.SimpleEntry<String, URL>(libinfo[0], libFile.toURI().toURL()));
            } else {
                Object os = null;
                if (libinfo[0].endsWith(".dll")) {
                    os = "windows";
                } else if (libinfo[0].endsWith(".dylib")) {
                    os = "macos";
                } else if (libinfo[0].endsWith(".so")) {
                    os = "linux";
                }
                if (os == null) throw new Error("Unable to determine platform for library " + libinfo[0] + ". Please use --jarimport=<platform>" + File.pathSeparatorChar + "<path to jarimport library>");
                File libFile = new File(libinfo[0]);
                if (!libFile.isFile()) {
                    throw new Error("Specified jarimport library does not exist: " + libinfo[0]);
                }
                libraries.add(new AbstractMap.SimpleEntry<Object, URL>(os, libFile.toURI().toURL()));
            }
        } else if (parser.isSet(qmlLibraryLocationOption)) {
            QDir location = new QDir(parser.value(qmlLibraryLocationOption));
            if (isDebug == null) {
                throw new Error("Please specify --configuration=debug or --configuration=release prior to --jarimport-location");
            }
            for (String entry : location.entryList(new QDir.Filter[]{QDir.Filter.Files})) {
                void var19_22;
                Object var19_23 = null;
                if (isDebug.booleanValue()) {
                    if (entry.equals("jarimportd.dll")) {
                        String string = "windows";
                    } else if (entry.equals("libjarimport_debug.dylib") || entry.equals("libjarimport.dylib")) {
                        String string = "macos";
                    } else if (entry.equals("libjarimport_debug.so") || entry.equals("libjarimport.so")) {
                        String string = "linux";
                    }
                } else if (entry.equals("jarimport.dll")) {
                    String string = "windows";
                } else if (entry.equals("libjarimport.dylib")) {
                    String string = "macos";
                } else if (entry.equals("libjarimport.so")) {
                    String string = "linux";
                }
                if (var19_22 == null || !entry.contains("jarimport")) continue;
                File libFile = new File(location.absoluteFilePath(entry));
                libraries.add(new AbstractMap.SimpleEntry<void, URL>(var19_22, libFile.toURI().toURL()));
            }
        }
        if (library == null) {
            throw new Error("Missing qml library. Please use --library=...");
        }
        if (!library.isFile() || !library.getName().endsWith(".jar")) {
            throw new Error("Qml library is not a jar file.");
        }
        if (dir == null) {
            throw new Error("Missing target directory. Please use --dir=...");
        }
        if (dir.isFile()) {
            throw new Error("File not allowed as target directory. Please specify a directory --dir=...");
        }
        if (libraries.isEmpty()) {
            Enumeration<URL> specsFound = Main.findSpecs();
            HashSet<URL> specsUrls = new HashSet<URL>();
            while (specsFound.hasMoreElements()) {
                int start;
                String eform;
                int end;
                URL url = specsFound.nextElement();
                if (specsUrls.contains(url)) continue;
                specsUrls.add(url);
                String string = url.getProtocol();
                if (!string.equals("jar") || (end = (eform = url.toExternalForm()).indexOf("!/", start = 4)) == -1) continue;
                try {
                    Document doc;
                    try (InputStream inStream = url.openStream();){
                        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                        factory.setValidating(false);
                        DocumentBuilder builder = factory.newDocumentBuilder();
                        doc = builder.parse(inStream);
                    }
                    String system = doc.getDocumentElement().getAttribute("system");
                    String configuration = doc.getDocumentElement().getAttribute("configuration");
                    if (isDebug != null && isDebug.booleanValue() != "debug".equals(configuration)) continue;
                    for (int i = 0; i < doc.getDocumentElement().getChildNodes().getLength(); ++i) {
                        Element element;
                        String libraryName;
                        Node child = doc.getDocumentElement().getChildNodes().item(i);
                        if (!(child instanceof Element) || !child.getNodeName().equals("library") || !(libraryName = (element = (Element)child).getAttribute("name")).contains("jarimport")) continue;
                        URL libraryURL = new URL(eform.substring(0, end + 2) + libraryName);
                        libraries.add(new AbstractMap.SimpleEntry<String, URL>(system, libraryURL));
                    }
                }
                catch (Exception e) {
                    Logger.getLogger("io.qt").log(Level.WARNING, "", e);
                }
            }
        }
        if (libraries.isEmpty()) {
            throw new Error("Missing paths to jarimport library. Please use --jarimport=<path to jarimport library>, --jarimport=<platform>" + File.pathSeparatorChar + "<path to jarimport library> or --jarimport-location=<path> in combination with --configuration=debug/release");
        }
        String packageName = null;
        try (JarFile jarFile = new JarFile(library);){
            Enumeration<JarEntry> enries = jarFile.entries();
            while (enries.hasMoreElements()) {
                int idx;
                JarEntry jarEntry = enries.nextElement();
                if (jarEntry.isDirectory() || !jarEntry.getName().endsWith(".class") || (idx = jarEntry.getName().lastIndexOf(47)) < 0) continue;
                packageName = packageName.substring((packageName = jarEntry.getName()).startsWith("/") ? 1 : 0, idx);
                break;
            }
        }
        catch (IOException e) {
            throw new Error("Unable to read jar file.", e);
        }
        if (packageName == null) {
            throw new Error(String.format("Unable to detect package in jar file %1$s.", library.getName()));
        }
        dir = new File(dir, packageName.replace('/', File.separatorChar));
        dir.mkdirs();
        if (!dir.isDirectory()) throw new Error(String.format("Unable to create directory %1$s.", dir.getAbsolutePath()));
        boolean found = false;
        block59: for (Map.Entry entry : libraries) {
            String os = (String)entry.getKey();
            if (os != null) {
                File newFile;
                switch (os.toLowerCase()) {
                    case "win32": 
                    case "win64": 
                    case "windows": 
                    case "windows-aarch64": 
                    case "windows-arm64": 
                    case "windows-x86": 
                    case "windows-x64": {
                        newFile = isDebug == null ? new File(dir, "jarimport" + (((URL)entry.getValue()).toExternalForm().endsWith("d.dll") ? "d.dll" : ".dll")) : new File(dir, "jarimport" + (isDebug != false ? "d.dll" : ".dll"));
                        System.gc();
                        break;
                    }
                    case "macos": 
                    case "osx": {
                        newFile = new File(dir, "libjarimport.dylib");
                        break;
                    }
                    case "linux": 
                    case "linux32": 
                    case "linux64": 
                    case "linux-arm64": 
                    case "linux-aarch64": 
                    case "linux-x86": 
                    case "linux-x64": {
                        newFile = new File(dir, "libjarimport.so");
                        break;
                    }
                    default: {
                        continue block59;
                    }
                }
                try (InputStream in = ((URL)entry.getValue()).openStream();){
                    Files.copy(in, newFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
                    found = true;
                }
                catch (IOException e) {
                    throw new Error("Unable to write file " + newFile, e);
                }
            }
            if (!found) continue;
            try {
                Files.copy(library.toPath(), new File(dir, library.getName()).toPath(), StandardCopyOption.REPLACE_EXISTING);
            }
            catch (IOException e) {
                throw new Error("Unable to write file " + new File(dir, library.getName()), e);
            }
            if (!classPaths.isEmpty()) {
                for (String cp : classPaths) {
                    File jar;
                    if (!cp.endsWith(".jar") || !(jar = new File(cp)).exists()) continue;
                    try {
                        Files.copy(jar.toPath(), new File(dir, jar.getName()).toPath(), StandardCopyOption.REPLACE_EXISTING);
                    }
                    catch (IOException e) {
                        throw new Error("Unable to write file " + new File(dir, jar.getName()), e);
                    }
                }
            }
            try (PrintWriter writer = new PrintWriter(new File(dir, "qmldir"));){
                writer.print("module ");
                writer.println(packageName.replace('/', '.'));
                writer.println("plugin jarimport");
                if (natives.isEmpty()) continue;
                writer.print("librarypath ");
                writer.println(new QStringList(natives).join(","));
            }
            catch (IOException e) {
                throw new Error("Unable to write file " + new File(dir, "qmldir"), e);
            }
        }
    }
}

