/*
 * Decompiled with CFR 0.152.
 */
package io.qt.qtjambi.deployer;

import io.qt.core.QByteArray;
import io.qt.core.QCborMap;
import io.qt.core.QCborValue;
import io.qt.core.QCommandLineOption;
import io.qt.core.QCommandLineParser;
import io.qt.core.QDir;
import io.qt.core.QFile;
import io.qt.core.QIODevice;
import io.qt.core.QIODeviceBase;
import io.qt.core.QJsonDocument;
import io.qt.core.QJsonObject;
import io.qt.core.QJsonParseError;
import io.qt.core.QList;
import io.qt.core.QStringList;
import io.qt.core.QTextStream;
import io.qt.internal.QtJambiPlugins;
import io.qt.qtjambi.deployer.Main;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

class PluginGenerator {
    PluginGenerator() {
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static void generate(QCommandLineParser parser, String[] args, QCommandLineOption dirOption, QCommandLineOption classPathOption, QCommandLineOption configurationOption) throws InterruptedException, IOException {
        File subdir;
        File file;
        String string;
        QCommandLineOption pluginIIDOption = new QCommandLineOption((Collection)QList.of((String)"iid", (String[])new String[0]), "Plugin IID", "iid");
        QCommandLineOption pluginClassNameOption = new QCommandLineOption((Collection)QList.of((String)"class-name", (String[])new String[0]), "Class name", "name");
        QCommandLineOption pluginNameOption = new QCommandLineOption((Collection)QList.of((String)"plugin-name", (String[])new String[0]), "Plugin name", "name");
        QCommandLineOption pluginLibraryOption = new QCommandLineOption((Collection)QList.of((String)"plugin-library", (String[])new String[0]), "Path to qtjambiplugin library.\nExamples:\n--plugin-library=path" + File.separator + "qtjambiplugin.dll\n--plugin-library=macos" + File.pathSeparator + "path" + File.separator + "qtjambiplugin.dylib", "file");
        QCommandLineOption pluginLibraryLocationOption = new QCommandLineOption((Collection)QList.of((String)"plugin-library-location", (String[])new String[0]), "Directory containing qtjambiplugin library", "path");
        QCommandLineOption pluginMetaDataOption = new QCommandLineOption((Collection)QList.of((String)"meta-data", (String[])new String[0]), "Plugin meta data as json code or path to existing json file.", "json|file");
        QCommandLineOption pluginSourceOption = new QCommandLineOption((Collection)QList.of((String)"source", (String[])new String[0]), "Generate C++ source project");
        parser.addOptions((Collection)QList.of((Object)pluginIIDOption, (Object[])new QCommandLineOption[]{configurationOption, pluginClassNameOption, pluginNameOption, pluginLibraryOption, pluginLibraryLocationOption, pluginMetaDataOption, pluginSourceOption, dirOption, classPathOption}));
        if (args.length == 1) {
            parser.showHelp();
        }
        parser.process((Collection)new QStringList(args));
        QStringList unusedArguments = new QStringList((Collection)parser.positionalArguments());
        if (unusedArguments.size() == 1) {
            throw new Error("Qt plugin generation, illegal argument: " + unusedArguments.join(", "));
        }
        if (unusedArguments.size() > 1) {
            throw new Error("Qt plugin generation, illegal argument: " + unusedArguments.join(", "));
        }
        String iid = null;
        if (parser.isSet(pluginIIDOption)) {
            iid = parser.value(pluginIIDOption);
        }
        String className = null;
        if (parser.isSet(pluginClassNameOption)) {
            className = parser.value(pluginClassNameOption);
        }
        String pluginName = null;
        if (parser.isSet(pluginNameOption)) {
            pluginName = parser.value(pluginNameOption);
        }
        File dir = null;
        if (!parser.isSet(dirOption)) {
            throw new Error("Missing target directory. Please use --dir=...");
        }
        dir = new File(parser.value(dirOption));
        QJsonObject metaData = null;
        if (parser.isSet(pluginMetaDataOption)) {
            File file2;
            QByteArray data;
            String _metaData = parser.value(pluginMetaDataOption);
            if (_metaData.startsWith("\"") && _metaData.endsWith("\"")) {
                _metaData = _metaData.substring(1, _metaData.length() - 2);
            }
            if ((data = _metaData.startsWith("{") && _metaData.endsWith("}") ? new QByteArray(_metaData.replace("''", "\"")) : ((file2 = new File(_metaData)).exists() ? new QByteArray(Files.readAllBytes(file2.toPath())) : null)) != null) {
                QJsonDocument.FromJsonResult result = QJsonDocument.fromJson((QByteArray)data);
                if (result.error.error() == QJsonParseError.ParseError.NoError && result.document.isObject()) {
                    metaData = result.document.object();
                }
            }
        }
        Boolean isDebug = null;
        if (parser.isSet(configurationOption)) {
            isDebug = "debug".equals(parser.value(configurationOption));
        }
        ArrayList classPath = new ArrayList();
        if (parser.isSet(classPathOption)) {
            Collections.addAll(classPath, parser.value(classPathOption).split(File.pathSeparator));
        }
        if (classPath.isEmpty()) {
            throw new Error("Missing classpath. Please use --class-path=...");
        }
        ArrayList<AbstractMap.SimpleEntry<Object, URL>> libraries = new ArrayList<AbstractMap.SimpleEntry<Object, URL>>();
        boolean generateSource = parser.isSet(pluginSourceOption);
        if (parser.isSet(pluginLibraryOption)) {
            String[] libinfo = parser.value(pluginLibraryOption).split(File.pathSeparator);
            if (libinfo.length == 2) {
                File file3 = new File(libinfo[1]);
                if (!file3.isFile()) {
                    throw new Error("Specified qtjambiplugin library does not exist: " + libinfo[1]);
                }
                libraries.add(new AbstractMap.SimpleEntry<String, URL>(libinfo[0], file3.toURI().toURL()));
            } else {
                void var23_28;
                Object var23_24 = null;
                if (libinfo[0].endsWith(".dll")) {
                    String string2 = "windows";
                } else if (libinfo[0].endsWith(".dylib")) {
                    String string3 = "macos";
                } else if (libinfo[0].endsWith(".so")) {
                    String string4 = "linux";
                }
                if (var23_28 == null) throw new Error("Unable to determine platform for library " + libinfo[0] + ". Please use --plugin-library=<platform>" + File.pathSeparatorChar + "<path to library>");
                File libFile = new File(libinfo[0]);
                if (!libFile.isFile()) {
                    throw new Error("Specified qtjambiplugin library does not exist: " + libinfo[0]);
                }
                libraries.add(new AbstractMap.SimpleEntry<void, URL>(var23_28, libFile.toURI().toURL()));
            }
        } else if (parser.isSet(pluginLibraryLocationOption)) {
            File location = new File(parser.value(pluginLibraryLocationOption));
            if (isDebug == null) {
                throw new Error("Please specify --configuration=debug or --configuration=release prior to --plugin-library-location");
            }
            if (location.isDirectory()) {
                for (File file4 : location.listFiles()) {
                    if (!file4.isFile()) continue;
                    String os = null;
                    if (isDebug.booleanValue()) {
                        if (file4.getName().equals("qtjambiplugind.dll")) {
                            os = "windows";
                        } else if (file4.getName().equals("libqtjambiplugin_debug.dylib")) {
                            os = "macos";
                        } else if (file4.getName().equals("libqtjambiplugin_debug.so")) {
                            os = "linux";
                        }
                    } else if (file4.getName().equals("qtjambiplugin.dll")) {
                        os = "windows";
                    } else if (file4.getName().equals("libqtjambiplugin.dylib")) {
                        os = "macos";
                    } else if (file4.getName().equals("libqtjambiplugin.so")) {
                        os = "linux";
                    }
                    if (os == null || !file4.getName().contains("qtjambiplugin")) continue;
                    libraries.add(new AbstractMap.SimpleEntry<String, URL>(os, file4.toURI().toURL()));
                }
            }
        }
        if (className == null || metaData == null || pluginName == null) {
            try (JarFile jarFile = new JarFile(new File((String)classPath.get(0)));){
                String _metaData;
                Attributes attributes = jarFile.getManifest().getMainAttributes();
                if (metaData == null && (_metaData = attributes.getValue("QtJambi-Plugin-Metadata")) != null) {
                    QByteArray data = new QByteArray(_metaData.replace("''", "\""));
                    QJsonDocument.FromJsonResult fromJsonResult = QJsonDocument.fromJson((QByteArray)data);
                    if (fromJsonResult.error.error() == QJsonParseError.ParseError.NoError && fromJsonResult.document.isObject()) {
                        metaData = fromJsonResult.document.object();
                    }
                }
                if (className == null) {
                    className = attributes.getValue("QtJambi-Plugin-Class");
                }
                if (pluginName == null) {
                    pluginName = attributes.getValue("QtJambi-Plugin-Name");
                }
            }
        }
        if (className == null || className.isEmpty()) {
            throw new Error("Missing class name. Please use --class-name=...");
        }
        if (metaData == null) {
            throw new Error("Missing metadata. Please use --meta-data=...");
        }
        if (libraries.isEmpty() && !generateSource) {
            Enumeration<URL> specsFound = Main.findSpecs();
            HashSet<Object> hashSet = new HashSet<Object>();
            while (specsFound.hasMoreElements()) {
                int start;
                String string5;
                int end;
                URL url = specsFound.nextElement();
                if (hashSet.contains(url)) continue;
                hashSet.add(url);
                String protocol = url.getProtocol();
                if (!protocol.equals("jar") || (end = (string5 = url.toExternalForm()).indexOf("!/", start = 4)) == -1) continue;
                try {
                    Document doc;
                    try (InputStream inStream = url.openStream();){
                        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                        factory.setValidating(false);
                        DocumentBuilder builder = factory.newDocumentBuilder();
                        doc = builder.parse(inStream);
                    }
                    String system = doc.getDocumentElement().getAttribute("system");
                    String configuration = doc.getDocumentElement().getAttribute("configuration");
                    if (isDebug != null && isDebug.booleanValue() != "debug".equals(configuration)) continue;
                    for (int i = 0; i < doc.getDocumentElement().getChildNodes().getLength(); ++i) {
                        Element element;
                        String library;
                        Node child = doc.getDocumentElement().getChildNodes().item(i);
                        if (!(child instanceof Element) || !child.getNodeName().equals("library") || !(library = (element = (Element)child).getAttribute("name")).contains("qtjambiplugin")) continue;
                        URL libraryURL = new URL(string5.substring(0, end + 2) + library);
                        libraries.add(new AbstractMap.SimpleEntry<String, URL>(system, libraryURL));
                    }
                }
                catch (Exception e) {
                    Logger.getLogger("io.qt").log(Level.WARNING, "", e);
                }
            }
            if (libraries.isEmpty()) {
                throw new Error("Missing paths to qtjambiplugin library. Please use --plugin-library=<path to library>, --plugin-library=<platform>" + File.pathSeparatorChar + "<path to library> or --plugin-library-location=<path> in combination with --configuration=debug/release");
            }
        }
        if (pluginName == null && classPath.size() == 1 && (string = (file = new File((String)classPath.get(0))).getName()).endsWith(".jar")) {
            pluginName = string.substring(0, string.length() - 4);
        }
        if (pluginName == null) {
            throw new Error("Missing plugin name. Please use --plugin-name=...");
        }
        if (iid == null) {
            void var26_66;
            ArrayList<URL> urls = new ArrayList<URL>();
            ArrayList<File> arrayList = new ArrayList<File>();
            for (String path : classPath) {
                File file5 = new File(path);
                if (!file5.exists()) throw new Error("Classpath not a file or directory: " + path);
                if (file5.isFile() && !file5.getName().endsWith(".jar")) {
                    arrayList.add(file5.getParentFile());
                    continue;
                }
                urls.add(file5.toURI().toURL());
            }
            StringBuilder lp = new StringBuilder(System.getProperty("java.library.path", ""));
            if (!arrayList.isEmpty()) {
                for (File file6 : arrayList) {
                    if (lp.length() != 0) {
                        lp.append(File.pathSeparator);
                    }
                    lp.append(file6.getAbsolutePath());
                }
                System.setProperty("java.library.path", lp.toString());
            }
            PluginClassLoader pluginClassLoader = new PluginClassLoader();
            pluginClassLoader.addURLs(urls);
            try {
                Class<?> clazz = pluginClassLoader.loadClass(className);
            }
            catch (ClassNotFoundException | NoClassDefFoundError e) {
                System.err.println("Loading class " + className + " failed. Trying to extend classpath.");
                URL url = QFile.class.getResource("QFile.class");
                if (url != null) {
                    String path = url.toString();
                    int idx = -1;
                    if (path.startsWith("jar:file:") && (idx = path.indexOf("!/")) >= 0) {
                        path = path.substring(4, idx);
                        try {
                            File jarFile = new File(new URL(path).toURI());
                            if (jarFile.getParentFile().isDirectory()) {
                                for (File other : jarFile.getParentFile().listFiles()) {
                                    if (!other.isFile() || !other.getName().startsWith("qtjambi") || other.getName().endsWith("javadoc.jar") || other.getName().endsWith("sources.jar") || !other.getName().endsWith(".jar")) continue;
                                    urls.add(other.toURI().toURL());
                                }
                            }
                            pluginClassLoader.close();
                            pluginClassLoader = new PluginClassLoader();
                            pluginClassLoader.addURLs(urls);
                            Class<?> clazz = pluginClassLoader.loadClass(className);
                        }
                        catch (Exception e1) {
                            throw new Error("Unable to find class: " + className, e1);
                        }
                    }
                    System.err.println(url);
                    throw new Error("Unable to find class: " + className);
                }
                System.err.println(url);
                throw new Error("Unable to find class: " + className);
            }
            iid = QtJambiPlugins.getInterfaceIID((Class)var26_66);
            if (iid == null) {
                throw new Error("Unable to detect IID from class: " + var26_66.getName());
            }
        }
        if (iid == null || className == null) return;
        QCborMap cborValue = new QCborMap();
        cborValue.setValue(2L, new QCborValue(iid));
        cborValue.setValue(3L, new QCborValue(className.replace(".", "::")));
        cborValue.setValue(4L, new QCborValue(QCborMap.fromJsonObject((QJsonObject)metaData)));
        cborValue.setValue(54491065312L, new QCborValue(pluginName));
        QByteArray qByteArray = cborValue.toCborValue().toCbor();
        System.gc();
        if (generateSource) {
            subdir = new File(dir, pluginName);
            subdir.mkdirs();
            if (classPath.size() == 1) {
                File file7 = new File((String)classPath.get(0));
                Files.copy(file7.toPath(), new File(subdir, pluginName + ".jar").toPath(), StandardCopyOption.REPLACE_EXISTING);
            } else {
                subdir = new File(subdir, pluginName);
                subdir.mkdirs();
                for (String string6 : classPath) {
                    File target = new File(subdir, string6);
                    target.getParentFile().mkdirs();
                    Files.copy(new File(string6).toPath(), target.toPath(), StandardCopyOption.REPLACE_EXISTING);
                }
            }
            PluginGenerator.generateSource(dir, pluginName, qByteArray);
            return;
        } else {
            if (classPath.size() == 1) {
                File file8 = new File((String)classPath.get(0));
                Files.copy(file8.toPath(), new File(dir, pluginName + ".jar").toPath(), StandardCopyOption.REPLACE_EXISTING);
            } else {
                subdir = new File(dir, pluginName);
                subdir.mkdirs();
                for (String string7 : classPath) {
                    File target = new File(subdir, string7);
                    target.getParentFile().mkdirs();
                    Files.copy(new File(string7).toPath(), target.toPath(), StandardCopyOption.REPLACE_EXISTING);
                }
            }
            QCborMap map = new QCborMap();
            map.insert(-889275714L, QCborValue.fromVariant((Object)new QByteArray(1006L, 10)));
            map.insert(-1161901314L, QCborValue.fromVariant((Object)"END"));
            QByteArray QTMETADATA = map.toCborValue().toCbor();
            if (qByteArray.size() > QTMETADATA.size()) {
                throw new Error("Plugin metadata exceeds maximum size of " + QTMETADATA.size() + " byte.");
            }
            if (qByteArray.size() < QTMETADATA.size()) {
                qByteArray.resize(QTMETADATA.size());
            }
            block49: for (Map.Entry entry : libraries) {
                File newFile;
                String os = (String)entry.getKey();
                if (os == null) continue;
                switch (os.toLowerCase()) {
                    case "win32": 
                    case "win64": 
                    case "windows": 
                    case "windows-aarch64": 
                    case "windows-arm64": 
                    case "windows-x86": 
                    case "windows-x64": {
                        newFile = isDebug == null ? new File(dir, pluginName + (((URL)entry.getValue()).toExternalForm().endsWith("d.dll") ? "d.dll" : ".dll")) : new File(dir, pluginName + (isDebug != false ? "d.dll" : ".dll"));
                        System.gc();
                        break;
                    }
                    case "macos": 
                    case "osx": {
                        newFile = new File(dir, "lib" + pluginName + ".dylib");
                        break;
                    }
                    case "linux": 
                    case "linux32": 
                    case "linux64": 
                    case "linux-arm64": 
                    case "linux-aarch64": 
                    case "linux-x86": 
                    case "linux-x64": {
                        newFile = new File(dir, "lib" + pluginName + ".so");
                        break;
                    }
                    default: {
                        continue block49;
                    }
                }
                try {
                    QIODevice device = QIODevice.fromInputStream((InputStream)((URL)entry.getValue()).openStream());
                    QByteArray libData = device.readAll();
                    device.close();
                    int idx = (int)libData.indexOf(QTMETADATA);
                    if (idx <= 0) throw new Error("Unable to find plugin meta data in file " + ((URL)entry.getValue()).toExternalForm());
                    QFile _newFile = new QFile(QDir.fromNativeSeparators((String)newFile.getAbsolutePath()));
                    if (!_newFile.open(new QIODeviceBase.OpenModeFlag[]{QIODeviceBase.OpenModeFlag.WriteOnly})) throw new Error("Unable to write file " + _newFile.fileName());
                    _newFile.write(libData);
                    while (idx > 0) {
                        _newFile.seek((long)idx);
                        _newFile.write(qByteArray);
                        idx = (int)libData.indexOf(QTMETADATA, (long)idx + QTMETADATA.size());
                    }
                    _newFile.close();
                }
                catch (IOException e) {
                    throw new Error("Unable to read file " + ((URL)entry.getValue()).toExternalForm(), e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void generateSource(File dir, String pluginName, QByteArray cborData) {
        block24: {
            QTextStream s;
            QFile fileout;
            QFile filein;
            String fileName;
            QDir subdir;
            block23: {
                subdir = new QDir(dir.getAbsolutePath());
                subdir.mkpath(pluginName);
                subdir.cd(pluginName);
                fileName = subdir.absoluteFilePath("plugin.cpp");
                filein = new QFile(":io/qt/qtjambi/deployer/plugin.cpp");
                fileout = new QFile(fileName);
                if (filein.open(new QIODeviceBase.OpenModeFlag[]{QIODeviceBase.OpenModeFlag.ReadOnly})) {
                    try {
                        if (fileout.open(new QIODeviceBase.OpenModeFlag[]{QIODeviceBase.OpenModeFlag.WriteOnly, QIODeviceBase.OpenModeFlag.Text})) {
                            s = new QTextStream((QIODevice)fileout);
                            try {
                                s.append("#include <QtCore/QtPlugin>").endl().append("#include <QtCore/QPluginLoader>").endl().endl().append("#define CBOR_DATA \\").endl().append("    ");
                                byte[] data = cborData.toByteArray();
                                int i = 0;
                                int j = 0;
                                while (i < data.length) {
                                    byte b = data[i];
                                    if (Character.isAlphabetic(b)) {
                                        s.append('\'').append((char)b).append("', ");
                                    } else {
                                        String hex = Integer.toHexString(Byte.toUnsignedInt(b));
                                        while (hex.length() > 2 && hex.charAt(0) == '0') {
                                            hex = hex.substring(1);
                                        }
                                        s.append("0x").append(hex).append(", ");
                                    }
                                    if (j == 7) {
                                        s.append("\\").endl().append("    ");
                                        j = 0;
                                    }
                                    ++i;
                                    ++j;
                                }
                                s.endl().endl().flush();
                                QTextStream in = new QTextStream((QIODevice)filein);
                                while (!in.atEnd()) {
                                    s.append(in.readLine()).endl();
                                }
                                in.dispose();
                                break block23;
                            }
                            finally {
                                s.flush();
                                s.dispose();
                                fileout.close();
                            }
                        }
                        throw new Error("Unable to write file " + fileName);
                    }
                    finally {
                        filein.close();
                    }
                }
                throw new Error("Unable to read resource plugin.cpp");
            }
            fileName = subdir.absoluteFilePath("plugin.pro");
            fileout = new QFile(fileName);
            filein = new QFile(":io/qt/qtjambi/deployer/plugin.pro");
            if (filein.open(new QIODeviceBase.OpenModeFlag[]{QIODeviceBase.OpenModeFlag.ReadOnly})) {
                try {
                    if (fileout.open(new QIODeviceBase.OpenModeFlag[]{QIODeviceBase.OpenModeFlag.WriteOnly, QIODeviceBase.OpenModeFlag.Text})) {
                        s = new QTextStream((QIODevice)fileout);
                        try {
                            s.append("TARGET = ").append(pluginName).endl();
                            QTextStream in = new QTextStream((QIODevice)filein);
                            while (!in.atEnd()) {
                                s.append(in.readLine()).endl();
                            }
                            in.dispose();
                            break block24;
                        }
                        finally {
                            s.flush();
                            s.dispose();
                            fileout.close();
                        }
                    }
                    throw new Error("Unable to write file " + fileName);
                }
                finally {
                    filein.close();
                }
            }
            throw new Error("Unable to read resource plugin.pro");
        }
    }

    private static class PluginClassLoader
    extends URLClassLoader {
        public PluginClassLoader() {
            super(new URL[0]);
        }

        protected void addURLs(Collection<URL> urls) {
            for (URL url : urls) {
                super.addURL(url);
            }
        }
    }
}

