/*
 * Decompiled with CFR 0.152.
 */
package io.qt.qtjambi.deployer;

import io.qt.core.QCommandLineOption;
import io.qt.core.QCommandLineParser;
import io.qt.core.QDir;
import io.qt.core.QLibraryInfo;
import io.qt.core.QOperatingSystemVersion;
import io.qt.core.QPair;
import io.qt.core.QProcess;
import io.qt.core.QStringList;
import io.qt.core.QVersionNumber;
import io.qt.internal.QtJambiInternal;
import io.qt.qtjambi.deployer.Main;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarInputStream;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

final class BundleGenerator {
    private static final Map<String, Set<String>> pluginsByModules;

    BundleGenerator() {
    }

    static <K, V> Function<? super K, ArrayList<V>> getArrayListFactory() {
        return key -> new ArrayList();
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static void generate(QCommandLineParser parser, String[] args, QCommandLineOption platformOption, QCommandLineOption dirOption, QCommandLineOption configurationOption) throws InterruptedException, IOException {
        Object object;
        ArrayList<QPair> qtdirs;
        URL androidBindingsURL;
        Boolean isMinGWBuilt;
        File targetDir;
        boolean isDebug;
        block119: {
            int eform2;
            Object osArchName;
            block120: {
                QCommandLineOption qtbaseOption;
                QCommandLineOption qtdirOption;
                block117: {
                    File foundVersionDir;
                    block118: {
                        void var16_20;
                        int patchVersion;
                        block116: {
                            int protocol2;
                            File[] url;
                            block115: {
                                File qtdir;
                                QCommandLineOption versionOption;
                                block113: {
                                    File qtbase;
                                    block114: {
                                        qtdirOption = new QCommandLineOption((Collection)QStringList.of((String)"qtdir", (String[])new String[0]), "Directory containing Qt binaries", "directory");
                                        qtbaseOption = new QCommandLineOption((Collection)QStringList.of((String)"qtbase", (String[])new String[0]), "Installation directory of Qt", "directory");
                                        versionOption = new QCommandLineOption((Collection)QStringList.of((String)"target-version", (String[])new String[0]), "Qt version", "version");
                                        QCommandLineOption utilitiesOption = new QCommandLineOption((Collection)QStringList.of((String)"utilities", (String[])new String[0]), "Path to android utilities.\nExamples:\n--utilities=utilities/QtAndroidBindings.jar", "file");
                                        QCommandLineOption utilitiesLocationOption = new QCommandLineOption((Collection)QStringList.of((String)"utilities-location", (String[])new String[0]), "Directory containing android utilities", "path");
                                        parser.addOptions(Arrays.asList(platformOption, dirOption, configurationOption, qtdirOption, qtbaseOption, versionOption, utilitiesOption, utilitiesLocationOption));
                                        parser.process((Collection)new QStringList(args));
                                        QStringList unusedArguments = new QStringList((Collection)parser.positionalArguments());
                                        if (unusedArguments.size() == 1) {
                                            throw new Error("Qt bundle generation, illegal argument: " + unusedArguments.join(", "));
                                        }
                                        if (unusedArguments.size() > 1) {
                                            throw new Error("Qt bundle generation, illegal argument: " + unusedArguments.join(", "));
                                        }
                                        isDebug = parser.isSet(configurationOption) && parser.value(configurationOption).equals("debug");
                                        targetDir = new File(parser.isSet(dirOption) ? parser.value(dirOption) : System.getProperty("user.dir"));
                                        qtdir = null;
                                        qtbase = null;
                                        isMinGWBuilt = null;
                                        Object var16_16 = null;
                                        osArchName = null;
                                        androidBindingsURL = null;
                                        if (parser.isSet(utilitiesOption)) {
                                            File utilitiesJar = new File(parser.value(utilitiesOption));
                                            if (!utilitiesJar.exists()) {
                                                throw new Error(String.format("Utilities file does not exist: %1$s", utilitiesJar.getAbsolutePath()));
                                            }
                                            androidBindingsURL = utilitiesJar.toURI().toURL();
                                        } else if (parser.isSet(utilitiesLocationOption)) {
                                            QDir location = new QDir(parser.value(utilitiesLocationOption));
                                            File utilitiesJar = new File(location.absoluteFilePath("QtAndroidBindings.jar"));
                                            if (!utilitiesJar.exists()) {
                                                throw new Error("utilities-location does not contain QtAndroidBindings.jar.");
                                            }
                                            androidBindingsURL = utilitiesJar.toURI().toURL();
                                        }
                                        if (androidBindingsURL == null) {
                                            Enumeration<URL> specsFound = Main.findSpecs();
                                            HashSet<File[]> specsUrls = new HashSet<File[]>();
                                            block29: while (specsFound.hasMoreElements() && androidBindingsURL == null) {
                                                int start;
                                                String eform2;
                                                int end;
                                                url = specsFound.nextElement();
                                                if (specsUrls.contains(url)) continue;
                                                specsUrls.add(url);
                                                String protocol2 = url.getProtocol();
                                                if (!protocol2.equals("jar") || (end = (eform2 = url.toExternalForm()).indexOf("!/", start = 4)) == -1) continue;
                                                try {
                                                    Document doc;
                                                    try (InputStream inStream = url.openStream();){
                                                        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                                                        factory.setValidating(false);
                                                        DocumentBuilder builder = factory.newDocumentBuilder();
                                                        doc = builder.parse(inStream);
                                                    }
                                                    String system = doc.getDocumentElement().getAttribute("system");
                                                    if (system == null || !system.startsWith("android")) continue;
                                                    int l = doc.getDocumentElement().getChildNodes().getLength();
                                                    for (int i = 0; i < l; ++i) {
                                                        Element element;
                                                        String libraryName;
                                                        Node child = doc.getDocumentElement().getChildNodes().item(i);
                                                        if (!(child instanceof Element) || !child.getNodeName().equals("file") || !(libraryName = (element = (Element)child).getAttribute("name")).equals("utilities/QtAndroidBindings.jar")) continue;
                                                        androidBindingsURL = new URL(eform2.substring(0, end + 2) + libraryName);
                                                        continue block29;
                                                    }
                                                }
                                                catch (Exception e) {
                                                    Logger.getLogger("io.qt").log(Level.WARNING, "", e);
                                                }
                                            }
                                        }
                                        if (parser.isSet(qtdirOption)) {
                                            if (parser.isSet(qtbaseOption)) {
                                                throw new Error(String.format("Qt bundle generation: either use --%1$s or --%2$s but not both.", qtbaseOption.valueName(), qtdirOption.valueName()));
                                            }
                                            qtdir = new File(parser.value(qtdirOption));
                                        } else {
                                            if (parser.isSet(versionOption)) {
                                                QVersionNumber qVersionNumber = QVersionNumber.fromString((String)parser.value(versionOption));
                                            }
                                            if (parser.isSet(qtbaseOption)) {
                                                qtbase = new File(parser.value(qtbaseOption));
                                            } else {
                                                File qtLibraryPath;
                                                void var16_18;
                                                String base = null;
                                                if (QOperatingSystemVersion.current().type() == QOperatingSystemVersion.OSType.Windows) {
                                                    base = "C:\\Qt";
                                                    if (base == null || !new File(base).isDirectory()) {
                                                        base = null;
                                                    }
                                                } else if (QOperatingSystemVersion.current().type() == QOperatingSystemVersion.OSType.MacOS) {
                                                    base = "/Library/Qt";
                                                    if (base == null || !new File(base).isDirectory()) {
                                                        base = "/System/Qt";
                                                    }
                                                    if (base == null || !new File(base).isDirectory()) {
                                                        base = "/opt/Qt";
                                                    }
                                                    if (base == null || !new File(base).isDirectory()) {
                                                        base = null;
                                                    }
                                                } else {
                                                    base = "/opt/Qt";
                                                    if (base == null || !new File(base).isDirectory()) {
                                                        base = null;
                                                    }
                                                }
                                                if (base == null || !new File(base).isDirectory()) {
                                                    base = System.getProperty("user.home") + File.separator + "Qt";
                                                }
                                                if (base == null || !new File(base).isDirectory()) {
                                                    base = System.getProperty("user.dir") + File.separator + ".." + File.separator + "Qt";
                                                }
                                                if (base == null || !(qtbase = new File(base)).isDirectory()) {
                                                    base = null;
                                                    qtbase = null;
                                                }
                                                if (qtbase == null && (var16_18 == null || QLibraryInfo.version().equals((Object)var16_18)) && (qtLibraryPath = new File(QtJambiInternal.qtLibraryPath())).isDirectory() && qtLibraryPath.getName().equals(QOperatingSystemVersion.current().type() == QOperatingSystemVersion.OSType.Windows ? "bin" : "lib")) {
                                                    qtdir = qtLibraryPath.getParentFile();
                                                    isMinGWBuilt = QtJambiInternal.isMinGWBuilt();
                                                    osArchName = QtJambiInternal.osArchName();
                                                    QVersionNumber qVersionNumber = QLibraryInfo.version();
                                                }
                                            }
                                        }
                                        if (qtbase == null) break block113;
                                        patchVersion = -1;
                                        foundVersionDir = null;
                                        if (var16_20 != null) break block114;
                                        url = qtbase.listFiles();
                                        protocol2 = url.length;
                                        break block115;
                                    }
                                    foundVersionDir = new File(qtbase, var16_20.toString());
                                    if (!foundVersionDir.isDirectory()) {
                                        throw new Error(String.format("Qt bundle generation: Unknown version '%1$s'.", var16_20));
                                    }
                                    break block116;
                                }
                                if (qtdir != null) {
                                    void var16_25;
                                    if (!new File(qtdir, "bin").isDirectory()) {
                                        if (!new File(qtdir, "lib").isDirectory()) throw new Error("Qt bundle generation: Specified Qt location does not contain Qt libraries.");
                                    }
                                    if (!new File(qtdir, "plugins").isDirectory()) {
                                        throw new Error("Qt bundle generation: Specified Qt location does not contain Qt libraries.");
                                    }
                                    if (parser.isSet(platformOption)) {
                                        osArchName = parser.value(platformOption);
                                    }
                                    if (osArchName == null) {
                                        if (qtdir.getName().equals("android")) {
                                            osArchName = "android";
                                        } else if (qtdir.getName().equals("android_arm64_v8a")) {
                                            osArchName = "android-arm64";
                                        } else if (qtdir.getName().equals("android_armv7")) {
                                            osArchName = "android-arm";
                                        } else if (qtdir.getName().equals("android_x86_64")) {
                                            osArchName = "android-x64";
                                        } else if (qtdir.getName().equals("android_x86")) {
                                            osArchName = "android-x86";
                                        } else if (qtdir.getName().startsWith("mingw") || qtdir.getName().startsWith("msvc2019")) {
                                            osArchName = qtdir.getName().endsWith("_64") ? "windows-x64" : (qtdir.getName().endsWith("_arm64") ? null : "windows-x86");
                                        } else if (qtdir.getName().startsWith("gcc")) {
                                            osArchName = qtdir.getName().endsWith("_64") ? "linux-x64" : "linux-x86";
                                        } else if (qtdir.getName().equals("clang_64") || qtdir.getName().equals("macos")) {
                                            osArchName = "macos";
                                        }
                                    }
                                    if (isMinGWBuilt == null) {
                                        isMinGWBuilt = qtdir.getName().startsWith("mingw");
                                    }
                                    if (parser.isSet(platformOption) && !parser.value(platformOption).equals(osArchName)) {
                                        throw new Error(String.format("Qt bundle generation: Platform specified by --%1$s is not available in %2$s.", platformOption.valueName(), qtdir));
                                    }
                                    if (!targetDir.exists()) {
                                        targetDir.mkdirs();
                                    }
                                    if (parser.isSet(versionOption)) {
                                        QVersionNumber qVersionNumber = QVersionNumber.fromString((String)parser.value(versionOption));
                                    } else {
                                        Object var16_24 = null;
                                    }
                                    if ("android".equals(osArchName)) {
                                        BundleGenerator.generateBundles(targetDir, qtdir, "android-arm64", androidBindingsURL, isDebug, isMinGWBuilt, (QVersionNumber)var16_25);
                                        BundleGenerator.generateBundles(targetDir, qtdir, "android-arm", androidBindingsURL, isDebug, isMinGWBuilt, (QVersionNumber)var16_25);
                                        BundleGenerator.generateBundles(targetDir, qtdir, "android-x64", androidBindingsURL, isDebug, isMinGWBuilt, (QVersionNumber)var16_25);
                                        BundleGenerator.generateBundles(targetDir, qtdir, "android-x86", androidBindingsURL, isDebug, isMinGWBuilt, (QVersionNumber)var16_25);
                                        return;
                                    }
                                    BundleGenerator.generateBundles(targetDir, qtdir, (String)osArchName, androidBindingsURL, isDebug, isMinGWBuilt, (QVersionNumber)var16_25);
                                    return;
                                }
                                if (args.length == 1) {
                                    parser.showHelp();
                                }
                                throw new Error(String.format("Qt bundle generation: Unable to find Qt. Either use --%1$s or --%2$s.", qtbaseOption.valueName(), qtdirOption.valueName()));
                            }
                            for (int eform2 = 0; eform2 < protocol2; ++eform2) {
                                File versionDir = url[eform2];
                                String qtjambiVersionString = String.format("%1$s.%2$s.", QtJambiInternal.majorVersion(), QtJambiInternal.minorVersion());
                                if (!versionDir.isDirectory() || !versionDir.getName().startsWith(qtjambiVersionString)) continue;
                                try {
                                    int patch = Integer.parseInt(versionDir.getName().substring(qtjambiVersionString.length()));
                                    if (patch <= patchVersion) continue;
                                    patchVersion = patch;
                                    foundVersionDir = versionDir;
                                    continue;
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                            }
                        }
                        if (foundVersionDir == null) break block117;
                        if (var16_20 == null) {
                            QVersionNumber qVersionNumber = new QVersionNumber(QtJambiInternal.majorVersion(), QtJambiInternal.minorVersion(), patchVersion);
                        }
                        isMinGWBuilt = QtJambiInternal.isMinGWBuilt();
                        qtdirs = new ArrayList<QPair>();
                        if (!parser.isSet(platformOption)) break block118;
                        osArchName = parser.value(platformOption);
                        File subdir = null;
                        switch (osArchName) {
                            case "android-arm64": {
                                subdir = new File(foundVersionDir, "android");
                                if (subdir.isDirectory()) break;
                                subdir = new File(foundVersionDir, "android_arm64_v8a");
                                break;
                            }
                            case "android-arm": {
                                subdir = new File(foundVersionDir, "android");
                                if (subdir.isDirectory()) break;
                                subdir = new File(foundVersionDir, "android_armv7");
                                break;
                            }
                            case "android-x64": {
                                subdir = new File(foundVersionDir, "android");
                                if (subdir.isDirectory()) break;
                                subdir = new File(foundVersionDir, "android_x86_64");
                                break;
                            }
                            case "android-x86": {
                                subdir = new File(foundVersionDir, "android");
                                if (subdir.isDirectory()) break;
                                subdir = new File(foundVersionDir, "android_x86");
                                break;
                            }
                            case "windows-x64": {
                                subdir = new File(foundVersionDir, isMinGWBuilt != false ? "mingw_64" : "msvc2019_64");
                                break;
                            }
                            case "windows-arm64": {
                                subdir = new File(foundVersionDir, "msvc2019_arm64");
                                break;
                            }
                            case "linux-x64": {
                                subdir = new File(foundVersionDir, "gcc_64");
                                break;
                            }
                            case "macos": {
                                subdir = new File(foundVersionDir, "macos");
                                if (subdir.isDirectory()) break;
                                subdir = new File(foundVersionDir, "clang_64");
                                break;
                            }
                            default: {
                                throw new Error(String.format("Qt bundle generation: Unknown target platform '%1$s'.", osArchName));
                            }
                        }
                        if (subdir != null && subdir.isDirectory() && (new File(subdir, "bin").isDirectory() || new File(subdir, "lib").isDirectory()) && new File(subdir, "plugins").isDirectory()) {
                            qtdirs.add(new QPair(osArchName, (Object)subdir));
                        }
                        break block119;
                    }
                    object = foundVersionDir.listFiles();
                    eform2 = ((File[])object).length;
                    break block120;
                }
                if (parser.isSet(qtbaseOption)) {
                    throw new Error(String.format("Qt bundle generation: Unable to find Qt in directory specified by --%1$s.", qtbaseOption.valueName()));
                }
                throw new Error(String.format("Qt bundle generation: Unable to find Qt. Either use --%1$s or --%2$s.", qtbaseOption.valueName(), qtdirOption.valueName()));
            }
            for (int i = 0; i < eform2; ++i) {
                File subdir = object[i];
                if (!subdir.isDirectory()) continue;
                osArchName = null;
                if (subdir.getName().equals("android")) {
                    osArchName = null;
                    if ((new File(subdir, "bin").isDirectory() || new File(subdir, "lib").isDirectory()) && new File(subdir, "plugins").isDirectory()) {
                        qtdirs.add(new QPair((Object)"android-arm64", (Object)subdir));
                        qtdirs.add(new QPair((Object)"android-arm", (Object)subdir));
                        qtdirs.add(new QPair((Object)"android-x64", (Object)subdir));
                        qtdirs.add(new QPair((Object)"android-x86", (Object)subdir));
                    }
                } else if (subdir.getName().equals("android_arm64_v8a")) {
                    osArchName = "android-arm64";
                } else if (subdir.getName().equals("android_armv7")) {
                    osArchName = "android-arm";
                } else if (subdir.getName().equals("android_x86_64")) {
                    osArchName = "android-x64";
                } else if (subdir.getName().equals("android_x86")) {
                    osArchName = "android-x86";
                } else if (subdir.getName().startsWith("mingw")) {
                    if (!isMinGWBuilt.booleanValue()) continue;
                    osArchName = subdir.getName().endsWith("_64") ? "windows-x64" : "windows-x86";
                } else if (subdir.getName().startsWith("msvc2019")) {
                    if (isMinGWBuilt.booleanValue()) continue;
                    osArchName = subdir.getName().endsWith("_64") ? "windows-x64" : (subdir.getName().endsWith("_arm64") ? null : "windows-x86");
                } else if (subdir.getName().startsWith("gcc")) {
                    osArchName = subdir.getName().endsWith("_64") ? "linux-x64" : "linux-x86";
                } else if (subdir.getName().equals("clang_64") || subdir.getName().equals("macos")) {
                    osArchName = "macos";
                }
                if (osArchName == null || !new File(subdir, "bin").isDirectory() && !new File(subdir, "lib").isDirectory() || !new File(subdir, "plugins").isDirectory()) continue;
                qtdirs.add(new QPair(osArchName, (Object)subdir));
            }
        }
        if (!targetDir.exists()) {
            targetDir.mkdirs();
        }
        object = qtdirs.iterator();
        while (object.hasNext()) {
            void var16_22;
            QPair qPair = (QPair)object.next();
            BundleGenerator.generateBundles(targetDir, (File)qPair.second, (String)qPair.first, androidBindingsURL, isDebug, isMinGWBuilt, (QVersionNumber)var16_22);
        }
    }

    private static String findTargetModule(String name) {
        if (name.equals("xcbqpa") || name.startsWith("eglfs")) {
            return "gui";
        }
        if (name.equals("designercomponents")) {
            return "designer";
        }
        if (name.equals("waylandeglclienthwintegration") || name.equals("wlshellintegration")) {
            return "waylandclient";
        }
        if (name.equals("waylandeglcompositorhwintegration")) {
            return "waylandcompositor";
        }
        if (name.startsWith("quickcontrols2") || name.startsWith("quickdialogs2") || name.startsWith("quicklayout") || name.startsWith("quickparticles") || name.startsWith("quickshapes") || name.startsWith("quicktemplates2") || name.startsWith("quicktimeline")) {
            return "quick";
        }
        if (name.startsWith("labs")) {
            return "qml";
        }
        if (name.startsWith("qml") && !name.equals("qml")) {
            return "qml";
        }
        if (name.startsWith("webenginequick") && !name.equals("webenginequick")) {
            return "webenginequick";
        }
        if (name.startsWith("quick3d") && !name.equals("quick3d")) {
            return "quick3d";
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private static void generateBundles(File targetDir, File qtdir, String osArchName, URL androidBindingsURL, boolean isDebug, boolean isMinGWBuilt, QVersionNumber version) {
        block306: {
            String suffix;
            Object prefix;
            QProcess process;
            File qmake;
            File binDir = new File(qtdir, "bin");
            File libDir = new File(qtdir, "lib");
            File pluginsDir = new File(qtdir, "plugins");
            File qmlDir = new File(qtdir, "qml");
            if (System.getProperty("os.name").toLowerCase().startsWith("windows")) {
                qmake = new File(binDir, "qmake.exe");
                if (!qmake.exists()) {
                    qmake = new File(binDir, "qmake.bat");
                }
                if (qmake.exists()) {
                    process = new QProcess();
                    process.start(qmake.getAbsolutePath(), (Collection)QStringList.of((String)"-query", (String[])new String[]{"QT_VERSION"}));
                    process.waitForFinished();
                    if (process.exitCode() == 0) {
                        version = QVersionNumber.fromString((String)process.readAllStandardOutput().trimmed().toString());
                    }
                }
            } else {
                qmake = new File(binDir, "qmake");
                if (qmake.exists()) {
                    process = new QProcess();
                    process.start(qmake.getAbsolutePath(), (Collection)QStringList.of((String)"-query", (String[])new String[]{"QT_VERSION"}));
                    process.waitForFinished();
                    if (process.exitCode() == 0) {
                        version = QVersionNumber.fromString((String)process.readAllStandardOutput().trimmed().toString());
                    }
                }
            }
            if (version == null) break block306;
            TreeMap libraries = new TreeMap();
            TreeMap<String, Object> plugins = new TreeMap<String, Object>();
            TreeMap<String, File> qmllibs = new TreeMap<String, File>();
            if (osArchName.startsWith("windows-")) {
                String libNoSuffix;
                prefix = "Qt" + version.majorVersion();
                if (isDebug) {
                    if (new File(binDir, "libstdc++-6.dll").exists()) {
                        for (String string : binDir.list()) {
                            List list;
                            if (string.startsWith((String)prefix) && string.endsWith(".dll")) {
                                String name = string.substring(((String)prefix).length(), string.length() - 4).toLowerCase();
                                if (name.startsWith("3d")) {
                                    name = "qt" + name;
                                }
                                boolean prepend = true;
                                String targetModule = BundleGenerator.findTargetModule(name);
                                if (targetModule != null) {
                                    name = targetModule;
                                    prepend = false;
                                }
                                List list2 = libraries.computeIfAbsent(name, BundleGenerator.getArrayListFactory());
                                if (prepend) {
                                    list2.add(0, new File(binDir, string));
                                } else {
                                    list2.add(new File(binDir, string));
                                }
                                File debugLib = new File(libDir, (String)string + ".debug");
                                if (!debugLib.exists()) continue;
                                list2.add(debugLib);
                                continue;
                            }
                            if (string.equals("libGLESv2.dll") || string.equals("libEGL.dll")) {
                                list = libraries.computeIfAbsent("gui", BundleGenerator.getArrayListFactory());
                                list.add(new File(binDir, string));
                                continue;
                            }
                            if (!string.equals("libstdc++-6.dll") && !string.equals("libwinpthread-1.dll") && !string.equals("libgcc_s_seh-1.dll")) continue;
                            list = libraries.computeIfAbsent("core", BundleGenerator.getArrayListFactory());
                            list.add(new File(binDir, string));
                        }
                        for (File file : pluginsDir.listFiles()) {
                            if (!file.isDirectory()) continue;
                            boolean found = false;
                            for (String lib : file.list()) {
                                if (!lib.endsWith(".dll") || new File(file, (libNoSuffix = lib.substring(0, lib.length() - 5)) + ".dll").exists()) continue;
                                found = true;
                                break;
                            }
                            if (!found) continue;
                            plugins.put(file.getName(), file);
                        }
                    } else {
                        for (String string : binDir.list()) {
                            String libNoSuffix2;
                            if (string.startsWith((String)prefix) && string.endsWith("d.dll")) {
                                String libNoSuffix22 = string.substring(0, string.length() - 5);
                                if (new File(binDir, libNoSuffix22 + "dd.dll").exists()) continue;
                                String name = string.substring(((String)prefix).length(), string.length() - 5).toLowerCase();
                                if (name.startsWith("3d")) {
                                    name = "qt" + name;
                                }
                                int prepend = 1;
                                String targetModule = BundleGenerator.findTargetModule(name);
                                if (targetModule != null) {
                                    name = targetModule;
                                    prepend = 0;
                                }
                                List list = libraries.computeIfAbsent(name, BundleGenerator.getArrayListFactory());
                                if (prepend != 0) {
                                    list.add(0, new File(binDir, string));
                                    continue;
                                }
                                list.add(new File(binDir, string));
                                continue;
                            }
                            if (!string.startsWith("libGLESv2") && !string.startsWith("libEGL") || !string.endsWith("d.dll") || new File(binDir, (libNoSuffix2 = string.substring(0, string.length() - 5)) + "dd.dll").exists()) continue;
                            List list = libraries.computeIfAbsent("gui", BundleGenerator.getArrayListFactory());
                            list.add(new File(binDir, string));
                        }
                        for (File file : pluginsDir.listFiles()) {
                            if (!file.isDirectory()) continue;
                            boolean found = false;
                            for (String lib : file.list()) {
                                if (!lib.endsWith("d.dll") || new File(file, (libNoSuffix = lib.substring(0, lib.length() - 5)) + "dd.dll").exists()) continue;
                                found = true;
                                break;
                            }
                            if (!found) continue;
                            plugins.put(file.getName(), file);
                        }
                    }
                } else {
                    for (String string : binDir.list()) {
                        if (string.startsWith((String)prefix) && string.endsWith(".dll")) {
                            String libNoSuffix3;
                            if (string.endsWith("d.dll") && new File(binDir, (libNoSuffix3 = string.substring(0, string.length() - 5)) + ".dll").exists()) continue;
                            String name = string.substring(((String)prefix).length(), string.length() - 4).toLowerCase();
                            if (name.startsWith("3d")) {
                                name = "qt" + name;
                            }
                            boolean prepend = true;
                            String targetModule = BundleGenerator.findTargetModule(name);
                            if (targetModule != null) {
                                name = targetModule;
                                prepend = false;
                            }
                            List list = libraries.computeIfAbsent(name, BundleGenerator.getArrayListFactory());
                            if (prepend) {
                                list.add(0, new File(binDir, string));
                                continue;
                            }
                            list.add(new File(binDir, string));
                            continue;
                        }
                        if ((string.startsWith("libGLESv2") || string.startsWith("libEGL")) && string.endsWith("d.dll")) {
                            String libNoSuffix3 = string.substring(0, string.length() - 5);
                            if (new File(binDir, libNoSuffix3 + ".dll").exists()) continue;
                            List list = libraries.computeIfAbsent("gui", BundleGenerator.getArrayListFactory());
                            list.add(new File(binDir, string));
                            continue;
                        }
                        if (!string.equals("libstdc++-6.dll") && !string.equals("libwinpthread-1.dll") && !string.equals("libgcc_s_seh-1.dll")) continue;
                        List list = libraries.computeIfAbsent("core", BundleGenerator.getArrayListFactory());
                        list.add(new File(binDir, string));
                    }
                    for (File file : pluginsDir.listFiles()) {
                        if (!file.isDirectory()) continue;
                        boolean found = false;
                        for (String lib : file.list()) {
                            if (!lib.endsWith(".dll") || new File(file, (libNoSuffix = lib.substring(0, lib.length() - 5)) + ".dll").exists()) continue;
                            found = true;
                            break;
                        }
                        if (!found) continue;
                        plugins.put(file.getName(), file);
                    }
                }
            } else if (osArchName.startsWith("android-")) {
                void var18_44;
                void var18_42;
                if (androidBindingsURL == null) {
                    throw new Error("QtAndroidBindings.jar required. Please specify --utilities or --utilities-location.");
                }
                isDebug = false;
                prefix = "libQt" + version.majorVersion();
                switch (osArchName) {
                    case "android-arm64": {
                        suffix = "_arm64-v8a.so";
                        break;
                    }
                    case "android-arm": {
                        suffix = "_armeabi-v7a.so";
                        break;
                    }
                    case "android-x64": {
                        suffix = "_x86_64.so";
                        break;
                    }
                    default: {
                        suffix = "_x86.so";
                    }
                }
                Object[] objectArray = libDir.list();
                int n = objectArray.length;
                boolean bl = false;
                while (var18_42 < n) {
                    String lib = objectArray[var18_42];
                    if (lib.startsWith((String)prefix) && lib.endsWith(suffix)) {
                        String name = lib.substring(((String)prefix).length(), lib.length() - suffix.length()).toLowerCase();
                        if (name.startsWith("3d")) {
                            name = "qt" + name;
                        }
                        boolean prepend = true;
                        String targetModule = BundleGenerator.findTargetModule(name);
                        if (targetModule != null) {
                            name = targetModule;
                            prepend = false;
                        }
                        List list = libraries.computeIfAbsent(name, BundleGenerator.getArrayListFactory());
                        if (prepend) {
                            list.add(0, new File(libDir, lib));
                        } else {
                            list.add(new File(libDir, lib));
                        }
                    }
                    ++var18_42;
                }
                objectArray = pluginsDir.listFiles();
                n = objectArray.length;
                boolean bl2 = false;
                while (var18_44 < n) {
                    Object pluginDir = objectArray[var18_44];
                    if (((File)pluginDir).isDirectory()) {
                        boolean found = false;
                        for (String lib : ((File)pluginDir).list()) {
                            if (!lib.startsWith("lib") || !lib.endsWith(suffix)) continue;
                            found = true;
                            break;
                        }
                        if (found) {
                            plugins.put(((File)pluginDir).getName(), pluginDir);
                        }
                    }
                    ++var18_44;
                }
            } else if (osArchName.startsWith("linux-")) {
                isDebug = false;
                prefix = "libQt" + version.majorVersion();
                suffix = ".so." + version;
                String prefix2 = "libicu";
                String suffix2 = ".so.56.1";
                for (String lib : libDir.list()) {
                    if (lib.startsWith((String)prefix) && lib.endsWith(suffix)) {
                        String name = lib.substring(((String)prefix).length(), lib.length() - suffix.length()).toLowerCase();
                        if (name.startsWith("3d")) {
                            name = "qt" + name;
                        }
                        boolean prepend = true;
                        String targetModule = BundleGenerator.findTargetModule(name);
                        if (targetModule != null) {
                            name = targetModule;
                            prepend = false;
                        }
                        List list = libraries.computeIfAbsent(name, BundleGenerator.getArrayListFactory());
                        if (prepend) {
                            list.add(0, new File(libDir, lib));
                            continue;
                        }
                        list.add(new File(libDir, lib));
                        continue;
                    }
                    if (!lib.startsWith(prefix2) || !lib.endsWith(suffix2)) continue;
                    ((List)libraries.computeIfAbsent("core", BundleGenerator.getArrayListFactory())).add(new File(libDir, lib));
                }
                for (File pluginDir : pluginsDir.listFiles()) {
                    if (!pluginDir.isDirectory()) continue;
                    boolean found = false;
                    for (String lib : pluginDir.list()) {
                        if (!lib.startsWith("lib") || !lib.endsWith(".so")) continue;
                        found = true;
                        break;
                    }
                    if (!found) continue;
                    plugins.put(pluginDir.getName(), pluginDir);
                }
            } else if (osArchName.equals("macos")) {
                void var18_50;
                void var18_48;
                isDebug = false;
                prefix = "Qt";
                suffix = ".framework";
                File[] prefix2 = libDir.listFiles();
                int suffix2 = prefix2.length;
                boolean bl = false;
                while (var18_48 < suffix2) {
                    File lib = prefix2[var18_48];
                    if (lib.isDirectory() && lib.getName().startsWith((String)prefix) && lib.getName().endsWith(suffix)) {
                        String name = lib.getName().substring(((String)prefix).length(), lib.getName().length() - suffix.length()).toLowerCase();
                        if (name.startsWith("3d")) {
                            name = "qt" + name;
                        }
                        boolean prepend = true;
                        String targetModule = BundleGenerator.findTargetModule(name);
                        if (targetModule != null) {
                            name = targetModule;
                            prepend = false;
                        }
                        List list = libraries.computeIfAbsent(name, BundleGenerator.getArrayListFactory());
                        if (prepend) {
                            list.add(0, lib);
                        } else {
                            list.add(lib);
                        }
                    }
                    ++var18_48;
                }
                prefix2 = pluginsDir.listFiles();
                suffix2 = prefix2.length;
                boolean bl3 = false;
                while (var18_50 < suffix2) {
                    File pluginDir = prefix2[var18_50];
                    if (pluginDir.isDirectory()) {
                        boolean found = false;
                        for (String lib : pluginDir.list()) {
                            if (!lib.startsWith("lib") || !lib.endsWith(".dylib")) continue;
                            found = true;
                            break;
                        }
                        if (found) {
                            plugins.put(pluginDir.getName(), pluginDir);
                        }
                    }
                    ++var18_50;
                }
            }
            block146: for (File qmlsubDir : qmlDir.listFiles()) {
                if (!qmlsubDir.isDirectory()) continue;
                switch (qmlsubDir.getName()) {
                    case "QtAudioEngine": {
                        qmllibs.put("QtMultimedia", qmlsubDir);
                        continue block146;
                    }
                    case "QtQuick": {
                        qmllibs.put(qmlsubDir.getName(), qmlsubDir);
                        for (File quicklib : qmlsubDir.listFiles()) {
                            if (!quicklib.isDirectory()) continue;
                            qmllibs.put("QtQuick/" + quicklib.getName(), quicklib);
                        }
                        continue block146;
                    }
                    case "QtWayland": {
                        for (File quicklib : qmlsubDir.listFiles()) {
                            if (!quicklib.isDirectory()) continue;
                            qmllibs.put("QtWayland/" + quicklib.getName(), quicklib);
                        }
                        continue block146;
                    }
                    case "Qt3D": {
                        qmllibs.put(qmlsubDir.getName(), qmlsubDir);
                        for (File quicklib : qmlsubDir.listFiles()) {
                            if (!quicklib.isDirectory()) continue;
                            qmllibs.put("Qt3D/" + quicklib.getName(), quicklib);
                        }
                        continue block146;
                    }
                    default: {
                        qmllibs.put(qmlsubDir.getName(), qmlsubDir);
                    }
                }
            }
            try {
                Document doc;
                Transformer transformer = TransformerFactory.newInstance().newTransformer();
                transformer.setOutputProperty("indent", "yes");
                transformer.setOutputProperty("encoding", "UTF-8");
                transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                factory.setValidating(false);
                DocumentBuilder builder = factory.newDocumentBuilder();
                final Manifest manifest = new Manifest();
                manifest.getMainAttributes().putValue("Bundle-Version", version.toString());
                for (Map.Entry libPair : libraries.entrySet()) {
                    Object buffer;
                    File newFile = new File(targetDir, "qt-lib-" + (String)libPair.getKey() + "-native-" + (String)osArchName + (isDebug ? "-debug-" : "-") + version + ".jar");
                    AutoCloseable closable = () -> {};
                    JarOutputStream jarUtilFile = null;
                    if (osArchName.startsWith("android")) {
                        final File utilFile = new File(targetDir, "qt-lib-" + (String)libPair.getKey() + "-native-android-common-" + version + ".jar");
                        FileOutputStream os = new FileOutputStream(utilFile);
                        jarUtilFile = new JarOutputStream((OutputStream)os){
                            boolean hasManifest;
                            int entries;
                            {
                                super(arg0);
                                this.hasManifest = false;
                            }

                            @Override
                            public void putNextEntry(ZipEntry ze) throws IOException {
                                if ("META-INF/MANIFEST.MF".equals(ze.getName())) {
                                    if (this.hasManifest) {
                                        class HasManifestException
                                        extends IOException {
                                            HasManifestException() {
                                            }
                                        }
                                        throw new HasManifestException();
                                    }
                                    this.hasManifest = true;
                                    super.putNextEntry(ze);
                                } else if (ze.getName().startsWith("META-INF/") || ze.getName().endsWith(".class")) {
                                    super.putNextEntry(ze);
                                } else if (ze.getName().startsWith("qml/")) {
                                    super.putNextEntry(new JarEntry("qt-project.org/imports/" + ze.getName().substring(4)));
                                } else {
                                    super.putNextEntry(new JarEntry(ze.getName()));
                                }
                                ++this.entries;
                            }

                            @Override
                            public void close() throws IOException {
                                if (!this.hasManifest && this.entries > 0) {
                                    super.putNextEntry(new ZipEntry("META-INF/MANIFEST.MF"));
                                    manifest.write(this);
                                    super.closeEntry();
                                }
                                super.close();
                                if (this.entries == 0) {
                                    utilFile.delete();
                                }
                            }
                        };
                        closable = jarUtilFile;
                        if ("core".equals(libPair.getKey())) {
                            try (JarInputStream is = new JarInputStream(androidBindingsURL.openStream());){
                                JarEntry entry = is.getNextJarEntry();
                                while (entry != null) {
                                    if (!entry.isDirectory() && !entry.getName().equals("META-INF/MANIFEST.MF")) {
                                        jarUtilFile.putNextEntry(entry);
                                        buffer = new byte[1024];
                                        int length = is.read((byte[])buffer, 0, ((Object)buffer).length);
                                        while (length > 0) {
                                            jarUtilFile.write((byte[])buffer, 0, length);
                                            length = is.read((byte[])buffer, 0, ((Object)buffer).length);
                                        }
                                        jarUtilFile.closeEntry();
                                    }
                                    is.closeEntry();
                                    entry = is.getNextJarEntry();
                                }
                            }
                        }
                    }
                    boolean isEmpty = false;
                    try (JarOutputStream jarFile = new JarOutputStream(new FileOutputStream(newFile));
                         AutoCloseable _closable = closable;){
                        List list;
                        Object libraryElement;
                        if (jarUtilFile == null) {
                            jarUtilFile = jarFile;
                        }
                        doc = builder.getDOMImplementation().createDocument(null, "qtjambi-deploy", null);
                        doc.getDocumentElement().setAttribute("module", "qt.lib." + ((String)libPair.getKey()).replace('-', '.').replace('/', '.'));
                        doc.getDocumentElement().setAttribute("system", (String)osArchName);
                        doc.getDocumentElement().setAttribute("version", version.toString());
                        doc.getDocumentElement().setAttribute("configuration", isDebug ? "debug" : "release");
                        buffer = ((List)libPair.getValue()).iterator();
                        block153: while (buffer.hasNext()) {
                            block308: {
                                File libraryFile;
                                block310: {
                                    File dependencies;
                                    String targetDirName;
                                    block309: {
                                        File debugSym;
                                        block307: {
                                            libraryFile = (File)buffer.next();
                                            if (!osArchName.startsWith("macos")) break block307;
                                            String libName = libraryFile.getName();
                                            libName = libName.substring(0, libName.length() - ".framework".length());
                                            File versionDir = new File(new File(libraryFile, "Versions"), version.majorVersion() == 5 ? "5" : "A");
                                            File libFile = new File(versionDir, libName);
                                            if (libFile.isFile()) {
                                                File helpersDir;
                                                if (isDebug) {
                                                    File debugSym2 = new File(libraryFile.getParentFile(), libName + ".framework.dSYM");
                                                    if (debugSym2.exists() && debugSym2.isFile()) {
                                                        jarUtilFile.putNextEntry(new ZipEntry(libraryFile.getParentFile().getName() + "/" + libName + ".framework.dSYM"));
                                                        Files.copy(debugSym2.toPath(), jarUtilFile);
                                                        jarUtilFile.closeEntry();
                                                        Element libraryElement2 = doc.createElement("file");
                                                        libraryElement2.setAttribute("name", libraryFile.getParentFile().getName() + "/" + libName + ".framework.dSYM");
                                                        doc.getDocumentElement().appendChild(libraryElement2);
                                                    } else if (debugSym2.isDirectory()) {
                                                        BundleGenerator.copyDirectory(debugSym2, jarFile, jarUtilFile, libraryFile.getParentFile().getName(), (String)osArchName, isDebug, doc);
                                                    }
                                                }
                                                String libFilePath = libraryFile.getName() + (version.majorVersion() == 5 ? "/Versions/5" : "/Versions/A");
                                                jarFile.putNextEntry(new ZipEntry(libraryFile.getParentFile().getName() + "/" + libFilePath + "/" + libName));
                                                Files.copy(libFile.toPath(), jarFile);
                                                jarFile.closeEntry();
                                                Element libraryElement2 = doc.createElement("library");
                                                libraryElement2.setAttribute("name", libraryFile.getParentFile().getName() + "/" + libFilePath + "/" + libName);
                                                doc.getDocumentElement().appendChild(libraryElement2);
                                                File resourcesDir = new File(versionDir, "Resources");
                                                if (resourcesDir.isDirectory()) {
                                                    BundleGenerator.copyDirectory(resourcesDir, jarFile, jarUtilFile, libraryFile.getParentFile().getName() + "/" + libFilePath, (String)osArchName, isDebug, doc);
                                                }
                                                if ((helpersDir = new File(versionDir, "Helpers")).isDirectory()) {
                                                    BundleGenerator.copyDirectory(helpersDir, jarFile, jarUtilFile, libraryFile.getParentFile().getName() + "/" + libFilePath, (String)osArchName, isDebug, doc);
                                                }
                                                Element symlinkElement = doc.createElement("symlink");
                                                symlinkElement.setAttribute("name", libraryFile.getParentFile().getName() + "/" + libraryFile.getName() + "/Versions/Current");
                                                symlinkElement.setAttribute("target", libraryFile.getParentFile().getName() + "/" + libFilePath);
                                                doc.getDocumentElement().appendChild(symlinkElement);
                                                if (resourcesDir.isDirectory()) {
                                                    symlinkElement = doc.createElement("symlink");
                                                    symlinkElement.setAttribute("name", libraryFile.getParentFile().getName() + "/" + libraryFile.getName() + "/Resources");
                                                    symlinkElement.setAttribute("target", libraryFile.getParentFile().getName() + "/" + libraryFile.getName() + "/Versions/Current/Resources");
                                                    doc.getDocumentElement().appendChild(symlinkElement);
                                                }
                                                if (helpersDir.isDirectory()) {
                                                    symlinkElement = doc.createElement("symlink");
                                                    symlinkElement.setAttribute("name", libraryFile.getParentFile().getName() + "/" + libraryFile.getName() + "/Helpers");
                                                    symlinkElement.setAttribute("target", libraryFile.getParentFile().getName() + "/" + libraryFile.getName() + "/Versions/Current/Helpers");
                                                    doc.getDocumentElement().appendChild(symlinkElement);
                                                }
                                                symlinkElement = doc.createElement("symlink");
                                                symlinkElement.setAttribute("name", libraryFile.getParentFile().getName() + "/" + libraryFile.getName() + "/" + libName);
                                                symlinkElement.setAttribute("target", libraryFile.getParentFile().getName() + "/" + libraryFile.getName() + "/Versions/Current/" + libName);
                                                doc.getDocumentElement().appendChild(symlinkElement);
                                            }
                                            break block308;
                                        }
                                        if (!osArchName.startsWith("linux-")) break block309;
                                        jarFile.putNextEntry(new ZipEntry(libraryFile.getParentFile().getName() + "/" + libraryFile.getName()));
                                        Files.copy(libraryFile.toPath(), jarFile);
                                        jarFile.closeEntry();
                                        libraryElement = doc.createElement("library");
                                        libraryElement.setAttribute("name", libraryFile.getParentFile().getName() + "/" + libraryFile.getName());
                                        doc.getDocumentElement().appendChild((Node)libraryElement);
                                        String libName = libraryFile.getName();
                                        if (libName.endsWith(".so." + version) && isDebug && (debugSym = new File(libraryFile.getParentFile(), libName.replace(".so." + version, ".debug"))).exists()) {
                                            jarUtilFile.putNextEntry(new ZipEntry(libraryFile.getParentFile().getName() + "/" + debugSym.getName()));
                                            Files.copy(debugSym.toPath(), jarUtilFile);
                                            jarUtilFile.closeEntry();
                                            libraryElement = doc.createElement("file");
                                            libraryElement.setAttribute("name", libraryFile.getParentFile().getName() + "/" + debugSym.getName());
                                            doc.getDocumentElement().appendChild((Node)libraryElement);
                                        }
                                        if (libName.contains(".so.")) {
                                            while (!libName.endsWith(".so")) {
                                                int idx = libName.lastIndexOf(46);
                                                libName = libName.substring(0, idx);
                                                Element symlinkElement = doc.createElement("symlink");
                                                symlinkElement.setAttribute("name", libraryFile.getParentFile().getName() + "/" + libName);
                                                symlinkElement.setAttribute("target", libraryFile.getParentFile().getName() + "/" + libraryFile.getName());
                                                doc.getDocumentElement().appendChild(symlinkElement);
                                            }
                                        }
                                        break block308;
                                    }
                                    if (!osArchName.startsWith("android-")) break block310;
                                    switch (osArchName) {
                                        case "android-arm64": {
                                            targetDirName = "lib/arm64-v8a/";
                                            break;
                                        }
                                        case "android-arm": {
                                            targetDirName = "lib/armeabi-v7a/";
                                            break;
                                        }
                                        case "android-x64": {
                                            targetDirName = "lib/x86_64/";
                                            break;
                                        }
                                        default: {
                                            targetDirName = "lib/x86/";
                                        }
                                    }
                                    jarFile.putNextEntry(new ZipEntry(targetDirName + libraryFile.getName()));
                                    Files.copy(libraryFile.toPath(), jarFile);
                                    jarFile.closeEntry();
                                    Element libraryElement3 = doc.createElement("library");
                                    libraryElement3.setAttribute("name", targetDirName + libraryFile.getName());
                                    doc.getDocumentElement().appendChild(libraryElement3);
                                    String libName = libraryFile.getName();
                                    if (!libName.startsWith("libQt") || !libName.endsWith(".so") || !(dependencies = new File(libraryFile.getParentFile(), libName.substring(3, libName.length() - 3) + "-android-dependencies.xml")).exists()) break block308;
                                    Document depDoc = builder.parse(dependencies);
                                    Element rulesEl = depDoc.getDocumentElement();
                                    HashSet<String> resources = new HashSet<String>();
                                    if (!rulesEl.getNodeName().equals("rules")) break block308;
                                    int length = rulesEl.getChildNodes().getLength();
                                    for (int i = 0; i < length; ++i) {
                                        Element dependenciesEl;
                                        if (!(rulesEl.getChildNodes().item(i) instanceof Element) || !(dependenciesEl = (Element)rulesEl.getChildNodes().item(i)).getNodeName().equals("dependencies")) continue;
                                        int length2 = dependenciesEl.getChildNodes().getLength();
                                        for (int i2 = 0; i2 < length2; ++i2) {
                                            Element libEl;
                                            if (!(dependenciesEl.getChildNodes().item(i2) instanceof Element) || !(libEl = (Element)dependenciesEl.getChildNodes().item(i2)).getNodeName().equals("lib") || !libName.substring(3, libName.length() - 3).equals(libEl.getAttribute("name"))) continue;
                                            int length3 = libEl.getChildNodes().getLength();
                                            for (int i3 = 0; i3 < length3; ++i3) {
                                                Element dependsEl;
                                                if (!(libEl.getChildNodes().item(i3) instanceof Element) || !(dependsEl = (Element)libEl.getChildNodes().item(i3)).getNodeName().equals("depends")) continue;
                                                int length4 = dependsEl.getChildNodes().getLength();
                                                block158: for (int i4 = 0; i4 < length4; ++i4) {
                                                    if (!(dependsEl.getChildNodes().item(i4) instanceof Element)) continue;
                                                    Element childEl = (Element)dependsEl.getChildNodes().item(i4);
                                                    switch (childEl.getNodeName()) {
                                                        case "jar": {
                                                            File jarResource = new File(qtdir, childEl.getAttribute("file"));
                                                            if (!jarResource.exists() || resources.contains(childEl.getAttribute("file"))) continue block158;
                                                            resources.add(childEl.getAttribute("file"));
                                                            try (JarFile jarResourceFile = new JarFile(jarResource);){
                                                                Enumeration<JarEntry> entries = jarResourceFile.entries();
                                                                while (entries.hasMoreElements()) {
                                                                    JarEntry entry = entries.nextElement();
                                                                    if (entry.isDirectory()) continue;
                                                                    try {
                                                                        jarUtilFile.putNextEntry(entry);
                                                                    }
                                                                    catch (HasManifestException h) {
                                                                        continue;
                                                                    }
                                                                    catch (Throwable e) {
                                                                        e.printStackTrace();
                                                                        continue;
                                                                    }
                                                                    try (InputStream is = jarResourceFile.getInputStream(entry);){
                                                                        byte[] buffer2 = new byte[1024];
                                                                        int l = is.read(buffer2);
                                                                        while (l > 0) {
                                                                            jarUtilFile.write(buffer2, 0, l);
                                                                            l = is.read(buffer2);
                                                                        }
                                                                    }
                                                                    jarUtilFile.closeEntry();
                                                                }
                                                                continue block158;
                                                            }
                                                        }
                                                        case "lib": {
                                                            String plugin;
                                                            File pluginFile;
                                                            File libResource = new File(qtdir, childEl.getAttribute("file"));
                                                            if (!libResource.exists() || !pluginsDir.equals(libResource.getParentFile().getParentFile()) || (pluginFile = (File)plugins.remove(plugin = libResource.getParentFile().getName())) == null) continue block158;
                                                            BundleGenerator.copyDirectory(pluginFile, jarFile, jarUtilFile, "plugins", (String)osArchName, isDebug, doc);
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                    break block308;
                                }
                                jarFile.putNextEntry(new ZipEntry(libraryFile.getParentFile().getName() + "/" + libraryFile.getName()));
                                Files.copy(libraryFile.toPath(), jarFile);
                                jarFile.closeEntry();
                                libraryElement = doc.createElement("library");
                                libraryElement.setAttribute("name", libraryFile.getParentFile().getName() + "/" + libraryFile.getName());
                                doc.getDocumentElement().appendChild((Node)libraryElement);
                            }
                            switch ((String)libPair.getKey()) {
                                case "webenginecore": {
                                    Iterator<String> resourcesDir = new File(qtdir, "resources");
                                    if (((File)((Object)resourcesDir)).isDirectory()) {
                                        BundleGenerator.copyDirectory(resourcesDir, jarFile, jarUtilFile, "", (String)osArchName, isDebug, doc);
                                    }
                                    File exe = null;
                                    String path = null;
                                    if (osArchName.startsWith("windows-")) {
                                        path = "bin";
                                        exe = new File(binDir, isDebug ? "QtWebEngineProcessd.exe" : "QtWebEngineProcess.exe");
                                    } else if (osArchName.startsWith("linux-")) {
                                        path = "libexec";
                                        exe = new File(new File(qtdir, "libexec"), "QtWebEngineProcess");
                                    }
                                    if (exe == null || !exe.exists()) continue block153;
                                    jarFile.putNextEntry(new ZipEntry(path + "/" + exe.getName()));
                                    Files.copy(exe.toPath(), jarFile);
                                    jarFile.closeEntry();
                                    Element libraryElement4 = doc.createElement("file");
                                    libraryElement4.setAttribute("name", path + "/" + exe.getName());
                                    if (exe.canExecute()) {
                                        libraryElement4.setAttribute("executable", "true");
                                    }
                                    doc.getDocumentElement().appendChild(libraryElement4);
                                    break;
                                }
                                case "svg": {
                                    String suffix2;
                                    for (String subdir : Arrays.asList("imageformats", "iconengines")) {
                                        for (File pluginFile : new File(pluginsDir, subdir).listFiles()) {
                                            if (!pluginFile.getName().contains("qsvg")) continue;
                                            if (pluginFile.isFile()) {
                                                String targetDirName = "plugins/" + subdir + "/";
                                                if (osArchName.startsWith("windows-")) {
                                                    if (pluginFile.getName().endsWith(".pdb") || pluginFile.getName().endsWith(".dll.debug") && !isDebug || isDebug && !pluginFile.getName().endsWith("d.dll") || !isDebug && pluginFile.getName().endsWith("d.dll")) {
                                                        continue;
                                                    }
                                                } else if (osArchName.startsWith("android-")) {
                                                    switch (osArchName) {
                                                        case "android-arm64": {
                                                            suffix2 = "_arm64-v8a.so";
                                                            targetDirName = "lib/arm64-v8a/";
                                                            break;
                                                        }
                                                        case "android-arm": {
                                                            suffix2 = "_armeabi-v7a.so";
                                                            targetDirName = "lib/armeabi-v7a/";
                                                            break;
                                                        }
                                                        case "android-x64": {
                                                            suffix2 = "_x86_64.so";
                                                            targetDirName = "lib/x86_64/";
                                                            break;
                                                        }
                                                        default: {
                                                            suffix2 = "_x86.so";
                                                            targetDirName = "lib/x86/";
                                                        }
                                                    }
                                                    if (!pluginFile.getName().endsWith(suffix2)) continue;
                                                }
                                                jarFile.putNextEntry(new ZipEntry(targetDirName + pluginFile.getName()));
                                                Files.copy(pluginFile.toPath(), jarFile);
                                                jarFile.closeEntry();
                                                Element libraryElement3 = doc.createElement("library");
                                                libraryElement3.setAttribute("name", targetDirName + pluginFile.getName());
                                                doc.getDocumentElement().appendChild(libraryElement3);
                                                continue;
                                            }
                                            if (!pluginFile.getName().endsWith("dSYM") || !isDebug) continue;
                                            BundleGenerator.copyDirectory(pluginFile, jarFile, jarUtilFile, "plugins/" + subdir, (String)osArchName, isDebug, doc);
                                        }
                                    }
                                    continue block153;
                                }
                                case "virtualkeyboard": {
                                    String suffix2;
                                    for (String subdir : Arrays.asList("platforminputcontexts")) {
                                        for (File pluginFile : new File(pluginsDir, subdir).listFiles()) {
                                            if (!pluginFile.getName().contains("qtvirtualkeyboard")) continue;
                                            if (pluginFile.isFile()) {
                                                String targetDirName = "plugins/" + subdir + "/";
                                                if (osArchName.startsWith("windows-")) {
                                                    if (pluginFile.getName().endsWith(".pdb") || pluginFile.getName().endsWith(".dll.debug") && !isDebug || isDebug && !pluginFile.getName().endsWith("d.dll") || !isDebug && pluginFile.getName().endsWith("d.dll")) {
                                                        continue;
                                                    }
                                                } else if (osArchName.startsWith("android-")) {
                                                    switch (osArchName) {
                                                        case "android-arm64": {
                                                            String suffix22 = "_arm64-v8a.so";
                                                            targetDirName = "lib/arm64-v8a/";
                                                            break;
                                                        }
                                                        case "android-arm": {
                                                            suffix2 = "_armeabi-v7a.so";
                                                            targetDirName = "lib/armeabi-v7a/";
                                                            break;
                                                        }
                                                        case "android-x64": {
                                                            suffix2 = "_x86_64.so";
                                                            targetDirName = "lib/x86_64/";
                                                            break;
                                                        }
                                                        default: {
                                                            suffix2 = "_x86.so";
                                                            targetDirName = "lib/x86/";
                                                        }
                                                    }
                                                    if (!pluginFile.getName().endsWith(suffix2)) continue;
                                                }
                                                jarFile.putNextEntry(new ZipEntry(targetDirName + pluginFile.getName()));
                                                Files.copy(pluginFile.toPath(), jarFile);
                                                jarFile.closeEntry();
                                                Element libraryElement5 = doc.createElement("library");
                                                libraryElement5.setAttribute("name", targetDirName + pluginFile.getName());
                                                doc.getDocumentElement().appendChild(libraryElement5);
                                                continue;
                                            }
                                            if (!pluginFile.getName().endsWith("dSYM") || !isDebug) continue;
                                            BundleGenerator.copyDirectory(pluginFile, jarFile, jarUtilFile, "plugins/" + subdir, (String)osArchName, isDebug, doc);
                                        }
                                    }
                                    break;
                                }
                            }
                        }
                        Set<String> associatedPlugins = pluginsByModules.get(libPair.getKey());
                        if (associatedPlugins != null) {
                            for (String plugin : associatedPlugins) {
                                File pluginFile = (File)plugins.remove(plugin);
                                if (pluginFile == null || !pluginFile.isDirectory()) continue;
                                BundleGenerator.copyDirectory(pluginFile, jarFile, jarUtilFile, "plugins", (String)osArchName, isDebug, doc);
                            }
                        }
                        if ("pdfquick".equals(libPair.getKey())) {
                            BundleGenerator.copyQmlPaths(qmllibs, Collections.singletonList("QtQuick/Pdf"), jarFile, jarUtilFile, (String)osArchName, isDebug, doc);
                        } else if ("waylandclient".equals(libPair.getKey())) {
                            BundleGenerator.copyQmlPaths(qmllibs, Collections.singletonList("QtWayland/Client"), jarFile, jarUtilFile, (String)osArchName, isDebug, doc);
                        } else if ("waylandcompositor".equals(libPair.getKey())) {
                            BundleGenerator.copyQmlPaths(qmllibs, Collections.singletonList("QtWayland/Compositor"), jarFile, jarUtilFile, (String)osArchName, isDebug, doc);
                        } else if ("virtualkeyboard".equals(libPair.getKey())) {
                            BundleGenerator.copyQmlPaths(qmllibs, Collections.singletonList("QtQuick/VirtualKeyboard"), jarFile, jarUtilFile, (String)osArchName, isDebug, doc);
                        } else if ("qml".equals(libPair.getKey())) {
                            BundleGenerator.copyQmlPaths(qmllibs, Arrays.asList("QtQuick/LocalStorage", "QtQml", "QtQuick/Window", "QtQuick/tooling"), jarFile, jarUtilFile, (String)osArchName, isDebug, doc);
                            if (version.majorVersion() == 5) {
                                BundleGenerator.copyQmlPaths(qmllibs, Collections.singletonList("QtQuick/LocalStorage"), jarFile, jarUtilFile, (String)osArchName, isDebug, doc);
                            }
                        } else if ("qt3dcore".equals(libPair.getKey())) {
                            BundleGenerator.copyQmlPaths(qmllibs, Arrays.asList("QtQuick/Scene2D", "QtQuick/Scene3D"), jarFile, jarUtilFile, (String)osArchName, isDebug, doc);
                        } else if ("quick".equals(libPair.getKey())) {
                            BundleGenerator.copyQmlPaths(qmllibs, Arrays.asList("QtQuick/NativeStyle", "QtQuick/Particles", "Qt", "QtQuick", "QtCore", "QtQuick/Shapes", "QtQuick/Templates", "QtQuick/Controls", "QtQuick/Dialogs", "QtQuick/Layouts", "QtQuick/Timeline"), jarFile, jarUtilFile, (String)osArchName, isDebug, doc);
                            if (version.majorVersion() == 5) {
                                BundleGenerator.copyQmlPaths(qmllibs, Arrays.asList("QtGraphicalEffects", "QtQuick/Window.2", "QtQuick/Templates.2", "QtQuick/Controls.2", "QtQuick/Particles.2", "QtQuick.2", "QtQuick/Extras", "QtQuick/PrivateWidgets"), jarFile, jarUtilFile, (String)osArchName, isDebug, doc);
                            }
                        } else if ("webenginequick".equals(libPair.getKey())) {
                            BundleGenerator.copyQmlPaths(qmllibs, Collections.singletonList("QtWebEngine"), jarFile, jarUtilFile, (String)osArchName, isDebug, doc);
                        } else if ("xmlpatterns".equals(libPair.getKey())) {
                            BundleGenerator.copyQmlPaths(qmllibs, Collections.singletonList("QtQuick/XmlListModel"), jarFile, jarUtilFile, (String)osArchName, isDebug, doc);
                        }
                        if (!"core".equals(libPair.getKey())) {
                            for (String key : new ArrayList(qmllibs.keySet())) {
                                String nonQmlLib;
                                String _libName;
                                String libName = key.replace('/', '-').replace(".", "").toLowerCase();
                                if (libName.startsWith("qt3d-")) {
                                    switch (libName) {
                                        case "qt3d-core": {
                                            libName = "qt3dquick";
                                            break;
                                        }
                                        case "qt3d-logic": {
                                            libName = "qt3dlogic";
                                            break;
                                        }
                                        default: {
                                            libName = "qt3dquick" + libName.substring(5);
                                        }
                                    }
                                }
                                if (libName.startsWith("qtquick-")) {
                                    libName = "quick" + libName.substring(8);
                                }
                                if (libName.startsWith("qt") && !(_libName = libName.substring(2)).isEmpty() && Character.isJavaIdentifierStart(_libName.charAt(0))) {
                                    libName = _libName;
                                }
                                if (((String)libPair.getKey()).equals("core5compat") && libName.equals("qt5compat")) {
                                    libName = (String)libPair.getKey();
                                } else if (((String)libPair.getKey()).equals(libName + "2")) {
                                    libName = (String)libPair.getKey();
                                } else if (((String)libPair.getKey()).endsWith("qml")) {
                                    nonQmlLib = ((String)libPair.getKey()).substring(0, ((String)libPair.getKey()).length() - 3);
                                    if (libraries.containsKey(nonQmlLib) && libName.equals(nonQmlLib)) {
                                        libName = (String)libPair.getKey();
                                    }
                                } else if (((String)libPair.getKey()).endsWith("quick") && libraries.containsKey(nonQmlLib = ((String)libPair.getKey()).substring(0, ((String)libPair.getKey()).length() - 5)) && libName.equals(nonQmlLib)) {
                                    libName = (String)libPair.getKey();
                                }
                                if (!libName.equals(libPair.getKey()) || libraries.containsKey((String)libPair.getKey() + "qml") || libraries.containsKey((String)libPair.getKey() + "quick")) continue;
                                BundleGenerator.copyQmlPaths(qmllibs, Collections.singletonList(key), jarFile, jarUtilFile, (String)osArchName, isDebug, doc);
                            }
                        }
                        if ((list = (List)libraries.get((String)libPair.getKey() + "qml")) != null && !list.isEmpty()) {
                            libraryElement = doc.createElement("qmllib");
                            if (osArchName.startsWith("macos")) {
                                String libName = ((File)list.get(0)).getName();
                                libName = libName.substring(0, libName.length() - ".framework".length());
                                libraryElement.setAttribute("name", ((File)list.get(0)).getName() + "/Versions/" + (version.majorVersion() == 5 ? "5/" : "A/") + libName);
                            } else {
                                libraryElement.setAttribute("name", ((File)list.get(0)).getParentFile().getName() + "/" + ((File)list.get(0)).getName());
                            }
                            doc.getDocumentElement().appendChild((Node)libraryElement);
                        } else {
                            list = "webenginecore".equals(libPair.getKey()) ? (version.majorVersion() == 5 ? (List)libraries.get("webengine") : (List)libraries.get("webenginequick")) : (List)libraries.get((String)libPair.getKey() + "quick");
                            if (list != null && !list.isEmpty()) {
                                libraryElement = doc.createElement("qmllib");
                                if (osArchName.startsWith("macos")) {
                                    String libName = ((File)list.get(0)).getName();
                                    libName = libName.substring(0, libName.length() - ".framework".length());
                                    libraryElement.setAttribute("name", ((File)list.get(0)).getName() + "/Versions/" + (version.majorVersion() == 5 ? "5/" : "A/") + libName);
                                } else {
                                    libraryElement.setAttribute("name", ((File)list.get(0)).getParentFile().getName() + "/" + ((File)list.get(0)).getName());
                                }
                                doc.getDocumentElement().appendChild((Node)libraryElement);
                            }
                        }
                        jarFile.putNextEntry(new ZipEntry("META-INF/MANIFEST.MF"));
                        manifest.write(jarFile);
                        jarFile.closeEntry();
                        boolean bl = isEmpty = !doc.getDocumentElement().hasChildNodes();
                        if (!osArchName.startsWith("android-")) {
                            jarFile.putNextEntry(new ZipEntry("qtjambi-deployment.xml"));
                            StreamResult result = new StreamResult(jarFile);
                            transformer.transform(new DOMSource(doc), result);
                            jarFile.closeEntry();
                        }
                    }
                    if (!isEmpty) continue;
                    newFile.delete();
                }
                for (Map.Entry libPair : plugins.entrySet()) {
                    File newFile = new File(targetDir, "qt-plugin-" + ((String)libPair.getKey()).replace("/", "-") + "-native-" + (String)osArchName + (isDebug ? "-debug-" : "-") + version + ".jar");
                    AutoCloseable closable = () -> {};
                    JarOutputStream jarUtilFile = null;
                    if (osArchName.startsWith("android")) {
                        File utilFile = new File(targetDir, "qt-plugin-" + ((String)libPair.getKey()).replace("/", "-") + "-native-android-common-" + version + ".jar");
                        jarUtilFile = !utilFile.exists() ? new JarOutputStream(new FileOutputStream(utilFile)) : new JarOutputStream(new ByteArrayOutputStream());
                        closable = jarUtilFile;
                    }
                    boolean isEmpty = false;
                    try (JarOutputStream jarFile = new JarOutputStream(new FileOutputStream(newFile));
                         AutoCloseable _closable = closable;){
                        if (jarUtilFile == null) {
                            jarUtilFile = jarFile;
                        }
                        doc = builder.getDOMImplementation().createDocument(null, "qtjambi-deploy", null);
                        doc.getDocumentElement().setAttribute("module", "qt.plugin." + ((String)libPair.getKey()).replace('-', '.').replace('/', '.'));
                        doc.getDocumentElement().setAttribute("system", (String)osArchName);
                        doc.getDocumentElement().setAttribute("version", version.toString());
                        doc.getDocumentElement().setAttribute("configuration", isDebug ? "debug" : "release");
                        BundleGenerator.copyDirectory((File)libPair.getValue(), jarFile, jarUtilFile, "plugins", (String)osArchName, isDebug, doc);
                        jarFile.putNextEntry(new ZipEntry("META-INF/MANIFEST.MF"));
                        manifest.write(jarFile);
                        jarFile.closeEntry();
                        boolean bl = isEmpty = !doc.getDocumentElement().hasChildNodes();
                        if (!osArchName.startsWith("android-")) {
                            jarFile.putNextEntry(new ZipEntry("qtjambi-deployment.xml"));
                            StreamResult result = new StreamResult(jarFile);
                            transformer.transform(new DOMSource(doc), result);
                            jarFile.closeEntry();
                        }
                    }
                    if (!isEmpty) continue;
                    newFile.delete();
                }
                for (Map.Entry libPair : qmllibs.entrySet()) {
                    String _libName;
                    String libName = ((String)libPair.getKey()).replace('/', '-').replace(".", "").toLowerCase();
                    if (libName.startsWith("qt") && !(_libName = libName.substring(2)).isEmpty() && Character.isJavaIdentifierStart(_libName.charAt(0))) {
                        libName = _libName;
                    }
                    File newFile = new File(targetDir, "qt-qml-" + libName + "-native-" + (String)osArchName + (isDebug ? "-debug-" : "-") + version + ".jar");
                    boolean isEmpty = false;
                    AutoCloseable closable = () -> {};
                    JarOutputStream jarUtilFile = null;
                    if (osArchName.startsWith("android")) {
                        File utilFile = new File(targetDir, "qt-qml-" + libName + "-native-android-common-" + version + ".jar");
                        jarUtilFile = !utilFile.exists() ? new JarOutputStream(new FileOutputStream(utilFile)) : new JarOutputStream(new ByteArrayOutputStream());
                        closable = jarUtilFile;
                    }
                    try (JarOutputStream jarFile = new JarOutputStream(new FileOutputStream(newFile));
                         AutoCloseable _closable = closable;){
                        if (jarUtilFile == null) {
                            jarUtilFile = jarFile;
                        }
                        Document doc2 = builder.getDOMImplementation().createDocument(null, "qtjambi-deploy", null);
                        doc2.getDocumentElement().setAttribute("module", "qt.qml." + libName.replace('-', '.').replace('/', '.'));
                        doc2.getDocumentElement().setAttribute("system", (String)osArchName);
                        doc2.getDocumentElement().setAttribute("version", version.toString());
                        doc2.getDocumentElement().setAttribute("configuration", isDebug ? "debug" : "release");
                        ArrayList<String> path = new ArrayList<String>();
                        path.add("qml");
                        path.addAll(Arrays.asList(((String)libPair.getKey()).split("/")));
                        path.remove(path.size() - 1);
                        BundleGenerator.copyDirectory((File)libPair.getValue(), jarFile, jarUtilFile, String.join((CharSequence)"/", path), (String)osArchName, isDebug, doc2);
                        jarFile.putNextEntry(new ZipEntry("META-INF/MANIFEST.MF"));
                        manifest.write(jarFile);
                        jarFile.closeEntry();
                        boolean bl = isEmpty = !doc2.getDocumentElement().hasChildNodes();
                        if (!osArchName.startsWith("android-")) {
                            jarFile.putNextEntry(new ZipEntry("qtjambi-deployment.xml"));
                            StreamResult result = new StreamResult(jarFile);
                            transformer.transform(new DOMSource(doc2), result);
                            jarFile.closeEntry();
                        }
                    }
                    if (!isEmpty) continue;
                    newFile.delete();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private static void copyQmlPaths(Map<String, File> qmllibs, Iterable<String> paths, JarOutputStream jarFile, JarOutputStream jarUtilFile, String osArchName, boolean isDebug, Document doc) throws IOException {
        for (String path : paths) {
            File qmlLib = qmllibs.remove(path);
            if (qmlLib == null || !qmlLib.isDirectory()) continue;
            ArrayList<String> _path = new ArrayList<String>();
            _path.add("qml");
            _path.addAll(Arrays.asList(path.split("/")));
            _path.remove(_path.size() - 1);
            BundleGenerator.copyDirectory(qmlLib, jarFile, jarUtilFile, String.join((CharSequence)"/", _path), osArchName, isDebug, doc);
        }
    }

    private static void copyDirectory(File dir, JarOutputStream jarFile, JarOutputStream jarUtilFile, String path, String osArchName, boolean isDebug, Document doc) throws IOException {
        boolean noSubdirs;
        if (osArchName.equals("macos") && !isDebug && dir.getName().endsWith(".dSYM")) {
            return;
        }
        if (path == null) {
            path = "";
        }
        if (!path.isEmpty() && !path.endsWith("/")) {
            path = path + "/";
        }
        boolean bl = noSubdirs = "qml/".equals(path) && ("QtQuick".equals(dir.getName()) || "Qt3D".equals(dir.getName()));
        if ("qml/".equals(path) && "QtQml".equals(dir.getName())) {
            Element element;
            File qmltypesFile = new File(dir.getParentFile(), "builtins.qmltypes");
            if (qmltypesFile.exists()) {
                jarUtilFile.putNextEntry(new ZipEntry(path + qmltypesFile.getName()));
                Files.copy(qmltypesFile.toPath(), jarUtilFile);
                jarUtilFile.closeEntry();
                element = doc.createElement("file");
                element.setAttribute("name", path + dir.getName() + "/" + qmltypesFile.getName());
                doc.getDocumentElement().appendChild(element);
            }
            if ((qmltypesFile = new File(dir.getParentFile(), "jsroot.qmltypes")).exists()) {
                jarUtilFile.putNextEntry(new ZipEntry(path + qmltypesFile.getName()));
                Files.copy(qmltypesFile.toPath(), jarUtilFile);
                jarUtilFile.closeEntry();
                element = doc.createElement("file");
                element.setAttribute("name", path + dir.getName() + "/" + qmltypesFile.getName());
                doc.getDocumentElement().appendChild(element);
            }
        }
        for (File file : dir.listFiles()) {
            Element element;
            if (file.isDirectory()) {
                if (noSubdirs || osArchName.equals("macos") && !isDebug && file.getName().endsWith(".dSYM")) continue;
                BundleGenerator.copyDirectory(file, jarFile, jarUtilFile, path + dir.getName() + "/", osArchName, isDebug, doc);
                continue;
            }
            if (file.getName().contains("qsvg") || file.getName().contains("qtvirtualkeyboardplugin")) continue;
            boolean isLibrary = false;
            String targetDirName = path + dir.getName() + "/";
            if (osArchName.startsWith("windows-")) {
                if (file.getName().endsWith(".dll.debug") && !isDebug || file.getName().endsWith(".pdb")) continue;
                if (file.getName().endsWith(".dll")) {
                    String libNoSuffix;
                    isLibrary = true;
                    if (isDebug ? !file.getName().endsWith("d.dll") || new File(dir, (libNoSuffix = file.getName().substring(0, file.getName().length() - 5)) + "dd.dll").exists() : file.getName().endsWith("d.dll") && new File(dir, (libNoSuffix = file.getName().substring(0, file.getName().length() - 5)) + ".dll").exists()) {
                        continue;
                    }
                }
            } else if (osArchName.startsWith("android-")) {
                String suffix;
                isLibrary = file.getName().endsWith(".so");
                switch (osArchName) {
                    case "android-arm64": {
                        suffix = "_arm64-v8a.so";
                        if (!isLibrary) break;
                        targetDirName = "lib/arm64-v8a/";
                        break;
                    }
                    case "android-arm": {
                        suffix = "_armeabi-v7a.so";
                        if (!isLibrary) break;
                        targetDirName = "lib/armeabi-v7a/";
                        break;
                    }
                    case "android-x64": {
                        suffix = "_x86_64.so";
                        if (!isLibrary) break;
                        targetDirName = "lib/x86_64/";
                        break;
                    }
                    default: {
                        suffix = "_x86.so";
                        if (!isLibrary) break;
                        targetDirName = "lib/x86/";
                    }
                }
                if (isLibrary && !file.getName().endsWith(suffix)) {
                    continue;
                }
            } else if (osArchName.startsWith("linux-")) {
                isLibrary = file.getName().endsWith(".so");
                if (!isDebug && file.getName().endsWith(".debug")) {
                    continue;
                }
            } else if (osArchName.equals("macos")) {
                isLibrary = file.getName().endsWith(".dylib");
                if (!isDebug && file.getName().endsWith(".dSYM")) continue;
            }
            if (isLibrary) {
                element = doc.createElement("library");
                jarFile.putNextEntry(new ZipEntry(targetDirName + file.getName()));
                Files.copy(file.toPath(), jarFile);
                jarFile.closeEntry();
            } else {
                element = doc.createElement("file");
                jarUtilFile.putNextEntry(new ZipEntry(targetDirName + file.getName()));
                Files.copy(file.toPath(), jarUtilFile);
                jarUtilFile.closeEntry();
            }
            if (!isLibrary && osArchName.equals("macos") && file.getName().equals("QtWebEngineProcess")) {
                element.setAttribute("executable", "true");
            }
            element.setAttribute("name", targetDirName + file.getName());
            doc.getDocumentElement().appendChild(element);
        }
    }

    static {
        TreeMap<String, String> _pluginsModules = new TreeMap<String, String>();
        _pluginsModules.put("3dinputdevices", "qt3dinput");
        _pluginsModules.put("renderplugins", "qt3drender");
        _pluginsModules.put("geometryloaders", "qt3drender");
        _pluginsModules.put("sceneparsers", "qt3drender");
        _pluginsModules.put("renderers", "qt3drender");
        _pluginsModules.put("geometryloaders", "qt3drender");
        _pluginsModules.put("accessible", "gui");
        _pluginsModules.put("accessiblebridge", "gui");
        _pluginsModules.put("iconengines", "gui");
        _pluginsModules.put("imageformats", "gui");
        _pluginsModules.put("generic", "gui");
        _pluginsModules.put("platforminputcontexts", "gui");
        _pluginsModules.put("platforms", "gui");
        _pluginsModules.put("platformthemes", "gui");
        _pluginsModules.put("networkaccess", "network");
        _pluginsModules.put("networkinformation", "network");
        _pluginsModules.put("tls", "network");
        _pluginsModules.put("egldeviceintegrations", "gui");
        _pluginsModules.put("xcbglintegrations", "gui");
        _pluginsModules.put("printsupport", "printsupport");
        _pluginsModules.put("sqldrivers", "sql");
        _pluginsModules.put("styles", "widgets");
        _pluginsModules.put("qmltooling", "qml");
        _pluginsModules.put("qmllint", "qml");
        _pluginsModules.put("scenegraph", "quick");
        _pluginsModules.put("opcua", "opcua");
        _pluginsModules.put("position", "positioning");
        _pluginsModules.put("assetimporters", "quick3d");
        _pluginsModules.put("scxmldatamodel", "scxml");
        _pluginsModules.put("canbus", "serialbus");
        _pluginsModules.put("virtualkeyboard", "virtualkeyboard");
        _pluginsModules.put("wayland-graphics-integration-client", "waylandclient");
        _pluginsModules.put("wayland-inputdevice-integration", "waylandclient");
        _pluginsModules.put("wayland-decoration-client", "waylandclient");
        _pluginsModules.put("wayland-shell-integration", "waylandclient");
        _pluginsModules.put("wayland-graphics-integration-server", "waylandcompositor");
        _pluginsModules.put("wayland-hardware-layer-integration", "waylandcompositor");
        _pluginsModules.put("wayland-graphics-integration-server", "waylandcompositor");
        _pluginsModules.put("webview", "webview");
        _pluginsModules.put("gamepads", "gamepad");
        _pluginsModules.put("geoservices", "location");
        _pluginsModules.put("texttospeech", "texttospeech");
        _pluginsModules.put("designer", "designer");
        _pluginsModules.put("sensors", "sensors");
        _pluginsModules.put("sensorgestures", "sensors");
        _pluginsModules.put("video", "multimedia");
        _pluginsModules.put("audio", "multimedia");
        _pluginsModules.put("mediaservice", "multimedia");
        _pluginsModules.put("resourcepolicy", "multimedia");
        _pluginsModules.put("playlistformats", "multimedia");
        _pluginsModules.put("multimedia", "multimedia");
        _pluginsModules.put("bearer", "network");
        _pluginsModules.put("qtwebengine", "webenginecore");
        TreeMap<String, Set> _pluginsByModules = new TreeMap<String, Set>();
        Function<String, Set> containerFactory = key -> new TreeSet();
        for (Map.Entry entry : _pluginsModules.entrySet()) {
            _pluginsByModules.computeIfAbsent((String)entry.getValue(), containerFactory).add((String)entry.getKey());
        }
        for (Map.Entry entry : _pluginsByModules.entrySet()) {
            entry.setValue(Collections.unmodifiableSet((Set)entry.getValue()));
        }
        pluginsByModules = Collections.unmodifiableMap(_pluginsByModules);
    }
}

